/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import java.util.ArrayDeque;
import java.util.Deque;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.ICFPreprocScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.CFIndentScanner;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.util.CFUtils;

public class VlogCFPreprocScanner
extends CFTokenScanner
implements ICFPreprocScannerImpl {
    private CFTokenScanner fCFTokenScanner;
    protected Deque<CFToken> preprocsStack = new ArrayDeque<CFToken>();
    protected static final String PREPROC_INSIDE_SHORT_SCOPE = "preprocInsideShortScope";
    protected static final String PREPROC_INCREASES_INDENT = "preprocIncreasesIndent";
    protected static final String PREPROC_LINE_INDENT = "preprocLineIndent";
    protected static final String PREPROC_NEXT_LINE_INDENT_ADJUSTMENT = "preprocNextLineIndentAdjustment";
    private boolean fInComplexPreproc = false;
    private boolean fInIncludePreproc;

    public VlogCFPreprocScanner(CFModel model) {
        super(model);
    }

    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        this.fCFTokenScanner = cfTokenScanner;
    }

    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        this.fCFTokenScanner.startPartition(strategy);
    }

    public void startChunk(CFChunk chunk) {
        super.startChunk(chunk);
        this.fCFTokenScanner.startChunk(chunk);
    }

    public void endChunk(CFChunk chunk) {
        super.endChunk(chunk);
        this.fCFTokenScanner.endChunk(chunk);
    }

    public void startToken(CFToken token) {
        super.startToken(token);
        this.fCFTokenScanner.startToken(token);
    }

    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        this.fCFTokenScanner.analyzeToken(token);
    }

    public void endToken(CFToken token) {
        super.endToken(token);
        this.fCFTokenScanner.endToken(token);
        this.updatePreprocContext(token);
    }

    private void updatePreprocContext(CFToken token) {
        CFLineInfo lineInfo = this.fModel.getLineInfo(token.getLineNo());
        if (this.fInComplexPreproc && lineInfo != null) {
            lineInfo.setContainsPreproc();
            lineInfo.setContainsComplexPreproc();
        }
        if (token.getTokenType() == 2) {
            String word = token.getValue();
            int preprocType = this.fStrategy.getPreprocType(word);
            if (preprocType == 5) {
                this.fInComplexPreproc = true;
                if ("`include".equals(word)) {
                    this.fInIncludePreproc = true;
                }
                if (lineInfo != null) {
                    lineInfo.setContainsComplexPreproc();
                }
            }
            if (preprocType != 0 && lineInfo != null) {
                lineInfo.setContainsPreproc();
            }
        } else if (token.getTokenType() == 3 && this.fInComplexPreproc && token.getValue().contains("\n") && token.getEnclosingChunk().getType() != 4 && !token.getEnclosingChunk().getValue().trim().endsWith("\\")) {
            this.fInComplexPreproc = false;
            this.fInIncludePreproc = false;
        }
    }

    public boolean isInPreproc() {
        return this.fInComplexPreproc;
    }

    public void setInPreproc(boolean inPreproc) {
        this.fInComplexPreproc = inPreproc;
    }

    public void setInIncludePreproc(boolean inIncludePreproc) {
        this.fInIncludePreproc = inIncludePreproc;
    }

    public boolean isInIncludePreproc() {
        return this.fInIncludePreproc;
    }

    protected void updatePreprocTokenInfo(CFToken token, CFIndentScanner indentScanner) {
        if (token == null) {
            return;
        }
        if (!token.isFirstNWSTokenOnLine()) {
            return;
        }
        CFPreferences formatPreferences = this.fStrategy.getFormatPreferences();
        if (formatPreferences == null) {
            return;
        }
        if (formatPreferences.isPreprocPrefLeaveAsIs() || formatPreferences.isPreprocPrefResetIndent()) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        if (!lineInfo.isFormatterOn()) {
            return;
        }
        int tabWidth = formatPreferences.getTabWidth();
        switch (this.fStrategy.getPreprocType(token.getValue())) {
            case 1: 
            case 3: {
                int preprocCurrLineIndent = this.getPreprocLineIndentMeta(token);
                int preprocNextLineIndentAdjustment = this.getPreprocNextLineIndentAdjustmentMeta(token);
                indentScanner.setStrictIndent(Math.max(preprocCurrLineIndent, 0));
                indentScanner.setLineIndent(Math.max(preprocCurrLineIndent, 0));
                indentScanner.setNextLineIndentLevel(preprocNextLineIndentAdjustment / tabWidth);
                break;
            }
            case 2: {
                int preprocCurrLineIndent = this.getPreprocLineIndentMeta(token);
                int preprocNextLineIndentAdjustment = this.getPreprocNextLineIndentAdjustmentMeta(token);
                indentScanner.setStrictIndent(Math.max(preprocCurrLineIndent, 0));
                if (preprocNextLineIndentAdjustment == 0) break;
                indentScanner.setLineIndent(Math.max(preprocCurrLineIndent, 0));
                indentScanner.setNextLineIndentLevel(preprocNextLineIndentAdjustment / tabWidth);
                break;
            }
        }
    }

    protected void updatePrepocStack(CFToken token, CFScope enclosingScope, int currLineIndent) {
        CFPreferences formatPreferences = this.fStrategy.getFormatPreferences();
        if (formatPreferences == null) {
            return;
        }
        if (formatPreferences.isPreprocPrefLeaveAsIs() || formatPreferences.isPreprocPrefResetIndent()) {
            return;
        }
        DVTSourceViewerConfiguration svc = this.fStrategy.getSourceViewerConfiguration();
        if (svc == null) {
            return;
        }
        int tabWidth = formatPreferences.getTabWidth();
        switch (this.fStrategy.getPreprocType(token.getValue())) {
            case 1: {
                if (token.isFirstNWSTokenOnLine()) {
                    int nextLineIndentAdjustment = 0;
                    if (formatPreferences.isPreprocPrefIndentContent() || !this.preprocsStack.isEmpty() && formatPreferences.isPreprocPrefIndentContentExceptFirst()) {
                        nextLineIndentAdjustment = tabWidth;
                    }
                    this.setPreprocIndentMeta(token, currLineIndent, nextLineIndentAdjustment);
                    if (enclosingScope != null && enclosingScope.getIndentKind() == CFScope.INDENT) {
                        token.putMeta(PREPROC_INSIDE_SHORT_SCOPE, (Object)enclosingScope.isShortScope());
                    }
                }
                this.pushPreprocToken(token);
                break;
            }
            case 3: {
                CFToken openPreprocToken = this.getOpenPreprocToken();
                if (openPreprocToken == null) {
                    return;
                }
                int openPreprocLineIndent = this.getPreprocLineIndentMeta(openPreprocToken);
                if (openPreprocLineIndent == Integer.MIN_VALUE) {
                    if (token.isFirstNWSTokenOnLine()) {
                        this.setPreprocIndentMeta(token, currLineIndent, 0);
                    }
                    this.pushPreprocToken(token);
                    return;
                }
                int openPreprocNextLineIndentAdjustment = this.getPreprocNextLineIndentAdjustmentMeta(openPreprocToken);
                if (openPreprocNextLineIndentAdjustment == Integer.MIN_VALUE) {
                    if (token.isFirstNWSTokenOnLine()) {
                        this.setPreprocIndentMeta(token, openPreprocLineIndent, 0);
                    }
                    this.pushPreprocToken(token);
                    return;
                }
                if (token.isFirstNWSTokenOnLine()) {
                    this.setPreprocIndentMeta(token, openPreprocLineIndent, openPreprocNextLineIndentAdjustment);
                }
                this.pushPreprocToken(token);
                break;
            }
            case 2: {
                CFToken openPreproc = this.getOpenPreprocToken();
                if (openPreproc == null) break;
                int openPreprocCurrLineIndent = this.getPreprocLineIndentMeta(openPreproc);
                if (openPreprocCurrLineIndent == Integer.MIN_VALUE) {
                    if (token.isFirstNWSTokenOnLine()) {
                        this.setPreprocIndentMeta(token, currLineIndent, 0);
                    }
                    this.popAndIndentOpenAndMiddlePreprocTokens(currLineIndent, true);
                    break;
                }
                if (!token.isFirstNWSTokenOnLine()) {
                    this.popAndIndentOpenAndMiddlePreprocTokens(openPreprocCurrLineIndent, false);
                    break;
                }
                int closePreprocLineIndent = currLineIndent;
                if (closePreprocLineIndent < openPreprocCurrLineIndent) {
                    this.setPreprocIndentMeta(token, closePreprocLineIndent, 0);
                    this.popAndIndentOpenAndMiddlePreprocTokens(closePreprocLineIndent, true);
                    break;
                }
                Object openPreprocInsideShortScope = openPreproc.getMeta(PREPROC_INSIDE_SHORT_SCOPE);
                if (openPreprocInsideShortScope != null && ((Boolean)openPreprocInsideShortScope).booleanValue()) {
                    this.setPreprocIndentMeta(token, openPreprocCurrLineIndent, -tabWidth);
                    this.popAndIndentOpenAndMiddlePreprocTokens(openPreprocCurrLineIndent, true);
                    break;
                }
                this.setPreprocIndentMeta(token, openPreprocCurrLineIndent, 0);
                this.popAndIndentOpenAndMiddlePreprocTokens(openPreprocCurrLineIndent, true);
                break;
            }
        }
    }

    private void setPreprocIndentMeta(CFToken token, int lineIndent, int nextLineIndentAdjustment) {
        token.putMeta(PREPROC_LINE_INDENT, (Object)lineIndent);
        token.putMeta(PREPROC_NEXT_LINE_INDENT_ADJUSTMENT, (Object)nextLineIndentAdjustment);
    }

    private int getPreprocLineIndentMeta(CFToken token) {
        Object preprocCurrLineIndentObj = token.getMeta(PREPROC_LINE_INDENT);
        if (preprocCurrLineIndentObj == null) {
            return Integer.MIN_VALUE;
        }
        return (Integer)preprocCurrLineIndentObj;
    }

    private int getPreprocNextLineIndentAdjustmentMeta(CFToken token) {
        Object preprocNextLineIndentObj = token.getMeta(PREPROC_NEXT_LINE_INDENT_ADJUSTMENT);
        if (preprocNextLineIndentObj == null) {
            return Integer.MIN_VALUE;
        }
        return (Integer)preprocNextLineIndentObj;
    }

    /*
     * Unable to fully structure code
     */
    private void popAndIndentOpenAndMiddlePreprocTokens(int lineIndent, boolean shouldIndent) {
        if (this.preprocsStack != null) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            peekPreprocToken = this.preprocsStack.peek();
            if (peekPreprocToken == null) {
                return;
            }
            peekPreprocType = this.fStrategy.getPreprocType(peekPreprocToken.getValue());
            if (peekPreprocType != 1 && peekPreprocType != 3) {
                return;
            }
            peekPreprocLineInfo = this.fModel.getLineInfo(peekPreprocToken.getLineNo());
            if (peekPreprocLineInfo == null) {
                return;
            }
            if (shouldIndent && peekPreprocToken.isFirstNWSTokenOnLine()) {
                CFUtils.getInstance().indentLine(peekPreprocLineInfo, lineIndent, this.fModel.indentFirstLine(), "indent preproc");
            }
            this.popPreprocToken();
            if (peekPreprocType != 1) continue;
            return;
lbl18:
            // 2 sources

            ** while (!this.preprocsStack.isEmpty())
        }
lbl19:
        // 1 sources

    }

    private CFToken popPreprocToken() {
        if (this.preprocsStack == null || this.preprocsStack.isEmpty()) {
            return null;
        }
        return this.preprocsStack.pop();
    }

    private void pushPreprocToken(CFToken token) {
        this.preprocsStack.push(token);
    }

    protected boolean isEnclosingPreprocFormattingOn() {
        if (this.preprocsStack == null || this.preprocsStack.isEmpty()) {
            return true;
        }
        CFToken enclosingPreprocToken = this.preprocsStack.peek();
        if (enclosingPreprocToken == null) {
            return true;
        }
        CFChunk preprocEnclosingChunk = enclosingPreprocToken.getEnclosingChunk();
        if (preprocEnclosingChunk == null) {
            return true;
        }
        CFLineInfo preprocEnclosingLineInfo = preprocEnclosingChunk.getEnclosingLineInfo();
        if (preprocEnclosingLineInfo == null) {
            return true;
        }
        return preprocEnclosingLineInfo.isFormatterOn();
    }

    protected boolean matchingOpenPreprocIncreasesIndent() {
        if (this.preprocsStack == null || this.preprocsStack.isEmpty()) {
            return false;
        }
        CFToken matchingOpenPreproc = this.getOpenPreprocToken();
        if (matchingOpenPreproc == null) {
            return false;
        }
        Object increasesIndentObj = matchingOpenPreproc.getMeta(PREPROC_INCREASES_INDENT);
        if (increasesIndentObj == null) {
            return false;
        }
        return (Boolean)increasesIndentObj;
    }

    private CFToken getOpenPreprocToken() {
        if (this.preprocsStack == null || this.preprocsStack.isEmpty()) {
            return null;
        }
        for (CFToken preprocToken : this.preprocsStack) {
            if (preprocToken == null) break;
            int preprocType = this.fStrategy.getPreprocType(preprocToken.getValue());
            if (preprocType != 1) continue;
            return preprocToken;
        }
        return null;
    }
}

