/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScopeScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFPreprocScanner;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCodeFormattingStrategy;

public class VlogCFScopeScanner
extends VlogCFPreprocScanner {
    private CFScopeScanner fCFScopeScanner;
    protected int fWrapThreshold;
    private String fPrevWord;
    private Set<String> fShortScopeExceptions = new HashSet<String>();
    private static Set<String> EXCEPTION_SCOPES = new HashSet<String>(Arrays.asList("constraint"));
    protected CFPreferences fFormatPreferences;
    private String fPrevKeyword;

    public VlogCFScopeScanner(CFModel model) {
        super(model);
        this.fShortScopeExceptions.add("do");
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFScopeScanner = (CFScopeScanner)cfTokenScanner;
    }

    @Override
    public void startPartition(DVTBaseFormattingStrategy strategy) {
        super.startPartition(strategy);
        this.fFormatPreferences = strategy.getFormatPreferences();
        DVTSourceViewerConfiguration sourceViewerConfiguration = this.fStrategy.getSourceViewerConfiguration();
        this.fWrapThreshold = this.fFormatPreferences.getLineWrapThreshold(sourceViewerConfiguration.isPreview());
    }

    @Override
    public void startToken(CFToken token) {
        super.startToken(token);
        if (this.isInPreproc()) {
            return;
        }
        switch (token.getTokenType()) {
            case 2: {
                String word = token.getValue();
                if ("else".equals(word)) {
                    return;
                }
                if ("while".equals(word) && this.fCFScopeScanner.hasScope("do")) {
                    return;
                }
                if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") == 0) {
                    this.fCFScopeScanner.popShouldClose(token.isFirstNWSTokenOnLine());
                }
                return;
            }
            case 10: {
                if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") == 0) {
                    this.fCFScopeScanner.popShouldClose(token.isFirstNWSTokenOnLine());
                }
                return;
            }
            case 20: {
                if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") == 0) {
                    this.fCFScopeScanner.popShouldClose(token.isFirstNWSTokenOnLine());
                }
                return;
            }
            case 3: {
                return;
            }
            case 30: {
                return;
            }
            case 40: {
                return;
            }
            case 1: {
                if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "[") == 0 && this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") == 0) {
                    this.fCFScopeScanner.popShouldClose(token.isFirstNWSTokenOnLine());
                }
                return;
            }
            case 4: {
                String tokenValue = token.getValue();
                if (tokenValue.length() != 1) break;
                char c = token.getValue().charAt(0);
                if ('(' == c || ')' == c || '}' == c || ']' == c || ';' == c || '.' == c || ',' == c) {
                    return;
                }
                if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "[") == 0 && this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") == 0) {
                    this.fCFScopeScanner.popShouldClose(token.isFirstNWSTokenOnLine());
                }
                return;
            }
        }
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (this.isInPreproc()) {
            return;
        }
        if (token == null) {
            return;
        }
        String tokenValue = token.getValue();
        block0 : switch (token.getTokenType()) {
            case 2: {
                if (this.fStrategy.getPreprocType(tokenValue) != 0) {
                    this.updateOnPreprocWord(token);
                    break;
                }
                if (this.fStrategy.getKeywordType(tokenValue) != 0) {
                    this.updateOnKeyword(token);
                    break;
                }
                if (this.fFormatPreferences.isIndentAssumeImplicitSemiMacrosEnabled() && tokenValue.startsWith("`")) {
                    this.updateOnSemi(token);
                    break;
                }
                if (!this.fStrategy.isImplicitSemiMacro(tokenValue)) break;
                this.updateOnSemi(token);
                break;
            }
            case 4: {
                if (tokenValue.length() != 1) break;
                char tokenChar = tokenValue.charAt(0);
                switch (tokenChar) {
                    case '[': {
                        this.fCFScopeScanner.updateOnBracketOpen(token);
                        break block0;
                    }
                    case ']': {
                        this.fCFScopeScanner.updateOnBracketClose(token);
                        break block0;
                    }
                    case '(': {
                        this.updateOnParenOpen(token);
                        break block0;
                    }
                    case ')': {
                        this.updateOnParenClose(token);
                        break block0;
                    }
                    case '{': {
                        this.updateOnCurlyOpen(token);
                        break block0;
                    }
                    case '}': {
                        this.updateOnCurlyClose(token);
                        break block0;
                    }
                    case ';': {
                        this.updateOnSemi(token);
                        break block0;
                    }
                    case ',': {
                        this.fCFScopeScanner.updateOnComma(token);
                        break block0;
                    }
                    case '@': {
                        this.updateOnAt(token);
                        break block0;
                    }
                    case ':': {
                        this.updateOnColon(token);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (this.isAssignmentOperator(token)) {
                    this.updateOnOperator(token);
                    break;
                }
                if (!this.isValidOperatorInsideConstraint(token, this.fCFScopeScanner.getPeekScope())) break;
                this.updateOnOperator(token);
                break;
            }
            case 3: {
                break;
            }
        }
    }

    protected String getPrevKeyword() {
        return this.fPrevKeyword;
    }

    @Override
    public void endToken(CFToken token) {
        super.endToken(token);
        if (this.isInPreproc()) {
            if (this.isInIncludePreproc() && token.getTokenType() == 10) {
                this.setInPreproc(false);
                this.setInIncludePreproc(false);
            }
            return;
        }
        String tokenValue = token.getValue();
        switch (token.getTokenType()) {
            case 2: {
                this.fPrevWord = tokenValue;
                if (this.fStrategy.getKeywordType(tokenValue) == 0 && this.fStrategy.getPreprocType(tokenValue) == 0) break;
                if ("extern".equals(this.fPrevKeyword) || "pure".equals(this.fPrevKeyword)) {
                    if ("virtual".equals(tokenValue)) break;
                    this.fPrevKeyword = tokenValue;
                    break;
                }
                this.fPrevKeyword = tokenValue;
                break;
            }
            case 3: 
            case 30: 
            case 40: {
                break;
            }
            default: {
                this.fPrevWord = null;
            }
        }
        if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") == 0 && ";".equals(tokenValue)) {
            this.fPrevKeyword = null;
        }
    }

    private void updateOnKeyword(CFToken token) {
        if (token == null) {
            return;
        }
        if (!(this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") == 0 && this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "[") == 0 || "with".equals(token.getValue()))) {
            return;
        }
        String keywordValue = token.getValue();
        int keywordType = this.fStrategy.getKeywordType(keywordValue);
        if (!((VlogCodeFormattingStrategy)this.fStrategy).isSkipIndent(this.fPrevWord, this.fPrevKeyword, keywordValue)) {
            boolean isNoIndentKeywordPref = this.fStrategy.isNoIndentKeywordPref(keywordValue);
            switch (keywordType) {
                case 4: {
                    this.updateOnBeginKeyword(token);
                    break;
                }
                case 1: {
                    this.updateOnOPENKeyword(token, isNoIndentKeywordPref);
                    break;
                }
                case 2: {
                    this.updateOnCLOSEKeyword(token);
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    if ("end".equals(keywordValue)) {
                        this.updateOnEndKeyword(token);
                    }
                    if ("if".equals(keywordValue)) {
                        this.updateOnIfKeyword(token);
                        break;
                    }
                    if ("else".equals(keywordValue)) {
                        this.updateOnElseKeyword(token);
                        break;
                    }
                    if ("while".equals(keywordValue)) {
                        this.updateOnWhileKeyword(token, isNoIndentKeywordPref);
                        break;
                    }
                    if ("default".equals(keywordValue)) {
                        CFToken nextToken = this.getFirstNWSTokenInChunkAfterCurrToken();
                        if (nextToken != null && ":".equals(nextToken.getValue())) break;
                        this.updateOnColon(token);
                        break;
                    }
                    if ("constraint".equals(keywordValue)) {
                        this.updateOnConstraintKeyword(token, isNoIndentKeywordPref);
                        break;
                    }
                    if ("with".equals(keywordValue)) {
                        this.updateOnConstraintKeyword(token, isNoIndentKeywordPref);
                        break;
                    }
                    if (!"inside".equals(keywordValue)) break;
                    this.updateOnOperator(token);
                }
            }
        }
    }

    private void updateOnBeginKeyword(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && !peekScope.isMultiConstructScope()) {
            peekScope.setMultiConstructScope();
            if (this.fFormatPreferences.isBeginPrefNewLineAndIndent()) {
                this.fCFScopeScanner.pushScope(token, "begin", CFScope.BLOCK_SCOPE, CFScope.INDENT);
            } else {
                this.fCFScopeScanner.pushScope(token, "begin", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
            }
        } else {
            this.fCFScopeScanner.pushScope(token, "begin", CFScope.BLOCK_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnEndKeyword(CFToken token) {
        this.fCFScopeScanner.updateOnEndOfBlock(token, this.fShortScopeExceptions);
    }

    private void updateOnOPENKeyword(CFToken token, boolean isNoIndentKeywordPref) {
        if (token == null) {
            return;
        }
        String keywordValue = token.getValue();
        if (keywordValue == null || keywordValue.isEmpty()) {
            return;
        }
        int indentType = CFScope.INDENT;
        if (isNoIndentKeywordPref) {
            indentType = CFScope.NO_INDENT;
        } else {
            CFScope peekScope = this.fCFScopeScanner.getPeekScope();
            if (peekScope != null && this.isAssignmentOperator(peekScope.getToken()) && peekScope.addsIndent() && peekScope.getLineNo() == token.getLineNo()) {
                indentType = CFScope.GLUE_INDENT;
            }
        }
        if (keywordValue.startsWith("always") || "initial".equals(keywordValue)) {
            this.fCFScopeScanner.pushScope(token, "always", CFScope.SHORT_SCOPE, indentType);
        } else if ("for".equals(keywordValue) || "foreach".equals(keywordValue)) {
            this.fCFScopeScanner.pushScope(token, "for", CFScope.SHORT_SCOPE, indentType);
        } else if ("forever".equals(keywordValue)) {
            this.fCFScopeScanner.pushScope(token, "forever", CFScope.SHORT_SCOPE, indentType);
        } else if ("do".equals(keywordValue)) {
            this.fCFScopeScanner.pushScope(token, "do", CFScope.SHORT_SCOPE, indentType);
        } else if ("repeat".equals(keywordValue)) {
            this.fCFScopeScanner.pushScope(token, "repeat", CFScope.SHORT_SCOPE, indentType);
        } else if ("assert".equals(keywordValue) || "assume".equals(keywordValue) || "expect".equals(keywordValue) || "wait_order".equals(keywordValue)) {
            this.fCFScopeScanner.pushScope(token, "assert", CFScope.SHORT_SCOPE, indentType);
        } else if ("cover".equals(keywordValue)) {
            this.fCFScopeScanner.pushScope(token, "cover", CFScope.SHORT_SCOPE, indentType);
        } else if ("case".equals(keywordValue) || "casex".equals(keywordValue) || "casez".equals(keywordValue) || "randcase".equals(keywordValue)) {
            this.fCFScopeScanner.pushScope(token, "case", CFScope.BLOCK_SCOPE, indentType);
        } else if (!"config".equals(keywordValue) || !this.fCFScopeScanner.hasScope("config")) {
            if ("assign".equals(keywordValue)) {
                this.fCFScopeScanner.pushScope(token, "assign", CFScope.SHORT_SCOPE, indentType);
            } else if ("module".equals(keywordValue) || "macromodule".equals(keywordValue) || "connectmodule".equals(keywordValue)) {
                this.fCFScopeScanner.pushScope(token, "module", CFScope.BLOCK_SCOPE, indentType);
            } else {
                this.fCFScopeScanner.pushScope(token, keywordValue, CFScope.BLOCK_SCOPE, indentType);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateOnCLOSEKeyword(CFToken token) {
        block13: {
            block16: {
                block15: {
                    block14: {
                        if (token == null) {
                            return;
                        }
                        keywordValue = token.getValue();
                        isFirstOnLine = token.isFirstNWSTokenOnLine();
                        if (keywordValue == null || keywordValue.isEmpty()) {
                            return;
                        }
                        if (!"endcase".equals(keywordValue)) break block14;
                        while (this.fCFScopeScanner.hasScopes()) {
                            peekScopeName = this.fCFScopeScanner.getPeekScope().getScopeName();
                            if ("case".equals(peekScopeName)) break;
                            this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                        }
                        this.fCFScopeScanner.popAndSetShouldClose(isFirstOnLine, this.fShortScopeExceptions);
                        break block13;
                    }
                    if (!"join".equals(keywordValue) && !"join_any".equals(keywordValue) && !"join_none".equals(keywordValue)) break block15;
                    peekScope = this.fCFScopeScanner.getPeekScope();
                    if (peekScope == null) {
                        return;
                    }
                    peekScopeName = peekScope.getScopeName();
                    if (peekScopeName == null) {
                        return;
                    }
                    if (!this.fCFScopeScanner.hasScopes() || !"randsequence".equals(peekScopeName) && !":".equals(peekScopeName)) {
                        while (this.fCFScopeScanner.hasScopes()) {
                            if ("fork".equals(peekScopeName)) break;
                            this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                        }
                        this.fCFScopeScanner.popAndSetShouldClose(isFirstOnLine, this.fShortScopeExceptions);
                    }
                    break block13;
                }
                if (!keywordValue.startsWith("end")) break block16;
                while (this.fCFScopeScanner.hasScopes()) {
                    peekScope = this.fCFScopeScanner.getPeekScope();
                    if (peekScope.getScopeName().contains(keywordValue.substring(3)) || "endclass".equals(keywordValue) && "interface".equals(peekScope.getScopeName())) {
                        this.fCFScopeScanner.popAndSetShouldClose(isFirstOnLine, this.fShortScopeExceptions);
                        break block13;
                    }
                    this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                }
                break block13;
            }
            if (!keywordValue.startsWith("`")) break block13;
            if (!keywordValue.endsWith("end")) ** GOTO lbl58
            while (this.fCFScopeScanner.hasScopes()) {
                peekScope = this.fCFScopeScanner.getPeekScope();
                peekScopeName = peekScope.getScopeName();
                if (peekScopeName.endsWith("begin")) {
                    this.fCFScopeScanner.popAndSetShouldClose(isFirstOnLine, this.fShortScopeExceptions);
                    break block13;
                }
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                peekScope = this.fCFScopeScanner.getPeekScope();
                peekScopeName = peekScope.getScopeName();
                if (peekScopeName.startsWith("`")) {
                    this.fCFScopeScanner.popAndSetShouldClose(isFirstOnLine, this.fShortScopeExceptions);
                    break;
                }
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
lbl58:
                // 2 sources

                ** while (this.fCFScopeScanner.hasScopes())
            }
        }
    }

    private void updateOnIfKeyword(CFToken token) {
        if (token == null) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && "else".equals(peekScope.getScopeName()) && this.fCFScopeScanner.isOnTheSameLineWithCurrentScope(token)) {
            peekScope.setScopeName("if");
            return;
        }
        this.fCFScopeScanner.pushScope(token, "if", CFScope.SHORT_SCOPE, CFScope.INDENT);
    }

    private void updateOnElseKeyword(CFToken token) {
        CFScope peekScope;
        if (token == null) {
            return;
        }
        boolean isFirstOnLine = token.isFirstNWSTokenOnLine();
        while (this.fCFScopeScanner.hasScopes() && (this.fCFScopeScanner.getPeekScope().shouldClose() || this.isAssignmentOperator(this.fCFScopeScanner.getPeekScope().getToken()))) {
            peekScope = this.fCFScopeScanner.getPeekScope();
            if ("if".equals(peekScope.getScopeName()) || "assert".equals(peekScope.getScopeName())) break;
            this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
        }
        if ((peekScope = this.fCFScopeScanner.getPeekScope()) == null) {
            return;
        }
        if ("if".equals(peekScope.getScopeName()) || "assert".equals(peekScope.getScopeName())) {
            if (peekScope.shouldClose()) {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
            } else if ("assert".equals(peekScope.getScopeName())) {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
            } else {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
                this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
            }
        } else {
            this.fCFScopeScanner.pushScope(token, "else", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnWhileKeyword(CFToken token, boolean isNoIndentKeywordPref) {
        if (token == null) {
            return;
        }
        boolean isFirstOnLine = token.isFirstNWSTokenOnLine();
        CFScope doScope = this.fCFScopeScanner.getScope("do");
        if (doScope != null && (!doScope.isMultiConstructScope() || doScope.shouldClose())) {
            while (this.fCFScopeScanner.hasScopes()) {
                String peekScopeName = this.fCFScopeScanner.getPeekScope().getScopeName();
                boolean isOpenDo = "do".equals(peekScopeName);
                if (isOpenDo) break;
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
            }
            this.fCFScopeScanner.popAndSetShouldClose(isFirstOnLine, this.fShortScopeExceptions);
        } else {
            this.fCFScopeScanner.pushScope(token, "while", CFScope.SHORT_SCOPE, isNoIndentKeywordPref ? CFScope.NO_INDENT : CFScope.INDENT);
        }
    }

    private void updateOnConstraintKeyword(CFToken token, boolean isNoIndentKeywordPref) {
        if (token == null) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && this.isAssignmentOperator(peekScope.getToken())) {
            this.fCFScopeScanner.pushScope(token, "constraint", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
            return;
        }
        this.fCFScopeScanner.pushScope(token, "constraint", CFScope.BLOCK_SCOPE, isNoIndentKeywordPref ? CFScope.NO_INDENT : CFScope.INDENT);
    }

    private void updateOnParenOpen(CFToken token) {
        this.fCFScopeScanner.updateOnParenOpen(token);
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && this.fStrategy.isImplicitSemiParamMacro(this.fPrevWord)) {
            peekScope.setIsImplicitSemiParamMacro();
        }
    }

    private void updateOnParenClose(CFToken token) {
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && this.isAssignmentOperator(peekScope.getToken())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            peekScope = this.fCFScopeScanner.getPeekScope();
            if (peekScope == null) {
                return;
            }
        }
        this.fCFScopeScanner.updateOnParenClose(token);
        if (peekScope != null && peekScope.isImplicitSemiParamMacro()) {
            this.updateOnSemi(token);
        } else {
            if (this.fCFScopeScanner.getPeekScope() != null && "constraint".equals(this.fCFScopeScanner.getPeekScope().getScopeName())) {
                this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            }
            if (this.fCFScopeScanner.getPeekScope() != null && token.isFirstNWSTokenOnLine() && peekScope != null && peekScope.getIndentKind() == CFScope.GLUE_INDENT && this.isAssignmentOperator(this.fCFScopeScanner.getPeekScope().getToken())) {
                this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            }
        }
    }

    private void updateOnCurlyOpen(CFToken token) {
        if (token == null) {
            return;
        }
        boolean isInsideParens = this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") != 0;
        CFScope peekedScope = this.fCFScopeScanner.getPeekScope();
        if (peekedScope != null) {
            if (this.fCFScopeScanner.hasOperatorsOnStack()) {
                this.updateOnCurlyOpenAfterOperator(token, peekedScope, isInsideParens);
            } else if (this.fCFScopeScanner.hasScope("constraint")) {
                this.updateOnCurlyOpenAfterConstraint(token, peekedScope, isInsideParens);
            } else if (this.fCFScopeScanner.hasScope("covergroup") && ":".equals(peekedScope.getScopeName())) {
                this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
            } else if (peekedScope.isImplicitSemiParamMacro()) {
                this.fCFScopeScanner.pushScope(token, "constraint", CFScope.BLOCK_SCOPE, CFScope.NO_INDENT);
                this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.INDENT);
            } else {
                this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.INDENT);
            }
        } else {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnCurlyOpenAfterOperator(CFToken token, CFScope peekScope, boolean isInsideParens) {
        if (this.isAssignmentOperator(peekScope.getToken()) || this.isValidOperatorInsideConstraint(peekScope.getToken(), this.fCFScopeScanner.getPrePeekScope())) {
            int indentKind = CFScope.NO_INDENT;
            indentKind = peekScope.addsIndent() && peekScope.getLineNo() == token.getLineNo() ? CFScope.GLUE_INDENT : CFScope.INDENT;
            int lineNo = token.getLineNo();
            CFLineInfo lineInfo = this.fModel.getLineInfo(lineNo);
            if (lineInfo == null) {
                return;
            }
            if (this.fFormatPreferences.isLineWrapEnabled()) {
                boolean exceedsLineWrap = this.fCFScopeScanner.exceedsLineWrap(token.getEndOffsetInLineAfterWS(), lineInfo);
                int lineBreakOffsetAdjustment = lineInfo.getLineBreakOffsetAdjustment();
                if (exceedsLineWrap || lineBreakOffsetAdjustment != 0 && lineBreakOffsetAdjustment < token.getStartOffsetInLine()) {
                    indentKind = CFScope.INDENT;
                }
            }
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, indentKind);
        } else if ("constraint".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
        } else if (!isInsideParens && !peekScope.isMultiConstructScope()) {
            peekScope.setMultiConstructScope();
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
        } else {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnCurlyOpenAfterConstraint(CFToken token, CFScope peekScope, boolean isInsideParens) {
        if ("constraint".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
        } else if (!isInsideParens && !peekScope.isMultiConstructScope()) {
            peekScope.setMultiConstructScope();
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.GLUE_INDENT);
        } else {
            this.fCFScopeScanner.pushScope(token, "{", CFScope.BLOCK_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnCurlyClose(CFToken token) {
        if (token == null) {
            return;
        }
        boolean isFirstOnLine = token.isFirstNWSTokenOnLine();
        while (this.fCFScopeScanner.hasScopes() && !this.fCFScopeScanner.getPeekScope().getScopeName().equals("{")) {
            this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (this.fCFScopeScanner.hasScopes() && peekScope.getScopeName().equals("{")) {
            boolean isOperator;
            this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
            if (this.fCFScopeScanner.hasScopes() && this.fCFScopeScanner.hasScope("constraint") && ("constraint".equals(this.fCFScopeScanner.getPeekScope().getScopeName()) || "for".equals(this.fCFScopeScanner.getPeekScope().getScopeName()) || "if".equals(this.fCFScopeScanner.getPeekScope().getScopeName()) || "else".equals(this.fCFScopeScanner.getPeekScope().getScopeName()))) {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
            }
            if (this.fCFScopeScanner.hasScopes() && this.fCFScopeScanner.hasScope("covergroup") && ":".equals(this.fCFScopeScanner.getPeekScope().getScopeName())) {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
            }
            CFToken peekToken = this.fCFScopeScanner.getPeekScope() == null ? null : this.fCFScopeScanner.getPeekScope().getToken();
            boolean bl = isOperator = peekToken != null && (this.isAssignmentOperator(peekToken) || this.isValidOperatorInsideConstraint(peekToken, this.fCFScopeScanner.getPrePeekScope()));
            if (this.fCFScopeScanner.hasScopes() && token.isFirstNWSTokenOnLine() && peekScope.getIndentKind() == CFScope.GLUE_INDENT && isOperator) {
                this.fCFScopeScanner.popScopeAndUpdate(isFirstOnLine);
            }
        }
    }

    private void updateOnColon(CFToken token) {
        if (token == null) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScopeIgnoreAssignmentOperators();
        if (peekScope == null) {
            return;
        }
        String peekScopeName = peekScope.getScopeName();
        if ("case".equals(peekScopeName) || "covergroup".equals(peekScopeName) || "randsequence".equals(peekScopeName)) {
            this.fCFScopeScanner.pushScope(token, ":", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }

    private void updateOnOperator(CFToken token) {
        if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "[") != 0) {
            return;
        }
        if (token == null) {
            return;
        }
        String tokenValue = token.getValue();
        if (tokenValue == null) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            this.fCFScopeScanner.pushScope(token, tokenValue, CFScope.SHORT_SCOPE, CFScope.INDENT);
            return;
        }
        String peekScopeName = peekScope.getScopeName();
        if (peekScopeName == null) {
            return;
        }
        int tokenLineNo = token.getLineNo();
        int peekScopeLineNo = peekScope.getLineNo();
        int peekScopeIndentKind = peekScope.getIndentKind();
        if ("(".equals(peekScopeName)) {
            CFScope prePeekScope = this.fCFScopeScanner.getPrePeekScope();
            if (prePeekScope != null && prePeekScope.isShortScope() && !this.isAssignmentOperator(prePeekScope.getToken())) {
                return;
            }
            CFLineInfo tokenLineInfo = this.fModel.getLineInfo(tokenLineNo);
            if (tokenLineInfo == null) {
                return;
            }
            CFToken peekToken = peekScope.getToken();
            if (peekToken == null) {
                return;
            }
            int startOffsetInLine = peekToken.getStartOffsetInLine();
            int lineBreakOffset = tokenLineInfo.getLineBreakOffsetAdjustment();
            if (tokenLineInfo.hasLineBreak() && lineBreakOffset > startOffsetInLine && lineBreakOffset < token.getStartOffsetInLine()) {
                this.fCFScopeScanner.pushScope(token, tokenValue, CFScope.SHORT_SCOPE, CFScope.INDENT);
                return;
            }
            if ((peekScopeIndentKind == CFScope.INDENT || peekScopeIndentKind == CFScope.GLUE_INDENT) && peekScopeLineNo == tokenLineNo) {
                this.fCFScopeScanner.pushScope(token, tokenValue, CFScope.SHORT_SCOPE, CFScope.GLUE_INDENT);
                return;
            }
            this.fCFScopeScanner.pushScope(token, tokenValue, CFScope.SHORT_SCOPE, CFScope.INDENT);
            return;
        }
        boolean firstNWSTokenOnLine = token.isFirstNWSTokenOnLine();
        if (firstNWSTokenOnLine) {
            this.fCFScopeScanner.pushScope(token, tokenValue, CFScope.SHORT_SCOPE, CFScope.INDENT);
            return;
        }
        if (peekScopeIndentKind == CFScope.NO_INDENT) {
            this.fCFScopeScanner.pushScope(token, tokenValue, CFScope.SHORT_SCOPE, CFScope.NO_INDENT);
            return;
        }
        if ((peekScopeIndentKind == CFScope.INDENT || peekScopeIndentKind == CFScope.GLUE_INDENT) && peekScopeLineNo == tokenLineNo) {
            this.fCFScopeScanner.pushScope(token, tokenValue, CFScope.SHORT_SCOPE, CFScope.GLUE_INDENT);
            return;
        }
        this.fCFScopeScanner.pushScope(token, tokenValue, CFScope.SHORT_SCOPE, CFScope.INDENT);
    }

    private void updateOnAt(CFToken token) {
        if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "[") != 0 || this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") != 0) {
            return;
        }
        if (token == null) {
            return;
        }
        if (!this.fCFScopeScanner.hasScopes() || !"always".equals(this.fCFScopeScanner.getPeekScope().getScopeName())) {
            this.fCFScopeScanner.pushScope(token, "@", CFScope.SHORT_SCOPE, CFScope.INDENT);
        }
    }

    private boolean isValidOperatorInsideConstraint(CFToken currentToken, CFScope enclosingScope) {
        if (currentToken == null || enclosingScope == null) {
            return false;
        }
        if (!this.fCFScopeScanner.hasScope("constraint")) {
            return false;
        }
        CFToken enclosingToken = enclosingScope.getToken();
        if (enclosingToken == null) {
            return false;
        }
        String enclosingTokenValue = enclosingToken.getValue();
        if (enclosingTokenValue == null) {
            return false;
        }
        if (!"{".equals(enclosingTokenValue)) {
            return false;
        }
        String currentTokenValue = currentToken.getValue();
        if (currentTokenValue == null) {
            return false;
        }
        if (!this.fStrategy.isRelationalOperatorKeyword(currentTokenValue) && !this.fStrategy.isEqualityOperatorKeyword(currentTokenValue)) {
            return false;
        }
        return this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") == 0 && this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "[") == 0;
    }

    private void updateOnSemi(CFToken token) {
        if (token == null) {
            return;
        }
        if (!this.fCFScopeScanner.hasScopes()) {
            return;
        }
        CFScope peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        if (this.isValidOperatorInsideConstraint(peekScope.getToken(), this.fCFScopeScanner.getPrePeekScope())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            return;
        }
        CFToken peekToken = peekScope.getToken();
        if (peekToken == null) {
            return;
        }
        if (this.isAssignmentOperator(peekToken)) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        }
        if (this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "(") != 0 || this.fCFScopeScanner.getNofOpenParensUntilScope(EXCEPTION_SCOPES, "[") != 0) {
            return;
        }
        if (peekScope != null && "@".equals(peekScope.getScopeName()) && !peekScope.isMultiConstructScope()) {
            this.fCFScopeScanner.popScopeAndUpdate(false);
        }
        if ((peekScope = this.fCFScopeScanner.getPeekScope()) != null && "constraint".equals(peekScope.getScopeName())) {
            this.fCFScopeScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            return;
        }
        peekScope = this.fCFScopeScanner.getPeekScope();
        if (peekScope != null && peekScope.isMultiConstructScope()) {
            return;
        }
        if (peekScope != null && "do".equals(peekScope.getScopeName())) {
            return;
        }
        this.fCFScopeScanner.setShouldCloseShortScopeAndRecurseUntilMultiConstructOrExceptions(this.fShortScopeExceptions);
    }

    protected void updateOnPreprocWord(CFToken token) {
        if (token == null) {
            return;
        }
        if (!this.fFormatPreferences.isPreprocPrefIndentContent() && !this.fFormatPreferences.isPreprocPrefIndentContentExceptFirst()) {
            return;
        }
        switch (this.fStrategy.getPreprocType(token.getValue())) {
            case 1: {
                if (this.fFormatPreferences.isPreprocPrefIndentContent()) {
                    this.fCFScopeScanner.incrNextLineIndentLevel();
                    token.putMeta("preprocIncreasesIndent", (Object)true);
                    break;
                }
                if (!this.preprocsStack.isEmpty()) {
                    this.fCFScopeScanner.incrNextLineIndentLevel();
                    token.putMeta("preprocIncreasesIndent", (Object)true);
                    break;
                }
                token.putMeta("preprocIncreasesIndent", (Object)false);
                break;
            }
            case 3: {
                this.fCFScopeScanner.decrCurrLineIndentLevel(token.isFirstNWSTokenOnLine());
                break;
            }
            case 2: {
                if (!this.matchingOpenPreprocIncreasesIndent()) break;
                this.fCFScopeScanner.decrNextLineIndentLevel(token.isFirstNWSTokenOnLine());
                break;
            }
        }
    }

    public String getPrevKeywordToken() {
        return this.fPrevKeyword;
    }
}

