/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExBaseDefinition;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExPattern;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.NamedMatcher;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;

public class VlogCFVRegExDefinitionByNamePortConnections
extends CFVRegExBaseDefinition {
    private static final Pattern MULTIPLE_PORT_CONNECTIONS_ON_LINE = Pattern.compile((String)"(?:[\\.][ ]*)\\w+[ ]*[(]");
    private int efNofOpenParen;
    private CFVScope openParenVScope;
    private CFVScope lineVScope;
    private int noPreproc;

    public VlogCFVRegExDefinitionByNamePortConnections() {
        super("VlogByNamePortConnections", "By Name Port Connections", false);
    }

    public void definePattern(boolean splitDimenions) {
        this.fOrderedGroupNames = new ArrayList();
        this.fOrderedGroupNames.add("pfrom");
        this.fOrderedGroupNames.add("ppopen");
        this.fOrderedGroupNames.add("pto");
        this.fOrderedGroupNames.add("ppclose");
        this.fOrderedGroupNames.add("pcomment");
        this.fVRegExPatterns = new ArrayList();
        LinkedHashMap<String, String> patternFragments = new LinkedHashMap<String, String>();
        patternFragments = new LinkedHashMap();
        patternFragments.put("OPT_COMMA_1", "(?:.*\\([ ]*|[,][ ]*)?");
        patternFragments.put("pfrom", "(?<pfrom>(?:[\\.][ ]*)\\w+)");
        patternFragments.put("OPT_WS_1", "[ ]*");
        patternFragments.put("ppopen", "(?<ppopen>[(][ ]*)");
        patternFragments.put("pto", "(?<pto>(?:(?:(?!//).)*))");
        patternFragments.put("ppclose", "(?<ppclose>\\)[ ]*(?=,|\\);|\\s))");
        patternFragments.put("REST_1", "(?:(?:(?!//).)*)");
        patternFragments.put("pcomment", "(?<pcomment>" + this.FRAGMENT_VLOG_SL_COMMENT + ")?");
        this.fVRegExPatterns.add(new CFVRegExPattern(patternFragments, ""));
    }

    protected void definePatternSplitDimensions() {
    }

    protected void definePatternGroupDimensions() {
    }

    public boolean isValidRegExVScope(CFVRegExScanner vRegExScanner) {
        if (this.lineVScope != null) {
            return true;
        }
        if (vRegExScanner == null) {
            return false;
        }
        CFScope peekScope = vRegExScanner.getPeekScopeIgnoreOperatorsAndPreproc();
        if (peekScope == null) {
            return false;
        }
        if (!"(".equals(peekScope.getScopeName())) {
            return false;
        }
        if (vRegExScanner.hasScope("module")) {
            return true;
        }
        return true;
    }

    public void endToken(CFToken token, CFVRegExScanner vRegExScanner) {
        if (token == null) {
            return;
        }
        String tokenValue = token.getValue();
        DVTBaseCodeFormattingStrategy codeFormattingStrategy = vRegExScanner.getCodeFormattingStrategy();
        if (codeFormattingStrategy == null) {
            return;
        }
        int preprocType = codeFormattingStrategy.getPreprocType(tokenValue);
        if (preprocType == 1) {
            ++this.noPreproc;
        } else if (preprocType == 2) {
            --this.noPreproc;
        }
        if (this.noPreproc != 0) {
            return;
        }
        if ("(".equals(tokenValue) || "#(".equals(tokenValue)) {
            ++this.efNofOpenParen;
            if (this.efNofOpenParen == 1) {
                this.lineVScope = this.openParenVScope = vRegExScanner.getCurrentVScope();
            }
        } else if (")".equals(tokenValue)) {
            --this.efNofOpenParen;
        } else if (this.efNofOpenParen == 0 && ";".equals(tokenValue)) {
            this.efNofOpenParen = 0;
            this.openParenVScope = null;
        }
    }

    public CFVScope getVScope(CFVScope vScope, CFVRegExScanner vRegExScanner) {
        if (this.noPreproc != 0) {
            return vScope;
        }
        if (this.lineVScope != null) {
            return this.lineVScope;
        }
        return super.getVScope(vScope, vRegExScanner);
    }

    public boolean isValidMatch(NamedMatcher nMatcher) {
        Map groups = nMatcher.alternativeNamedGroups();
        if (groups == null) {
            return false;
        }
        for (Map.Entry entry : groups.entrySet()) {
            Matcher matcher;
            String value;
            String identifier = (String)entry.getKey();
            if (!"pto".equals(identifier) || (value = (String)entry.getValue()) == null || !(matcher = MULTIPLE_PORT_CONNECTIONS_ON_LINE.matcher((CharSequence)value)).find()) continue;
            return false;
        }
        return true;
    }

    public void resetState() {
        this.noPreproc = 0;
        this.efNofOpenParen = 0;
        this.openParenVScope = null;
        this.lineVScope = null;
    }
}

