/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExScanner;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExBaseDefinitionPortDeclaration;

public class VlogCFVRegExDefinitionModulePortDeclaration
extends VlogCFVRegExBaseDefinitionPortDeclaration {
    private CFVScope lineVScope;
    private boolean efGotModule;
    private int efNofOpenParen;
    private CFVScope openParenVScope;
    private int noPreproc;
    private boolean importInHeader;

    public VlogCFVRegExDefinitionModulePortDeclaration(boolean splitDimensions) {
        super(splitDimensions ? "VlogModulePortDeclarations" : "VlogModulePortDeclarationsGroupDimensions", splitDimensions ? "Module Port Declarations (split dimensions)" : "Module Port Declarations", splitDimensions);
    }

    public boolean isValidRegExVScope(CFVRegExScanner vRegExScanner) {
        return this.lineVScope != null;
    }

    public void endToken(CFToken token, CFVRegExScanner vRegExScanner) {
        if (token == null) {
            return;
        }
        if (token.isFirstNWSTokenOnLine()) {
            this.lineVScope = this.openParenVScope;
        }
        String tokenValue = token.getValue();
        DVTBaseCodeFormattingStrategy codeFormattingStrategy = vRegExScanner.getCodeFormattingStrategy();
        if (codeFormattingStrategy == null) {
            return;
        }
        int preprocType = codeFormattingStrategy.getPreprocType(tokenValue);
        if (preprocType == 1) {
            ++this.noPreproc;
        } else if (preprocType == 2) {
            --this.noPreproc;
        }
        if (this.noPreproc != 0) {
            return;
        }
        if (this.efGotModule) {
            if ("(".equals(tokenValue)) {
                ++this.efNofOpenParen;
                if (this.efNofOpenParen == 1) {
                    this.lineVScope = this.openParenVScope = vRegExScanner.getCurrentVScope();
                }
            } else if (this.efGotModule && ")".equals(tokenValue)) {
                --this.efNofOpenParen;
            } else if (this.efNofOpenParen == 0 && ";".equals(tokenValue)) {
                if (this.importInHeader) {
                    this.importInHeader = false;
                } else {
                    this.efGotModule = false;
                    this.openParenVScope = null;
                }
            } else if ("import".equals(tokenValue)) {
                this.importInHeader = true;
            }
        } else if ("module".equals(tokenValue)) {
            this.efGotModule = true;
            this.efNofOpenParen = 0;
            this.openParenVScope = null;
            this.importInHeader = false;
        }
    }

    public CFVScope getVScope(CFVScope vScope, CFVRegExScanner vRegExScanner) {
        if (this.noPreproc != 0) {
            return vScope;
        }
        if (this.lineVScope != null) {
            return this.lineVScope;
        }
        return vScope;
    }

    @Override
    public void resetState() {
        this.efGotModule = false;
        this.efNofOpenParen = 0;
        this.noPreproc = 0;
        this.openParenVScope = null;
        this.lineVScope = null;
    }
}

