/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.CFVScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.vertical.ICFVTokenScannerImpl;
import ro.amiq.dvt.ui.editor.formatter.util.CFSyso;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFScopeScanner;

public class VlogCFVScanner
extends VlogCFScopeScanner
implements ICFVTokenScannerImpl {
    private CFVScanner fCFVScanner;

    public VlogCFVScanner(CFModel model) {
        super(model);
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFVScanner = (CFVScanner)cfTokenScanner;
    }

    @Override
    public void startChunk(CFChunk chunk) {
        super.startChunk(chunk);
        this.fCFVScanner.verticalAlignStartChunk(chunk);
    }

    @Override
    public void endChunk(CFChunk chunk) {
        super.endChunk(chunk);
        this.fCFVScanner.verticalAlignEndChunk(chunk);
    }

    @Override
    public void startToken(CFToken token) {
        super.startToken(token);
        this.fCFVScanner.verticalAlignStartToken(token);
    }

    @Override
    public void endToken(CFToken token) {
        super.endToken(token);
        this.fCFVScanner.verticalAlignEndToken(token);
    }

    public void verticalAlign() {
        this.fCFVScanner.verticalAlign();
    }

    public void compactWSForVerticalAlignPatterns() {
        this.fCFVScanner.compactWSForVerticalAlignPatterns();
    }

    public CFVScope createVScope(CFToken token, String scopeName, boolean isShortScope, int indentKind) {
        if (token == null) {
            return null;
        }
        CFVScope currentVScope = this.fCFVScanner.getCurrentVScope();
        if (currentVScope == null) {
            return null;
        }
        int vScopeId = currentVScope.getVScopeId();
        int vScopeLevel = currentVScope.getVScopeLevel();
        if (!"begin".equals(scopeName) && !"assign".equals(scopeName)) {
            if ("if".equals(scopeName) || "else".equals(scopeName) || ":".equals(scopeName)) {
                this.fCFVScanner.setVScopeLevel(++vScopeLevel);
            } else {
                vScopeId = this.fCFVScanner.getVScopeId() + 1;
                vScopeLevel = 0;
                this.fCFVScanner.setVScopeId(vScopeId);
                this.fCFVScanner.setVScopeLevel(vScopeLevel);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("create scope: ").append(scopeName).append(" id:").append(vScopeId).append(" level:").append(vScopeLevel);
        CFSyso.println((String)"VALIGN", (StringBuilder)sb);
        return new CFVScope(token, scopeName, isShortScope, indentKind, vScopeId, vScopeLevel, token.getStartOffsetInLine());
    }

    @Override
    protected void updateOnPreprocWord(CFToken token) {
        super.updateOnPreprocWord(token);
        if (!this.fFormatPreferences.isVerticalAlignIndependentIfdefs()) {
            return;
        }
        if (token == null) {
            return;
        }
        int preprocType = this.fStrategy.getPreprocType(token.getValue());
        switch (preprocType) {
            case 1: {
                this.fCFVScanner.pushScope(token, token.getValue(), false, CFScope.NO_INDENT);
                break;
            }
            case 3: {
                this.fCFVScanner.pushScope(token, token.getValue(), false, CFScope.NO_INDENT);
                break;
            }
            case 2: {
                this.fCFVScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
            }
        }
    }
}

