/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum VlogCodeFormattingKeywordsSet {
    INSTANCE;

    public final String BEGIN_KEYWORD_VALUE = "begin";
    protected final Set<String> OPEN_CODE_BLOCK_KEYWORDS = new HashSet<String>(Arrays.asList("module", "macromodule", "connectmodule", "checker", "primitive", "package", "function", "task", "class", "property", "generate", "specify", "clocking", "config", "table", "program", "interface", "case", "casez", "casex", "randcase", "covergroup", "sequence", "randsequence", "fork", "`ifdef", "`ifndef", "`else", "`elsif", "begin"));
    protected final Set<String> CLOSE_CODE_BLOCK_KEYWORDS = new HashSet<String>(Arrays.asList("endmodule", "endconnectmodule", "endchecker", "endprimitive", "endpackage", "endfunction", "endtask", "endclass", "endproperty", "endgenerate", "endspecify", "endclocking", "endconfig", "endtable", "endprogram", "endinterface", "endcase", "endgroup", "endsequence", "join", "join_any", "join_none", "`endif", "end"));
    protected final Set<String> OPEN_KEYWORDS = new HashSet<String>(Arrays.asList("module", "macromodule", "connectmodule", "checker", "primitive", "package", "function", "task", "class", "property", "generate", "specify", "clocking", "config", "table", "program", "interface", "case", "casez", "casex", "randcase", "covergroup", "sequence", "randsequence", "fork", "always", "always_ff", "always_latch", "always_comb", "initial", "for", "foreach", "forever", "do", "repeat", "assert", "assume", "expect", "wait_order", "assign", "cover"));
    protected final Set<String> CLOSE_KEYWORDS = new HashSet<String>(Arrays.asList("endmodule", "endconnectmodule", "endchecker", "endprimitive", "endpackage", "endfunction", "endtask", "endclass", "endproperty", "endgenerate", "endspecify", "endclocking", "endconfig", "endtable", "endprogram", "endinterface", "endcase", "endgroup", "endsequence", "join", "join_any", "join_none"));
    protected final Set<String> SPECIAL_KEYWORDS = new HashSet<String>(Arrays.asList("end", "if", "else", "while", "default", "constraint", "with", "inside"));
    protected final Set<String> SIMPLE_KEYWORDS = new HashSet<String>(Arrays.asList("cover", "input", "inout", "output", "restrict", "extern", "virtual", "import", "int", "export", "typedef", "enum", "pure", "disable", "wait"));
    protected final Set<String> OPEN_PREPROCS = new HashSet<String>(Arrays.asList("`ifdef", "`ifndef"));
    protected final Set<String> CLOSE_PREPROCS = new HashSet<String>(Arrays.asList("`endif"));
    protected final Set<String> MIDDLE_PREPROCS = new HashSet<String>(Arrays.asList("`else", "`elsif"));
    protected final Set<String> SIMPLE_PREPROCS = new HashSet<String>(Arrays.asList("`begin_keywords", "`end_keywords", "`celldefine", "`endcelldefine", "`resetall", "`nounconnected_drive", "`undefineall"));
    protected final Set<String> COMPLEX_PREPROCS = new HashSet<String>(Arrays.asList("`define", "`include", "`line", "`timescale", "`undef", "`default_nettype", "`pragma", "`unconnected_drive"));
    protected final Set<String> ALL_PREPROCS = this.createAllPreprocsSet();
    protected final Set<String> ASSIGNMENT_OPERATORS = new HashSet<String>(Arrays.asList("=", "+=", "-=", "*=", "/=", "%=", "&=", "|=", "^=", ">>=", "<<=", ">>>=", "<<<=", ":=", ":/", "<=", "|->", "|=>"));
    protected final Set<String> RELATIONAL_OPERATORS = new HashSet<String>(Arrays.asList("<", "<=", ">", ">="));
    protected final Set<String> EQUALITY_OPERATORS = new HashSet<String>(Arrays.asList("==", "!="));
    protected final Map<String[], String[]> SKIP_INDENT_KEYWORD_PAIRS = new HashMap<String[], String[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(new String[]{"typedef"}, new String[]{"interface", "class"});
            this.put(new String[]{"modport"}, new String[]{"clocking"});
            this.put(new String[]{"wait"}, new String[]{"fork"});
            this.put(new String[]{"disable"}, new String[]{"fork"});
            this.put(new String[]{"cover", "restrict", "assert", "assume"}, new String[]{"property"});
            this.put(new String[]{"input", "inout", "output", "cover", "default"}, new String[]{"sequence"});
            this.put(new String[]{"extern", "with", "import", "pure", "export"}, new String[]{"function"});
            this.put(new String[]{"extern", "pure", "import", "export"}, new String[]{"task"});
            this.put(new String[]{"int"}, new String[]{"checker", "config", "table"});
            this.put(new String[]{"extern"}, new String[]{"module", "macromodule", "program", "primitive"});
            this.put(new String[]{"virtual", "extern"}, new String[]{"interface"});
            this.put(new String[]{"interface"}, new String[]{"class"});
        }
    };
    protected final Set<String> XVM_MACRO_OPEN_SUFFIXES = new HashSet<String>(Arrays.asList("_field_utils_begin", "_component_utils_begin", "_component_abstract_utils_begin", "_component_param_utils_begin", "_component_abstract_param_utils_begin", "_object_utils_begin", "_object_abstract_utils_begin", "_object_param_utils_begin", "_object_abstract_param_utils_begin", "_sequence_utils_begin", "_sequencer_utils_begin", "_sequencer_param_utils_begin"));
    protected final Set<String> XVM_MACRO_CLOSE_SUFFIXES = new HashSet<String>(Arrays.asList("_field_utils_end", "_component_utils_end", "_component_abstract_utils_end", "_component_param_utils_end", "_component_abstract_param_utils_end", "_object_utils_end", "_object_abstract_utils_end", "_object_param_utils_end", "_object_abstract_param_utils_end", "_sequence_utils_end", "_sequencer_utils_end"));
    protected final Set<Character> WITHOUT_BOUNDARY_ALIGN_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf(';'), Character.valueOf('{'), Character.valueOf('}')));
    protected final Set<Character> BOUNDARY_ALIGN_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf(';'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(')'), Character.valueOf('('), Character.valueOf(']'), Character.valueOf('['), Character.valueOf(',')));

    private Set<String> createAllPreprocsSet() {
        HashSet<String> all_preprocs = new HashSet<String>();
        all_preprocs.addAll(this.OPEN_PREPROCS);
        all_preprocs.addAll(this.CLOSE_PREPROCS);
        all_preprocs.addAll(this.MIDDLE_PREPROCS);
        all_preprocs.addAll(this.SIMPLE_PREPROCS);
        all_preprocs.addAll(this.COMPLEX_PREPROCS);
        return all_preprocs;
    }
}

