/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCodeFormattingKeywordsSet;
import ro.amiq.vlogdt.ui.editor.formatter.VlogFormattingPreferences;

public class VlogCodeFormattingStrategy
extends DVTBaseCodeFormattingStrategy {
    public VlogCodeFormattingStrategy(VlogSourceViewerConfiguration configuration, CFPreferences formatPreferences) {
        super((DVTSourceViewerConfiguration)configuration, formatPreferences);
    }

    protected void refreshFormattingPreferences() {
        super.refreshFormattingPreferences();
        if (!(this.fFormatPreferences instanceof VlogFormattingPreferences)) {
            return;
        }
        VlogFormattingPreferences formatPreferences = (VlogFormattingPreferences)this.fFormatPreferences;
        formatPreferences.refreshImplicitSemiMacrosPref();
        formatPreferences.refreshOpenScopeMacros();
        formatPreferences.refreshCloseScopeMacros();
    }

    protected Set<Character> getBoundaryVAlignChars() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.BOUNDARY_ALIGN_CHARS;
    }

    public Set<String> getOpenCodeBlockKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.OPEN_CODE_BLOCK_KEYWORDS;
    }

    public Set<String> getOpenKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.OPEN_KEYWORDS;
    }

    public Set<String> getCloseCodeBlockKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.CLOSE_CODE_BLOCK_KEYWORDS;
    }

    public Set<String> getCloseKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.CLOSE_KEYWORDS;
    }

    public Set<String> getSimpleKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.SIMPLE_KEYWORDS;
    }

    public Set<String> getSpecialKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.SPECIAL_KEYWORDS;
    }

    public Set<String> getOpenPreprocs() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.OPEN_PREPROCS;
    }

    public Set<String> getMiddlePreprocs() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.MIDDLE_PREPROCS;
    }

    public Set<String> getClosePreprocs() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.CLOSE_PREPROCS;
    }

    public Set<String> getSimplePreprocs() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.SIMPLE_PREPROCS;
    }

    public Set<String> getComplexPreprocs() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.COMPLEX_PREPROCS;
    }

    public Set<String> getAllPreprocs() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.ALL_PREPROCS;
    }

    public String getBeginKeyword() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.BEGIN_KEYWORD_VALUE;
    }

    public Map<String[], String[]> getSkipIndentKeywordPairs() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.SKIP_INDENT_KEYWORD_PAIRS;
    }

    public Set<String> getAssignmentOperatorKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.ASSIGNMENT_OPERATORS;
    }

    public Set<String> getRelationalOperatorKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.RELATIONAL_OPERATORS;
    }

    public Set<String> getEqualityOperatorKeywords() {
        return VlogCodeFormattingKeywordsSet.INSTANCE.EQUALITY_OPERATORS;
    }

    public boolean isImplicitSemiMacro(String word) {
        if (!(this.fFormatPreferences instanceof VlogFormattingPreferences)) {
            return false;
        }
        Set<String> implicitSemiMacrosPref = ((VlogFormattingPreferences)this.fFormatPreferences).getImplicitSemiMacrosPref();
        if (implicitSemiMacrosPref == null) {
            return false;
        }
        return implicitSemiMacrosPref.contains(word);
    }

    public boolean isImplicitSemiParamMacro(String word) {
        if (!(this.fFormatPreferences instanceof VlogFormattingPreferences)) {
            return false;
        }
        Set<String> implicitSemiParamMacrosPref = ((VlogFormattingPreferences)this.fFormatPreferences).getImplicitSemiParamMacrosPref();
        if (implicitSemiParamMacrosPref == null) {
            return false;
        }
        return implicitSemiParamMacrosPref.contains(word);
    }

    protected boolean isClosingToken(String tokenValue) {
        if (tokenValue == null) {
            return false;
        }
        if (this.isCloseKeyword(tokenValue)) {
            return true;
        }
        if (this.isCloseXVMMacro(tokenValue)) {
            return true;
        }
        if (this.isCloseScopeMacro(tokenValue)) {
            return true;
        }
        if ("end".equals(tokenValue)) {
            return true;
        }
        return "}".equals(tokenValue) || ")".equals(tokenValue) || "]".equals(tokenValue);
    }

    public int getKeywordType(String word) {
        if (this.isOpenScopeMacro(word)) {
            return 1;
        }
        if (this.isCloseScopeMacro(word)) {
            return 2;
        }
        if (this.isOpenXVMMacro(word)) {
            return 1;
        }
        if (this.isCloseXVMMacro(word)) {
            return 2;
        }
        return super.getKeywordType(word);
    }

    private boolean isOpenScopeMacro(String word) {
        if (!(this.fFormatPreferences instanceof VlogFormattingPreferences)) {
            return false;
        }
        Set<String> openScopeMacrosPref = ((VlogFormattingPreferences)this.fFormatPreferences).getOpenScopeMacrosPref();
        if (openScopeMacrosPref == null) {
            return false;
        }
        return openScopeMacrosPref.contains(word);
    }

    private boolean isCloseScopeMacro(String word) {
        if (!(this.fFormatPreferences instanceof VlogFormattingPreferences)) {
            return false;
        }
        Set<String> closeScopeMacrosPref = ((VlogFormattingPreferences)this.fFormatPreferences).getCloseScopeMacrosPref();
        if (closeScopeMacrosPref == null) {
            return false;
        }
        return closeScopeMacrosPref.contains(word);
    }

    private boolean isOpenXVMMacro(String word) {
        if (!word.startsWith("`ovm") && !word.startsWith("`uvm")) {
            return false;
        }
        word = word.substring(4);
        return VlogCodeFormattingKeywordsSet.INSTANCE.XVM_MACRO_OPEN_SUFFIXES.contains(word);
    }

    private boolean isCloseXVMMacro(String word) {
        if (!word.startsWith("`ovm") && !word.startsWith("`uvm")) {
            return false;
        }
        word = word.substring(4);
        return VlogCodeFormattingKeywordsSet.INSTANCE.XVM_MACRO_CLOSE_SUFFIXES.contains(word);
    }

    public boolean isSkipIndent(String prevWord, String prevKeyword, String word) {
        if ("fork".equals(word) && prevWord == null && "wait".equals(prevKeyword)) {
            return false;
        }
        return super.isSkipIndent(prevKeyword, word);
    }

    public boolean isWordChar(char c, char prevChar, char nextChar, StringBuilder currWord) {
        char prevPrevChar = '\u0000';
        if (currWord != null && currWord.length() > 2) {
            prevPrevChar = currWord.charAt(currWord.length() - 2);
        }
        return Character.isJavaIdentifierPart(c) || c == '`' || c == '\'' || c == '.' || c == '+' && (prevChar == 'E' || prevChar == 'e') && Character.isDigit(prevPrevChar) || c == '-' && (prevChar == 'E' || prevChar == 'e') && Character.isDigit(prevPrevChar);
    }

    public boolean isSingleChar(char c, char prevChar, char nextChar) {
        if (c == '@' || c == '#' && prevChar != '#' && nextChar != '#') {
            return true;
        }
        if (c == ':') {
            if (prevChar == '-' || prevChar == '+') {
                return false;
            }
            if (nextChar == '=' || nextChar == '/') {
                return false;
            }
            return prevChar != ':' && nextChar != ':';
        }
        if (c == '-' && nextChar == ':') {
            return false;
        }
        if (c == '+' && nextChar == ':') {
            return false;
        }
        if (c == '=' && prevChar == ':') {
            return false;
        }
        if (c == '/' && prevChar == ':') {
            return false;
        }
        return super.isSingleChar(c, prevChar, nextChar);
    }

    public boolean isValidVAlignBoundaryChar(String vTokenString, char ch, boolean before) {
        if (before && ")".equals(vTokenString) && ch != '*') {
            return true;
        }
        if (!before && "(".equals(vTokenString) && ch != '*') {
            return true;
        }
        return super.isValidVAlignBoundaryChar(vTokenString, ch, before);
    }

    public boolean allowWhitespaceBeforeToken(CFToken token) {
        if (token == null) {
            return true;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return true;
        }
        String tokenValue = token.getValue();
        if (tokenValue == null || tokenValue.length() == 0) {
            return true;
        }
        char tokenChar = tokenValue.charAt(0);
        if (tokenChar == '?') {
            return false;
        }
        if (tokenChar != '*' && tokenChar != ')' && tokenChar != ':' && tokenChar != '=' && tokenChar != '/') {
            return true;
        }
        int tokenStartOffsetInChunk = token.getStartOffsetInChunk();
        String chunkValue = chunk.getValue();
        if (chunkValue == null) {
            return true;
        }
        int prevChar = 0;
        if (tokenStartOffsetInChunk - 1 >= 0) {
            prevChar = chunkValue.charAt(tokenStartOffsetInChunk - 1);
        }
        if (40 == prevChar && '*' == tokenChar) {
            return false;
        }
        if (46 == prevChar && '*' == tokenChar) {
            return false;
        }
        if (42 == prevChar && ')' == tokenChar) {
            return false;
        }
        if (43 == prevChar && ':' == tokenChar) {
            return false;
        }
        if (45 == prevChar && ':' == tokenChar) {
            return false;
        }
        if (58 == prevChar && '=' == tokenChar) {
            return false;
        }
        return 58 != prevChar || '/' != tokenChar;
    }

    public boolean allowWhitespaceAfterToken(CFToken token) {
        if (token == null) {
            return true;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return true;
        }
        String tokenValue = token.getValue();
        if (tokenValue == null || tokenValue.length() == 0) {
            return true;
        }
        char tokenChar = tokenValue.charAt(0);
        if (tokenChar == '?') {
            return false;
        }
        if (tokenChar != '*' && tokenChar != '.' && tokenChar != '(' && tokenChar != '+' && tokenChar != '-' && tokenChar != ':') {
            return true;
        }
        int tokenEndOffsetInChunk = token.getEndOffsetInChunk();
        String chunkValue = chunk.getValue();
        if (chunkValue == null) {
            return true;
        }
        char nextChar = '\u0000';
        if (tokenEndOffsetInChunk < chunkValue.length()) {
            nextChar = chunkValue.charAt(tokenEndOffsetInChunk);
        }
        if ('(' == tokenChar && '*' == nextChar) {
            return false;
        }
        if ('.' == tokenChar && '*' == nextChar) {
            return false;
        }
        if ('*' == tokenChar && ')' == nextChar) {
            return false;
        }
        if ('+' == tokenChar && ':' == nextChar) {
            return false;
        }
        if ('-' == tokenChar && ':' == nextChar) {
            return false;
        }
        if (':' == tokenChar && '=' == nextChar) {
            return false;
        }
        return ':' != tokenChar || '/' != nextChar;
    }
}

