/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseLiteralFormattingStrategy;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;

public class VlogEscapedIDFormattingStrategy
extends DVTBaseLiteralFormattingStrategy {
    public VlogEscapedIDFormattingStrategy(VlogSourceViewerConfiguration configuration, CFPreferences formatPreferences) {
        super((DVTSourceViewerConfiguration)configuration, formatPreferences);
    }

    protected List<CFToken> createTokens(CFModel model, CFChunk chunk) {
        ArrayList<CFToken> result = new ArrayList<CFToken>();
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return result;
        }
        DVTStringBuilder trailingWS = new DVTStringBuilder();
        String chunkValue = chunk.getValue();
        int trailingWSOffset = chunkValue.length() - 1;
        while (trailingWSOffset >= 0) {
            char c = chunkValue.charAt(trailingWSOffset);
            if (!Character.isWhitespace(c)) break;
            trailingWS.prepend(c);
            --trailingWSOffset;
        }
        if (trailingWS.length() != 0 && trailingWS.getFirstChar() == ' ') {
            trailingWS.deleteFirstChar();
        }
        CFToken literalToken = new CFToken(chunk, 20, chunk.getValue().substring(0, chunkValue.length() - trailingWS.length()), 0, chunk.isFirstOnLine() || lineInfo.areAllPrevChunksWS(chunk));
        result.add(literalToken);
        if (trailingWS.length() != 0) {
            CFToken wsToken = new CFToken(chunk, 3, trailingWS.toString(), trailingWSOffset + 1, false);
            result.add(wsToken);
        }
        return result;
    }
}

