/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFNoIndentDefinition;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.scanner.vregex.CFVRegExBaseDefinition;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionByNamePortConnections;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionClassDeclaration;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionClassVariableDeclarations;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionConsecutiveDefines;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionFunctionDeclaration;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionFunctionVariableDeclarations;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionInterfacePortDeclarations;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionInterfaceSignalDeclarations;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionLibraryPackageParameterDeclaration;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionModulePortDeclaration;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionModuleSignalDeclaration;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFVRegExDefinitionXVMFieldMacros;

public class VlogFormattingPreferences
extends CFPreferences {
    protected Set<String> implicitSemiMacrosPref = new HashSet<String>();
    protected Set<String> implicitSemiParamMacrosPref = new HashSet<String>();
    protected Set<String> openScopeMacrosPref = new HashSet<String>();
    protected Set<String> closeScopeMacrosPref = new HashSet<String>();
    private static VlogFormattingPreferences INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogFormattingPreferences getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VlogFormattingPreferences();
            }
        }
        return INSTANCE;
    }

    protected VlogFormattingPreferences() {
    }

    public Set<String> getImplicitSemiMacrosPref() {
        return this.implicitSemiMacrosPref;
    }

    public Set<String> getImplicitSemiParamMacrosPref() {
        return this.implicitSemiParamMacrosPref;
    }

    public Set<String> getOpenScopeMacrosPref() {
        return this.openScopeMacrosPref;
    }

    public Set<String> getCloseScopeMacrosPref() {
        return this.closeScopeMacrosPref;
    }

    public void refreshImplicitSemiMacrosPref() {
        String[] ismValues;
        this.implicitSemiParamMacrosPref.clear();
        this.implicitSemiMacrosPref.clear();
        String ismPref = this.getImplicitSemiMacros();
        if (ismPref != null && (ismValues = ismPref.split(",")) != null) {
            String[] stringArray = ismValues;
            int n = ismValues.length;
            int n2 = 0;
            while (n2 < n) {
                String ism = stringArray[n2];
                if (ism != null && !(ism = ism.trim()).isEmpty()) {
                    if (ism.endsWith("()")) {
                        if (ism.length() > 2) {
                            this.implicitSemiParamMacrosPref.add("`" + ism.substring(0, ism.length() - 2));
                        }
                    } else {
                        this.implicitSemiMacrosPref.add("`" + ism);
                    }
                }
                ++n2;
            }
        }
    }

    protected void refreshScopeMacrosPref(Set<String> toPrefSet, String fromPref) {
        String[] ismValues;
        toPrefSet.clear();
        String ismPref = fromPref;
        if (ismPref != null && (ismValues = ismPref.split(",")) != null) {
            String[] stringArray = ismValues;
            int n = ismValues.length;
            int n2 = 0;
            while (n2 < n) {
                String ism = stringArray[n2];
                if (ism != null && !(ism = ism.trim()).isEmpty()) {
                    if (ism.endsWith("()")) {
                        if (ism.length() > 2) {
                            toPrefSet.add("`" + ism.substring(0, ism.length() - 2));
                        }
                    } else {
                        toPrefSet.add("`" + ism);
                    }
                }
                ++n2;
            }
        }
    }

    public void refreshOpenScopeMacros() {
        this.refreshScopeMacrosPref(this.openScopeMacrosPref, this.getOpenScopeMacros());
    }

    public void refreshOpenScopeMacros(String openScopeMacros) {
        this.refreshScopeMacrosPref(this.openScopeMacrosPref, openScopeMacros);
    }

    public void refreshCloseScopeMacros() {
        this.refreshScopeMacrosPref(this.closeScopeMacrosPref, this.getCloseScopeMacros());
    }

    public void refreshCloseScopeMacros(String closeScopeMacros) {
        this.refreshScopeMacrosPref(this.closeScopeMacrosPref, closeScopeMacros);
    }

    protected VlogPlugin getDefaultPlugin() {
        return VlogPlugin.getDefault();
    }

    protected IPreferenceStore getPluginCombinedPreferenceStore() {
        return VlogPlugin.getDefault().getCombinedPreferenceStore();
    }

    public String getPreviewFileName() {
        return "FormattingPreviewCode.v";
    }

    public String getPreviewFileNameExtension() {
        return ".sv";
    }

    protected void initAllNoIndentKeywordsPref() {
        super.initAllNoIndentKeywordsPref();
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(Arrays.asList("module", "macromodule", "checker", "primitive", "package", "function", "task", "class", "property", "generate", "specify", "clocking", "config", "table", "program", "interface", "case", "casez", "casex", "randcase", "group", "covergroup", "sequence", "randsequence", "fork", "assign", "assert", "assume", "cover"));
        Collections.sort(all);
        for (String name : all) {
            this.fAllNoIndentKeywordsPref.put(name, new CFNoIndentDefinition(name));
        }
    }

    protected void initAllVRegExPref() {
        super.initAllVRegExPref();
        CFVRegExBaseDefinition def = new VlogCFVRegExDefinitionModulePortDeclaration(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionModulePortDeclaration(true);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionModuleSignalDeclaration(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionModuleSignalDeclaration(true);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionInterfacePortDeclarations(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionInterfacePortDeclarations(true);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionInterfaceSignalDeclarations(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionInterfaceSignalDeclarations(true);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionByNamePortConnections();
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionFunctionDeclaration(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionFunctionDeclaration(true);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionClassDeclaration(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionClassDeclaration(true);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionClassVariableDeclarations(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionClassVariableDeclarations(true);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionFunctionVariableDeclarations(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionFunctionVariableDeclarations(true);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionConsecutiveDefines();
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionXVMFieldMacros();
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionLibraryPackageParameterDeclaration(false);
        this.fAllVRegExPref.put(def.getName(), def);
        def = new VlogCFVRegExDefinitionLibraryPackageParameterDeclaration(true);
        this.fAllVRegExPref.put(def.getName(), def);
    }

    public String getBeginKeywordText() {
        return "Optional \"begin\"";
    }

    public boolean hasBeginPrefNewLineAndIndent() {
        return true;
    }

    public boolean hasElseOptions() {
        return true;
    }

    public boolean hasAddWhitespaceOptions() {
        return true;
    }

    public boolean hasRemoveNLOptions() {
        return true;
    }

    public boolean hasCapitalizationOptions() {
        return false;
    }

    public boolean hasParametersOptions() {
        return true;
    }

    public boolean hasPreprocessingOptions() {
        return true;
    }

    public boolean hasIndentMLCommentsOptions() {
        return true;
    }

    public boolean hasIndentSkipAssignsOptions() {
        return true;
    }

    public boolean hasIndentSkipMLMacroDefsOptions() {
        return true;
    }

    public boolean hasIndentAssumeImplicitSemiMacrosOptions() {
        return true;
    }

    public boolean hasImplicitSemiOptions() {
        return true;
    }

    public boolean hasScopeMacrosOptions() {
        return true;
    }

    public boolean hasVIndependentIfdefs() {
        return true;
    }

    public boolean hasVParenOptions() {
        return true;
    }

    public boolean hasVCurlyOptions() {
        return true;
    }

    public boolean hasVRegExCompactWSOptions() {
        return true;
    }

    public boolean hasFixWhitespaceAfterCodeMarkerInExpansion() {
        return false;
    }

    public boolean hasAddNewLineAfterBeginAndBeforeEnd() {
        return true;
    }

    public boolean hasAddNewLineAfterEnd() {
        return true;
    }
}

