/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.highlight;

import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.editor.highlight.VlogHlUtils;

public class HighlightHidVisitor
implements IHidVisitor<IHidObject> {
    private static final String IMPORT_EXPORT_ALL = "*";
    private IDocument fDocument;
    private Set<String> fDefaultKeywords;
    private Map<Integer, Position> fPositions;
    private ParserPath fParserPath;
    private ParserPath fCurrentParserPath;
    private int fStartOffset;
    private int fEndOffset;

    public HighlightHidVisitor(IDocument document, Set<String> defaultKeywords, Map<Integer, Position> positions, ParserPath parserPath, int startOffset, int endOffset) {
        this.fDocument = document;
        this.fDefaultKeywords = defaultKeywords;
        this.fPositions = positions;
        this.fParserPath = parserPath;
        this.fStartOffset = startOffset;
        this.fEndOffset = endOffset;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IHidObject hidObject) {
        boolean isFromOperator = false;
        if (!this.fCurrentParserPath.equals((Object)this.fParserPath)) {
            return true;
        }
        try {
            HidOccurrence occurrence;
            IDataType dataType;
            if (hidObject.getHidKind() == IHidObject.HidKind.OPERATOR) {
                RfHidOperator operator = (RfHidOperator)hidObject;
                if (operator.getOccurrence().getOffset() < this.fStartOffset && !TestHelper.isTestMode()) {
                    return true;
                }
                if (operator.getOccurrence().getOffset() > this.fEndOffset && !TestHelper.isTestMode()) {
                    return true;
                }
                isFromOperator = true;
                if (operator.hasQualifier(HidQualifierCache.IS_IMPORT_QUALIFIER) || operator.hasQualifier(HidQualifierCache.IS_EXPORT_QUALIFIER)) {
                    Set lhHids = operator.getLHHids(HidFlatteningOption.NONE_EXCLUDED);
                    for (IHid hid : lhHids) {
                        int offset = operator.getOccurrence().getOffset() - hid.getName().length();
                        if (offset < 0 || offset >= this.fDocument.getLength()) continue;
                        VlogHlUtils.addPosition((IDocument)this.fDocument, (int)offset, (HighlightKind)HighlightKind.TYPE, this.fPositions);
                    }
                    Set rhHids = operator.getRHHids(HidFlatteningOption.NONE_EXCLUDED);
                    for (IHid hid : rhHids) {
                        int offset;
                        if (hid.getName().equals(IMPORT_EXPORT_ALL) || (offset = operator.getOccurrence().getOffset() + 2) < 0 || offset >= this.fDocument.getLength()) continue;
                        VlogHlUtils.addPosition((IDocument)this.fDocument, (int)offset, (HighlightKind)HighlightKind.TYPE, this.fPositions);
                    }
                    return true;
                }
                IHidObject elementObject = AssociationUtils.getNiceFormalPart((IHidObject)operator, (long)HidQualifierCache.IS_ASSOCIATION_QUALIFIER);
                if (!HidUtils.isHid((IHidObject)elementObject) || !HidUtils.isResolved((IHidObject)elementObject)) {
                    return true;
                }
                hidObject = HidUtils.getHidFrom((IHidObject)elementObject);
            }
            if (hidObject.getHidKind() == IHidObject.HidKind.ACCESS && (dataType = ((HidAccess)hidObject).getDataType()) != null && dataType.getParamValuesHolder() != null) {
                IHidHolder hidHolder = dataType.getParamValuesHolder();
                hidHolder.visitHidObject(null, (IHidVisitor)this);
            }
            if (hidObject.getHidKind() != IHidObject.HidKind.HID) {
                return true;
            }
            RfHid rfHid = (RfHid)hidObject;
            if (rfHid.getOccurrence().getOffset() < this.fStartOffset && !TestHelper.isTestMode()) {
                return true;
            }
            if (rfHid.getOccurrence().getOffset() > this.fEndOffset && !TestHelper.isTestMode()) {
                return true;
            }
            IRfNamedElement element = rfHid.getElement();
            HighlightKind highlightKind = null;
            if (this.fDefaultKeywords.contains(rfHid.getName())) {
                return true;
            }
            highlightKind = VlogHlUtils.getHighlightKind(element);
            if ((highlightKind == HighlightKind.ARGUMENT || highlightKind == HighlightKind.SV_OBJECT_ARGUMENT || highlightKind == HighlightKind.SV_UVM_OBJECT_ARGUMENT) && isFromOperator) {
                highlightKind = ((RfField)element).isOutput() ? HighlightKind.OUT_PORT : HighlightKind.PORT;
            }
            if (highlightKind == null) {
                highlightKind = rfHid.hasQualifier(HidQualifierCache.TYPE_QUALIFIER) ? HighlightKind.TYPE : (rfHid.hasQualifier(HidQualifierCache.ATTRIBUTE_QUALIFIER) ? HighlightKind.ATTRIBUTE : (rfHid.isPotentialMethodCall() ? HighlightKind.METHOD : HighlightKind.DEFAULT));
            }
            if ((occurrence = rfHid.getOccurrence()) == null) {
                return true;
            }
            int offset = occurrence.getOffset();
            if (offset < 0 || offset >= this.fDocument.getLength()) {
                return true;
            }
            VlogHlUtils.addPosition((IDocument)this.fDocument, (int)offset, (HighlightKind)highlightKind, this.fPositions);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public void setParserPath(ParserPath parserPath) {
        this.fCurrentParserPath = parserPath;
    }

    public Class<IHidObject> getType() {
        return IHidObject.class;
    }
}

