/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.highlight;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IToken;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightPosition;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataExpressionType;
import ro.amiq.vlogdt.model.reflection.DataSelectType;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCoverpoint;
import ro.amiq.vlogdt.model.reflection.RfElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.ams.RfDiscipline;
import ro.amiq.vlogdt.model.reflection.ams.RfNatureAttr;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.ui.editor.VlogStyle;

public class VlogHlUtils
extends DVTHlUtils {
    public static HighlightKind getHighlightKind(IRfNamedElement element) {
        if (element instanceof RfElement && ((RfElement)element).isConst()) {
            return HighlightKind.CONSTANT;
        }
        if (element instanceof RfNamedActionBlock || element instanceof RfAssertExpect) {
            return HighlightKind.LABEL;
        }
        if (element instanceof RfInstance) {
            return HighlightKind.DEFAULT;
        }
        if (element instanceof RfConstraint) {
            return HighlightKind.CONSTRAINT;
        }
        if (element instanceof IRfFieldElement) {
            IRfFieldElement fieldElement = (IRfFieldElement)element;
            IRfScopeElement enclosingScope = fieldElement.getEnclosingScope();
            int fieldKind = fieldElement.getFieldKind();
            if (fieldKind == 128) {
                return HighlightKind.CONSTANT;
            }
            if (fieldKind == 256) {
                return HighlightKind.TYPE;
            }
            if (fieldElement instanceof RfField && ((RfField)fieldElement).isEvent()) {
                return HighlightKind.EVENT;
            }
            if (fieldElement instanceof RfField && (enclosingScope instanceof RfClass || fieldElement.getEnclosingScope() instanceof RfFunction || fieldElement.getEnclosingScope() instanceof RfActionBlock) && ((RfField)fieldElement).isStorageStatic()) {
                ColorObjectResult colorObjectResult = VlogHlUtils.colorObjectVariables("highlight.semantic_static_member", "highlight.semantic_static_object_member", "highlight.semantic_uvm_static_object_member", fieldElement);
                if (colorObjectResult == null) {
                    return HighlightKind.STATIC_CLASS_MEMBER;
                }
                return colorObjectResult.isClassInstance ? (colorObjectResult.isUvmClass ? HighlightKind.SV_UVM_STATIC_OBJECT_VARIABLES : HighlightKind.SV_STATIC_OBJECT_VARIABLES) : HighlightKind.STATIC_CLASS_MEMBER;
            }
            if (enclosingScope instanceof RfStruct && ((RfStruct)enclosingScope).isEnum()) {
                return HighlightKind.CONSTANT;
            }
            if (fieldElement instanceof IRfPortElement) {
                return ((IRfPortElement)fieldElement).isOutput() ? HighlightKind.OUT_PORT : HighlightKind.PORT;
            }
            if (fieldKind == 8192 || fieldKind == 4) {
                ColorObjectResult colorObjectResult = VlogHlUtils.colorObjectVariables("highlight.semantic_variable", "highlight.semantic_object_variable", "highlight.semantic_uvm_object_variable", fieldElement);
                if (colorObjectResult == null) {
                    return HighlightKind.VARIABLE;
                }
                return colorObjectResult.isClassInstance ? (colorObjectResult.isUvmClass ? HighlightKind.SV_UVM_OBJECT_VARIABLE : HighlightKind.SV_OBJECT_VARIABLE) : HighlightKind.VARIABLE;
            }
            if (fieldKind == 2) {
                ColorObjectResult colorObjectResult = VlogHlUtils.colorObjectVariables("highlight.semantic_argument", "highlight.semantic_object_argument", "highlight.semantic_uvm_object_argument", fieldElement);
                if (colorObjectResult == null) {
                    return HighlightKind.ARGUMENT;
                }
                return colorObjectResult.isClassInstance ? (colorObjectResult.isUvmClass ? HighlightKind.SV_UVM_OBJECT_ARGUMENT : HighlightKind.SV_OBJECT_ARGUMENT) : HighlightKind.ARGUMENT;
            }
            ColorObjectResult colorObjectResult = VlogHlUtils.colorObjectVariables("highlight.semantic_field", "highlight.semantic_object_field", "highlight.semantic_uvm_object_field", fieldElement);
            if (colorObjectResult == null) {
                return HighlightKind.FIELD;
            }
            return colorObjectResult.isClassInstance ? (colorObjectResult.isUvmClass ? HighlightKind.SV_UVM_OBJECT_FIELD : HighlightKind.SV_OBJECT_FIELD) : HighlightKind.FIELD;
        }
        if (element instanceof IRfMethodElement) {
            IRfMethodElement methodElement = (IRfMethodElement)element;
            IRfScopeElement enclosingScope = methodElement.getEnclosingScope();
            if (methodElement instanceof RfFunction && enclosingScope instanceof RfClass && ((RfFunction)methodElement).isObjectStatic()) {
                return HighlightKind.STATIC_METHOD;
            }
            return HighlightKind.METHOD;
        }
        if (element instanceof RfListType || element instanceof RfClass || element instanceof RfInterface || element instanceof RfModule || element instanceof RfCoverpoint || element instanceof RfCovergroup || element instanceof RfModport || element instanceof RfClockingBlock || element instanceof RfPackage || element instanceof RfProgram || element instanceof RfPrimitive) {
            return HighlightKind.TYPE;
        }
        if (element instanceof IRfTypeAliasElement) {
            return HighlightKind.TYPE;
        }
        if (element instanceof RfAssociatedType) {
            return HighlightKind.DEFAULT;
        }
        if (element instanceof RfDiscipline) {
            return HighlightKind.TYPE;
        }
        if (element instanceof RfNatureAttr) {
            return HighlightKind.METHOD;
        }
        return null;
    }

    public static void colorDataType(DataType dataType, IDocument document, IHidVisitor<IHidObject> visitor, Map<Integer, Position> positionOffsets) throws BadLocationException, BadPositionCategoryException {
        Map<String, ArgInfo> namedParamAssigns;
        List<DataType> orderedParamAssigns;
        List<DataType> innerClasses;
        DataType packageScope;
        int offset;
        if (dataType == null || document == null) {
            return;
        }
        if (dataType instanceof DataExpressionType || dataType instanceof DataSelectType) {
            return;
        }
        HighlightKind highlightKind = HighlightKind.TYPE;
        RfHidHolder paramValues = dataType.getParamValuesHolder();
        if (paramValues != null) {
            paramValues.visitHidObject(null, visitor);
        }
        if ((offset = dataType.getOffset()) < 0 || offset >= document.getLength()) {
            return;
        }
        String typeName = dataType.getType();
        if (typeName == null) {
            return;
        }
        int dotPosition = typeName.startsWith("enum/") || typeName.startsWith("struct/") || typeName.startsWith("union/") ? -1 : typeName.indexOf(46);
        int colorOffset = offset;
        VlogHlUtils.addPosition((IDocument)document, (int)colorOffset, (HighlightKind)highlightKind, positionOffsets);
        if (dotPosition != -1) {
            boolean shouldColorDataType = true;
            int i = 0;
            while (i < typeName.length()) {
                char ch = document.getChar(offset + i);
                if (ch == '.' && shouldColorDataType) {
                    shouldColorDataType = false;
                    colorOffset = offset + i + 1;
                    VlogHlUtils.addPosition((IDocument)document, (int)colorOffset, (HighlightKind)highlightKind, positionOffsets);
                } else if (ch != '.') {
                    shouldColorDataType = true;
                }
                ++i;
            }
            if (shouldColorDataType) {
                VlogHlUtils.addPosition((IDocument)document, (int)colorOffset, (HighlightKind)highlightKind, positionOffsets);
            }
        }
        if ((packageScope = dataType.getPackageScope()) != null) {
            VlogHlUtils.addPosition((IDocument)document, (int)packageScope.getOffset(), (HighlightKind)highlightKind, positionOffsets);
        }
        if ((innerClasses = dataType.getInnerClassesInfo()) != null) {
            for (DataType innerClass : innerClasses) {
                VlogHlUtils.addPosition((IDocument)document, (int)innerClass.getOffset(), (HighlightKind)highlightKind, positionOffsets);
            }
        }
        if ((orderedParamAssigns = dataType.getOrderedParamAssignments()) != null) {
            for (DataType orderedParamAssign : orderedParamAssigns) {
                VlogHlUtils.colorDataType(orderedParamAssign, document, visitor, positionOffsets);
            }
        }
        if ((namedParamAssigns = dataType.getNamedParamAssignments()) != null) {
            for (ArgInfo namedParamAssign : namedParamAssigns.values()) {
                VlogHlUtils.colorDataType(namedParamAssign.getDataType(), document, visitor, positionOffsets);
            }
        }
    }

    private static ColorObjectResult colorObjectVariables(String tokenID, String objectTokenID, String uvmObjectTokenID, IRfFieldElement fieldElement) {
        IToken token = VlogStyle.getInstance().getToken(tokenID);
        IToken objectToken = VlogStyle.getInstance().getToken(objectTokenID);
        IToken uvmObjectToken = VlogStyle.getInstance().getToken(uvmObjectTokenID);
        if (token == null || objectToken == null || uvmObjectToken == null) {
            return null;
        }
        if (token.getData().equals(objectToken.getData()) && token.getData().equals(uvmObjectToken.getData())) {
            return null;
        }
        IRfNamedElement associatedType = fieldElement.getAssociatedType();
        if (associatedType == null) {
            return null;
        }
        RfPackage enclosingPackage = (RfPackage)associatedType.getEnclosingScope(RfPackage.class);
        if (enclosingPackage == null) {
            return new ColorObjectResult(associatedType instanceof RfClass, false);
        }
        return new ColorObjectResult(associatedType instanceof RfClass, "uvm_pkg".equals(enclosingPackage.getName()));
    }

    public static void addPSLScopePosition(IDocument document, int startOffset, int endOffset, Map<Integer, Position> positions) {
        if (document == null) {
            return;
        }
        if (startOffset < 0 || endOffset >= document.getLength() || startOffset > endOffset || positions == null) {
            return;
        }
        positions.put(startOffset, (Position)new SemanticHighlightPosition(startOffset, endOffset - startOffset + 1, HighlightKind.PSL_SCOPE));
    }

    private static class ColorObjectResult {
        private boolean isClassInstance;
        private boolean isUvmClass;

        ColorObjectResult(boolean isClassInstance, boolean isUvmClass) {
            this.isClassInstance = isClassInstance;
            this.isUvmClass = isUvmClass;
        }
    }
}

