/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.highlight;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBaseElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.editor.highlight.SemanticHighlightJob;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfVunit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.ui.editor.highlight.HighlightHidVisitor;
import ro.amiq.vlogdt.ui.editor.highlight.VlogHlUtils;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class VlogSemanticHighlighter
extends DVTSemanticHighlighter<RfDefElement> {
    private static final char EXTERN_METHOD_DOT = ':';
    private static final int EXTERN_METHOD_DOT_SIZE = 3;
    private IHidVisitor<IHidObject> fHighlightHidVisitor;
    private Set<String> fDefaultKeywords;

    public VlogSemanticHighlighter(IDocument document) {
        super(document);
    }

    public void process(IRfFileDef file, SemanticHighlightJob job, int startOffset, int endOffset) {
        this.fDefaultKeywords = new HashSet<String>(Arrays.asList(PrefConst.getDefaultVerilogKeywords()));
        this.fHighlightHidVisitor = new HighlightHidVisitor(this.getDocument(), this.fDefaultKeywords, this.getPositions(), file != null ? file.getParserPath() : null, startOffset, endOffset);
        super.process(file, job, startOffset, endOffset);
    }

    protected IStatus doHighlightRecursive(RfDefElement root, Set<RfDefElement> visited, SemanticHighlightJob job) throws BadLocationException, BadPositionCategoryException, Exception {
        if (root == null) {
            return Status.OK_STATUS;
        }
        int startOffset = root.getStartOffset();
        int endOffset = root.getEndOffset();
        if (startOffset != -1 && endOffset != -1 && (startOffset > this.getEndOffset() || endOffset < this.getStartOffset())) {
            return Status.OK_STATUS;
        }
        return super.doHighlightRecursive((IRfBaseElement)root, visited, job);
    }

    protected void doHighlight(RfDefElement defElement) throws BadLocationException, BadPositionCategoryException {
        int prevCodeCharOffset;
        if (defElement == null || defElement.hasVirtualOffsets()) {
            return;
        }
        if (this.fHighlightHidVisitor == null) {
            return;
        }
        RfNamedElement element = defElement.getNamedElement();
        if (element == null) {
            return;
        }
        RfHidHolder hidHolder = element.getHidHolder();
        if (hidHolder != null) {
            hidHolder.visitHidObject(null, this.fHighlightHidVisitor);
        }
        IDocument document = this.getDocument();
        int elementOffset = defElement.getLabelStartOffset();
        if (elementOffset < this.getStartOffset() || elementOffset > this.getEndOffset()) {
            return;
        }
        if (element instanceof RfVunit) {
            VlogHlUtils.addPSLScopePosition(document, elementOffset + element.getName().length(), element.getEndOffset(), this.getPositions());
        } else if (element.getEnclosingScope(RfVunit.class) != null) {
            return;
        }
        HighlightKind highlightKind = VlogHlUtils.getHighlightKind(element);
        if (highlightKind != null && (element instanceof IRfMethodElement || element instanceof RfConstraint) && (prevCodeCharOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)(elementOffset - 1), (boolean)false, (String)"__vlog_partitioning")) >= 3 && prevCodeCharOffset < document.getLength() && document.getChar(prevCodeCharOffset - 1) == ':') {
            int externTypeOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)(prevCodeCharOffset - 3), (boolean)false, (String)"__vlog_partitioning") - 1;
            char ch = document.getChar(externTypeOffset);
            boolean foundType = false;
            while (!Character.isWhitespace(ch)) {
                if (ch == ':' && foundType) {
                    foundType = false;
                    VlogHlUtils.addPosition((IDocument)document, (int)(externTypeOffset + 1), (HighlightKind)HighlightKind.TYPE, (Map)this.getPositions());
                } else if (ch != ':') {
                    foundType = true;
                }
                ch = document.getChar(--externTypeOffset);
            }
            VlogHlUtils.addPosition((IDocument)document, (int)(externTypeOffset + 1), (HighlightKind)HighlightKind.TYPE, (Map)this.getPositions());
        }
        VlogHlUtils.addPosition((IDocument)document, (int)elementOffset, (HighlightKind)highlightKind, (Map)this.getPositions());
        if (element instanceof RfClass) {
            RfClass classElement = (RfClass)element;
            List<DataType> impletementedDataType = classElement.getImplementedTypes();
            if (impletementedDataType != null) {
                for (DataType interfaceDataType : impletementedDataType) {
                    VlogHlUtils.colorDataType(interfaceDataType, document, this.fHighlightHidVisitor, this.getPositions());
                }
            }
            VlogHlUtils.colorDataType(classElement.getExtendedType(), document, this.fHighlightHidVisitor, this.getPositions());
        } else if (element instanceof RfFunction) {
            VlogHlUtils.colorDataType(((RfFunctionDef)defElement).getTypeInfo(element), document, this.fHighlightHidVisitor, this.getPositions());
        } else if (element instanceof IRfAssociatedTypeElement) {
            VlogHlUtils.colorDataType(defElement.getRawDataType(element), document, this.fHighlightHidVisitor, this.getPositions());
        }
    }

    protected Collection<RfDefElement> getChildren(RfDefElement root) {
        if (root == null) {
            return null;
        }
        return root.getChildren();
    }

    public void clean() {
        this.fHighlightHidVisitor = null;
        this.fDefaultKeywords = null;
        super.clean();
    }
}

