/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hover;

import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.VlogCodeScanner;
import ro.amiq.vlogdt.ui.editor.VlogCommentScanner;
import ro.amiq.vlogdt.ui.editor.VlogStyle;
import ro.amiq.vlogdt.ui.editor.hover.VlogHoverNonRuleBasedReconciler;
import ro.amiq.vlogdt.ui.editor.hover.VlogHoverSourceViewerReconciler;

public class VlogHoverSourceViewerConfiguration
extends SourceViewerConfiguration {
    private VlogCodeScanner fCodeScanner;
    private VlogCommentScanner fCommentScanner;
    private VlogStyle fColorManager;

    public VlogHoverSourceViewerConfiguration(VlogStyle colorManager) {
        this.fColorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__vlog_escaped_id", "__vlog_literal", "__vlog_ml_comment", "__vlog_sl_comment"};
    }

    protected VlogCodeScanner getCodeScanner() {
        if (this.fCodeScanner == null) {
            this.fCodeScanner = new VlogCodeScanner(this.fColorManager, 0, false, true);
            this.fCodeScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCodeScanner;
    }

    protected VlogCommentScanner getCommentScanner() {
        if (this.fCommentScanner == null) {
            this.fCommentScanner = new VlogCommentScanner(this.fColorManager, false, 0, false, null);
            this.fCommentScanner.setDefaultReturnToken(this.fColorManager.getToken("highlight.default"));
        }
        return this.fCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        VlogHoverSourceViewerReconciler dr1 = new VlogHoverSourceViewerReconciler((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
        VlogHoverSourceViewerReconciler dr2 = new VlogHoverSourceViewerReconciler((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr2, "__vlog_sl_comment");
        reconciler.setRepairer((IPresentationRepairer)dr2, "__vlog_sl_comment");
        VlogHoverSourceViewerReconciler dr3 = new VlogHoverSourceViewerReconciler((ITokenScanner)this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr3, "__vlog_ml_comment");
        reconciler.setRepairer((IPresentationRepairer)dr3, "__vlog_ml_comment");
        VlogHoverNonRuleBasedReconciler ndr1 = new VlogHoverNonRuleBasedReconciler(this.fColorManager, "highlight.string");
        reconciler.setDamager((IPresentationDamager)ndr1, "__vlog_literal");
        reconciler.setRepairer((IPresentationRepairer)ndr1, "__vlog_literal");
        VlogHoverNonRuleBasedReconciler ndr2 = new VlogHoverNonRuleBasedReconciler(this.fColorManager, "highlight.escaped_id");
        reconciler.setDamager((IPresentationDamager)ndr2, "__vlog_escaped_id");
        reconciler.setRepairer((IPresentationRepairer)ndr2, "__vlog_escaped_id");
        return reconciler;
    }
}

