/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hover;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import ro.amiq.dvt.diagrams.wavedrom.WaveDromManager;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.ui.editor.hover.VlogTextHoverParticipantCommon;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogTextHoverParticipant
extends VlogTextHoverParticipantCommon {
    @Override
    protected String getTooltipContentFilePath(ITextViewer textViewer) {
        VlogFileUtils fileUtilsInstance = VlogFileUtils.getInstance();
        IFile fileFromViewer = fileUtilsInstance != null ? fileUtilsInstance.getFileFromViewer(textViewer) : null;
        IPath relativePath = fileFromViewer != null ? fileFromViewer.getProjectRelativePath() : null;
        String filePath = relativePath == null ? "" : relativePath.lastSegment();
        return filePath;
    }

    @Override
    protected IFile getFile() {
        if (this.fTextEditor == null) {
            return null;
        }
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    @Override
    protected String getWaveform(IDocument document, int offset, String contextType) {
        try {
            String waveform = WaveDromManager.getInstance().getWaveform(document, this.getFile(), offset, "__vlog_partitioning", contextType);
            if ("WaveDrom description file not found!".equals(waveform) || "WaveDrom description file does not have a valid extension!".equals(waveform) || waveform.startsWith("WaveDrom description exceeds")) {
                return waveform;
            }
            return Wavedrom.getInstance().generateSVG(waveform);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    @Override
    protected IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.fTextEditor.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        }
        return null;
    }

    @Override
    protected IProject getProject() {
        if (this.fTextEditor == null) {
            return null;
        }
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }
}

