/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hover;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldUtils;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.SVTBCharParser;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;

public abstract class VlogTextHoverParticipantCommon
implements ITextHoverParticipant {
    protected ITextEditor fTextEditor;

    public void setTextEditor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public void makeInfo(ITextViewer textViewer, IRegion region, DVTTooltipContent tooltipContent) {
        if (textViewer == null) {
            return;
        }
        IProject project = this.getProject();
        IDocument document = textViewer.getDocument();
        if (project == null || document == null) {
            return;
        }
        try {
            if (region == null || document == null || project == null) {
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return;
            }
            int offset = region.getOffset();
            int line = document.getLineOfOffset(offset);
            int col = offset - DVTDocumentUtils.documentLineOffset((Object)document, (int)line);
            tooltipContent.set(DVTTooltipContent.TooltipContent.LINE, Integer.valueOf(line + 1));
            tooltipContent.set(DVTTooltipContent.TooltipContent.COLUMN, Integer.valueOf(col + 1));
            tooltipContent.set(DVTTooltipContent.TooltipContent.FILE, this.getTooltipContentFilePath(textViewer));
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return;
            }
            String contextType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset, false);
            if (contextType.equals("__dftl_partition_content_type") || contextType.equals("__vlog_escaped_id")) {
                offset = Math.min(offset + 1, document.getLength() - 1);
                RfWNamedElementAndScope elementScope = RfUtils.getRfElement(rfProject, this.getFile(), document, offset, textViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)textViewer).getEditor() : (DVTEditor)DVTFileUtils.getInstance().getActiveEditor());
                IRfNamedElement element = null;
                if (elementScope != null) {
                    element = elementScope.getIRfNamedElement();
                    elementScope.getScope();
                }
                if (element == null) {
                    element = RfUtils.getLastDefineBeforeMacroUse(rfProject, this.getFile(), document, offset);
                    if (elementScope instanceof RfWNamedElementAndScope) {
                        elementScope.setNamedElement(element);
                    }
                }
                if (element == null) {
                    return;
                }
                RfUtils.getTooltipFormattedText(elementScope, true, this.getEditor(), tooltipContent);
                BitFieldModel model = BitFieldUtils.getModelForEditor((DVTEditor)((DVTEditor)this.getEditor()), (IRfNamedElementAndScope)elementScope, (int)offset);
                if (Wavedrom.getInstance().isVSCode()) {
                    tooltipContent.set(DVTTooltipContent.TooltipContent.BITFIELD_REGISTER, model);
                } else {
                    tooltipContent.set(DVTTooltipContent.TooltipContent.BITFIELD_DIAGRAM, Wavedrom.getInstance().generateBitfieldSVG(model));
                }
            } else if (contextType.equals("__vlog_ml_comment") || contextType.equals("__vlog_sl_comment")) {
                String linterPragmaComment = this.getLinterPragmaComment(document, line, col);
                if (linterPragmaComment != null && !linterPragmaComment.isEmpty()) {
                    String linterTooltipContent = LintUtils.getTooltipContent(linterPragmaComment, rfProject);
                    if (!linterTooltipContent.isEmpty()) {
                        tooltipContent.set(DVTTooltipContent.TooltipContent.LINTER_PRAGMA, linterTooltipContent);
                    }
                } else {
                    String waveform = this.getWaveform(document, offset, contextType);
                    tooltipContent.set(DVTTooltipContent.TooltipContent.WAVEDROM_DIAGRAM, waveform);
                }
            } else {
                IAnnotationModel annotationModel = this.getAnnotationModel();
                if (annotationModel == null) {
                    return;
                }
                Iterator iter = annotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    Annotation annotation = (Annotation)iter.next();
                    Position position = annotationModel.getPosition(annotation);
                    if (!annotation.getType().equals("org.eclipse.ui.workbench.texteditor.spelling") || region.getOffset() < position.getOffset() || region.getOffset() > position.getOffset() + position.getLength()) continue;
                    tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, annotation.getText());
                    return;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String getLinterPragmaComment(IDocument document, int line, int offsetOnLine) {
        String lineContent;
        try {
            int lineOffset = document.getLineOffset(line);
            lineContent = document.get(lineOffset, document.getLineLength(line));
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
        return SVTBCharParser.getPragmaWaiverFromText(lineContent, offsetOnLine).trim();
    }

    protected abstract String getTooltipContentFilePath(ITextViewer var1);

    protected abstract IFile getFile();

    protected abstract String getWaveform(IDocument var1, int var2, String var3);

    protected abstract IAnnotationModel getAnnotationModel();

    protected abstract IProject getProject();
}

