/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hyperlink.DVTCommentHyperlinkDetector;
import ro.amiq.dvt.ui.editor.hyperlink.HyperlinkTimeoutException;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.utils.VlogLinkResolver;

public class CommentHyperlinkDetector
extends DVTCommentHyperlinkDetector {
    public CommentHyperlinkDetector(VlogEditor editor) {
        super((DVTEditor)editor, (IRfSingleLangProject)editor.getRfProject());
    }

    public CommentHyperlinkDetector(IRfSingleLangProject project) {
        super(project);
    }

    protected List<IHyperlink> solveHyperlinkForAllCandidates(Collection<IRfNamedElement> candidates, String[] types, IRegion region, IDocument document, long timeoutTime) throws HyperlinkTimeoutException {
        ArrayList<IHyperlink> actionHyperlinks = new ArrayList<IHyperlink>();
        for (IRfNamedElement candidate : candidates) {
            this.recursiveSolveHyperlink(candidate, types, 0, actionHyperlinks, region, timeoutTime);
        }
        if (types.length != 1 || candidates.isEmpty()) {
            return actionHyperlinks;
        }
        IRfNamedElement firstCandidate = candidates.iterator().next();
        if (candidates.size() == 1 && firstCandidate instanceof IRfPackageElement) {
            return actionHyperlinks;
        }
        for (IRfNamedElement candidate : candidates) {
            RfNamedElementActionHyperlink hyperlink;
            RfNamedElement potentialMacro = VlogLinkResolver.searchForMacro(candidate, types[0], region.getOffset(), document);
            if (potentialMacro == null || (hyperlink = RfUtils.createOpenAction((IRfNamedElement)potentialMacro, potentialMacro.getRfProject().getProject(), region, this.getFullName(potentialMacro))) == null || actionHyperlinks.contains(hyperlink)) continue;
            actionHyperlinks.add((IHyperlink)hyperlink);
            break;
        }
        return actionHyperlinks;
    }

    protected void recursiveSolveHyperlink(IRfNamedElement currentElement, String[] types, int index, List<IHyperlink> actionHyperlinks, IRegion region, long timeoutTime) throws HyperlinkTimeoutException {
        if (System.currentTimeMillis() > timeoutTime) {
            throw new HyperlinkTimeoutException();
        }
        if (!(currentElement instanceof RfNamedElement) || types == null) {
            return;
        }
        if (currentElement.getRfProject() == null) {
            return;
        }
        RfNamedElement element = (RfNamedElement)currentElement;
        if (index >= types.length) {
            RfNamedElementActionHyperlink hyperlink = RfUtils.createOpenAction(element.getDeclaration(), element.getName(), element.getRfProject().getProject(), region, this.getFullName(element));
            if (hyperlink != null && !actionHyperlinks.contains(hyperlink)) {
                actionHyperlinks.add((IHyperlink)hyperlink);
            }
            return;
        }
        List<RfNamedElement> members = VlogLinkResolver.getCandidatesInScope(element);
        if (members == null) {
            return;
        }
        String[] elementTypeParams = VlogLinkResolver.extractTypeNames(types[index]);
        String className = VlogLinkResolver.extractClassName(types[index]);
        for (RfNamedElement member : members) {
            if (!types[index].equals(member.getName()) && !VlogLinkResolver.isElementWithGenericParams(member, types[index], elementTypeParams, className)) continue;
            this.recursiveSolveHyperlink(member, types, index + 1, actionHyperlinks, region, timeoutTime);
        }
    }

    protected Collection<IRfNamedElement> getInitialCandidates(IDocument document, int startOffset) throws BadLocationException {
        IRfScope scope = RfUtils.getRfScope((ITextEditor)this.getEditor(), document, startOffset);
        if (scope == null) {
            return null;
        }
        Collection<IRfNamedElement> result = VlogLinkResolver.getInitialCandidatesFromScope(scope);
        IRfScope elementScope = VlogLinkResolver.getRfScopeOfElementForCommentOffset((ITextEditor)this.getEditor(), document, startOffset, this.getProject());
        if (elementScope != null && !elementScope.equals(scope) && elementScope instanceof RfDefElement) {
            result.add(((RfDefElement)elementScope).getNamedElement());
        }
        return result;
    }

    protected boolean isInCommentPartition(IDocument document, int offset) {
        return VlogLinkResolver.isInCommentPartition(document, offset);
    }

    protected List<IRfNamedElement> getPackageCandidates(DVTCommentHyperlinkDetector.ParseCommentResult parsedComment) {
        IRfSingleLangProject project = this.getProject();
        if (!(project instanceof RfProject)) {
            return null;
        }
        return VlogLinkResolver.getPackageCandidatesFromProject(parsedComment.getPackageName(), (RfProject)project);
    }

    private String getFullName(RfNamedElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append("Open ").append(element.getKindName()).append(" ").append(element.getFullName());
        return sb.toString();
    }
}

