/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.pathmanager.DPMListenerManager;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotification;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.ui.editor.hyperlink.ActionHyperlink;
import ro.amiq.vlogdt.ui.editor.pathmanager.VlogDesignPathProvider;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpander;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class IncludeHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;
    private DVTStringBuilder fText;

    public IncludeHyperlinkDetector() {
    }

    public IncludeHyperlinkDetector(ITextEditor editor) {
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || this.fTextEditor == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        IEditorInput editorInput = this.fTextEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        return this.detectHyperlinks(project, document, file, region);
    }

    public IHyperlink[] detectHyperlinks(IProject project, IDocument document, IFile file, IRegion region) {
        if (region == null) {
            return null;
        }
        int offset = region.getOffset();
        this.fText = new DVTStringBuilder();
        IRegion word = DVTDocumentUtils.getIncludedFileRegion((IDocument)document, (int)offset, (DVTStringBuilder)this.fText);
        if (word == null || word.getLength() == 0) {
            return null;
        }
        IDVTHyperlink[] accurateHyperlinks = this.getAccurateHyperlinks(file, project, word);
        if (accurateHyperlinks != null) {
            return accurateHyperlinks;
        }
        String knownPath = this.fText.toString();
        if (knownPath.equals("`include")) {
            return null;
        }
        if (knownPath.startsWith("`")) {
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            try {
                knownPath = MacroExpander.expand(new MacroScanner(), (IProgressMonitor)new NullProgressMonitor(), null, knownPath, rfProject, "__dftl_partition_content_type", Integer.MAX_VALUE, -1, null, false, true);
            }
            catch (VlogException vlogException) {
                return null;
            }
        }
        if (knownPath == null) {
            return null;
        }
        if ((knownPath = knownPath.trim()).startsWith("\"") && knownPath.endsWith("\"")) {
            knownPath = knownPath.substring(1, knownPath.length() - 1);
        }
        final IProject finalProject = project;
        final String finalKnownPath = knownPath;
        Action openAction = new Action(){

            public void run() {
                VlogFileUtils.getInstance().openFile(finalProject, finalKnownPath, 1);
            }

            public String getPath() {
                return finalKnownPath;
            }
        };
        return new IHyperlink[]{new ActionHyperlink(word, (IAction)openAction, DVTHyperlinkMessages.jumpToIncludedFile)};
    }

    private IDVTHyperlink[] getAccurateHyperlinks(IFile file, IProject project, IRegion word) {
        VlogFileInstance sourceFileInstance = (VlogFileInstance)VlogDesignPathProvider.getInstance().getFileInstance(file, true);
        ArrayList<ActionHyperlink> actionHyperlinks = new ArrayList<ActionHyperlink>();
        if (sourceFileInstance != null) {
            VlogFileInstance destination = this.getDestinationFromFileInstanceAndScope(sourceFileInstance, word);
            if (destination == null) {
                return null;
            }
            String finalPath = destination.getParserPath().path;
            IProject finalProject = project;
            VlogFileInstance finalDestination = destination;
            actionHyperlinks.add(this.createActionFromPath(finalDestination, finalPath, finalProject, word));
            if (actionHyperlinks.isEmpty()) {
                return null;
            }
            return actionHyperlinks.toArray(new IDVTHyperlink[actionHyperlinks.size()]);
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        VlogFileInstance topInstance = rfProject.getPreprocessingTable().getTopFileInstance();
        if (topInstance == null) {
            return null;
        }
        ParserPath parserPath = rfProject.resource2parser((IResource)file);
        if (parserPath == null) {
            return null;
        }
        List<VlogFileInstance> enclosingInstances = topInstance.getFileInstances(parserPath);
        if (enclosingInstances == null) {
            return null;
        }
        for (VlogFileInstance enclosingInstance : enclosingInstances) {
            ParserPath destinationParserPath;
            VlogFileInstance destination = this.getDestinationFromFileInstanceAndScope(enclosingInstance, word);
            if (destination == null || (destinationParserPath = destination.getParserPath()) == null) continue;
            String finalPath = destinationParserPath.path;
            IProject finalProject = project;
            VlogFileInstance finalDestination = destination;
            actionHyperlinks.add(this.createActionFromPath(finalDestination, finalPath, finalProject, word));
        }
        if (actionHyperlinks.isEmpty()) {
            return null;
        }
        return actionHyperlinks.toArray(new IDVTHyperlink[actionHyperlinks.size()]);
    }

    private ActionHyperlink createActionFromPath(final VlogFileInstance instance, final String path, final IProject project, IRegion word) {
        if (path == null || project == null) {
            return null;
        }
        return new ActionHyperlink(word, (IAction)new Action(){

            public void run() {
                DVTEditor editor = IncludeHyperlinkDetector.this.fTextEditor instanceof DVTEditor ? (DVTEditor)IncludeHyperlinkDetector.this.fTextEditor : null;
                VlogDesignPathProvider.getInstance().setSessionProperty(project, editor, (IDVTFileInstance)instance, path);
                VlogFileUtils.getInstance().openFile(project, path, 1);
                this.updateDPM(instance, project);
            }

            private void updateDPM(VlogFileInstance instance2, IProject project2) {
                IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
                if (!(activeEditor instanceof DVTEditor)) {
                    return;
                }
                ElementPath designPath = DesignPathManager.getInstance().getPathFor((IDVTBreadcrumbTextHost)IncludeHyperlinkDetector.this.fTextEditor);
                if (designPath == null) {
                    return;
                }
                VlogDesignPathProvider.getInstance().checkPathFromInclude(project2, designPath, instance2.getParserPath().toString());
                DVTEditor dvtEditor = (DVTEditor)activeEditor;
                DesignPathManager.getInstance().setDirty((IDVTBreadcrumbTextHost)dvtEditor, true);
                DesignPathManager.getInstance().updateFor((IDVTBreadcrumbTextHost)dvtEditor, designPath);
                ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_UPDATE);
                DPMListenerManager.INSTANCE.notifyListeners(dvtEditor, DPMNotification.DPMNotificationKind.FORCE_UPDATE);
            }

            public String getPath() {
                return path;
            }
        }, DVTHyperlinkMessages.jumpToIncludedFile);
    }

    private VlogFileInstance getDestinationFromFileInstanceAndScope(VlogFileInstance source, IRegion scope) {
        if (source == null || scope == null) {
            return null;
        }
        IPath candidatePath = Path.fromOSString((String)this.fText.toString());
        if (candidatePath == null) {
            return null;
        }
        for (VlogFileInstance includedInstance : source.getIncludedInstances()) {
            VlogIncludingScope includingScope;
            IPath includedPath = Path.fromOSString((String)includedInstance.getParserPath().path);
            if (includedPath == null || (includingScope = includedInstance.getIncludingScope()) == null) continue;
            boolean offsetInsideRegion = DesignPathManager.getInstance().isOffsetInsideRegion(scope, includingScope.getIncludingOffset());
            if (!this.isSamePath(includedPath, candidatePath) || !offsetInsideRegion) continue;
            return includedInstance;
        }
        return null;
    }

    private boolean isSamePath(IPath a, IPath b) {
        int i = 0;
        while (i < Math.min(a.segmentCount(), b.segmentCount())) {
            String segment2;
            String segment1 = a.segment(a.segmentCount() - i - 1);
            if (!segment1.equals(segment2 = b.segment(b.segmentCount() - i - 1))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

