/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.hyperlink.tlmtreeviewer.JumpToConnectedTLMTreeContentProvider;
import ro.amiq.vlogdt.hyperlink.tlmtreeviewer.JumpToConnectedTLMTreeLabelProvider;
import ro.amiq.vlogdt.hyperlink.tlmtreeviewer.JumpToConnectedTLMTreeViewer;
import ro.amiq.vlogdt.hyperlink.tlmtreeviewer.JumpToTLMPathNode;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public class JumpToTLMConnectionDialog
extends Dialog {
    private static final String ID = "JumpToConnetedTLM";
    private static final String TREE_VIEWER_ID = "JumpToConnetedTLMTreeView";
    private static final String FILTER_MESSAGE_STRING = "Filter by: name (* = any string, ? = any character)";
    private static final int MAX_JTC_TREE_WIDTH = 1000;
    private static final int MAX_JTC_TREE_HEIGHT = 300;
    private JumpToTLMPathNode root;
    private String searchedElement;
    private MouseListener mouseSelectionListener;
    private KeyListener keySelectionListener;
    private JumpToConnectedTLMTreeViewer jtcTreeViewer;

    protected JumpToTLMConnectionDialog(Shell parentShell, JumpToTLMPathNode root, String searchedElement) {
        super(parentShell);
        this.root = root;
        this.searchedElement = searchedElement;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        Rectangle bounds = shell.getBounds();
        int newShellWidth = bounds.width < 1000 ? bounds.width : 1000;
        int newShellHeight = bounds.height < 300 ? bounds.height : 300;
        int newShellX = bounds.x + (int)Math.ceil((double)(bounds.width - newShellWidth) / 2.0);
        int newShellY = bounds.y + (int)Math.ceil((double)(bounds.height - newShellHeight) / 2.0);
        shell.setBounds(newShellX, newShellY, newShellWidth, newShellHeight);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Jump To Connected TLM Port");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(10, 10).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        Composite titleComposite = new Composite(composite, 4);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(titleComposite);
        StyledText selectedPortText = new StyledText(titleComposite, 4);
        selectedPortText.setEditable(false);
        selectedPortText.setEnabled(false);
        selectedPortText.setBackground(titleComposite.getBackground());
        String selectedPortString = this.root.toString();
        selectedPortText.setText(selectedPortString);
        StyleRange styledRange = new StyleRange(selectedPortString.indexOf(this.searchedElement), this.searchedElement.length(), null, null, 1);
        selectedPortText.setStyleRange(styledRange);
        Composite textComposite = new Composite(composite, 0x100004);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(textComposite);
        Composite treeComposite = new Composite(composite, 4);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(treeComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)treeComposite);
        this.jtcTreeViewer = new JumpToConnectedTLMTreeViewer(treeComposite);
        this.jtcTreeViewer.setAutoExpandLevel(-1);
        this.jtcTreeViewer.setContentProvider((IContentProvider)new JumpToConnectedTLMTreeContentProvider());
        this.jtcTreeViewer.setInput(this.root);
        GridDataFactory.fillDefaults().grab(true, false).minSize(-1, 30).align(4, 4).applyTo((Control)textComposite);
        TextFilterObject textFilterObject = new TextFilterObject((IFilterableView)this.jtcTreeViewer, ID, textComposite, TREE_VIEWER_ID, true);
        textFilterObject.getControl().moveAbove(composite.getChildren()[1]);
        textFilterObject.getTextFilter().setMessage(FILTER_MESSAGE_STRING);
        final Tree tree = (Tree)this.jtcTreeViewer.getControl();
        tree.setSelection(tree.getItem(0));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        JumpToConnectedTLMTreeLabelProvider jumpToConnectedTLMTreeLabelProvider = new JumpToConnectedTLMTreeLabelProvider(tree);
        this.jtcTreeViewer.setLabelProvider((IBaseLabelProvider)jumpToConnectedTLMTreeLabelProvider);
        this.mouseSelectionListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                JumpToTLMConnectionDialog.this.openConnectedTLMFile((Item)item);
            }
        };
        this.keySelectionListener = new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode != 13 && e.keyCode != 0x1000050) {
                    return;
                }
                TreeItem[] items = tree.getSelection();
                if (items == null || items.length == 0) {
                    return;
                }
                TreeItem item = items[0];
                JumpToTLMConnectionDialog.this.openConnectedTLMFile((Item)item);
            }

            public void keyPressed(KeyEvent e) {
            }
        };
        tree.addMouseListener(this.mouseSelectionListener);
        tree.addKeyListener(this.keySelectionListener);
        return composite;
    }

    private void openConnectedTLMFile(Item item) {
        if (item == null) {
            return;
        }
        Object itemData = item.getData();
        if (!(itemData instanceof JumpToTLMPathNode)) {
            return;
        }
        JumpToTLMPathNode pathNode = (JumpToTLMPathNode)itemData;
        Object info = pathNode.getInfo();
        if (!(info instanceof VlogSearchHit)) {
            return;
        }
        VlogSearchHit searchHit = (VlogSearchHit)((Object)info);
        IFile searchHitFile = DVTFileUtils.getInstance().findProjectFile(searchHit.getProject(), searchHit.getParserPath().toString());
        if (searchHitFile == null) {
            return;
        }
        DVTFileUtils.getInstance().openEditor(searchHitFile, searchHit.getLine(), null);
        this.getShell().close();
    }
}

