/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXConfigDBConstants;
import ro.amiq.dvt.interpreter.IXFactoryOverridesConstants;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.StringReplace;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkDetectorContributors;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.editor.hyperlink.IHyperlinkContext;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTViewContributor;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.config.db.ConfigDBRevealType;
import ro.amiq.dvt.ui.views.factory.overrides.XFactoryOverridesViewHandler;
import ro.amiq.dvt.ui.views.factory.overrides.XRegistersViewHandler;
import ro.amiq.dvt.ui.views.typehierarchy.ITHViewContributor;
import ro.amiq.dvt.ui.views.typehierarchy.QuickTypeHierarchyView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.vlogdt.hyperlink.tlmtreeviewer.JumpToTLMPathNode;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtilsBase;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroText;
import ro.amiq.vlogdt.ui.editor.VlogPartitionScanner;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;
import ro.amiq.vlogdt.ui.editor.actions.ShowConstraintsAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowInstancesAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowInstancesInDHAction;
import ro.amiq.vlogdt.ui.editor.hyperlink.JumpToTLMConnectionDialog;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfHyperlinkDetectorCommon;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfHyperlinkUtils;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.ui.editor.hyperlink.XConfigDBViewHandler;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class RfHyperlinkDetector
extends RfHyperlinkDetectorCommon {
    private static final int MAX_MACRO_REPLACEMENT_SIZE = 100;
    private static final String OPEN_FIELD_TYPE = "Open Field Type";
    private static final String OPEN_DECLARATION = "Open Declaration";
    private static final Set<Character> MACRO_INVALID_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf(' '), Character.valueOf(','), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf('\\')));
    private static final int DUMMY_DOCUMENT_MAX_SIZE = 1000;

    protected void computeHyperlinksForElementUnderMacro(List<IDVTHyperlink> links, RfNamedElementActionHyperlink hyperlinkAction, IDocument document, IFile file, IRegion region, int offset, RfProject rfProject, boolean canShowMultipleHyperlinks, ITextViewer textViewer, IRfScope[] previousScope) {
        IRfNamedElement hyperlinkNamedElement = hyperlinkAction.getRfNamedElement();
        if (!(hyperlinkNamedElement instanceof VlogMacroInfo)) {
            return;
        }
        VlogMacroInfo macroInfo = (VlogMacroInfo)hyperlinkNamedElement;
        if (macroInfo.hasParams() || macroInfo.isUndef() || macroInfo.isUndefConfigMacro() || macroInfo.isIfndefGuard() || macroInfo.getMacroText() == null) {
            return;
        }
        VlogMacroText vlogMacroText = macroInfo.getMacroText();
        List<StringReplace> macroTextReplacement = vlogMacroText.getReplacement();
        if (macroTextReplacement == null || macroTextReplacement.size() != 1) {
            return;
        }
        StringReplace firstReplacement = macroTextReplacement.get(0);
        if (firstReplacement == null || firstReplacement.getString() == null) {
            return;
        }
        String trimmedFirstReplacementString = firstReplacement.getString().trim();
        if (this.invalidMacroReplacement(trimmedFirstReplacementString)) {
            return;
        }
        try {
            IRegion hyperlinkRegion = hyperlinkAction.getHyperlinkRegion();
            int startMacroOffset = hyperlinkRegion.getOffset();
            int endMacroOffset = startMacroOffset + hyperlinkRegion.getLength();
            int maxDocumentDimension = Math.min(endMacroOffset, 1000);
            int realSubdocumentOffset = endMacroOffset - maxDocumentDimension;
            int subdocumentCursorOffset = startMacroOffset - realSubdocumentOffset;
            String documentSubtext = document.get(realSubdocumentOffset, maxDocumentDimension);
            Document dummyDocument = new Document(documentSubtext);
            dummyDocument.replace(subdocumentCursorOffset, hyperlinkRegion.getLength(), trimmedFirstReplacementString);
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new VlogPartitionScanner(), new String[]{"__vlog_sl_comment", "__vlog_ml_comment", "__vlog_literal", "__vlog_escaped_id", "__dftl_partition_content_type"});
            dummyDocument.setDocumentPartitioner("__vlog_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect((IDocument)dummyDocument);
            RfNamedElementActionHyperlink elementUnderMacroHyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(rfProject, this.fTextEditor, (IDocument)dummyDocument, dummyDocument.getLength() - 1, false, previousScope, true);
            if (elementUnderMacroHyperlinkAction == null) {
                return;
            }
            IRfNamedElement namedElementUnderMacroCall = elementUnderMacroHyperlinkAction.getRfNamedElement();
            if (namedElementUnderMacroCall == null) {
                return;
            }
            List<IDVTHyperlink> elementUnderMacroHyperlinks = this.getHyperlinkForElementUnderMacro(elementUnderMacroHyperlinkAction, offset, file, document, region, rfProject, canShowMultipleHyperlinks, textViewer, false);
            if (elementUnderMacroHyperlinks == null || elementUnderMacroHyperlinks.isEmpty()) {
                return;
            }
            String elementName = namedElementUnderMacroCall.getName();
            String elementKind = namedElementUnderMacroCall.getKindName();
            String elementUnderMacroLabelSuffix = " of " + elementKind + " '" + elementName + "'";
            elementUnderMacroHyperlinks.forEach(h -> {
                boolean bl = links.add(new IDVTHyperlink((IDVTHyperlink)h, elementUnderMacroLabelSuffix, region){
                    private final /* synthetic */ IDVTHyperlink val$h;
                    private final /* synthetic */ String val$elementUnderMacroLabelSuffix;
                    private final /* synthetic */ IRegion val$region;
                    {
                        this.val$h = iDVTHyperlink;
                        this.val$elementUnderMacroLabelSuffix = string;
                        this.val$region = iRegion;
                    }

                    public void updateGuiPart() {
                        this.val$h.updateGuiPart();
                    }

                    public boolean updateNonGuiPart() {
                        return this.val$h.updateNonGuiPart();
                    }

                    public String getTypeLabel() {
                        return this.val$h.getTypeLabel();
                    }

                    public String getHyperlinkText() {
                        return String.valueOf(this.val$h.getHyperlinkText()) + this.val$elementUnderMacroLabelSuffix;
                    }

                    public IRegion getHyperlinkRegion() {
                        return this.val$region;
                    }
                });
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean invalidMacroReplacement(String macroReplacement) {
        if (macroReplacement.length() > 100) {
            return true;
        }
        int i = 0;
        while (i < macroReplacement.length()) {
            if (MACRO_INVALID_CHARS.contains(Character.valueOf(macroReplacement.charAt(i)))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List<IDVTHyperlink> getHyperlinkForElementUnderMacro(RfNamedElementActionHyperlink hyperlinkAction, int offset, IFile file, IDocument document, IRegion region, RfProject rfProject, boolean canShowMultipleHyperlinks, ITextViewer textViewer, boolean includePredefined) {
        boolean isSelectionRegBlock;
        boolean isSelectionTLMPort;
        IDVTHyperlink jtaHyperlink;
        RfNamedElementActionHyperlink hyperlinkActionFirstImpl;
        IDVTHyperlink openDeclaration = this.createHyperlink(hyperlinkAction, DVTHyperlinkMessages.openDeclaration);
        IProject project = rfProject.getProject();
        if (project == null) {
            return null;
        }
        IRfNamedElement namedElement = hyperlinkAction.getRfNamedElement();
        IRfDefElement declaration = namedElement != null ? namedElement.getDeclaration() : null;
        String elementName = namedElement != null ? namedElement.getName() : null;
        boolean showFirstOpenDeclaration = namedElement instanceof VlogMacroInfo || DVTUtilsCommon.INSTANCE.showHyperlinkAction(declaration, elementName, offset, file.getLocation());
        IDVTHyperlink showUsages = this.createUsagesHyperlink(hyperlinkAction);
        boolean isFunctionPrototype = declaration != null && declaration instanceof RfFunctionDef && ((RfFunctionDef)declaration).isPrototype();
        boolean isImportFunctionDPI = namedElement instanceof RfFunction && ((RfFunction)namedElement).isImportDPI();
        boolean isPureFunction = namedElement instanceof RfFunction && ((RfFunction)namedElement).isPure();
        boolean isPredefined = namedElement != null && namedElement.isPredefined();
        boolean isAutoDefined = namedElement != null && namedElement.isAutoDefined();
        boolean isNamedArrayMethodItem = namedElement instanceof RfPredefinedField && ((RfPredefinedField)namedElement).isNamedArrayMethodItem();
        boolean isPredefinedOverriddenFunction = namedElement instanceof RfPredefinedFunction && ((RfPredefinedFunction)namedElement).isPredefinedOverridden();
        LinkedList<IDVTHyperlink> links = new LinkedList<IDVTHyperlink>();
        if (isAutoDefined) {
            links.add(this.createHyperlink(hyperlinkAction, "Auto defined"));
        } else if (includePredefined && isPredefined && !isPredefinedOverriddenFunction && !isNamedArrayMethodItem) {
            links.add(this.createHyperlink(hyperlinkAction, "Predefined"));
        } else {
            links.add(openDeclaration);
        }
        if (namedElement == null) {
            return null;
        }
        if (!(!isFunctionPrototype || isImportFunctionDPI || isPureFunction || isPredefined && !isPredefinedOverriddenFunction || (hyperlinkActionFirstImpl = RfUtils.getRfNamedElementActionHyperlink(rfProject, this.fTextEditor, document, offset, true, null, false)) == null)) {
            boolean firstImplementation = PrefConst.getJumpToImplementationFunctionTaskLayerAndSkipExternPrototype();
            if (firstImplementation) {
                links.add(0, this.createHyperlink(hyperlinkActionFirstImpl, DVTHyperlinkMessages.openImplementation));
            } else {
                links.add(this.createHyperlink(hyperlinkActionFirstImpl, DVTHyperlinkMessages.openImplementation));
            }
            this.createRevealInFactoryOverridesViewLink(region, links, hyperlinkActionFirstImpl);
        }
        this.createRevealInConfigDBViewLink(region, links, namedElement);
        this.createRevealAssociatedCallForSetterGetterInConfigDBViewLink(region, links, namedElement);
        this.createEnumHyperlink(region, rfProject, links, namedElement, hyperlinkAction.getAssocType(), file);
        this.createSuperImplementationHyperlink(region, project, links, namedElement, elementName);
        this.createChildImplementationHyperlinkQTHView(region, project, links, namedElement);
        if (canShowMultipleHyperlinks && !isPredefined) {
            this.createOpenHyperlinks(links, hyperlinkAction, rfProject, namedElement, this.fTextEditor, showFirstOpenDeclaration);
        }
        if ((jtaHyperlink = RfHyperlinkUtils.getJumpToAssignmentHyperlink(hyperlinkAction, offset, file, this.fTextEditor, rfProject, namedElement, isPredefined)) != null) {
            links.add(jtaHyperlink);
        }
        if (isSelectionTLMPort = RfHyperlinkDetector.checkSelectionIsTLMPort(namedElement)) {
            links.add(this.createJumpToConnectedTLMPortsHyperlink(this.fTextEditor, hyperlinkAction));
        }
        this.createOpenInstanceHyperlink(this.fTextEditor, region, namedElement, links);
        this.createShowConstraintsHyperlink(hyperlinkAction, links, namedElement);
        this.createShowInstancesHyperlink(hyperlinkAction, links, namedElement);
        this.createShowInstancesInDHHyperlink(hyperlinkAction, links, namedElement);
        links.add(showUsages);
        this.createShowReadersHyperlink(hyperlinkAction, links);
        this.createShowWritersHyperlink(hyperlinkAction, links);
        if (isSelectionTLMPort) {
            links.add(this.createShowConnectedTLMPortsHyperlink(hyperlinkAction));
        }
        if (isSelectionRegBlock = this.checkSelectionIsRegBlock(namedElement)) {
            links.add(this.createRevealInRegistersViewHyperlink(this.fTextEditor, hyperlinkAction));
        }
        DVTHyperlinkDetectorContributors.INSTANCE.insertHyperlinks(links, (IHyperlinkContext)new HyperlinkContext(project, textViewer, region, RfUtils.getRfElement(rfProject, this.fTextEditor, document, offset), canShowMultipleHyperlinks));
        return links;
    }

    private IDVTHyperlink createRevealInRegistersViewHyperlink(final ITextEditor editor, final RfNamedElementActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){

            public void updateGuiPart() {
                if (!(editor instanceof DVTEditor)) {
                    return;
                }
                IDocument document = ((DVTEditor)editor).getDocument();
                if (document == null) {
                    return;
                }
                IFile file = RfHyperlinkDetector.this.getFile(editor);
                if (file == null) {
                    return;
                }
                try {
                    XRegistersViewHandler xRegistersViewHandler = new XRegistersViewHandler();
                    xRegistersViewHandler.execute(null);
                }
                catch (ExecutionException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.revealInRegistersView;
            }

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }
        };
    }

    private boolean checkSelectionIsRegBlock(IRfNamedElement namedElement) {
        if (!(namedElement instanceof RfField)) {
            return false;
        }
        RfField rfField = (RfField)namedElement;
        IRfNamedElement resolvedType = rfField.getResolvedType(true);
        if (resolvedType == null || !(resolvedType instanceof RfClass)) {
            return false;
        }
        RfClass portClass = (RfClass)resolvedType;
        return portClass.isSubClass("uvm_reg", true) || portClass.isSubClass("uvm_reg_block", true);
    }

    private void createRevealAssociatedCallForSetterGetterInConfigDBViewLink(final IRegion region, List<IDVTHyperlink> links, IRfNamedElement namedElement) {
        if (!(namedElement instanceof IRfMethodElement)) {
            return;
        }
        final IXConfigDBConstants.ConfigDBCallType revealAction = IXConfigDBConstants.isConfigDBCall((IRfMethodElement)((IRfMethodElement)namedElement));
        if (revealAction == IXConfigDBConstants.ConfigDBCallType.NONE) {
            return;
        }
        links.add(new IDVTHyperlink(){

            public void updateGuiPart() {
                try {
                    new XConfigDBViewHandler().execute(revealAction == IXConfigDBConstants.ConfigDBCallType.SET ? ConfigDBRevealType.REVEAL_ASSOCIATED_GETTERS_FOR_SETTER : ConfigDBRevealType.REVEAL_ASSOCIATED_SETTER_FOR_GETTER);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public String getTypeLabel() {
                if (revealAction == IXConfigDBConstants.ConfigDBCallType.SET) {
                    return DVTHyperlinkMessages.revealGettersForSetterInConfigDB;
                }
                return DVTHyperlinkMessages.revealSetterForGetterInConfigDB;
            }

            public String getHyperlinkText() {
                if (revealAction == IXConfigDBConstants.ConfigDBCallType.SET) {
                    return DVTHyperlinkMessages.revealGettersForSetterInConfigDB;
                }
                return DVTHyperlinkMessages.revealSetterForGetterInConfigDB;
            }

            public IRegion getHyperlinkRegion() {
                return region;
            }
        });
    }

    private void createRevealInConfigDBViewLink(final IRegion region, List<IDVTHyperlink> links, final IRfNamedElement namedElement) {
        if (!(namedElement instanceof IRfMethodElement)) {
            return;
        }
        if (IXConfigDBConstants.isConfigDBCall((IRfMethodElement)((IRfMethodElement)namedElement)) == IXConfigDBConstants.ConfigDBCallType.NONE) {
            return;
        }
        links.add(new IDVTHyperlink(){

            public void updateGuiPart() {
                try {
                    new XConfigDBViewHandler().execute(IXConfigDBConstants.isConfigDBCall((IRfMethodElement)((IRfMethodElement)namedElement)) == IXConfigDBConstants.ConfigDBCallType.GET ? ConfigDBRevealType.REVEAL_GETTER : ConfigDBRevealType.REVEAL_SETTER);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public boolean updateNonGuiPart() {
                return true;
            }

            public String getTypeLabel() {
                return DVTHyperlinkMessages.revealInConfigDB;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.revealInConfigDB;
            }

            public IRegion getHyperlinkRegion() {
                return region;
            }
        });
    }

    private void createRevealInFactoryOverridesViewLink(final IRegion region, List<IDVTHyperlink> links, RfNamedElementActionHyperlink hyperlinkActionFirstImpl) {
        IRfNamedElement namedElement = hyperlinkActionFirstImpl.getRfNamedElement();
        if (!(namedElement instanceof IRfMethodElement)) {
            return;
        }
        String methodName = ((IRfMethodElement)namedElement).getName();
        if (!IXFactoryOverridesConstants.isFactoryOverrideSetCall((String)methodName)) {
            return;
        }
        links.add(new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getTypeLabel() {
                return DVTHyperlinkMessages.revealInFactoryOverrides;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.revealInFactoryOverrides;
            }

            public void updateGuiPart() {
                try {
                    new XFactoryOverridesViewHandler().execute(null);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            public boolean updateNonGuiPart() {
                return true;
            }
        });
    }

    private void createEnumHyperlink(final IRegion region, final RfProject project, List<IDVTHyperlink> links, final IRfNamedElement namedElement, final IRfScopeElement scopeElement, IFile currentFile) {
        if (!(namedElement instanceof RfField) || !((RfField)namedElement).isEnumElement() && !((RfField)namedElement).isParameter()) {
            return;
        }
        final ParserPath currentParserPath = DVTFileUtils.getInstance().resource2parser((IResource)currentFile);
        if (currentParserPath == null) {
            return;
        }
        links.add(new IDVTHyperlink(){
            SearchHit searchHit;

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getTypeLabel() {
                return DVTHyperlinkMessages.jumpToNextState;
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.jumpToNextState;
            }

            public void updateGuiPart() {
                VlogFileUtils.getInstance().openFile(project.getProject(), this.searchHit.getParserPath().path, this.searchHit.getLine(), namedElement.getName());
            }

            public boolean updateNonGuiPart() {
                this.searchHit = RfHyperlinkDetector.this.findNextCaseBranchAppearanceForElement(region.getOffset(), currentParserPath, project, namedElement, scopeElement);
                return this.searchHit != null;
            }
        });
    }

    private <T extends IDVTViewContributor> HistoryItem getHistoryItemAtCurrentOffset(Class<T> clazz) {
        IEditorPart editor;
        block6: {
            block5: {
                try {
                    editor = DVTFileUtils.getInstance().getActiveEditor();
                    if (editor != null) break block5;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            if (editor instanceof DVTEditor) break block6;
            return null;
        }
        IDVTViewContributor contributor = DVTViewContributors.getInstance().getViewContributor(((DVTEditor)editor).getLanguageKind(), clazz);
        HistoryItem hItem = null;
        if (contributor instanceof ITHViewContributor) {
            hItem = ((ITHViewContributor)contributor).createHistoryItemForElementAtCursor((IDVTEditor)((DVTEditor)editor), ((DVTEditor)editor).getCursor(), false);
        }
        return hItem;
    }

    private void createChildImplementationHyperlinkQTHView(final IRegion region, IProject project, List<IDVTHyperlink> links, IRfNamedElement namedElement) {
        boolean isVirtual;
        if (!(namedElement instanceof RfFunction)) {
            return;
        }
        RfFunction rfFunction = (RfFunction)namedElement;
        RfNamedElement container = rfFunction.getClosestTypeContainer();
        if (!(container instanceof RfClass)) {
            return;
        }
        boolean bl = isVirtual = rfFunction.isVirtual() && !rfFunction.isConstructor();
        if (!isVirtual) {
            return;
        }
        LinkedHashSet<RfClass> visited = new LinkedHashSet<RfClass>();
        RfHyperlinkDetectorCommon.FirstImplementationNrOfImplementationsPair pair = this.compute((RfClass)container, (RfClass)container, rfFunction, visited, new HashSet<RfFunction>());
        if (pair.firstImplementation == null) {
            return;
        }
        if (pair.nofImplementations == 1) {
            links.add(this.createHyperlink(RfUtils.createOpenAction(pair.firstImplementation, project, region), DVTHyperlinkMessages.openChildImplementation));
        } else {
            links.add(new IDVTHyperlink(){

                public void updateGuiPart() {
                    try {
                        HistoryItem hItem = RfHyperlinkDetector.this.getHistoryItemAtCurrentOffset(ITHViewContributor.class);
                        if (hItem == null) {
                            return;
                        }
                        ViewsUtils.openQuickView(QuickTypeHierarchyView.class, (Object)hItem);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }

                public boolean updateNonGuiPart() {
                    return true;
                }

                public String getTypeLabel() {
                    return null;
                }

                public String getHyperlinkText() {
                    return DVTHyperlinkMessages.openChildImplementation;
                }

                public IRegion getHyperlinkRegion() {
                    return region;
                }
            });
        }
    }

    private void createShowConstraintsHyperlink(RfNamedElementActionHyperlink hyperlink, List<IDVTHyperlink> links, IRfNamedElement namedElement) {
        if (!VlogRfReferencesUtils.shouldShowConstraints(namedElement)) {
            return;
        }
        links.add(this.createConstraintsHyperlink(hyperlink, namedElement));
    }

    private IDVTHyperlink createConstraintsHyperlink(final RfNamedElementActionHyperlink hyperlinkAction, final IRfNamedElement element) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showConstraints;
            }

            public void updateGuiPart() {
                ShowConstraintsAction.showConstraints((RfField)element);
            }

            public boolean updateNonGuiPart() {
                return true;
            }
        };
    }

    protected void openShowInstances(IRfNamedElement namedElement) {
        ShowInstancesAction.showInstances(namedElement);
    }

    protected void openShowInstancesInDH(IRfNamedElement element) {
        ShowInstancesInDHAction.showInstancesInDHFor(element);
    }

    protected void openShowReadersUsages(IActionHyperlink hyperlink) {
        if (!(this.fTextEditor instanceof DVTEditor)) {
            return;
        }
        if (!(hyperlink instanceof RfNamedElementActionHyperlink)) {
            return;
        }
        IDocument document = ((DVTEditor)this.fTextEditor).getDocument();
        VlogRfGUIReferencesUtils.showReadersAction((IRfFieldElement)hyperlink.getRfNamedElement(), ((RfNamedElementActionHyperlink)hyperlink).getScope(), hyperlink.getElementPath(), ((RfNamedElementActionHyperlink)hyperlink).getHidContext(), ((RfNamedElementActionHyperlink)hyperlink).getProject(), VlogRfReferencesUtils.getSearchedStringFromOffset(document, hyperlink.getHyperlinkRegion().getOffset()), hyperlink.isHierarchicalAccess());
    }

    protected void openShowWritersUsages(IActionHyperlink hyperlink) {
        if (!(this.fTextEditor instanceof DVTEditor)) {
            return;
        }
        IDocument document = ((DVTEditor)this.fTextEditor).getDocument();
        VlogRfGUIReferencesUtils.showWritersAction((IRfFieldElement)hyperlink.getRfNamedElement(), ((RfNamedElementActionHyperlink)hyperlink).getScope(), hyperlink.getElementPath(), ((RfNamedElementActionHyperlink)hyperlink).getHidContext(), ((RfNamedElementActionHyperlink)hyperlink).getProject(), VlogRfReferencesUtils.getSearchedStringFromOffset(document, hyperlink.getHyperlinkRegion().getOffset()), hyperlink.isHierarchicalAccess());
    }

    private IDVTHyperlink createUsagesHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showUsages;
            }

            public void updateGuiPart() {
                if (!(RfHyperlinkDetector.this.fTextEditor instanceof DVTEditor)) {
                    return;
                }
                IDocument document = ((DVTEditor)RfHyperlinkDetector.this.fTextEditor).getDocument();
                VlogRfGUIReferencesUtils.showUsagesAction(hyperlinkAction.getRfNamedElement(), hyperlinkAction.getAssocType() != null ? hyperlinkAction.getAssocType() : hyperlinkAction.getScope(), hyperlinkAction.getElementPath(), hyperlinkAction.isHierarchicalAccess(), hyperlinkAction.getProject(), VlogRfReferencesUtils.getSearchedStringFromOffset(document, hyperlinkAction.getHyperlinkRegion().getOffset()));
            }

            public boolean updateNonGuiPart() {
                return true;
            }
        };
    }

    @Override
    protected void openJumpToConnectedTLMPortsHyperlink(RfNamedElementActionHyperlink hyperlinkAction, JumpToTLMPathNode root) {
        Shell dialogShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRfNamedElement rfSearchedNamedElement = hyperlinkAction.getRfNamedElement();
        if (rfSearchedNamedElement == null) {
            return;
        }
        String searchedElement = rfSearchedNamedElement.getName();
        if (searchedElement == null) {
            return;
        }
        JumpToTLMConnectionDialog dialog = new JumpToTLMConnectionDialog(dialogShell, root, searchedElement);
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialogShell.forceActive();
    }

    private IDVTHyperlink createShowConnectedTLMPortsHyperlink(final RfNamedElementActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){
            BiPredicate<IHidObject, IRfClassElement> filterPredicate;
            private String searchedStringFromOffset;

            public void updateGuiPart() {
                VlogRfGUIReferencesUtils.showFilteredUsagesAction(hyperlinkAction.getRfNamedElement(), hyperlinkAction.getAssocType(), hyperlinkAction.getProject(), this.searchedStringFromOffset, this.filterPredicate);
            }

            public boolean updateNonGuiPart() {
                if (!(RfHyperlinkDetector.this.fTextEditor instanceof DVTEditor)) {
                    return false;
                }
                AbstractBreadcrumbViewer breadcrumbViewer = ((DVTEditor)RfHyperlinkDetector.this.fTextEditor).getBreadcrumbViewer(VHBreadcrumbViewer.class);
                if (!(breadcrumbViewer instanceof VHBreadcrumbViewer)) {
                    return false;
                }
                VHBreadcrumbViewer vhBreadcrumbViewer = (VHBreadcrumbViewer)breadcrumbViewer;
                BreadcrumbInput input = vhBreadcrumbViewer.getInput();
                if (input == null || input.getInputSegments() == null) {
                    return false;
                }
                List segments = input.getInputSegments();
                ArrayList<RfXvmBase> portTreePathElements = new ArrayList<RfXvmBase>();
                int index = segments.size() - 1;
                while (index >= 0) {
                    BreadcrumbSegment segment = (BreadcrumbSegment)segments.get(index);
                    IRfBreadcrumbElement element = segment.getElement();
                    if (!(element instanceof RfXvmBase)) {
                        return false;
                    }
                    portTreePathElements.add((RfXvmBase)element);
                    --index;
                }
                IDocument document = ((DVTEditor)RfHyperlinkDetector.this.fTextEditor).getDocument();
                if (document == null) {
                    return false;
                }
                RfProject rfProject = RfManager.getInstance().getRfProject(hyperlinkAction.getProject());
                if (rfProject == null) {
                    return false;
                }
                RfWNamedElementAndScope elementAndScope = RfUtilsBase.getRfElement(rfProject, RfHyperlinkDetector.this.fTextEditor, document, hyperlinkAction.getHyperlinkRegion().getOffset(), null, false);
                if (elementAndScope == null) {
                    return false;
                }
                ArrayList<RfWNamedElementAndScope> elemsAndScopeList = new ArrayList<RfWNamedElementAndScope>();
                Deque<RfWNamedElementAndScope> elementAndScopeStack = elementAndScope.getElementAndScopeStack();
                while (!elementAndScopeStack.isEmpty()) {
                    elemsAndScopeList.add(elementAndScopeStack.pollLast());
                }
                this.filterPredicate = (iHidObj, enclosingScope) -> RfHyperlinkDetector.shouldFilterIHidObject(iHidObj, enclosingScope, hyperlinkAction.getRfNamedElement(), portTreePathElements, elemsAndScopeList);
                this.searchedStringFromOffset = VlogRfReferencesUtils.getSearchedStringFromOffset(document, hyperlinkAction.getHyperlinkRegion().getOffset());
                return true;
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.showConnectedTLMPorts;
            }

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }
        };
    }

    private List<IDVTHyperlink> createInstanceHyperlinks(RfProject rfProject, IFile file, IDocument document, int offset, IRegion region) {
        IdentityHashMap<RfInstance, IDVTHyperlink> regularInstances = new IdentityHashMap<RfInstance, IDVTHyperlink>();
        NullProtectedList<IDVTHyperlink> boundInstanceLinks = new NullProtectedList<IDVTHyperlink>();
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, file, document, offset, null);
        if (namedElementAndScope == null) {
            return new ArrayList<IDVTHyperlink>();
        }
        RfNamedElement namedElement = namedElementAndScope.getNamedElement();
        if (!(namedElement instanceof RfModule || namedElement instanceof RfPrimitive || namedElement instanceof RfInterface || namedElement instanceof RfProgram)) {
            return new ArrayList<IDVTHyperlink>();
        }
        ArrayList<RfInstanceHolder> toplevels = new ArrayList<RfInstanceHolder>();
        toplevels.addAll(Arrays.asList(rfProject.getAllModules()));
        toplevels.addAll(Arrays.asList(rfProject.getAllInterfaces()));
        toplevels.addAll(rfProject.getProgramsWithPrefix("", 2, 1));
        if (toplevels.size() > 500) {
            return new ArrayList<IDVTHyperlink>();
        }
        for (RfNamedElement rfNamedElement : toplevels) {
            List<RfInstance> instances = rfNamedElement.getInstancesWithPrefix("", 2, 1);
            for (Map.Entry<RfGenerateBlock, List<RfInstance>> entry : RfHyperlinkDetector.getAllInstancesInGenerateBlocks(rfNamedElement).entrySet()) {
                for (RfInstance instance : entry.getValue()) {
                    instances.add(instance);
                }
            }
            for (RfInstance instance : instances) {
                if (!regularInstances.containsKey(instance) && instance.getAssociatedType() == namedElement) {
                    RfNamedElementActionHyperlink link = RfUtils.createOpenAction(instance, rfProject.getProject(), region);
                    String instanceName = rfNamedElement.getName() + "." + instance.getName();
                    regularInstances.put(instance, this.createHyperlink(link, DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openInstance, (Object[])new Object[]{instanceName})));
                }
                IdentityHashMap<RfFieldDef, IDVTHyperlink> boundDefsForCrtInstance = new IdentityHashMap<RfFieldDef, IDVTHyperlink>();
                for (RfInstance nestedInstance : instance.getInstancesWithPrefix("", 2, 1)) {
                    if (nestedInstance.getAssociatedType() != namedElement) continue;
                    for (RfDefElement def : nestedInstance.getDeclarations()) {
                        RfFieldDef fieldDef;
                        if (!(def instanceof RfFieldDef) || boundDefsForCrtInstance.containsKey(fieldDef = (RfFieldDef)def)) continue;
                        RfNamedElementActionHyperlink link = RfUtils.createOpenAction(fieldDef, nestedInstance.getName(), rfProject.getProject(), region);
                        String nestedInstanceName = rfNamedElement.getName() + "." + nestedInstance.getName();
                        boundDefsForCrtInstance.put(fieldDef, this.createHyperlink(link, DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openBoundInstance, (Object[])new Object[]{nestedInstanceName})));
                    }
                }
                boundInstanceLinks.addAll(boundDefsForCrtInstance.values());
            }
        }
        List<IDVTHyperlink> list = RfHyperlinkDetector.getSortedHyperlinks(regularInstances.values());
        list.addAll(RfHyperlinkDetector.getSortedHyperlinks(boundInstanceLinks));
        return list;
    }

    private static Map<RfGenerateBlock, List<RfInstance>> getAllInstancesInGenerateBlocks(RfNamedElement toplevel) {
        IdentityHashMap<RfGenerateBlock, List<RfInstance>> result = new IdentityHashMap<RfGenerateBlock, List<RfInstance>>();
        List<RfGenerateBlock> localGenerateBlocks = toplevel.getLocalMembers(RfGenerateBlock.class);
        if (localGenerateBlocks != null) {
            for (RfGenerateBlock genBlock : localGenerateBlocks) {
                List<RfInstance> instances = genBlock.getInstancesWithPrefix("", 2, 1);
                if (instances.isEmpty()) continue;
                result.put(genBlock, instances);
            }
        }
        return result;
    }

    private static List<IDVTHyperlink> getSortedHyperlinks(Collection<IDVTHyperlink> hyperlinks) {
        NullProtectedList<IDVTHyperlink> result = new NullProtectedList<IDVTHyperlink>(hyperlinks);
        Collections.sort(result, (o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getHyperlinkText().compareTo(o2.getHyperlinkText());
        });
        return result;
    }

    protected IActionHyperlink createOpenAction(IRfInstanceElement targetNamedElement, IProject project, IRegion region) {
        RfNamedElementActionHyperlink action = RfUtils.createOpenAction((IRfNamedElement)targetNamedElement, project, region);
        if (action != null) {
            action.setScope((IRfScopeElement)targetNamedElement);
        }
        return action;
    }

    protected void setDataForBreadcrumb(IActionHyperlink hyperlink, String label) {
    }

    protected void setDataForVHBreadcrumb(DVTEditor activeEditor, String label, IActionHyperlink hyperlink) {
        try {
            BreadcrumbInput newInput;
            if (!(hyperlink instanceof RfNamedElementActionHyperlink)) {
                return;
            }
            RfNamedElementActionHyperlink hyperlinkAction = (RfNamedElementActionHyperlink)hyperlink;
            if (!OPEN_FIELD_TYPE.equals(label) && !OPEN_DECLARATION.equals(label)) {
                return;
            }
            AbstractBreadcrumbUtils utils = activeEditor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
            if (!(utils instanceof VlogVHBreadcrumbUtils)) {
                return;
            }
            IRfNamedElement hyperlinkNamedElement = hyperlinkAction.getRfNamedElement();
            if (!(hyperlinkNamedElement instanceof RfClass) || !((VlogVHBreadcrumbUtils)utils).isXVMComponent((RfClass)hyperlinkNamedElement)) {
                return;
            }
            AbstractBreadcrumbViewer breadcrumbViewer = activeEditor.getBreadcrumbViewer(VHBreadcrumbViewer.class);
            if (!(breadcrumbViewer instanceof VHBreadcrumbViewer)) {
                return;
            }
            BreadcrumbInput oldInput = breadcrumbViewer.getInput();
            if (oldInput == null) {
                return;
            }
            RfField hperlinkField = null;
            Object meta = hyperlinkAction.getMeta("ASSOC_TYPE_OF");
            if (meta instanceof RfField) {
                hperlinkField = (RfField)meta;
            }
            if ((newInput = ((VlogVHBreadcrumbUtils)utils).computeHyperlinkBreadcrumb(activeEditor.getProject(), oldInput, hperlinkField, hyperlinkAction)) == null) {
                return;
            }
            IRfDefElement declaration = hyperlinkNamedElement.getDeclaration();
            if (declaration == null) {
                return;
            }
            IRfFileDef defFile = declaration.getDefFile();
            if (defFile == null) {
                return;
            }
            IResource file = (IResource)defFile.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)newInput);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected LanguageKind getSourceLanguageKind() {
        return LanguageKind.VLOG;
    }

    @Override
    protected IFile getFile(ITextEditor fTextEditor) {
        IEditorInput editorInput = fTextEditor.getEditorInput();
        if (editorInput == null || !(editorInput instanceof FileEditorInput)) {
            return null;
        }
        return ((FileEditorInput)editorInput).getFile();
    }

    private class HyperlinkContext
    implements IHyperlinkContext {
        private final IProject project;
        private final ITextViewer textViewer;
        private final IRegion region;
        private final IRfNamedElementAndScope namedElementAndScope;
        private final boolean canShowMultipleHyperlinks;

        public HyperlinkContext(IProject project, ITextViewer textViewer, IRegion region, IRfNamedElementAndScope namedElementAndScope, boolean canShowMultipleHyperlinks) {
            this.project = project;
            this.textViewer = textViewer;
            this.region = region;
            this.namedElementAndScope = namedElementAndScope;
            this.canShowMultipleHyperlinks = canShowMultipleHyperlinks;
        }

        public IProject getProject() {
            return this.project;
        }

        public ITextEditor getTextEditor() {
            return RfHyperlinkDetector.this.fTextEditor;
        }

        public ITextViewer getTextViewer() {
            return this.textViewer;
        }

        public IRegion getRegion() {
            return this.region;
        }

        public IRfNamedElementAndScope getNamedElementAndScope() {
            return this.namedElementAndScope;
        }

        public boolean canShowMultipleHyperlinks() {
            return this.canShowMultipleHyperlinks;
        }
    }
}

