/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkDetector;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.search.SearchHit;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.TypeParametersUtils;
import ro.amiq.vlogdt.hyperlink.tlmtreeviewer.JumpToTLMPathNode;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtilsBase;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogUsagesFilteringWrapper;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.ui.search.text.VlogSearchHit;

public abstract class RfHyperlinkDetectorCommon
extends DVTHyperlinkDetector {
    protected static final String MODULE_HYPERLINK_LABEL = "Module";
    private static final EnumSet<HidFlatteningOption> STATE_MACHINE_CONDITION_HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_SELECTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALLS);

    public void createSuperImplementationHyperlink(IRegion region, IProject project, List<IDVTHyperlink> links, IRfNamedElement namedElement, String elementName) {
        if (!(namedElement instanceof RfFunction) && !(namedElement instanceof RfConstraint)) {
            return;
        }
        boolean isFunction = namedElement instanceof RfFunction;
        RfNamedElement container = ((RfNamedElement)namedElement).getClosestTypeContainer();
        if (!(container instanceof RfClass)) {
            return;
        }
        if (isFunction && !((RfFunction)namedElement).isVirtual() && !((RfFunction)namedElement).isConstructor()) {
            return;
        }
        RfElement firstSuperImplementation = null;
        RfClass currentClass = ((RfClass)container).getParent();
        while (currentClass != null) {
            RfElement rfElement = firstSuperImplementation = isFunction ? (RfNamedElement)currentClass.getLocalMember(RfFunction.class, elementName, true) : (RfNamedElement)currentClass.getLocalMember(RfConstraint.class, elementName, true);
            if (firstSuperImplementation != null) break;
            currentClass = currentClass.getParent();
        }
        if (firstSuperImplementation == null) {
            ArrayList<RfClass> parentInterfaces = new ArrayList<RfClass>(this.getParentInterfaces((RfClass)container));
            while (!parentInterfaces.isEmpty()) {
                RfClass currentInterface = parentInterfaces.remove(0);
                RfElement rfElement = firstSuperImplementation = isFunction ? (RfNamedElement)currentInterface.getLocalMember(RfFunction.class, elementName, true) : (RfNamedElement)currentInterface.getLocalMember(RfConstraint.class, elementName, true);
                if (firstSuperImplementation != null) break;
                parentInterfaces.addAll(this.getParentInterfaces(currentInterface));
            }
        }
        if (firstSuperImplementation == null) {
            return;
        }
        if (isFunction && firstSuperImplementation.isExtern()) {
            RfDefElement element = ((RfNamedElement)firstSuperImplementation).getImplementation();
            if (element == null) {
                return;
            }
            links.add(this.createHyperlink(RfUtils.createOpenAction(element, elementName, project, region), DVTHyperlinkMessages.openSuperImplementation));
        } else {
            links.add(this.createHyperlink(RfUtils.createOpenAction((IRfNamedElement)firstSuperImplementation, project, region, elementName), DVTHyperlinkMessages.openSuperImplementation));
        }
    }

    private Collection<RfClass> getParentInterfaces(RfClass clazz) {
        List<RfClass> parentInterfacesCollection = clazz.getParentInterfaces();
        if (parentInterfacesCollection == null) {
            return new ArrayList<RfClass>();
        }
        return parentInterfacesCollection;
    }

    public FirstImplementationNrOfImplementationsPair compute(RfClass initialClass, RfClass container, RfFunction namedElement, Set<RfClass> visited, Set<RfFunction> implementations) {
        RfFunction currentChildImplementation;
        FirstImplementationNrOfImplementationsPair pair = null;
        int nOfImplementations = 0;
        RfFunction firstImplementation = null;
        if (!visited.contains(container)) {
            visited.add(container);
            Set<RfClass> childClasses = container.getChildren();
            if (childClasses != null && !childClasses.isEmpty()) {
                for (RfClass childClass : childClasses) {
                    pair = this.compute(initialClass, childClass, namedElement, visited, implementations);
                    nOfImplementations += pair.nofImplementations;
                    if (firstImplementation != null) continue;
                    firstImplementation = pair.firstImplementation;
                }
            }
        } else {
            DVTLogger.INSTANCE.logInfo("[Open Child Implementation] Chain detection in computing children tree for class " + initialClass.getName() + "\n These are visited classes: " + DVTStringUtil.join(visited, (String)","));
        }
        if ((currentChildImplementation = container.getLocalMember(RfFunction.class, namedElement.getName(), true)) != null && namedElement != currentChildImplementation) {
            firstImplementation = currentChildImplementation;
            ++nOfImplementations;
            if (implementations != null && !implementations.contains(firstImplementation)) {
                implementations.add(firstImplementation);
            }
        }
        return new FirstImplementationNrOfImplementationsPair(nOfImplementations, firstImplementation);
    }

    protected void addNonDesignOpenHyperlink(List<IDVTHyperlink> links, IRfNamedElement namedElement, RfNamedElementActionHyperlink associatedTypeAction, String hyperlinkLabel) {
        if (namedElement instanceof RfInstance.RfInstanceList || associatedTypeAction == null) {
            return;
        }
        links.add(this.createHyperlink(associatedTypeAction, hyperlinkLabel));
    }

    protected void addOpenLinks(List<IDVTHyperlink> links, IDVTHyperlink moduleOrEntityHyperlink, IDVTHyperlink archHyperlink, boolean showFirstOpenDeclaration) {
        if (!showFirstOpenDeclaration) {
            if (moduleOrEntityHyperlink != null) {
                links.add(0, moduleOrEntityHyperlink);
            }
            if (archHyperlink != null) {
                links.add(1, archHyperlink);
            }
        } else {
            if (moduleOrEntityHyperlink != null) {
                links.add(moduleOrEntityHyperlink);
            }
            if (archHyperlink != null) {
                links.add(archHyperlink);
            }
        }
    }

    protected IDVTHyperlink createOpenArchitectureHyperlink(IRfDesignElement designElement, IProject project, IRegion region) {
        IRfDesignElement architecture;
        if (designElement == null) {
            return null;
        }
        IRfDesignElement iRfDesignElement = architecture = designElement.getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE ? designElement : designElement.getArchitecture();
        if (architecture == null) {
            return null;
        }
        if (architecture.getKind() != IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
            return null;
        }
        RfNamedElementActionHyperlink architectureAction = RfUtils.createOpenAction((IRfNamedElement)architecture, project, region);
        if (architectureAction == null) {
            return null;
        }
        return this.createHyperlink(architectureAction, DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openArchitectureDeclaration, (Object[])new Object[]{architecture.getName()}));
    }

    public SearchHit findNextCaseBranchAppearanceForElement(int offset, ParserPath currentParserPath, RfProject rfProject, IRfNamedElement namedElement, IRfScopeElement scopeElement) {
        if (!(namedElement instanceof RfField) || !((RfField)namedElement).isEnumElement() && !((RfField)namedElement).isParameter()) {
            return null;
        }
        BiPredicate<IHidObject, IRfClassElement> filterPredicate = (iHidObj, enclosingScope) -> this.shouldFilterJumpToCaseBranch((IHidObject)iHidObj);
        VlogUsagesFilteringWrapper filteringWrapper = new VlogUsagesFilteringWrapper(filterPredicate, true);
        Set<SearchHit> usages = VlogRfGUIReferencesUtils.showFilteredUsagesActionResult(namedElement, scopeElement, rfProject.getProject(), filteringWrapper);
        if (usages == null || usages.isEmpty()) {
            return null;
        }
        if (usages.size() == 1) {
            Iterator<SearchHit> searchHitInterator = usages.iterator();
            return searchHitInterator.next();
        }
        SearchHit firstHit = null;
        SearchHit nextHit = null;
        for (SearchHit usage : usages) {
            if (usage.getParserPath() == null) continue;
            if (this.shouldUpdateFirstCaseBranchHit(firstHit, usage)) {
                firstHit = usage;
            }
            if (!this.shouldUpdateNextCaseBranchHit(nextHit, usage, currentParserPath, offset)) continue;
            nextHit = usage;
        }
        if (nextHit == null) {
            return firstHit;
        }
        return nextHit;
    }

    private boolean shouldFilterJumpToCaseBranch(IHidObject iHidObj) {
        if (iHidObj instanceof RfHidOperator) {
            return !((RfHidOperator)iHidObj).hasOccurrence(HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION);
        }
        return true;
    }

    private boolean shouldUpdateFirstCaseBranchHit(SearchHit firstHit, SearchHit usage) {
        if (firstHit == null) {
            return true;
        }
        if (usage.getParserPath().compareTo(firstHit.getParserPath()) < 0) {
            return true;
        }
        return usage.getParserPath().equals((Object)firstHit.getParserPath()) && usage.getOffset() < firstHit.getOffset();
    }

    private boolean shouldUpdateNextCaseBranchHit(SearchHit nextHit, SearchHit usage, ParserPath crtParserPath, int crtOffset) {
        if (usage.getParserPath().compareTo(crtParserPath) < 0) {
            return false;
        }
        if (usage.getParserPath().equals((Object)crtParserPath) && usage.getOffset() <= crtOffset) {
            return false;
        }
        if (nextHit == null) {
            return true;
        }
        if (usage.getParserPath().compareTo(nextHit.getParserPath()) > 0) {
            return false;
        }
        return !usage.getParserPath().equals((Object)nextHit.getParserPath()) || usage.getOffset() < nextHit.getOffset();
    }

    public static boolean checkSelectionIsTLMPort(IRfNamedElement namedElement) {
        if (!(namedElement instanceof RfField)) {
            return false;
        }
        RfField rfField = (RfField)namedElement;
        IRfNamedElement resolvedType = rfField.getResolvedType(true);
        if (resolvedType == null || !(resolvedType instanceof RfClass)) {
            return false;
        }
        RfClass portClass = (RfClass)resolvedType;
        return portClass.isSubClass("uvm_port_base", true);
    }

    public IDVTHyperlink createJumpToConnectedTLMPortsHyperlink(final ITextEditor editor, final RfNamedElementActionHyperlink hyperlinkAction) {
        return new IDVTHyperlink(){
            JumpToTLMPathNode root;
            private SearchHit searchHitElement;

            private void openSearchHitFile(SearchHit searchHit) {
                IFile searchHitFile = DVTFileUtils.getInstance().findProjectFile(searchHit.getProject(), searchHit.getParserPath().toString());
                if (searchHitFile == null) {
                    return;
                }
                DVTFileUtils.getInstance().openEditor(searchHitFile, searchHit.getLine(), null);
            }

            public String getTypeLabel() {
                return hyperlinkAction.getTypeLabel();
            }

            public String getHyperlinkText() {
                return DVTHyperlinkMessages.jumpToConnectedTLMPort;
            }

            public IRegion getHyperlinkRegion() {
                return hyperlinkAction.getHyperlinkRegion();
            }

            public void updateGuiPart() {
                if (this.searchHitElement == null) {
                    RfHyperlinkDetectorCommon.this.openJumpToConnectedTLMPortsHyperlink(hyperlinkAction, this.root);
                } else {
                    this.openSearchHitFile(this.searchHitElement);
                }
            }

            public boolean updateNonGuiPart() {
                if (!(editor instanceof DVTEditor)) {
                    return false;
                }
                AbstractBreadcrumbViewer breadcrumbViewer = ((DVTEditor)editor).getBreadcrumbViewer(VHBreadcrumbViewer.class);
                if (!(breadcrumbViewer instanceof VHBreadcrumbViewer)) {
                    return false;
                }
                VHBreadcrumbViewer vhBreadcrumbViewer = (VHBreadcrumbViewer)breadcrumbViewer;
                BreadcrumbInput input = vhBreadcrumbViewer.getInput();
                if (input == null || input.getInputSegments() == null) {
                    return false;
                }
                List segments = input.getInputSegments();
                ArrayList<RfXvmBase> portTreePathElements = new ArrayList<RfXvmBase>();
                int index = segments.size() - 1;
                while (index >= 0) {
                    BreadcrumbSegment segment = (BreadcrumbSegment)segments.get(index);
                    IRfBreadcrumbElement element = segment.getElement();
                    if (!(element instanceof RfXvmBase)) {
                        return false;
                    }
                    portTreePathElements.add((RfXvmBase)element);
                    --index;
                }
                IDocument document = ((DVTEditor)editor).getDocument();
                if (document == null) {
                    return false;
                }
                IFile file = RfHyperlinkDetectorCommon.this.getFile(editor);
                if (file == null) {
                    return false;
                }
                RfProject rfProject = RfManager.getInstance().getRfProject(hyperlinkAction.getProject());
                if (rfProject == null) {
                    return false;
                }
                RfWNamedElementAndScope elementAndScope = RfUtilsBase.getRfElement(rfProject, editor, document, hyperlinkAction.getHyperlinkRegion().getOffset(), null, false);
                if (elementAndScope == null) {
                    return false;
                }
                ArrayList<RfWNamedElementAndScope> elemsAndScopeList = new ArrayList<RfWNamedElementAndScope>();
                Deque elementAndScopeStack = elementAndScope.getElementAndScopeStack();
                while (!elementAndScopeStack.isEmpty()) {
                    elemsAndScopeList.add((RfWNamedElementAndScope)elementAndScopeStack.pollLast());
                }
                BiPredicate<IHidObject, IRfClassElement> filterPredicate = (iHidObj, enclosingScope) -> RfHyperlinkDetectorCommon.shouldFilterIHidObject(iHidObj, enclosingScope, hyperlinkAction.getRfNamedElement(), portTreePathElements, elemsAndScopeList);
                VlogUsagesFilteringWrapper filteringWrapper = new VlogUsagesFilteringWrapper(filterPredicate, false);
                Set<SearchHit> usages = VlogRfGUIReferencesUtils.showFilteredUsagesActionResult(hyperlinkAction.getRfNamedElement(), hyperlinkAction.getAssocType(), hyperlinkAction.getProject(), filteringWrapper);
                if (usages == null || usages.isEmpty()) {
                    return false;
                }
                if (usages.size() == 1) {
                    Iterator<SearchHit> searchHitInterator = usages.iterator();
                    SearchHit searchHit = searchHitInterator.next();
                    if (!(searchHit instanceof VlogSearchHit)) {
                        return false;
                    }
                    this.searchHitElement = searchHit;
                    return true;
                }
                ArrayList<SearchHit> searchHits = new ArrayList<SearchHit>();
                for (SearchHit searchHit : usages) {
                    IFile searchHitFile;
                    if (!(searchHit instanceof VlogSearchHit) || (searchHitFile = DVTFileUtils.getInstance().findProjectFile(searchHit.getProject(), searchHit.getParserPath().toString())) == null) continue;
                    if (searchHitFile.equals((Object)file) && searchHit.getOffset() == hyperlinkAction.getHyperlinkRegion().getOffset()) {
                        this.root = new JumpToTLMPathNode(null, searchHit);
                        continue;
                    }
                    searchHits.add(searchHit);
                }
                if (this.root == null) {
                    try {
                        IRegion region = document.getLineInformationOfOffset(this.getHyperlinkRegion().getOffset());
                        String lineContents = document.get(region.getOffset(), region.getLength()).trim();
                        int lineNumber = document.getLineOfOffset(region.getOffset()) + 1;
                        this.root = new JumpToTLMPathNode(null, String.valueOf(lineNumber) + ": " + lineContents);
                    }
                    catch (BadLocationException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                if (searchHits.isEmpty() || this.root == null) {
                    return false;
                }
                if (searchHits.size() == 1) {
                    SearchHit searchHit;
                    this.searchHitElement = searchHit = (SearchHit)searchHits.get(0);
                    return true;
                }
                Collections.sort(searchHits, (sh1, sh2) -> {
                    int shComp = sh1.getParserPath().compareTo(sh2.getParserPath());
                    if (shComp != 0) {
                        return shComp;
                    }
                    Integer shLine1 = sh1.getLine();
                    Integer shLine2 = sh2.getLine();
                    return shLine1.compareTo(shLine2);
                });
                SearchHit firstSearchHit = (SearchHit)searchHits.get(0);
                String lastParserPath = firstSearchHit.getParserPath().toString();
                JumpToTLMPathNode pathNode = new JumpToTLMPathNode(this.root, lastParserPath);
                this.root.addChild(pathNode);
                pathNode.addChild(new JumpToTLMPathNode(pathNode, firstSearchHit));
                int i = 1;
                while (i < searchHits.size()) {
                    String currentParserPath = ((SearchHit)searchHits.get(i)).getParserPath().toString();
                    if (!lastParserPath.equals(currentParserPath)) {
                        lastParserPath = currentParserPath;
                        pathNode = new JumpToTLMPathNode(this.root, lastParserPath);
                        this.root.addChild(pathNode);
                    }
                    pathNode.addChild(new JumpToTLMPathNode(pathNode, searchHits.get(i)));
                    ++i;
                }
                this.searchHitElement = null;
                return true;
            }
        };
    }

    protected abstract IFile getFile(ITextEditor var1);

    public static boolean shouldFilterIHidObject(IHidObject iHidObj, IRfClassElement enclosingScope, IRfNamedElement namedElement, List<RfXvmBase> portTreePathElements, List<RfWNamedElementAndScope> elementsAndScopes) {
        if (iHidObj instanceof RfHidOperator) {
            return RfHyperlinkDetectorCommon.shouldSkipRfHidOperator((RfHidOperator)iHidObj, enclosingScope, namedElement, portTreePathElements, elementsAndScopes);
        }
        if (iHidObj instanceof RfHid) {
            return RfHyperlinkDetectorCommon.shouldSkipRfHid((RfHid)iHidObj, enclosingScope, namedElement, portTreePathElements, elementsAndScopes);
        }
        return true;
    }

    private static boolean shouldSkipRfHid(RfHid rfHid, IRfClassElement enclosingScope, IRfNamedElement namedElement, List<RfXvmBase> portTreePathElements, List<RfWNamedElementAndScope> elementsAndScopes) {
        if (!namedElement.getName().equals(rfHid.getName())) {
            return true;
        }
        if (RfHyperlinkDetectorCommon.isDifferentParentAccessSpecialization(rfHid, enclosingScope, portTreePathElements, elementsAndScopes)) {
            return true;
        }
        ListContainer hidAccesses = rfHid.getAccesses();
        if (hidAccesses == null || hidAccesses.isEmpty()) {
            return true;
        }
        for (HidAccess hidAccess : hidAccesses) {
            ListContainer hidsContainer = hidAccess.getHids();
            for (Hid hidContainer : hidsContainer) {
                if (!hidContainer.getName().equals("connect")) continue;
                return false;
            }
        }
        return true;
    }

    public void createOpenHyperlinks(List<IDVTHyperlink> links, RfNamedElementActionHyperlink hyperlinkAction, RfProject rfProject, IRfNamedElement namedElement, ITextEditor editor, boolean showFirstOpenDeclaration) {
        String labelType;
        if (!(editor instanceof DVTEditor)) {
            return;
        }
        if (hyperlinkAction == null) {
            return;
        }
        if (rfProject == null) {
            return;
        }
        ELManager elManager = rfProject.getELManager();
        if (elManager == null) {
            return;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return;
        }
        IRegion hyperlinkRegion = hyperlinkAction.getHyperlinkRegion();
        DVTEditor dvtEditor = (DVTEditor)editor;
        IRfNamedElement associatedAliasedType = TypeParametersUtils.computeAssociatedAliasedType((IRfSingleLangProject)rfProject, (IELMemory)memory, (DVTEditor)dvtEditor, (IRfNamedElement)namedElement, (IActionHyperlink)hyperlinkAction);
        RfNamedElementActionHyperlink associatedTypeAction = associatedAliasedType != null ? RfUtils.getAssociatedTypeHyperlink(dvtEditor, associatedAliasedType, hyperlinkAction.getAssocType() != null ? hyperlinkAction.getAssocType() : hyperlinkAction.getScope(), project, hyperlinkRegion) : RfUtils.getAssociatedTypeHyperlink(dvtEditor, namedElement, hyperlinkAction.getAssocType() != null ? hyperlinkAction.getAssocType() : hyperlinkAction.getScope(), project, hyperlinkRegion);
        if (associatedTypeAction != null) {
            associatedTypeAction.setScope(hyperlinkAction.getScope());
        }
        String hyperlinkLabel = (labelType = RfUtils.getAssociatedTypeHyperlinkLabelPart(namedElement)).isEmpty() ? DVTHyperlinkMessages.openEmptyTypeDeclaration : DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openTypeDeclaration, (Object[])new Object[]{labelType});
        ElementPath currentPath = DesignPathManager.getInstance().getPathFor(dvtEditor, namedElement, false);
        if (currentPath == null) {
            boolean hasPreElabDesign = this.addPreElabDesignOpenHyperlink(links, namedElement, project, associatedTypeAction, showFirstOpenDeclaration);
            if (hasPreElabDesign) {
                return;
            }
            this.addNonDesignOpenHyperlink(links, namedElement, associatedTypeAction, hyperlinkLabel);
            return;
        }
        ELInstance instance = memory.instanceFor(currentPath);
        if (instance == null) {
            boolean hasPreElabDesign = this.addPreElabDesignOpenHyperlink(links, namedElement, project, associatedTypeAction, showFirstOpenDeclaration);
            if (hasPreElabDesign) {
                return;
            }
            this.addNonDesignOpenHyperlink(links, namedElement, associatedTypeAction, hyperlinkLabel);
            return;
        }
        if (associatedTypeAction == null) {
            this.addArchOpenHyperlink(links, namedElement, project, instance, hyperlinkRegion);
            return;
        }
        IDVTHyperlink archHyperlink = null;
        IRfNamedElement associatedTypeElement = associatedTypeAction.getRfNamedElement();
        if (namedElement instanceof RfInstance) {
            if (!ELUtils.hasValidBinding((ELInstance)instance)) {
                return;
            }
            IRfNamedElement moduleOrEntity = instance.getBinding(true);
            RfNamedElementActionHyperlink moduleOrEntityOpenAction = RfUtils.createOpenAction(moduleOrEntity, project, hyperlinkRegion);
            moduleOrEntityOpenAction.setScope(hyperlinkAction.getScope());
            if (!(moduleOrEntity instanceof RfNamedElement)) {
                IRfNamedElement arch = instance.getBinding(false);
                hyperlinkLabel = DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openEntityDeclaration, (Object[])new Object[]{moduleOrEntity.getName()});
                archHyperlink = this.createOpenArchitectureHyperlink((IRfDesignElement)arch, project, hyperlinkAction.getHyperlinkRegion());
            } else {
                labelType = RfUtils.getAssociatedTypeHyperlinkLabelPart(associatedTypeElement);
                if (labelType.isEmpty()) {
                    labelType = MODULE_HYPERLINK_LABEL;
                }
                hyperlinkLabel = DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openInstanceTypeDeclaration, (Object[])new Object[]{labelType});
            }
            IDVTHyperlink moduleOrEntityHyperlink = null;
            if (moduleOrEntityOpenAction != null) {
                moduleOrEntityOpenAction.setElementPath(instance.getHierarchyPath());
                moduleOrEntityHyperlink = this.createHyperlink(moduleOrEntityOpenAction, hyperlinkLabel);
            }
            this.addOpenLinks(links, moduleOrEntityHyperlink, archHyperlink, showFirstOpenDeclaration);
            return;
        }
        this.addNonDesignOpenHyperlink(links, namedElement, associatedTypeAction, hyperlinkLabel);
        this.addArchOpenHyperlink(links, namedElement, project, instance, hyperlinkRegion);
    }

    private boolean addPreElabDesignOpenHyperlink(List<IDVTHyperlink> links, IRfNamedElement namedElement, IProject project, RfNamedElementActionHyperlink associatedTypeAction, boolean showFirstOpenDeclaration) {
        if (!(namedElement instanceof RfInstance) || associatedTypeAction == null) {
            return false;
        }
        IRfNamedElement assocTypeElement = associatedTypeAction.getRfNamedElement();
        if (assocTypeElement == null) {
            return false;
        }
        IDVTHyperlink archHyperlink = null;
        String hyperlinkLabel = "";
        if (assocTypeElement instanceof RfNamedElement) {
            String labelType = RfUtils.getAssociatedTypeHyperlinkLabelPart(assocTypeElement);
            if (labelType.isEmpty()) {
                labelType = MODULE_HYPERLINK_LABEL;
            }
            hyperlinkLabel = DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openInstanceTypeDeclaration, (Object[])new Object[]{labelType});
        } else {
            hyperlinkLabel = DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openEntityDeclaration, (Object[])new Object[]{assocTypeElement.getName()});
            archHyperlink = this.createOpenArchitectureHyperlink((IRfDesignElement)assocTypeElement, project, associatedTypeAction.getHyperlinkRegion());
        }
        IDVTHyperlink openHyperlink = this.createHyperlink(associatedTypeAction, hyperlinkLabel);
        this.addOpenLinks(links, openHyperlink, archHyperlink, showFirstOpenDeclaration);
        return true;
    }

    private void addArchOpenHyperlink(List<IDVTHyperlink> links, IRfNamedElement namedElement, IProject project, ELInstance instance, IRegion hyperlinkRegion) {
        if (instance == null) {
            return;
        }
        if (!ELUtils.hasValidBinding((ELInstance)instance)) {
            return;
        }
        if (namedElement instanceof IRfDesignElement && ((IRfDesignElement)namedElement).getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY) {
            IRfNamedElement arch = instance.getBinding(false);
            String archLabel = DVTHyperlinkMessages.getMessage((String)DVTHyperlinkMessages.openArchitectureDeclaration, (Object[])new Object[]{arch.getName()});
            RfNamedElementActionHyperlink archOpenAction = RfUtils.createOpenAction(arch, project, hyperlinkRegion);
            links.add(this.createHyperlink(archOpenAction, archLabel));
        }
    }

    private static boolean shouldSkipRfHidOperator(RfHidOperator rfHidOperator, IRfClassElement enclosingScope, IRfNamedElement namedElement, List<RfXvmBase> portTreePathElements, List<RfWNamedElementAndScope> elementsAndScopes) {
        if (!(rfHidOperator.getLHValue() instanceof RfHid)) {
            return true;
        }
        RfHid lfHid = (RfHid)rfHidOperator.getLHValue();
        if (!(lfHid.getElement() instanceof RfField)) {
            return true;
        }
        RfField rfField = (RfField)lfHid.getElement();
        if (rfField == null) {
            return true;
        }
        if (rfField.getEnclosingScope() == null || !(rfField.getEnclosingScope() instanceof RfFunction)) {
            return true;
        }
        RfFunction rfFunction = (RfFunction)rfField.getEnclosingScope();
        if (rfFunction == null || !rfFunction.getName().equals("connect")) {
            return true;
        }
        IHidObject rhHid = rfHidOperator.getFirstRHValue();
        if (!(rhHid instanceof RfHid)) {
            return true;
        }
        if (!((RfHid)rhHid).getName().equals(namedElement.getName())) {
            return true;
        }
        return RfHyperlinkDetectorCommon.isDifferentParentAccessSpecialization((RfHid)rhHid, enclosingScope, portTreePathElements, elementsAndScopes);
    }

    private static boolean isDifferentParentAccessSpecialization(RfHid rfHid, IRfClassElement rfHidEnclosingScope, List<RfXvmBase> portTreePathElements, List<RfWNamedElementAndScope> elementsAndScopes) {
        HidAccess rfHidParentAccess = rfHid.getParentAccess();
        if (elementsAndScopes != null) {
            for (RfWNamedElementAndScope elementAndScope : elementsAndScopes) {
                RfNamedElement namedElement = elementAndScope.getNamedElement();
                if (namedElement == null) {
                    return true;
                }
                String elementName = namedElement.getName();
                if (elementName == null) {
                    return true;
                }
                if ("this".equals(elementName)) continue;
                if (rfHidParentAccess == null) {
                    return true;
                }
                RfNamedElement elementAssocType = elementAndScope.getCalledFromScope();
                if (elementAssocType == null) {
                    return true;
                }
                IRfNamedElement rfHidParentAccessAssociatedType = rfHidParentAccess.getAssociatedType();
                if (!((Object)elementAssocType).equals(rfHidParentAccessAssociatedType)) {
                    return true;
                }
                Hid parentHid = rfHidParentAccess.getParentHid();
                if (parentHid == null) {
                    return true;
                }
                if (!elementName.equals(parentHid.getName())) {
                    return true;
                }
                rfHidParentAccess = parentHid.getParentAccess();
            }
        }
        if (portTreePathElements != null && !portTreePathElements.isEmpty()) {
            if (rfHidParentAccess == null) {
                if (!(rfHidEnclosingScope instanceof RfClass)) {
                    return true;
                }
                RfClass rfHidEnclosingScopeClass = (RfClass)rfHidEnclosingScope;
                RfClass rfClass = RfHyperlinkDetectorCommon.getXVMObjectClass(portTreePathElements.get(0));
                if (rfClass == null || !rfClass.equals(rfHidEnclosingScopeClass)) {
                    return true;
                }
            } else {
                int i = 0;
                while (i < portTreePathElements.size()) {
                    RfXvmBase portTreePathElement = portTreePathElements.get(i);
                    RfClass elementRfClass = RfHyperlinkDetectorCommon.getXVMObjectClass(portTreePathElement);
                    IRfNamedElement associatedType = rfHidParentAccess.getAssociatedType();
                    if (associatedType instanceof RfSpecializedClass) {
                        associatedType = ((RfSpecializedClass)associatedType).getGenericClass();
                    }
                    if (elementRfClass == null || !elementRfClass.equals(associatedType)) {
                        return true;
                    }
                    Hid parentHid = rfHidParentAccess.getParentHid();
                    if (parentHid == null) {
                        return true;
                    }
                    String parentHidName = parentHid.getName();
                    if (parentHidName == null) {
                        return true;
                    }
                    if (!parentHidName.equals("this") && !parentHidName.equals(portTreePathElement.getName())) {
                        return true;
                    }
                    rfHidParentAccess = parentHid.getParentAccess();
                    if (rfHidParentAccess == null) {
                        if (i >= portTreePathElements.size() - 1 || rfHidEnclosingScope.equals(elementRfClass = RfHyperlinkDetectorCommon.getXVMObjectClass(portTreePathElement = portTreePathElements.get(i + 1)))) break;
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private static RfClass getXVMObjectClass(RfXvmBase portTreePathElement) {
        if (portTreePathElement instanceof RfXvmObjectInstance && ((RfXvmObjectInstance)portTreePathElement).getObject() != null) {
            return ((RfXvmObjectInstance)portTreePathElement).getObject().getRfClass();
        }
        if (portTreePathElement instanceof RfXvmObject) {
            return ((RfXvmObject)portTreePathElement).getRfClass();
        }
        return null;
    }

    protected abstract void openJumpToConnectedTLMPortsHyperlink(RfNamedElementActionHyperlink var1, JumpToTLMPathNode var2);

    protected static class FirstImplementationNrOfImplementationsPair {
        public int nofImplementations;
        public RfFunction firstImplementation;

        public FirstImplementationNrOfImplementationsPair(int nofImplementations, RfFunction firstImplementation) {
            this.nofImplementations = nofImplementations;
            this.firstImplementation = firstImplementation;
        }
    }
}

