/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.model.reflection.IDVTHyperlink;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkMessages;
import ro.amiq.dvt.ui.editor.hyperlink.DVTHyperlinkUtils;
import ro.amiq.dvt.ui.editor.hyperlink.HyperlinkWrapper;
import ro.amiq.dvt.ui.editor.hyperlink.IActionHyperlink;
import ro.amiq.dvt.ui.editor.hyperlink.MultipleHyperlinksDialog;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfConfigurationDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfHyperlinkDetector;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VlogRfHyperlinkDetector
extends RfHyperlinkDetector {
    public VlogRfHyperlinkDetector(ITextEditor editor) {
        this.fTextEditor = editor;
    }

    public IDVTHyperlink[] detectHyperlinksInternal(ITextViewer textViewer, final IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || !(this.fTextEditor instanceof VlogEditor)) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        if (!(this.fTextEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)this.fTextEditor.getEditorInput()).getFile();
        if (file == null) {
            return null;
        }
        final IProject project = file.getProject();
        if (project == null) {
            return null;
        }
        int offset = Math.min(region.getOffset() + 1, document.getLength() - 1);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        IRfScope[] currentScope = new IRfScope[1];
        boolean isHyperlinkRunTimeInfoEnabled = BuildConfigManager.isDebugHyperlinkRunTimeInfo((IProject)project);
        long start = System.currentTimeMillis();
        final RfNamedElementActionHyperlink hyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(rfProject, this.fTextEditor, document, offset, false, currentScope, false);
        if (isHyperlinkRunTimeInfoEnabled) {
            DVTHyperlinkUtils.getInstance().reportHyperlinkElementFromCursorBenchmark(System.currentTimeMillis() - start);
        }
        if (hyperlinkAction == null) {
            return null;
        }
        start = System.currentTimeMillis();
        try {
            List<IDVTHyperlink> links = this.getHyperlinkForElementUnderMacro(hyperlinkAction, offset, file, document, region, rfProject, canShowMultipleHyperlinks, textViewer, true);
            if (links == null) {
                return null;
            }
            this.computeHyperlinksForElementUnderMacro(links, hyperlinkAction, document, file, region, offset, rfProject, canShowMultipleHyperlinks, textViewer, currentScope);
            final IRfNamedElement namedElement = hyperlinkAction.getRfNamedElement();
            if (!(namedElement instanceof RfInstance)) {
                IDVTHyperlink[] iDVTHyperlinkArray = links.toArray(new IDVTHyperlink[links.size()]);
                return iDVTHyperlinkArray;
            }
            if (hyperlinkAction.getScope() instanceof RfConfigurationDef) {
                IDVTHyperlink[] iDVTHyperlinkArray = links.toArray(new IDVTHyperlink[links.size()]);
                return iDVTHyperlinkArray;
            }
            List instances = DVTHyperlinkUtils.getInstance().getInstancesFor((IRfInstanceElement)namedElement, true, project, 2);
            if (instances.size() <= 1) {
                IDVTHyperlink[] iDVTHyperlinkArray = links.toArray(new IDVTHyperlink[links.size()]);
                return iDVTHyperlinkArray;
            }
            links.add(new IDVTHyperlink(){
                private List<ELInstance> allInstances;

                public void updateGuiPart() {
                    new MultipleHyperlinksDialog(this.getOpenModuleDeclarationHyperlinks(this.allInstances)).open();
                }

                public boolean updateNonGuiPart() {
                    this.allInstances = DVTHyperlinkUtils.getInstance().getInstancesFor((IRfInstanceElement)namedElement, true, project, Integer.MAX_VALUE);
                    if (this.allInstances.isEmpty()) {
                        return false;
                    }
                    List<HyperlinkWrapper> links = this.getOpenModuleDeclarationHyperlinks(this.allInstances);
                    return !links.isEmpty();
                }

                public String getTypeLabel() {
                    return "+ Show more...";
                }

                public String getHyperlinkText() {
                    return "+ Show more...";
                }

                public IRegion getHyperlinkRegion() {
                    return hyperlinkAction.getHyperlinkRegion();
                }

                private List<HyperlinkWrapper> getOpenModuleDeclarationHyperlinks(List<ELInstance> instanceList) {
                    ArrayList<HyperlinkWrapper> multipleOpenModuleHyperlinkList = new ArrayList<HyperlinkWrapper>(5);
                    for (ELInstance instance : instanceList) {
                        if (!ELUtils.hasValidBinding((ELInstance)instance)) continue;
                        IRfNamedElement binding = instance.getBinding(true);
                        IRfInstanceElement description = instance.getDescription();
                        if (description == null) continue;
                        RfNamedElementActionHyperlink createOpenAction = RfUtils.createOpenAction(binding, project, region);
                        createOpenAction.setScope(description.getEnclosingScope());
                        createOpenAction.setElementPath(instance.getHierarchyPath());
                        IDVTHyperlink newLink = VlogRfHyperlinkDetector.this.createHyperlink(createOpenAction, "Open Module Declaration");
                        multipleOpenModuleHyperlinkList.add(new HyperlinkWrapper(newLink, (IActionHyperlink)createOpenAction));
                    }
                    return multipleOpenModuleHyperlinkList;
                }
            });
            IDVTHyperlink[] iDVTHyperlinkArray = links.toArray(new IDVTHyperlink[links.size()]);
            return iDVTHyperlinkArray;
        }
        finally {
            if (isHyperlinkRunTimeInfoEnabled) {
                DVTHyperlinkUtils.getInstance().reportHyperlinkProposalsBenchmark(System.currentTimeMillis() - start);
            }
        }
    }

    public DVTWordFinder getWordFinder() {
        return VlogWordFinder.getDefault();
    }

    public List<String> getDefaultHyperlinks() {
        return DVTHyperlinkMessages.getVLOGDefaultHyperlinks();
    }
}

