/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.lazy.outline;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.actions.CategorySelectAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.AbstractLazyOutlineProvider;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.views.QuickViewCategorySortingAction;
import ro.amiq.vlogdt.model.reflection.views.QuickViewLexicalSortingAction;
import ro.amiq.vlogdt.ui.editor.lazy.outline.VlogLazyOutlineProvider;
import ro.amiq.vlogdt.ui.editor.outline.IUpdateElement;

public class VlogLazyOutlinePage
extends DVTLazyOutlinePage
implements IUpdateElement {
    public VlogLazyOutlinePage(DVTEditor editor) {
        super(editor);
        this.provider = new VlogLazyOutlineProvider(editor);
        this.propertyChangeListener = this.createPropertyChangeListener();
        VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    protected AbstractLazyOutlineProvider createOutlineProvider() {
        return new VlogLazyOutlineProvider(this.editor);
    }

    protected void createLanguageSpecificActions() {
        this.categorySelectAction = new CategorySelectAction(this.parent, VlogPlugin.getDefault().getPreferenceStore(), VlogLazyOutlineProvider.VLOG_OUTLINE_FIELDS, "Outline Element Filters", LanguageKind.VLOG, "outline.prefs_changed");
        this.lexicalSortingAction = new QuickViewLexicalSortingAction((LabelProvider)this.provider.getLabelProvider(), this){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("outline.lexical_sort")) {
                    boolean checked = VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
                    this.valueChanged(checked);
                }
            }
        };
        this.lexicalSortingAction.setEnabled(true);
        this.lexicalSortingAction.setChecked(VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort"));
        this.categorySortingAction = new QuickViewCategorySortingAction(this){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("outline.category_sort")) {
                    boolean checked = VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
                    this.valueChanged(checked);
                }
            }
        };
        this.categorySortingAction.setEnabled(true);
        this.categorySortingAction.setChecked(VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort"));
        VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)((QuickViewLexicalSortingAction)this.lexicalSortingAction));
        VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)((QuickViewCategorySortingAction)this.categorySortingAction));
    }

    public void dispose() {
        if (this.categorySortingAction instanceof IPropertyChangeListener) {
            VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.categorySortingAction);
        }
        if (this.lexicalSortingAction instanceof IPropertyChangeListener) {
            VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.lexicalSortingAction);
        }
        if (this.propertyChangeListener != null) {
            VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        }
        super.dispose();
    }
}

