/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.lazy.outline;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.OutlineTreeViewProvider;
import ro.amiq.vlogdt.ui.editor.lazy.outline.VlogLazyOutlineProviderCommon;
import ro.amiq.vlogdt.ui.editor.lazy.outline.VlogOutlineUtil;

public class VlogLazyOutlineProvider
extends VlogLazyOutlineProviderCommon {
    public static final Map<String, String> VLOG_OUTLINE_FIELDS = new LinkedHashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("Show asserts", "outline.show_asserts");
            this.put("Show blocks", "outline.show_blocks");
            this.put("Show checker declarations", "outline.show_checkers");
            this.put("Show checker instantiations", "outline.show_checker_instantiations");
            this.put("Show classes", "outline.show_classes");
            this.put("Show clocking blocks", "outline.show_clocking_blocks");
            this.put("Show constraints", "outline.show_constraints");
            this.put("Show cover groups", "outline.show_covergroups");
            this.put("Show events", "outline.show_events");
            this.put("Show expects", "outline.show_expects");
            this.put("Show fields", "outline.show_fields");
            this.put("Show functions", "outline.show_functions");
            this.put("Show tasks", "outline.show_tasks");
            this.put("Show generate blocks", "outline.show_generate_blocks");
            this.put("Show interface declarations", "outline.show_interfaces");
            this.put("Show interface instantiations", "outline.show_interface_instantiations");
            this.put("Show modports", "outline.show_modports");
            this.put("Show module declarations", "outline.show_modules");
            this.put("Show module instantiations", "outline.show_module_instantiations");
            this.put("Show packages", "outline.show_packages");
            this.put("Show parameters", "outline.show_parameters");
            this.put("Show ports", "outline.show_ports");
            this.put("Show primitives", "outline.show_primitives");
            this.put("Show program declarations", "outline.show_programs");
            this.put("Show program instantiations", "outline.show_program_instantiations");
            this.put("Show property sequences", "outline.show_sequences");
            this.put("Show types", "outline.show_types");
        }
    };

    public VlogLazyOutlineProvider(DVTEditor editor) {
        super(editor);
        this.labelProvider = new OutlineTreeViewProvider();
    }

    public IRfFileDef getFileDef() {
        if (this.editor == null) {
            return null;
        }
        IFile currentFile = this.editor.getCurrentFile();
        if (currentFile == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(this.editor.getProject());
        if (rfProject == null) {
            return null;
        }
        return rfProject.getFile((IResource)currentFile);
    }

    public boolean isOutlineElement(IRfDefElement def) {
        return VlogOutlineUtil.INSTANCE.isOutlineElement(def);
    }

    public boolean isUnnamedBlock(IRfDefElement element) {
        return VlogOutlineUtil.INSTANCE.isUnnamedBlock(element);
    }

    public boolean isPossibleOutlineParent(IRfDefElement def) {
        return VlogOutlineUtil.INSTANCE.isPossibleOutlineParent(def);
    }

    public int getCategory(IRfDefElement def) {
        IRfNamedElement namedElem = def.getNamedElement();
        RfKind kind = RfKind.of(namedElem);
        return kind.ordinal();
    }

    public boolean isLexicallySorted() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
    }

    public boolean isCategoricallySorted() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
    }
}

