/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.lazy.outline;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfForwardTypedef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.views.OutlineTreeViewProvider;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;

public enum VlogOutlineUtil {
    INSTANCE;

    private static final ElementType.ElementTypeName[] parentElements;
    public static final Set<ElementType.ElementTypeName> PARENT_ELEMENTS_SET;
    private OutlineTreeViewProvider labelProvider = new OutlineTreeViewProvider();

    static {
        parentElements = new ElementType.ElementTypeName[]{ElementType.ElementTypeName.CLASS, ElementType.ElementTypeName.PROGRAM, ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeName.COVER_CROSS, ElementType.ElementTypeName.MODULE, ElementType.ElementTypeName.GENERATE_BLOCK, ElementType.ElementTypeName.INTERFACE, ElementType.ElementTypeName.CHECKER, ElementType.ElementTypeName.PRIMITIVE, ElementType.ElementTypeName.ASSERT, ElementType.ElementTypeName.EXPECT};
        PARENT_ELEMENTS_SET = EnumSet.copyOf(Arrays.asList(parentElements));
    }

    public boolean isOutlineElement(IRfDefElement def) {
        RfDefElement element;
        block5: {
            block4: {
                try {
                    if (def instanceof RfDefElement) break block4;
                    return false;
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    return false;
                }
            }
            element = (RfDefElement)def;
            if (this.isPotentialOutlineElement(def)) break block5;
            return false;
        }
        return !this.isUnnamedBlock(element);
    }

    protected boolean isPotentialOutlineElement(IRfDefElement def) {
        RfDefElement element = (RfDefElement)def;
        RfProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return false;
        }
        RfNamedElement namedElement = element.getNamedElement();
        if (namedElement instanceof RfForwardTypedef) {
            return false;
        }
        if (element instanceof RfPortDef && namedElement.getDeclaration() != element) {
            return false;
        }
        if (element instanceof RfPortDef && namedElement instanceof RfPort && ((RfPort)namedElement).isUnderAlias()) {
            return false;
        }
        ElementType elementType = rfProject.computeElementType(element, null, null);
        if (elementType == null || elementType.equals((Object)new ElementType(ElementType.ElementTypeName.VARIABLE, ElementType.ElementTypeLanguage.SV))) {
            return false;
        }
        return !(namedElement instanceof RfAssertExpect) || !(((RfAssertExpect)namedElement).getEnclosingScope() instanceof RfActionBlock);
    }

    public boolean isUnnamedBlock(IRfDefElement element) {
        return element instanceof RfActionBlockDef && !((RfActionBlock)((RfActionBlockDef)element).getNamedElement()).isNamedBlock();
    }

    public DVTGUIFilterMatcher.GUIFilterResult getFilterResult(IRfDefElement element) {
        RfTreeElementWrapper wrapper = new RfTreeElementWrapper(element, true);
        DVTGUIFilterMatcher.GUIFilterResult result = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.OUTLINE, (IRfDefElement)element, () -> this.labelProvider.getText((Object)wrapper));
        return result;
    }

    public boolean isPossibleOutlineParent(IRfDefElement def) {
        if (def == null) {
            return false;
        }
        IRfSingleLangProject rfProject = def.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementType elementType = rfProject.computeElementType(def, null, null);
        if (elementType == null || elementType.equals((Object)new ElementType(ElementType.ElementTypeName.VARIABLE, ElementType.ElementTypeLanguage.SV))) {
            return false;
        }
        return PARENT_ELEMENTS_SET.contains(elementType.getElementTypeName()) || def instanceof RfActionBlockDef;
    }
}

