/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.lazy.outline;

import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.actions.CategorySelectAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.AbstractLazyOutlineProvider;
import ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.views.QuickViewCategorySortingAction;
import ro.amiq.vlogdt.model.reflection.views.QuickViewLexicalSortingAction;
import ro.amiq.vlogdt.ui.editor.lazy.outline.VlogLazyOutlineProvider;
import ro.amiq.vlogdt.ui.editor.outline.IUpdateElement;

public class VlogQuickLazyOutlineView
extends QuickLazyOutlineView
implements IUpdateElement {
    public VlogQuickLazyOutlineView(DVTEditor editor) {
        super(editor);
        VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void createLanguageSpecificActions() {
        this.categorySelectAction = new CategorySelectAction(this.getLazyTree().getControlParent(), VlogPlugin.getDefault().getPreferenceStore(), VlogLazyOutlineProvider.VLOG_OUTLINE_FIELDS, "Outline Element Filters", LanguageKind.VLOG, "outline.prefs_changed");
        this.lexicalSortingAction = new QuickViewLexicalSortingAction((LabelProvider)this.getLabelProvider(), this){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("outline.lexical_sort")) {
                    boolean checked = VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort");
                    this.valueChanged(checked);
                }
            }
        };
        this.lexicalSortingAction.setEnabled(true);
        this.lexicalSortingAction.setChecked(VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.lexical_sort"));
        this.categorySortingAction = new QuickViewCategorySortingAction(this){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("outline.category_sort")) {
                    boolean checked = VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort");
                    this.valueChanged(checked);
                }
            }
        };
        this.categorySortingAction.setEnabled(true);
        this.categorySortingAction.setChecked(VlogPlugin.getDefault().getPreferenceStore().getBoolean("outline.category_sort"));
        VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)((QuickViewLexicalSortingAction)this.lexicalSortingAction));
        VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)((QuickViewCategorySortingAction)this.categorySortingAction));
    }

    protected AbstractLazyOutlineProvider createProvider() {
        return new VlogLazyOutlineProvider(this.editor);
    }

    public void dispose() {
        VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        if (this.lexicalSortingAction != null) {
            VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)((QuickViewLexicalSortingAction)this.lexicalSortingAction));
        }
        if (this.categorySortingAction != null) {
            VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)((QuickViewCategorySortingAction)this.categorySortingAction));
        }
        super.dispose();
    }
}

