/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.outline;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;

public class AccessLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "ro.amiq.vlogdt.AccessLabelDecorator";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof RfTreeElementWrapper || element instanceof TreePath) {
            this.decorateRfDefElement(element, decoration);
        }
    }

    private void decorateRfDefElement(Object def, IDecoration decoration) {
        Object element = null;
        if (def instanceof RfTreeElementWrapper) {
            element = ((RfTreeElementWrapper)((Object)def)).getRfElement();
        } else if (def instanceof TreePath) {
            element = ((TreePath)def).getElement();
        }
        if (!(element instanceof RfDefElement) && !(element instanceof RfNamedElement)) {
            return;
        }
        if (element instanceof RfFunctionDef || element instanceof RfFieldDef) {
            if (def instanceof IDVTElementWrapper && !((IDVTElementWrapper)def).getAccessDecoratorEnable() || ((RfDefElement)element).getNamedElement() == null) {
                return;
            }
            RfNamedElement namedElement = ((RfDefElement)element).getNamedElement();
            if (namedElement.isPrivate()) {
                decoration.addOverlay(DVTImages.OVR_PRIVATE, 0);
            } else if (namedElement.isProtected()) {
                decoration.addOverlay(DVTImages.OVR_PROTECTED, 0);
            } else {
                decoration.addOverlay(DVTImages.OVR_PUBLIC, 0);
            }
        } else if (element instanceof RfFunction || element instanceof RfField) {
            if (def instanceof IDVTElementWrapper && !((IDVTElementWrapper)def).getAccessDecoratorEnable()) {
                return;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            if (namedElement.isPrivate()) {
                decoration.addOverlay(DVTImages.OVR_PRIVATE, 0);
            } else if (namedElement.isProtected()) {
                decoration.addOverlay(DVTImages.OVR_PROTECTED, 0);
            } else {
                decoration.addOverlay(DVTImages.OVR_PUBLIC, 0);
            }
        }
    }
}

