/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.outline;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;

public class OverlayLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "ro.amiq.vlogdt.LayerLabelDecorator";

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof RfTreeElementWrapper) {
            element = ((RfTreeElementWrapper)((Object)element)).getRfElement();
        } else if (element instanceof TreePath) {
            element = ((TreePath)element).getElement();
        }
        if (element instanceof RfDefElement) {
            this.decorateRfDefElement((RfDefElement)element, decoration);
            return;
        }
        if (element instanceof RfNamedElement) {
            this.decorateRfNamedElement((RfNamedElement)element, decoration);
            return;
        }
    }

    private void decorateRfDefElement(RfDefElement def, IDecoration decoration) {
        DataType fieldDataType;
        RfField field;
        if (def instanceof RfFunctionDef) {
            RfFunctionDef mDef = (RfFunctionDef)def;
            RfFunction func = (RfFunction)mDef.getNamedElement();
            if (func != null) {
                if (func.isPure()) {
                    decoration.addOverlay(DVTImages.OVR_PURE, 1);
                } else if (func.isExtern() && mDef.isPrototype()) {
                    decoration.addOverlay(DVTImages.OVR_EXTERN, 1);
                }
            }
        } else if (def instanceof RfFieldDef && (field = (RfField)((RfFieldDef)def).getNamedElement()) != null && (fieldDataType = field.getDataType()) != null && fieldDataType.getUnpackedDimension() != null && !fieldDataType.getUnpackedDimension().isEmpty()) {
            decoration.addOverlay(DVTImages.OVR_ARRAY, 3);
        }
    }

    private void decorateRfNamedElement(RfNamedElement def, IDecoration decoration) {
    }

    public void refresh(final Object[] elements) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                OverlayLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)OverlayLabelDecorator.this, elements));
            }
        });
    }
}

