/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;

public abstract class GetterSetterMethodsUtilsCommon {
    public Map<RfField, List<String>> getGetterSetterMethodsContext(RfClass localClass) {
        HashMap<RfField, List<String>> resultGetSetRF = new HashMap<RfField, List<String>>();
        if (localClass == null) {
            return resultGetSetRF;
        }
        Collection<RfDefElement> members = localClass.getDeclaration().getChildren();
        ArrayList<RfField> fieldsRF = new ArrayList<RfField>();
        ArrayList<String> functionsRF = new ArrayList<String>();
        if (members != null) {
            for (RfDefElement member : members) {
                RfField field = null;
                RfFunction function = null;
                if (member instanceof RfFieldDef) {
                    field = (RfField)((RfFieldDef)member).getNamedElement();
                    if (field == null || !field.isField() || field.isConst()) continue;
                    fieldsRF.add(field);
                    continue;
                }
                if (!(member instanceof RfFunctionDef) || (function = (RfFunction)((RfFunctionDef)member).getNamedElement()) == null || !function.isFunction()) continue;
                functionsRF.add(function.getName());
            }
        }
        for (RfField field : fieldsRF) {
            boolean ifGetExist = false;
            boolean ifSetExist = false;
            ArrayList<String> getSetFunctionsRF = new ArrayList<String>();
            for (String function : functionsRF) {
                if (function.equals("get_" + field.getName())) {
                    ifGetExist = true;
                }
                if (!function.equals("set_" + field.getName())) continue;
                ifSetExist = true;
            }
            RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)field.getEnclosingScope(), field.getRfProject(), 14);
            IRfNamedElement associatedType = field.getAssociatedType(resolver);
            if (field.getPackedDimension() != null && !field.getPackedDimension().isEmpty()) {
                boolean isTypeAliasStruct;
                while (associatedType instanceof RfListType) {
                    associatedType = ((RfListType)associatedType).getAssociatedType(resolver);
                }
                boolean bl = isTypeAliasStruct = associatedType instanceof RfStruct && ((RfStruct)associatedType).getAliasName() != null;
                if ((!(associatedType instanceof RfPredefinedScalarType) || !FEConstants.INTEGRAL_TYPES.contains(associatedType.getName())) && !isTypeAliasStruct) continue;
            }
            if (!ifGetExist && !(associatedType instanceof RfListType)) {
                getSetFunctionsRF.add("get_" + field.getName());
            }
            if (!ifSetExist) {
                getSetFunctionsRF.add("set_" + field.getName());
            }
            if (getSetFunctionsRF.isEmpty()) continue;
            resultGetSetRF.put(field, getSetFunctionsRF);
        }
        return resultGetSetRF;
    }

    public Object getField(Object element, Map<RfField, List<String>> params) {
        if (element instanceof String) {
            for (Map.Entry<RfField, List<String>> entry : params.entrySet()) {
                for (String func : entry.getValue()) {
                    if (!func.equals(element)) continue;
                    return entry.getKey();
                }
            }
        }
        return null;
    }

    public boolean checkImplementFunction(RfClass clazz, String prefix) {
        Map<RfField, List<String>> context = this.getGetterSetterMethodsContext(clazz);
        if (context.isEmpty()) {
            return false;
        }
        boolean isGetSetPrefix = prefix.startsWith("get") || prefix.startsWith("set");
        StringMatcher sm = new StringMatcher(String.valueOf(prefix) + '*', true, false);
        StringMatcher smGet = new StringMatcher("get*" + prefix + '*', true, false);
        StringMatcher smSet = new StringMatcher("set*" + prefix + '*', true, false);
        for (List<String> functions : context.values()) {
            for (String func : functions) {
                if ((!isGetSetPrefix || !sm.match(func)) && (!prefix.isEmpty() && DVTStringUtil.getCamelCaseIndex((String)func, (String)prefix, (boolean)true) == -1 || !smGet.match(func) && !smSet.match(func))) continue;
                return true;
            }
        }
        return false;
    }
}

