/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.ui.editor.override.InsertSignaturesInfo;
import ro.amiq.vlogdt.ui.editor.override.OverrideConstraintsUtils;
import ro.amiq.vlogdt.ui.editor.override.OverrideUtils;
import ro.amiq.vlogdt.ui.editor.override.VlogOveriddenElementInserter;
import ro.amiq.vlogdt.ui.editor.utils.VlogConstraintsInsertConfigurationProvider;

public interface OverrideConstraintsUtilsCommon
extends OverrideUtils<RfConstraint> {
    default public Map<RfClass, List<RfConstraint>> getOverrideConstraintsContext(RfClass localClass) {
        LinkedHashMap<RfClass, List<RfConstraint>> result = new LinkedHashMap<RfClass, List<RfConstraint>>();
        if (localClass == null) {
            return result;
        }
        List<RfConstraint> localConstraints = localClass.getLocalMembers(RfConstraint.class);
        List<RfConstraint> localInheritedConstraints = OverrideConstraintsUtilsCommon.getConstraints(localClass);
        for (RfConstraint constraint : localInheritedConstraints) {
            if (constraint == null || localConstraints != null && localConstraints.contains(constraint)) continue;
            RfClass enclosingClass = (RfClass)constraint.getEnclosingScope();
            ArrayList<RfConstraint> constraints = (ArrayList<RfConstraint>)result.get(enclosingClass);
            if (constraints == null) {
                constraints = new ArrayList<RfConstraint>();
                result.put(enclosingClass, constraints);
            }
            constraints.add(constraint);
        }
        return result;
    }

    public static List<RfConstraint> getConstraints(RfClass clazz) {
        return clazz.getConstraintsWithPrefix("", 2, 2);
    }

    default public InsertSignaturesInfo getConstraintInsertSignature(RfElementPathInProject localClassPath, ITextEditor textEditor, int prefixLength, List<RfConstraint> selectedConstraints, List<RfClass> parentsHierarchy, boolean insertAsExternAndImplementation, int offset) {
        if (selectedConstraints == null) {
            return null;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return null;
        }
        Collections.sort(selectedConstraints, (constraint1, constraint2) -> this.compareElements(parentsHierarchy, constraint1, constraint2));
        IRfNamedElement localClass = localClassPath.toNamedElement();
        if (!(localClass instanceof RfClass)) {
            return null;
        }
        VlogConstraintsInsertConfigurationProvider configurator = new VlogConstraintsInsertConfigurationProvider((RfClass)localClass, selectedConstraints, (DVTEditor)textEditor, offset, prefixLength, insertAsExternAndImplementation);
        InsertSignaturesInfo result = VlogOveriddenElementInserter.getInstance().insertSignatures(configurator);
        return result;
    }

    public static boolean checkOverrideConstraintsContext(RfClass clazz, String prefix) {
        Map<RfClass, List<RfConstraint>> context = OverrideConstraintsUtils.INSTANCE.getOverrideConstraintsContext(clazz);
        if (context.isEmpty()) {
            return false;
        }
        StringMatcher matcher = ViewsUtils.createCamelCaseOrRegexMatcher((String)prefix, (boolean)true, (boolean)true);
        for (List<RfConstraint> constraints : context.values()) {
            for (RfConstraint constraint : constraints) {
                if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)constraint.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

