/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.ui.editor.override.InsertSignaturesInfo;
import ro.amiq.vlogdt.ui.editor.override.OverrideMethodsUtils;
import ro.amiq.vlogdt.ui.editor.override.OverrideUtils;
import ro.amiq.vlogdt.ui.editor.override.VlogOveriddenElementInserter;
import ro.amiq.vlogdt.ui.editor.utils.VlogMethodsInsertConfigurationProvider;

public interface OverrideMethodsUtilsCommon
extends OverrideUtils<RfFunction> {
    default public Map<RfClass, List<RfFunction>> getOverrideMethodsContext(RfClass localClass) {
        LinkedHashMap<RfClass, List<RfFunction>> result = new LinkedHashMap<RfClass, List<RfFunction>>();
        if (localClass == null) {
            return result;
        }
        HashSet<RfFunction> declaredLocalFunctions = new HashSet<RfFunction>();
        List<RfFunction> localFunctions = localClass.getLocalMembers(RfFunction.class);
        if (localFunctions != null && !localFunctions.isEmpty()) {
            for (RfFunction localFunction : localFunctions) {
                if (localFunction instanceof RfPredefinedFunction) {
                    if (localFunction.hasNoDefs(false)) continue;
                    declaredLocalFunctions.add(localFunction);
                    continue;
                }
                declaredLocalFunctions.add(localFunction);
            }
        }
        List<RfFunction> localInheritedFunctions = this.getFunctions(localClass);
        localInheritedFunctions.addAll(this.getTasks(localClass));
        localInheritedFunctions.addAll(this.getConstructors(localClass));
        for (RfFunction function : localInheritedFunctions) {
            if (function == null) continue;
            if (function.isPredefined() && !function.isConstructor()) {
                if (!"pre_randomize".equals(function.getName()) && !"post_randomize".equals(function.getName())) continue;
                RfFunction parentFunction = RfBatchUtils.getParentPredefinedFunction(function, true);
                if (parentFunction != null) {
                    function = parentFunction;
                }
            }
            if (declaredLocalFunctions.contains(function)) continue;
            RfClass enclosingClass = (RfClass)function.getEnclosingScope();
            ArrayList<RfFunction> functions = (ArrayList<RfFunction>)result.get(enclosingClass);
            if (functions == null) {
                functions = new ArrayList<RfFunction>();
                result.put(enclosingClass, functions);
            }
            functions.add(function);
        }
        return result;
    }

    public static boolean checkOverrideMethodsContext(RfClass clazz, String prefix) {
        Map<RfClass, List<RfFunction>> context = OverrideMethodsUtils.INSTANCE.getOverrideMethodsContext(clazz);
        if (context.isEmpty()) {
            return false;
        }
        StringMatcher matcher = ViewsUtils.createCamelCaseOrRegexMatcher((String)prefix, (boolean)true, (boolean)true);
        for (List<RfFunction> functions : context.values()) {
            for (RfFunction func : functions) {
                if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)func.getName())) continue;
                return true;
            }
        }
        return false;
    }

    default public List<RfFunction> getConstructors(RfClass clazz) {
        ArrayList<RfFunction> constructors = new ArrayList<RfFunction>();
        RfFunction localConstructor = clazz.getConstructorWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
        if (localConstructor == null) {
            return constructors;
        }
        constructors.add(localConstructor);
        RfFunction inheritedConstructor = clazz.getConstructorWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
        if (inheritedConstructor == null || inheritedConstructor == localConstructor) {
            return constructors;
        }
        constructors.add(inheritedConstructor);
        return constructors;
    }

    default public List<RfFunction> getFunctions(RfClass clazz) {
        return clazz.getFunctionsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
    }

    default public List<RfFunction> getTasks(RfClass clazz) {
        return clazz.getTasksWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
    }

    default public InsertSignaturesInfo getMethodInsertSignature(RfElementPathInProject localClassPath, ITextEditor textEditor, int prefixLength, List<RfFunction> selectedFunctions, List<RfClass> parentsHierarchy, boolean insertAsExternAndImplementation, int offset) {
        if (selectedFunctions == null) {
            return null;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return null;
        }
        Collections.sort(selectedFunctions, (function1, function2) -> this.compareFunctions(parentsHierarchy, (RfFunction)function1, (RfFunction)function2));
        IRfNamedElement localClass = localClassPath.toNamedElement();
        if (!(localClass instanceof RfClass)) {
            return null;
        }
        VlogMethodsInsertConfigurationProvider configurator = new VlogMethodsInsertConfigurationProvider((RfClass)localClass, selectedFunctions, (DVTEditor)textEditor, offset, prefixLength, insertAsExternAndImplementation);
        InsertSignaturesInfo result = VlogOveriddenElementInserter.getInstance().insertSignatures(configurator);
        return result;
    }

    default public int compareFunctions(List<RfClass> parentsHierarchy, RfFunction function1, RfFunction function2) {
        if (function1.isConstructor()) {
            return -1;
        }
        if (function2.isConstructor()) {
            return 1;
        }
        return this.compareElements(parentsHierarchy, function1, function2);
    }
}

