/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtilCommon;
import ro.amiq.vlogdt.ui.editor.override.InsertSignaturesInfo;
import ro.amiq.vlogdt.ui.editor.override.OverrideUtilsCommon;

public interface OverrideUtils<T extends RfNamedElement>
extends OverrideUtilsCommon<T> {
    default public RfNamedElement getElementFromEditor(ITextEditor textEditor, boolean showNotValidPositionDialog) {
        RfNamedElement namedElement;
        block29: {
            IRfScopeElement scope;
            block28: {
                RfWNamedElementAndScope elementAndScope;
                block27: {
                    int offset;
                    RfProject rfProject;
                    IDocument document;
                    IFile file;
                    block26: {
                        block25: {
                            IProject project;
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                IEditorInput editorInput;
                                                block19: {
                                                    block18: {
                                                        try {
                                                            if (textEditor.getSite().getShell() != null) break block18;
                                                            return null;
                                                        }
                                                        catch (Exception e) {
                                                            DVTLogger.INSTANCE.logError((Throwable)e);
                                                            return null;
                                                        }
                                                    }
                                                    editorInput = textEditor.getEditorInput();
                                                    if (editorInput != null) break block19;
                                                    return null;
                                                }
                                                file = (IFile)editorInput.getAdapter(IFile.class);
                                                if (file != null) break block20;
                                                return null;
                                            }
                                            project = file.getProject();
                                            if (project != null) break block21;
                                            return null;
                                        }
                                        document = DVTFileUtils.getInstance().getDocument(textEditor);
                                        if (document != null) break block22;
                                        return null;
                                    }
                                    IVlogModule vlogModule = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule((IFile)textEditor.getAdapter(IResource.class));
                                    if (vlogModule != null) break block23;
                                    return null;
                                }
                                ISelection selection = textEditor.getSelectionProvider().getSelection();
                                if (selection != null) break block24;
                                return null;
                            }
                            rfProject = RfManager.getInstance().getRfProject(project);
                            if (rfProject != null) break block25;
                            return null;
                        }
                        offset = this.getCurrentOffset(textEditor);
                        String contentType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset, false);
                        if (!contentType.equals("__vlog_ml_comment") && !contentType.equals("__vlog_sl_comment")) break block26;
                        if (showNotValidPositionDialog) {
                            this.showNotValidPositionMessageDialog();
                        }
                        return null;
                    }
                    elementAndScope = RfUtils.getRfElement(rfProject, file, document, offset, (DVTEditor)textEditor);
                    if (elementAndScope != null) break block27;
                    if (showNotValidPositionDialog) {
                        this.showNotValidPositionMessageDialog();
                    }
                    return null;
                }
                scope = elementAndScope.getScope();
                if (scope != null) break block28;
                if (showNotValidPositionDialog) {
                    this.showNotValidPositionMessageDialog();
                }
                return null;
            }
            namedElement = ((RfDefElement)scope).getNamedElement();
            if (namedElement instanceof RfClass) break block29;
            if (showNotValidPositionDialog) {
                this.showNotValidPositionMessageDialog();
            }
            return null;
        }
        return namedElement;
    }

    default public RfClass getLocalClass(ITextEditor textEditor, boolean showNotValidPositionDialog) {
        RfNamedElement namedElement = this.getElementFromEditor(textEditor, showNotValidPositionDialog);
        if (!(namedElement instanceof RfClass)) {
            return null;
        }
        return (RfClass)namedElement;
    }

    default public VlogContentAssistUtilCommon.LinkedPositionResult insertInEditor(RfElementPathInProject localClassPath, ITextEditor textEditor, int prefixLength, List<T> selectedFunctions, List<RfClass> parentsHierarchy, boolean insertAsExternAndImplementation) {
        return this.insertInEditor(localClassPath, textEditor, prefixLength, selectedFunctions, parentsHierarchy, insertAsExternAndImplementation, null);
    }

    default public VlogContentAssistUtilCommon.LinkedPositionResult insertInEditor(RfElementPathInProject localClassPath, ITextEditor textEditor, int prefixLength, List<T> selectedFunctions, List<RfClass> parentsHierarchy, boolean insertAsExternAndImplementation, DVTLinkedPositionProvider linkedPositionProvider) {
        int offset = this.getCurrentOffset(textEditor) - prefixLength;
        InsertSignaturesInfo result = this.getInsertSignature(localClassPath, textEditor, prefixLength, selectedFunctions, parentsHierarchy, insertAsExternAndImplementation, offset);
        if (result == null) {
            return null;
        }
        if (result != null && result.getLinkedPositionResult() != null && result.getLinkedPositionResult().firstLinkedRegion != null) {
            return result.getLinkedPositionResult();
        }
        IDocument document = DVTFileUtils.getInstance().getDocument(textEditor);
        if (document == null) {
            return new VlogContentAssistUtilCommon.LinkedPositionResult(0);
        }
        try {
            return new VlogContentAssistUtilCommon.LinkedPositionResult(document.getLineOffset(document.getLineOfOffset(offset) + 4) - 1 - offset);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new VlogContentAssistUtilCommon.LinkedPositionResult(0);
        }
    }

    default public int getCurrentOffset(ITextEditor textEditor) {
        return ((DVTEditor)textEditor).getCursor();
    }

    public void showNotValidPositionMessageDialog();

    public Map<RfClass, List<T>> getOverrideContext(RfClass var1);
}

