/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.override.InsertSignaturesInfo;

public interface OverrideUtilsCommon<T extends RfNamedElement> {
    default public int compareElements(List<RfClass> parentsHierarchy, T elem1, T elem2) {
        if (((RfNamedElement)elem1).isPredefined() && ((RfNamedElement)elem2).isPredefined()) {
            return ((RfNamedElement)elem2).getName().compareTo(((RfNamedElement)elem1).getName());
        }
        if (((RfNamedElement)elem1).isPredefined()) {
            return -1;
        }
        if (((RfNamedElement)elem2).isPredefined()) {
            return 1;
        }
        RfNamedElement enclosingScope1 = ((RfNamedElement)elem1).getEnclosingScope();
        RfNamedElement enclosingScope2 = ((RfNamedElement)elem2).getEnclosingScope();
        if (!(enclosingScope1 instanceof RfClass) || !(enclosingScope2 instanceof RfClass)) {
            return 0;
        }
        RfClass enclosingClass1 = (RfClass)enclosingScope1;
        RfClass enclosingClass2 = (RfClass)enclosingScope2;
        if (enclosingClass1.equals(enclosingClass2)) {
            return Integer.compare(((RfNamedElement)elem1).getStartOffset(), ((RfNamedElement)elem2).getStartOffset());
        }
        if (parentsHierarchy == null) {
            return 0;
        }
        return Integer.compare(parentsHierarchy.indexOf(enclosingClass1), parentsHierarchy.indexOf(enclosingClass2));
    }

    default public List<RfClass> getRelevantParents(RfClass localClass, Map<RfClass, List<T>> context) {
        ArrayList<RfClass> parentsHierarchy = new ArrayList<RfClass>();
        LinkedList<RfClass> parents = new LinkedList<RfClass>();
        parents.add(localClass);
        while (!parents.isEmpty()) {
            List<RfClass> parentInterfaces;
            RfClass currParent = (RfClass)parents.poll();
            if (context.containsKey(currParent) && !context.get(currParent).isEmpty()) {
                parentsHierarchy.add(currParent);
            }
            if (currParent.getParent() != null) {
                parents.add(currParent.getParent());
            }
            if ((parentInterfaces = currParent.getParentInterfaces()) == null || parentInterfaces.isEmpty()) continue;
            parents.addAll(parentInterfaces);
        }
        return parentsHierarchy;
    }

    public InsertSignaturesInfo getInsertSignature(RfElementPathInProject var1, ITextEditor var2, int var3, List<T> var4, List<RfClass> var5, boolean var6, int var7);
}

