/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateConfig;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateInserter;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogGetterSetterElementInserter {
    public static void insertAtOffset(ITextEditor textEditor, int prefixLength, String function, RfField field, int offset, boolean multipleFunctions) {
        if (textEditor == null || function == null || offset < 0) {
            return;
        }
        IDocument document = DVTFileUtils.getInstance().getDocument(textEditor);
        if (document == null) {
            return;
        }
        try {
            String fncsig = VlogGetterSetterElementInserter.createFunctionSignature(function, field, document, offset, multipleFunctions, textEditor);
            document.replace(offset, prefixLength, fncsig);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static String createFunctionSignature(String candidate, RfField field, IDocument document, int offset, boolean multipleFunctions, ITextEditor editor) {
        boolean useSpacesNotTabs;
        String offsetStr = "";
        RfNamedElement enclosingScope = field.getEnclosingScope();
        offsetStr = !(enclosingScope instanceof RfClass) || !(editor instanceof DVTEditor) ? VlogGetterSetterElementInserter.getOffsetFormat(document, offset) : VlogFileUtils.computeEnclosingClassIndent((RfClass)enclosingScope, (DVTEditor)editor);
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)editor);
        int tabWidth = 4;
        if (editor instanceof DVTEditor) {
            tabWidth = ((DVTEditor)editor).getTabWidth();
            useSpacesNotTabs = ((DVTEditor)editor).isInsertSpaces(VlogPlugin.getDefault().getCombinedPreferenceStore());
        } else {
            useSpacesNotTabs = TextUtils.getEditorSpacesForTabs((IPreferenceStore)VlogPlugin.getDefault().getCombinedPreferenceStore());
        }
        String tabOrSpace = TextUtils.getIndentTab((boolean)useSpacesNotTabs, (int)tabWidth);
        if (tabOrSpace == null) {
            tabOrSpace = "    ";
        }
        offsetStr = String.valueOf(offsetStr) + tabOrSpace;
        VlogMethodTemplateConfig config = (VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)new VlogMethodTemplateConfig().setTemplate("method_implementation")).setEditor((IEditorPart)editor)).setDocument(document)).setDocumentOffset(offset)).setKind("function").setEndKeyword("endfunction").setIndent("")).setTrailingNewlines(-1);
        if (candidate.startsWith("get")) {
            config.fillGetterInfo(field);
        } else {
            config.fillSetterInfo(field);
        }
        String replacementString = new VlogMethodTemplateInserter(config).parse();
        String indent = offsetStr;
        replacementString = String.valueOf(DVTStringUtil.mapSplitLines((String)replacementString, (String)lineDelimiter, (line, index) -> String.valueOf(index > 0 ? indent : "") + line)) + lineDelimiter + lineDelimiter;
        String firstLineIndent = "";
        String offsetFormat = VlogGetterSetterElementInserter.getOffsetFormat(document, offset);
        if (offsetFormat.length() < offsetStr.length()) {
            firstLineIndent = offsetStr.substring(offsetFormat.length());
        }
        if (multipleFunctions) {
            return String.valueOf(offsetStr) + replacementString;
        }
        return String.valueOf(firstLineIndent) + replacementString;
    }

    private static String getOffsetFormat(IDocument document, int offset) {
        String result;
        block4: {
            result = "";
            try {
                int lineNr = document.getLineOfOffset(offset);
                int lineOffset = document.getLineOffset(lineNr);
                int emptySpace = offset - lineOffset;
                if (offset <= lineOffset) break block4;
                int i = 0;
                while (i < emptySpace) {
                    char ch = document.getChar(offset - emptySpace + i);
                    if (Character.isWhitespace(ch)) {
                        result = String.valueOf(result) + ch;
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return result;
    }
}

