/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfStruct;

public class VlogGetterSetterMethodsDialog {
    private Map<RfField, List<String>> model;
    private String replacementPrefix;

    public VlogGetterSetterMethodsDialog(String replacementPrefix) {
        this.replacementPrefix = replacementPrefix;
    }

    public List<String> getSelectedFunctions(Map<RfField, List<String>> model) {
        this.model = model;
        SelectDialog selectDialog = new SelectDialog(Utils.getActiveShell(), (ILabelProvider)new GetterSetterLabelProvider(), new GetterSetterContentProvider());
        selectDialog.setBlockOnOpen(true);
        selectDialog.setTitle("Generate Getters and Setters");
        selectDialog.setInput(this.model);
        if (this.replacementPrefix != null) {
            selectDialog.setSearchTextString(this.replacementPrefix);
        }
        int status = selectDialog.open();
        ArrayList<String> result = new ArrayList<String>();
        if (status == 0) {
            Map<RfField, Set<String>> dialogResult = selectDialog.getResultMap();
            if (dialogResult == null) {
                return null;
            }
            for (Set<String> values : dialogResult.values()) {
                result.addAll(values);
            }
        }
        return result;
    }

    private class GetterSetterContentProvider
    implements ITreeContentProvider {
        HashMap<RfField, ArrayList<String>> params = new HashMap();

        private GetterSetterContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            HashMap params;
            if (!(inputElement instanceof HashMap)) {
                return null;
            }
            this.params = params = (HashMap)inputElement;
            LinkedHashSet<RfField> ret = new LinkedHashSet<RfField>();
            if (params.size() > 0) {
                for (Map.Entry entry : params.entrySet()) {
                    RfField field = (RfField)entry.getKey();
                    if (field == null || ((ArrayList)entry.getValue()).isEmpty()) continue;
                    ret.add(field);
                }
            }
            return ret.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<String> fnc;
            RfField field;
            if (parentElement instanceof RfField && this.params.containsKey(field = (RfField)parentElement) && (fnc = this.params.get(field)) != null && !fnc.isEmpty()) {
                return fnc.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (!(element instanceof String)) {
                return null;
            }
            for (Map.Entry<RfField, List<String>> entry : VlogGetterSetterMethodsDialog.this.model.entrySet()) {
                for (String func : entry.getValue()) {
                    if (!func.equals((String)element)) continue;
                    return entry.getKey();
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.params.containsKey(element) && !this.params.get(element).isEmpty();
        }
    }

    private class GetterSetterLabelProvider
    extends ColumnLabelProvider {
        private GetterSetterLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FUNCTION);
            }
            if (element instanceof RfField) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
            }
            return null;
        }

        public Object getParentTypeName(Object elem) {
            if (elem instanceof String) {
                for (Map.Entry<RfField, List<String>> entry : VlogGetterSetterMethodsDialog.this.model.entrySet()) {
                    RfField field = entry.getKey();
                    for (String func : entry.getValue()) {
                        List<RfField> elements;
                        if (!func.contains((String)elem)) continue;
                        IRfNamedElement fieldType = field.getAssociatedType();
                        if (fieldType instanceof RfStruct && ((RfStruct)fieldType).isEnum() && (elements = ((RfStruct)fieldType).getLocalMembers(RfField.class)) != null && !elements.isEmpty()) {
                            return elements.get(0).getAssociatedTypeName();
                        }
                        return field.getAssociatedTypeName();
                    }
                }
            }
            return null;
        }

        public Object getParentName(Object elem) {
            if (elem instanceof String) {
                for (Map.Entry<RfField, List<String>> entry : VlogGetterSetterMethodsDialog.this.model.entrySet()) {
                    RfField field = entry.getKey();
                    for (String func : entry.getValue()) {
                        if (!func.contains((String)elem)) continue;
                        return String.valueOf(field.getName()) + field.getUnpackedDimension();
                    }
                }
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof RfField) {
                List<RfField> elements;
                RfField field = (RfField)element;
                IRfNamedElement fieldType = field.getAssociatedType();
                if (fieldType instanceof RfStruct && ((RfStruct)fieldType).isEnum() && (elements = ((RfStruct)fieldType).getLocalMembers(RfField.class)) != null && !elements.isEmpty()) {
                    return String.valueOf(field.getName()) + field.getUnpackedDimension() + " : " + elements.get(0).getAssociatedTypeName();
                }
                return String.valueOf(field.getName()) + " : " + field.getAssociatedTypeName();
            }
            if (element instanceof String) {
                String function = (String)element;
                if (function.contains("get")) {
                    return String.valueOf((String)element) + "()";
                }
                if (function.contains("set")) {
                    return String.valueOf((String)element) + "(" + this.getParentTypeName(element) + " " + this.getParentName(element) + ")";
                }
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "N/A";
        }

        public String getToolTipText(Object element) {
            if (element instanceof RfField) {
                return String.valueOf(((RfField)element).getSignature().trim().replaceAll("\n", "")) + "\n\n" + ((RfField)element).getComment();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }
    }

    private class SelectDialog
    extends CheckedTreeSelectionDialog {
        private CheckboxTreeViewer checkboxTree;
        private Map<RfField, Set<String>> result;
        private Text filterTextWidget;
        private String searchTextString;
        private FilterTriggerJob filterTriggerJob;
        private Set<Object> checkedElements;

        public SelectDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider);
            this.result = new HashMap<RfField, Set<String>>();
            this.filterTriggerJob = new FilterTriggerJob();
            this.setEmptyListMessage("No fields to generate getters and setters for.");
            this.setContainerMode(true);
        }

        public Map<RfField, Set<String>> getResultMap() {
            return this.result;
        }

        protected CheckboxTreeViewer createTreeViewer(Composite parent) {
            this.checkboxTree = super.createTreeViewer(parent);
            this.checkboxTree.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    boolean isChecked = event.getChecked();
                    Object element = event.getElement();
                    ITreeContentProvider cp = (ITreeContentProvider)SelectDialog.this.checkboxTree.getContentProvider();
                    if (element instanceof String) {
                        if (isChecked) {
                            SelectDialog.this.checkedElements.add(element);
                        } else {
                            SelectDialog.this.checkedElements.remove(element);
                        }
                        Set<String> getterSetterFunctions = SelectDialog.this.result.get(cp.getParent(element));
                        if (getterSetterFunctions == null) {
                            getterSetterFunctions = new HashSet<String>();
                            SelectDialog.this.result.put((RfField)cp.getParent(element), getterSetterFunctions);
                        }
                        if (isChecked) {
                            getterSetterFunctions.add((String)element);
                        } else {
                            getterSetterFunctions.remove(element);
                        }
                    }
                    if (element instanceof RfField) {
                        RfField eventClazz = (RfField)element;
                        Object[] eventClazzChildren = cp.getChildren((Object)eventClazz);
                        Set<String> getterSetterFunctions = SelectDialog.this.result.get(element);
                        if (getterSetterFunctions == null) {
                            getterSetterFunctions = new HashSet<String>();
                            SelectDialog.this.result.put((RfField)element, getterSetterFunctions);
                        }
                        Object[] objectArray = eventClazzChildren;
                        int n = eventClazzChildren.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object c = objectArray[n2];
                            if (cp.getParent(c) == element) {
                                SelectDialog.this.checkboxTree.setChecked(c, isChecked);
                                if (isChecked) {
                                    getterSetterFunctions.add((String)c);
                                    SelectDialog.this.checkedElements.add(c);
                                } else {
                                    getterSetterFunctions.remove(c);
                                    SelectDialog.this.checkedElements.remove(c);
                                }
                            }
                            ++n2;
                        }
                        SelectDialog.this.getTreeViewer().getTree().update();
                        SelectDialog.this.getTreeViewer().refresh();
                        SelectDialog.this.checkboxTree.refresh(true);
                    }
                }
            });
            this.checkboxTree.setSorter((ViewerSorter)new GetterSetterMethodsSorter());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer(), (int)2);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.vlogdt.help.GenerateGettersSettersDialog");
            return this.checkboxTree;
        }

        public void setSearchTextString(String text) {
            this.searchTextString = text;
        }

        private void update() {
            Map<Object, Object> newModel = new HashMap();
            HashMap<RfField, Set<String>> newResultMap = new HashMap<RfField, Set<String>>();
            String filterText = this.filterTextWidget.getText().trim();
            Set<Object> visibleCheckedElements = new LinkedHashSet();
            if (filterText.isEmpty()) {
                newModel = VlogGetterSetterMethodsDialog.this.model;
                visibleCheckedElements = this.checkedElements;
                newResultMap.putAll(this.result);
            } else {
                for (Map.Entry<RfField, List<String>> entry : VlogGetterSetterMethodsDialog.this.model.entrySet()) {
                    RfField field = entry.getKey();
                    List<String> allFunctionsForField = entry.getValue();
                    ArrayList<String> visibleFunctionsForField = new ArrayList<String>();
                    HashSet<String> checkedFunctionsForField = new HashSet<String>();
                    for (String functionName : allFunctionsForField) {
                        StringMatcher matcher = new StringMatcher(String.valueOf('*') + filterText + '*', true, false);
                        if (matcher.match(functionName)) {
                            visibleFunctionsForField.add(functionName);
                            if (!this.checkedElements.contains(functionName)) continue;
                            checkedFunctionsForField.add(functionName);
                            visibleCheckedElements.add(functionName);
                            continue;
                        }
                        if (!this.checkedElements.contains(functionName)) continue;
                        checkedFunctionsForField.add(functionName);
                    }
                    if (!visibleFunctionsForField.isEmpty()) {
                        newModel.put(field, visibleFunctionsForField);
                    }
                    newResultMap.put(field, checkedFunctionsForField);
                }
            }
            this.result.clear();
            this.result.putAll(newResultMap);
            this.getTreeViewer().setInput(newModel);
            this.getTreeViewer().setCheckedElements(visibleCheckedElements.toArray());
            if (!filterText.isEmpty()) {
                this.getTreeViewer().expandAll();
            }
            this.getTreeViewer().getTree().update();
            this.getTreeViewer().refresh();
        }

        protected Control createDialogArea(Composite parent) {
            Composite topComposite = new Composite(parent, 0);
            topComposite.setLayout((Layout)new GridLayout(2, false));
            topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            this.filterTextWidget = new Text(topComposite, 2048);
            this.filterTextWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.filterTextWidget.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectDialog.this.filterTriggerJob.cancel();
                    SelectDialog.this.filterTriggerJob.schedule(700L);
                }
            });
            this.filterTextWidget.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                        SelectDialog.this.getTreeViewer().getTree().setFocus();
                    }
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            if (this.searchTextString != null && !this.searchTextString.isEmpty()) {
                this.filterTextWidget.setText(this.searchTextString);
                this.filterTextWidget.setSelection(this.searchTextString.length());
                this.filterTriggerJob.run((IProgressMonitor)new NullProgressMonitor());
            }
            this.filterTextWidget.setFocus();
            ToolBar toolbar = new ToolBar(topComposite, 0x800100);
            ToolItem expand = new ToolItem(toolbar, 0);
            expand.setImage(DVTImages.imageCache.getImage(DVTImages.EXPAND_TREE));
            expand.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Map model = new HashMap();
                    Object input = SelectDialog.this.getTreeViewer().getInput();
                    if (input instanceof Map) {
                        model = (Map)input;
                    }
                    for (RfField field : model.keySet()) {
                        SelectDialog.this.getTreeViewer().setExpandedState((Object)field, true);
                    }
                }
            });
            ToolItem collapse = new ToolItem(toolbar, 0);
            collapse.setImage(DVTImages.imageCache.getImage(DVTImages.COLLAPSE_TREE));
            collapse.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Map model = new HashMap();
                    Object input = SelectDialog.this.getTreeViewer().getInput();
                    if (input instanceof Map) {
                        model = (Map)input;
                    }
                    for (RfField field : model.keySet()) {
                        SelectDialog.this.getTreeViewer().setExpandedState((Object)field, false);
                    }
                }
            });
            Composite treeComposite = new Composite(parent, 0);
            treeComposite.setLayout((Layout)new GridLayout(2, false));
            treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            CheckboxTreeViewer treeViewer = this.createTreeViewer(treeComposite);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 400;
            data.widthHint = 600;
            Tree treeWidget = treeViewer.getTree();
            treeWidget.setLayoutData((Object)data);
            treeWidget.setFont(parent.getFont());
            treeWidget.setEnabled(true);
            String match = "";
            if (this.searchTextString != null && !this.searchTextString.isEmpty()) {
                match = this.searchTextString;
            }
            ArrayList<String> selectedElements = new ArrayList<String>();
            boolean isGetSetPrefix = match.startsWith("get") || match.startsWith("set");
            StringMatcher sm = new StringMatcher(String.valueOf(match) + '*', true, false);
            StringMatcher smGet = new StringMatcher("get*" + match + '*', true, false);
            StringMatcher smSet = new StringMatcher("set*" + match + '*', true, false);
            for (List<String> list : VlogGetterSetterMethodsDialog.this.model.values()) {
                for (String func : list) {
                    if ((!isGetSetPrefix || !sm.match(func)) && (!match.isEmpty() && DVTStringUtil.getCamelCaseIndex((String)func, (String)match, (boolean)true) == -1 || !smGet.match(func) && !smSet.match(func))) continue;
                    selectedElements.add(func);
                }
            }
            for (Map.Entry entry : VlogGetterSetterMethodsDialog.this.model.entrySet()) {
                HashSet<String> newFunc = new HashSet<String>();
                for (String func : (List)entry.getValue()) {
                    newFunc.add(func);
                }
                this.result.put((RfField)entry.getKey(), newFunc);
            }
            this.setInitialSelections(selectedElements.toArray());
            this.checkedElements = new LinkedHashSet<Object>();
            this.checkedElements.addAll(selectedElements);
            this.createSelectionButtons(treeComposite);
            return treeComposite;
        }

        protected void buttonPressed(int buttonId) {
            block7: {
                block6: {
                    super.buttonPressed(buttonId);
                    if (buttonId != 19) break block6;
                    if (!(this.getTreeViewer().getInput() instanceof Map)) {
                        return;
                    }
                    Map model = (Map)this.getTreeViewer().getInput();
                    for (Map.Entry entry : model.entrySet()) {
                        this.checkedElements.removeAll((Collection)entry.getValue());
                        Set<String> resultFunctions = this.result.get(entry.getKey());
                        if (resultFunctions == null) continue;
                        for (String func : (List)entry.getValue()) {
                            resultFunctions.remove(func);
                        }
                    }
                    break block7;
                }
                if (buttonId != 18) break block7;
                if (!(this.getTreeViewer().getInput() instanceof Map)) {
                    return;
                }
                Map model = (Map)this.getTreeViewer().getInput();
                for (Map.Entry entry : model.entrySet()) {
                    RfField field = (RfField)entry.getKey();
                    this.checkedElements.addAll((Collection)entry.getValue());
                    Set<String> resultFuncz = this.result.get(field);
                    if (resultFuncz == null) {
                        resultFuncz = new HashSet<String>();
                        this.result.put(field, resultFuncz);
                    }
                    resultFuncz.addAll((Collection)entry.getValue());
                }
            }
        }

        protected Composite createSelectionButtons(Composite composite) {
            Composite result = super.createSelectionButtons(composite);
            Object dataObject = result.getLayoutData();
            if (dataObject instanceof GridData) {
                GridData data = (GridData)dataObject;
                data.verticalAlignment = 128;
            }
            return result;
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            if (id != 0 && id != 1) {
                ((GridLayout)parent.getLayout()).numColumns = 0;
            }
            return super.createButton(parent, id, label, defaultButton);
        }

        class FilterTriggerJob
        extends UIJob {
            public FilterTriggerJob() {
                super("FilterTriggerJob");
                this.setPriority(50);
                this.setSystem(true);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SelectDialog.this.update();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }

        private class GetterSetterMethodsSorter
        extends ViewerSorter {
            private GetterSetterMethodsSorter() {
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 != null && e1 instanceof RfField) {
                    e1 = ((RfField)e1).getName();
                }
                if (e2 != null && e2 instanceof RfField) {
                    e2 = ((RfField)e2).getName();
                }
                if (e1 instanceof String && e2 instanceof String) {
                    String name1 = (String)e1;
                    String name2 = (String)e2;
                    return name1.compareTo(name2);
                }
                return 0;
            }
        }
    }
}

