/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtilCommon;
import ro.amiq.vlogdt.ui.editor.override.InsertSignaturesInfo;
import ro.amiq.vlogdt.ui.editor.utils.VlogSignaturesInsertConfigurationProvider;

public abstract class VlogOveriddenElementInserterCommon {
    public InsertSignaturesInfo insertSignatures(VlogSignaturesInsertConfigurationProvider configurator) {
        Change protypeChange;
        Change implementationChange;
        boolean addLineDelimitatorOnFirstLine;
        int prefixLength;
        VlogContentAssistUtilCommon.LinkedPositionResult linkedPositionResult = new VlogContentAssistUtilCommon.LinkedPositionResult();
        CompositeChange compositeChange = new CompositeChange("_insert_signatures_");
        DVTEditor textEditor = configurator.getTextEditor();
        IDocument document = configurator.getDocument();
        List<String> signatures = configurator.getSignatures();
        if (textEditor == null || document == null || signatures == null || signatures.isEmpty()) {
            return new InsertSignaturesInfo(null, linkedPositionResult);
        }
        int implementationInsertOffset = configurator.getInsertionOffset();
        String indent = configurator.getIndent();
        RfClass classElement = configurator.getClassElement();
        String enclosingClassIndent = "";
        if (classElement != null) {
            enclosingClassIndent = DVTDocumentUtils.getIndent((int)classElement.getDeclaration().getStartOffset(), (IDocument)document);
        }
        String prototypeIndent = indent;
        String lineDelimiter = configurator.getLineDelimiter();
        int prototypePrefixLength = prefixLength = configurator.getPrefixLength();
        boolean isUserInsertionPoint = configurator.isUserInsertionPoint();
        boolean prototypeAddLineDelimitatorOnFirstLine = addLineDelimitatorOnFirstLine = configurator.isAddLineDelimOnFirstLine();
        boolean indentFirstLine = configurator.isIndentFirstLine();
        boolean insertAsExternAndImplementation = configurator.isInsertExternPrototypeAndImplementation();
        boolean prependExtraNewLine = false;
        int prototypeInsertionPoint = configurator.getInsertionOffset();
        List<String> prototypes = configurator.getExternPrototypes();
        String prototypeSignatureString = "";
        if (insertAsExternAndImplementation) {
            if (prototypes == null || prototypes.isEmpty() || prototypeInsertionPoint < 0) {
                return new InsertSignaturesInfo(null, linkedPositionResult);
            }
            addLineDelimitatorOnFirstLine = true;
            try {
                if (classElement == null) {
                    return new InsertSignaturesInfo(null, linkedPositionResult);
                }
                IRegion endClassInfo = document.getLineInformationOfOffset(classElement.getDeclaration().getEndOffset());
                implementationInsertOffset = endClassInfo.getOffset() + endClassInfo.getLength();
                indent = DVTDocumentUtils.getIndent((int)implementationInsertOffset, (IDocument)document);
                prependExtraNewLine = true;
                prefixLength = 0;
                if (!prototypeAddLineDelimitatorOnFirstLine) {
                    prototypeSignatureString = DVTFileUtils.getInstance().computeFirstLineIndent(document, prototypeIndent, prototypeInsertionPoint);
                }
                prototypeSignatureString = String.valueOf(prototypeSignatureString) + DVTStringUtil.concatMethodsSignatures(prototypes, (String)enclosingClassIndent, (String)prototypeIndent, (String)lineDelimiter, (boolean)prototypeAddLineDelimitatorOnFirstLine, (boolean)indentFirstLine);
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (implementationInsertOffset < 0) {
            return new InsertSignaturesInfo(null, linkedPositionResult);
        }
        String implementationSignatureString = "";
        if (!addLineDelimitatorOnFirstLine) {
            implementationSignatureString = DVTFileUtils.getInstance().computeFirstLineIndent(document, indent, implementationInsertOffset);
        }
        implementationSignatureString = String.valueOf(implementationSignatureString) + DVTStringUtil.concatMethodsSignatures(signatures, (String)enclosingClassIndent, (String)indent, (String)lineDelimiter, (boolean)addLineDelimitatorOnFirstLine, (indentFirstLine || insertAsExternAndImplementation ? 1 : 0) != 0);
        if (prependExtraNewLine) {
            implementationSignatureString = String.valueOf(System.lineSeparator()) + implementationSignatureString;
        }
        if ((implementationChange = this.insertString(document, implementationInsertOffset, prefixLength, implementationSignatureString = this.removeLinkedPositions(implementationSignatureString), (IResource)((IFile)textEditor.getAdapter(IResource.class)))) instanceof DVTTextFileChange) {
            compositeChange.add((Change)((DVTTextFileChange)implementationChange));
        }
        if (insertAsExternAndImplementation && (protypeChange = this.insertString(document, prototypeInsertionPoint, prototypePrefixLength, prototypeSignatureString, (IResource)((IFile)textEditor.getAdapter(IResource.class)))) instanceof DVTTextFileChange) {
            compositeChange.add((Change)((DVTTextFileChange)protypeChange));
        }
        if (isUserInsertionPoint) {
            try {
                int insertionLine = document.getLineOfOffset(implementationInsertOffset);
                int docNofLines = document.getNumberOfLines();
                if (insertionLine + 2 < docNofLines) {
                    textEditor.selectAndReveal(document.getLineOffset(insertionLine + 2), 0);
                }
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return new InsertSignaturesInfo(compositeChange, linkedPositionResult);
    }

    abstract VlogContentAssistUtilCommon.LinkedPositionResult initLinkedPositionResult(DVTLinkedPositionProvider var1, DVTEditor var2, int var3, int var4, String var5, String var6) throws BadLocationException, TemplateException, BadPositionCategoryException;

    abstract Change insertString(IDocument var1, int var2, int var3, String var4, IResource var5);

    protected abstract String removeLinkedPositions(String var1);
}

