/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.ui.editor.override.VlogOverrideDialog;
import ro.amiq.vlogdt.ui.editor.override.VlogOverrideSelectDialog;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class VlogOverrideConstraintsDialog
extends VlogOverrideDialog<RfConstraint> {
    private static final String OVERRIDE_CONSTRAINTS_TITLE = "Override Constraints";
    private static final String EMPTY_LIST_MESSAGE = "No constraints to override.";

    public VlogOverrideConstraintsDialog(String replacementPrefix) {
        super(replacementPrefix);
    }

    @Override
    public List<RfConstraint> getSelectedElements(Map<RfClass, List<RfConstraint>> model, List<RfClass> parentsHierarchy) {
        return this.getSelectedConstraints(model, parentsHierarchy);
    }

    public List<RfConstraint> getSelectedConstraints(Map<RfClass, List<RfConstraint>> model, List<RfClass> parentsHierarchy) {
        this.model = new LinkedHashMap();
        for (Map.Entry<RfClass, List<RfConstraint>> entry : model.entrySet()) {
            this.model.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.parentsHierarchy = parentsHierarchy;
        SelectDialog selectDialog = new SelectDialog(Utils.getActiveShell(), this.getLabelProvider(), this.getContentProvider());
        selectDialog.setBlockOnOpen(true);
        selectDialog.setTitle(OVERRIDE_CONSTRAINTS_TITLE);
        selectDialog.setInput(model);
        if (this.replacementPrefix != null && !this.replacementPrefix.isEmpty()) {
            selectDialog.setSearchTextString(this.replacementPrefix);
        }
        ArrayList<RfConstraint> result = new ArrayList<RfConstraint>();
        int status = selectDialog.open();
        if (status == 0) {
            Map dialogResult = selectDialog.getResultMap();
            if (dialogResult == null) {
                return null;
            }
            for (Set<RfConstraint> set : dialogResult.values()) {
                HashSet newSet = new HashSet();
                set.forEach(v -> {
                    boolean bl = newSet.add(v);
                });
                result.addAll(newSet);
            }
        }
        return result;
    }

    private class SelectDialog
    extends VlogOverrideSelectDialog<RfConstraint> {
        protected SelectDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider, VlogOverrideConstraintsDialog.EMPTY_LIST_MESSAGE, VlogOverrideConstraintsDialog.this.parentsHierarchy, VlogOverrideConstraintsDialog.this.model);
        }

        @Override
        protected void performAdditionalChecks(Object function, boolean isChecked) {
        }

        @Override
        public boolean isChild(Object obj) {
            return obj instanceof RfConstraint;
        }

        @Override
        protected void setHelp(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.vlogdt.help.OverrideConstraintsDialog");
        }

        @Override
        protected void configureAdditionalButtons(Composite bottomComposite) {
        }

        @Override
        protected void setPreferenceValue(boolean selection) {
            PrefConst.setOverrideConstraintsExternPrototypeAndImplementation(selection);
        }

        @Override
        protected boolean getPreferenceValue() {
            return PrefConst.getOverrideConstraintsExternPrototypeAndImplementation();
        }

        @Override
        protected ViewerComparator getElementComparator() {
            return new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof RfConstraint && e2 instanceof RfConstraint) {
                        String name1 = ((RfConstraint)e1).getName();
                        String name2 = ((RfConstraint)e2).getName();
                        return name1.compareTo(name2);
                    }
                    return 0;
                }
            };
        }
    }
}

