/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.THViewLabelProvider;

public abstract class VlogOverrideDialog<T extends RfNamedElement> {
    protected Map<RfClass, List<T>> model;
    protected List<RfClass> parentsHierarchy;
    protected String replacementPrefix;

    protected VlogOverrideDialog(String replacementPrefix) {
        this.replacementPrefix = replacementPrefix;
    }

    protected ILabelProvider getLabelProvider() {
        return new OverrideLabelProvider();
    }

    protected ITreeContentProvider getContentProvider() {
        return new OverrideContentProvider();
    }

    public abstract List<T> getSelectedElements(Map<RfClass, List<T>> var1, List<RfClass> var2);

    private class OverrideContentProvider
    implements ITreeContentProvider {
        HashMap<RfClass, ArrayList<T>> params = new HashMap();

        private OverrideContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            HashMap params;
            if (!(inputElement instanceof HashMap)) {
                return null;
            }
            this.params = params = (HashMap)inputElement;
            LinkedHashSet<RfClass> ret = new LinkedHashSet<RfClass>();
            if (VlogOverrideDialog.this.parentsHierarchy != null && !VlogOverrideDialog.this.parentsHierarchy.isEmpty()) {
                int nrOfParents = VlogOverrideDialog.this.parentsHierarchy.size();
                int i = 0;
                while (i < nrOfParents) {
                    if (params.get(VlogOverrideDialog.this.parentsHierarchy.get(i)) != null && !((ArrayList)params.get(VlogOverrideDialog.this.parentsHierarchy.get(i))).isEmpty()) {
                        ret.add(VlogOverrideDialog.this.parentsHierarchy.get(i));
                    }
                    ++i;
                }
            }
            return ret.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList elem;
            RfClass parentRfClass;
            if (parentElement instanceof RfClass && this.params.containsKey(parentRfClass = (RfClass)parentElement) && (elem = this.params.get(parentRfClass)) != null && !elem.isEmpty()) {
                return elem.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (!(element instanceof RfNamedElement)) {
                return null;
            }
            RfNamedElement namedElem = ((RfNamedElement)element).getEnclosingScope();
            if (!(namedElem instanceof RfClass)) {
                return null;
            }
            RfClass elementScopeClass = (RfClass)namedElem;
            if (this.params.containsKey(elementScopeClass)) {
                return elementScopeClass;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.params.containsKey(element) && !this.params.get(element).isEmpty();
        }
    }

    private static class OverrideLabelProvider
    extends ColumnLabelProvider {
        private THViewLabelProvider membersViewLabelProvider = new THViewLabelProvider(false);

        private OverrideLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return this.membersViewLabelProvider.getImage((Object)new RfTreeElementWrapper(element));
        }

        public String getText(Object element) {
            if (element instanceof RfClass || element instanceof RfNamedElement) {
                return this.membersViewLabelProvider.getText((Object)new RfTreeElementWrapper(element));
            }
            return (String)element;
        }

        public String getToolTipText(Object element) {
            if (element instanceof RfNamedElement) {
                return String.valueOf(((RfNamedElement)element).getSignature().trim().replace("\n", "")) + "\n\n" + ((RfNamedElement)element).getComment();
            }
            return null;
        }
    }
}

