/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.ui.editor.override.VlogOverrideDialog;
import ro.amiq.vlogdt.ui.editor.override.VlogOverrideSelectDialog;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class VlogOverrideMethodsDialog
extends VlogOverrideDialog<RfFunction> {
    private static final String OVERRIDE_METHODS_TITLE = "Override Methods";
    private static final String EMPTY_LIST_MESSAGE = "No methods to override.";

    public VlogOverrideMethodsDialog(String replacementPrefix) {
        super(replacementPrefix);
    }

    @Override
    public List<RfFunction> getSelectedElements(Map<RfClass, List<RfFunction>> model, List<RfClass> parentsHierarchy) {
        return this.getSelectedFunctions(model, parentsHierarchy);
    }

    public List<RfFunction> getSelectedFunctions(Map<RfClass, List<RfFunction>> model, List<RfClass> parentsHierarchy) {
        this.model = new LinkedHashMap();
        for (Map.Entry<RfClass, List<RfFunction>> entry : model.entrySet()) {
            this.model.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        this.parentsHierarchy = parentsHierarchy;
        SelectDialog selectDialog = new SelectDialog(Utils.getActiveShell(), this.getLabelProvider(), this.getContentProvider());
        selectDialog.setBlockOnOpen(true);
        selectDialog.setTitle(OVERRIDE_METHODS_TITLE);
        selectDialog.setInput(model);
        if (this.replacementPrefix != null && !this.replacementPrefix.isEmpty()) {
            selectDialog.setSearchTextString(this.replacementPrefix);
        }
        ArrayList<RfFunction> result = new ArrayList<RfFunction>();
        int status = selectDialog.open();
        if (status == 0) {
            Map dialogResult = selectDialog.getResultMap();
            if (dialogResult == null) {
                return null;
            }
            for (Set<RfFunction> set : dialogResult.values()) {
                HashSet newSet = new HashSet();
                set.forEach(v -> {
                    boolean bl = newSet.add(v);
                });
                result.addAll(newSet);
            }
        }
        return result;
    }

    private class SelectDialog
    extends VlogOverrideSelectDialog<RfFunction> {
        private Button showOnlyVirtual;
        private Set<RfFunction> checkedConstructors;

        protected SelectDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
            super(parent, labelProvider, contentProvider, VlogOverrideMethodsDialog.EMPTY_LIST_MESSAGE, VlogOverrideMethodsDialog.this.parentsHierarchy, VlogOverrideMethodsDialog.this.model);
            this.checkedConstructors = new HashSet<RfFunction>();
        }

        @Override
        protected void performAdditionalChecks(Object function, boolean isChecked) {
            if (function == null || !(function instanceof RfFunction)) {
                return;
            }
            if (((RfFunction)function).isConstructor()) {
                if (isChecked) {
                    this.checkedConstructors.add((RfFunction)function);
                } else {
                    this.checkedConstructors.remove(function);
                }
            }
            if (this.checkedConstructors.size() > 1) {
                this.getOkButton().setEnabled(false);
                this.messageComposite.setVisible(true);
            } else {
                this.getOkButton().setEnabled(true);
                this.messageComposite.setVisible(false);
            }
        }

        @Override
        protected boolean shouldFilterElement(RfFunction elem, String matchText) {
            boolean filterVirtual = PrefConst.getOverrideMethodsShowOnlyVirtual();
            String functionName = elem.getName();
            if (!(!filterVirtual || elem.isVirtual() || elem.isConstructor() || functionName.equals("pre_randomize") || functionName.equals("post_randomize"))) {
                return true;
            }
            return super.shouldFilterElement(elem, matchText);
        }

        @Override
        protected void configureAdditionalButtons(Composite bottomComposite) {
            this.showOnlyVirtual = new Button(bottomComposite, 32);
            this.showOnlyVirtual.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.showOnlyVirtual.setText("Show only virtual methods");
            this.showOnlyVirtual.setToolTipText("Show only virtual methods");
            this.showOnlyVirtual.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PrefConst.setOverrideMethodsShowOnlyVirtual(SelectDialog.this.showOnlyVirtual.getSelection());
                    SelectDialog.this.update();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.showOnlyVirtual.setSelection(PrefConst.getOverrideMethodsShowOnlyVirtual());
        }

        @Override
        public boolean isChild(Object obj) {
            return obj instanceof RfFunction;
        }

        @Override
        protected void setHelp(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.vlogdt.help.OverrideMethodsDialog");
        }

        @Override
        protected void setPreferenceValue(boolean selection) {
            PrefConst.setOverrideMethodsExternPrototypeAndImplementation(selection);
        }

        @Override
        protected boolean getPreferenceValue() {
            return PrefConst.getOverrideMethodsExternPrototypeAndImplementation();
        }

        @Override
        protected ViewerComparator getElementComparator() {
            return new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    if (e1 instanceof RfFunction && e2 instanceof RfFunction) {
                        String name1 = ((RfFunction)e1).getName();
                        String name2 = ((RfFunction)e2).getName();
                        return name1.compareTo(name2);
                    }
                    return 0;
                }
            };
        }
    }
}

