/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.override;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class VlogOverrideSelectDialog<T extends RfNamedElement>
extends CheckedTreeSelectionDialog {
    private Text searchText;
    private String searchTextString;
    private FilterTriggerJob filterTriggerJob = new FilterTriggerJob();
    private Set<Object> checkedElements;
    private CheckboxTreeViewer checkboxTree;
    private Button insertAsExternPrototypeAndImplementation;
    private Map<RfClass, Set<T>> result;
    protected Composite messageComposite;
    private List<RfClass> parentsHierarchy;
    private Map<RfClass, List<T>> model;

    protected VlogOverrideSelectDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, String emptyListMessage, List<RfClass> parentsHierarchy, Map<RfClass, List<T>> model) {
        super(parent, labelProvider, contentProvider);
        this.setEmptyListMessage(emptyListMessage);
        this.setContainerMode(true);
        this.parentsHierarchy = parentsHierarchy;
        this.model = model;
        this.result = new HashMap<RfClass, Set<T>>();
    }

    public Map<RfClass, Set<T>> getResultMap() {
        return this.result;
    }

    protected boolean isParent(Object obj) {
        return obj instanceof RfClass;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        this.checkboxTree = super.createTreeViewer(parent);
        this.checkboxTree.addCheckStateListener(event -> {
            boolean isChecked = event.getChecked();
            Object element = event.getElement();
            ITreeContentProvider cp = (ITreeContentProvider)this.checkboxTree.getContentProvider();
            if (this.isChild(element)) {
                Set<T> overrideElements = this.result.get(cp.getParent(element));
                if (overrideElements == null) {
                    overrideElements = new HashSet<T>();
                    this.result.put((RfClass)cp.getParent(element), overrideElements);
                }
                if (isChecked) {
                    this.checkedElements.add(element);
                    overrideElements.add((RfNamedElement)element);
                } else {
                    this.checkedElements.remove(element);
                    overrideElements.remove(element);
                }
                this.performAdditionalChecks(element, isChecked);
            }
            if (this.isParent(element)) {
                Object[] eventClazzChildren = cp.getChildren(element);
                Set<T> elements = this.result.get(element);
                if (elements == null) {
                    elements = new HashSet<T>();
                    this.result.put((RfClass)element, elements);
                }
                Object[] objectArray = eventClazzChildren;
                int n = eventClazzChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    Object c = objectArray[n2];
                    if (cp.getParent(c) == element) {
                        this.checkboxTree.setChecked(c, isChecked);
                        if (isChecked) {
                            elements.add((RfNamedElement)c);
                            this.checkedElements.add(c);
                        } else {
                            elements.remove(c);
                            this.checkedElements.remove(c);
                        }
                        this.performAdditionalChecks(element, isChecked);
                    }
                    ++n2;
                }
                this.getTreeViewer().getTree().update();
                this.getTreeViewer().refresh();
                this.checkboxTree.refresh(true);
            }
        });
        this.checkboxTree.setComparator(this.getElementComparator());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer(), (int)2);
        this.setHelp(parent);
        return this.checkboxTree;
    }

    public void setSearchTextString(String text) {
        this.searchTextString = text;
    }

    protected void update() {
        if (this.checkedElements == null) {
            return;
        }
        TreePath[] expandedTreePath = this.getTreeViewer().getExpandedTreePaths();
        HashMap newModel = new HashMap();
        HashMap newResultMap = new HashMap();
        LinkedHashSet<RfNamedElement> visibleCheckedElements = new LinkedHashSet<RfNamedElement>();
        String matchText = this.searchText.getText().trim();
        for (Map.Entry<RfClass, List<T>> entry : this.model.entrySet()) {
            RfClass clazz = entry.getKey();
            List<T> allElementsForField = entry.getValue();
            ArrayList<RfNamedElement> visibleElementsForField = new ArrayList<RfNamedElement>();
            HashSet<RfNamedElement> checkedElementsForField = new HashSet<RfNamedElement>();
            if (this.shouldFilterClass(clazz, matchText)) {
                for (RfNamedElement elem : allElementsForField) {
                    if (!this.shouldFilterElement(elem, matchText)) {
                        visibleElementsForField.add(elem);
                        if (!this.checkedElements.contains(elem)) continue;
                        visibleCheckedElements.add(elem);
                        checkedElementsForField.add(elem);
                        continue;
                    }
                    if (!this.checkedElements.contains(elem)) continue;
                    checkedElementsForField.add(elem);
                }
            } else {
                for (RfNamedElement elem : allElementsForField) {
                    if (!this.shouldFilterElement(elem, "")) {
                        visibleElementsForField.add(elem);
                        if (!this.checkedElements.contains(elem)) continue;
                        visibleCheckedElements.add(elem);
                        checkedElementsForField.add(elem);
                        continue;
                    }
                    if (!this.checkedElements.contains(elem)) continue;
                    checkedElementsForField.add(elem);
                }
            }
            if (!visibleElementsForField.isEmpty()) {
                newModel.put(clazz, visibleElementsForField);
            }
            newResultMap.put(clazz, checkedElementsForField);
        }
        this.result.clear();
        this.result.putAll(newResultMap);
        this.getTreeViewer().setInput(newModel);
        this.getTreeViewer().setCheckedElements(visibleCheckedElements.toArray());
        this.getTreeViewer().getTree().update();
        if (matchText.isEmpty()) {
            this.getTreeViewer().setExpandedTreePaths(expandedTreePath);
        } else {
            this.getTreeViewer().expandAll();
        }
        this.getTreeViewer().refresh();
    }

    protected boolean shouldFilterElement(T elem, String matchText) {
        StringMatcher sm;
        String elementName = ((RfNamedElement)elem).getName();
        return !matchText.isEmpty() && !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)(sm = ViewsUtils.createCamelCaseOrRegexMatcher((String)matchText, (boolean)true, (boolean)false)), (String)elementName);
    }

    private boolean shouldFilterClass(RfClass clazz, String matchText) {
        if (matchText.isEmpty()) {
            return false;
        }
        StringMatcher sm = ViewsUtils.createCamelCaseOrRegexMatcher((String)matchText, (boolean)true, (boolean)false);
        return !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)sm, (String)clazz.getName());
    }

    protected Control createDialogArea(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        topComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchText = new Text(topComposite, 2048);
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchText.addModifyListener(e -> {
            this.filterTriggerJob.cancel();
            this.filterTriggerJob.schedule(500L);
        });
        this.searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    VlogOverrideSelectDialog.this.getTreeViewer().getTree().setFocus();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        if (this.searchTextString != null && !this.searchTextString.isEmpty()) {
            this.searchText.setText(this.searchTextString);
            this.searchText.setSelection(this.searchTextString.length());
            this.filterTriggerJob.run((IProgressMonitor)new NullProgressMonitor());
        }
        this.searchText.setFocus();
        ToolBar toolbar = new ToolBar(topComposite, 0x800100);
        ToolItem expand = new ToolItem(toolbar, 0);
        expand.setImage(DVTImages.imageCache.getImage(DVTImages.EXPAND_TREE));
        expand.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Map model = new HashMap();
                Object input = VlogOverrideSelectDialog.this.getTreeViewer().getInput();
                if (input instanceof Map) {
                    model = (Map)input;
                }
                for (RfClass clazz : model.keySet()) {
                    VlogOverrideSelectDialog.this.getTreeViewer().setExpandedState((Object)clazz, true);
                }
            }
        });
        ToolItem collapse = new ToolItem(toolbar, 0);
        collapse.setImage(DVTImages.imageCache.getImage(DVTImages.COLLAPSE_TREE));
        collapse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Map model = new HashMap();
                Object input = VlogOverrideSelectDialog.this.getTreeViewer().getInput();
                if (input instanceof Map) {
                    model = (Map)input;
                }
                for (RfClass clazz : model.keySet()) {
                    VlogOverrideSelectDialog.this.getTreeViewer().setExpandedState((Object)clazz, false);
                }
            }
        });
        Composite treeComposite = new Composite(parent, 0);
        treeComposite.setLayout((Layout)new GridLayout(2, false));
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        CheckboxTreeViewer treeViewer = this.createTreeViewer(treeComposite);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 400;
        data.widthHint = 600;
        Tree treeWidget = treeViewer.getTree();
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(parent.getFont());
        treeWidget.setEnabled(true);
        if (this.parentsHierarchy.get(0) != null) {
            treeViewer.expandToLevel((Object)this.parentsHierarchy.get(0), 1);
        }
        ArrayList<RfNamedElement> selectedElements = new ArrayList<RfNamedElement>();
        if (this.searchTextString != null && !this.searchTextString.isEmpty()) {
            for (Map.Entry<RfClass, List<T>> entry : this.model.entrySet()) {
                HashSet<RfNamedElement> checkedCandidates = new HashSet<RfNamedElement>();
                for (RfNamedElement candidate : entry.getValue()) {
                    if (this.shouldFilterElement(candidate, this.searchTextString)) continue;
                    checkedCandidates.add(candidate);
                    selectedElements.add(candidate);
                }
                if (checkedCandidates == null || checkedCandidates.isEmpty()) continue;
                this.result.put(entry.getKey(), checkedCandidates);
            }
        }
        this.setInitialSelections(selectedElements.toArray());
        this.checkedElements = new LinkedHashSet<Object>();
        this.checkedElements.addAll(selectedElements);
        this.createSelectionButtons(treeComposite);
        Composite bottomComposite = new Composite(parent, 0);
        bottomComposite.setLayout((Layout)new GridLayout(2, false));
        bottomComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.configureAdditionalButtons(bottomComposite);
        this.insertAsExternPrototypeAndImplementation = new Button(bottomComposite, 32);
        this.insertAsExternPrototypeAndImplementation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.insertAsExternPrototypeAndImplementation.setText("Insert as extern prototype and implementation");
        this.insertAsExternPrototypeAndImplementation.setToolTipText("Insert as extern prototype and implementation");
        this.insertAsExternPrototypeAndImplementation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = VlogOverrideSelectDialog.this.insertAsExternPrototypeAndImplementation.getSelection();
                VlogOverrideSelectDialog.this.setPreferenceValue(selection);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.insertAsExternPrototypeAndImplementation.setSelection(this.getPreferenceValue());
        this.messageComposite = new Composite(bottomComposite, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageLayout.makeColumnsEqualWidth = false;
        this.messageComposite.setLayout((Layout)messageLayout);
        Label messageImageLabel = new Label(this.messageComposite, 0);
        messageImageLabel.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        Text messageText = new Text(this.messageComposite, 0);
        messageText.setEditable(false);
        messageText.setText("Cannot override more than one constructor.");
        DVTColorUtil.INSTANCE.setBackground((Control)messageText, DVTColorUtil.INSTANCE.getBackground((Control)this.messageComposite), true);
        GridData textData = new GridData(772);
        messageText.setLayoutData((Object)textData);
        this.messageComposite.setVisible(false);
        this.update();
        return treeComposite;
    }

    protected void buttonPressed(int buttonId) {
        block8: {
            block7: {
                super.buttonPressed(buttonId);
                if (buttonId != 19) break block7;
                if (!(this.getTreeViewer().getInput() instanceof Map)) {
                    return;
                }
                Map model = (Map)this.getTreeViewer().getInput();
                for (Map.Entry entry : model.entrySet()) {
                    this.checkedElements.removeAll((Collection)entry.getValue());
                    Set<T> resultElements = this.result.get(entry.getKey());
                    if (resultElements == null) continue;
                    for (RfNamedElement elem : (List)entry.getValue()) {
                        resultElements.remove(elem);
                    }
                }
                break block8;
            }
            if (buttonId != 18) break block8;
            if (!(this.getTreeViewer().getInput() instanceof Map)) {
                return;
            }
            Map model = (Map)this.getTreeViewer().getInput();
            for (Map.Entry entry : model.entrySet()) {
                this.checkedElements.addAll((Collection)entry.getValue());
                Set<T> resultElements = this.result.get(entry.getKey());
                if (resultElements == null) {
                    resultElements = new HashSet<T>();
                }
                for (RfNamedElement elem : (List)entry.getValue()) {
                    resultElements.add(elem);
                }
            }
        }
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite result = super.createSelectionButtons(composite);
        Object dataObject = result.getLayoutData();
        if (dataObject instanceof GridData) {
            GridData data = (GridData)dataObject;
            data.verticalAlignment = 128;
        }
        return result;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id != 0 && id != 1) {
            ((GridLayout)parent.getLayout()).numColumns = 0;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected abstract boolean getPreferenceValue();

    protected abstract void setPreferenceValue(boolean var1);

    protected abstract void configureAdditionalButtons(Composite var1);

    protected abstract void performAdditionalChecks(Object var1, boolean var2);

    protected abstract boolean isChild(Object var1);

    protected abstract void setHelp(Composite var1);

    protected abstract ViewerComparator getElementComparator();

    class FilterTriggerJob
    extends UIJob {
        public FilterTriggerJob() {
            super("FilterTriggerJob");
            this.setPriority(50);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                VlogOverrideSelectDialog.this.update();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

