/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.pathmanager;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.ui.editor.pathmanager.VlogDesignPathProviderCommon;

public class VlogDesignPathProvider
extends VlogDesignPathProviderCommon {
    private static VlogDesignPathProvider INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    private VlogDesignPathProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDesignPathProvider getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VlogDesignPathProvider();
            }
        }
        return INSTANCE;
    }

    public String getLangNature() {
        return "F7376";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDVTFileInstance getFileInstance(IFile file, boolean acceptAny) {
        try {
            IDVTFileInstance fileInstance;
            if (file == null) {
                return null;
            }
            Object wrapper = file.getSessionProperty(IDVTConstants.FILE_INSTANCE_QN);
            IProject project = file.getProject();
            if (project == null) {
                return null;
            }
            if (wrapper == null && acceptAny) {
                IRfFileDef fileDef = this.getFileDef(project, file);
                if (fileDef == null) {
                    return null;
                }
                List fileInstances = RfMixedLangManager.getInstance().getFileInstances(project, fileDef.getParserPath());
                if (fileInstances == null) return null;
                if (!fileInstances.isEmpty()) return (IDVTFileInstance)fileInstances.get(0);
                return null;
            }
            if (wrapper instanceof IDVTElementWrapper) {
                wrapper = ((IDVTElementWrapper)wrapper).getRfElement();
            }
            if (wrapper instanceof IDVTFileInstance) {
                IDVTFileInstance instanceToReturn = (IDVTFileInstance)wrapper;
                if (!instanceToReturn.isValid()) return null;
                IDVTFileInstance iDVTFileInstance = instanceToReturn;
                return iDVTFileInstance;
            }
            if (!(wrapper instanceof IRfNamedElement)) return null;
            IRfDefElement declaration = ((IRfNamedElement)wrapper).getDeclaration();
            if (declaration == null) {
                return null;
            }
            RfFileDef fileDef = (RfFileDef)declaration.getDefFile();
            if (fileDef == null) {
                return null;
            }
            List fileInstances = RfMixedLangManager.getInstance().getFileInstances(project, fileDef.getParserPath());
            Iterator iterator = fileInstances.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(fileInstance = (IDVTFileInstance)iterator.next()).isInstanceInScope((IRfNamedElement)wrapper));
            return fileInstance;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public IRfNamedElement getBindingInScope(IRfDefElement defElement, IDVTFileInstance fileInstance) {
        if (!(defElement instanceof RfDefElement)) {
            return null;
        }
        if (fileInstance == null) {
            return defElement.getNamedElement();
        }
        List<RfNamedElement> namedElements = ((RfDefElement)defElement).getNamedElements();
        if (namedElements == null) {
            return defElement.getNamedElement();
        }
        for (RfNamedElement namedElement : namedElements) {
            if (!fileInstance.isInstanceInScope((IRfNamedElement)namedElement)) continue;
            return namedElement;
        }
        return defElement.getNamedElement();
    }

    public IRfFileDef getFileDef(IProject project, IFile file) {
        if (project == null || file == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return rfProject.getFile((IResource)file);
    }

    public IRfNamedElement getScopeFromFileInstance(IDVTFileInstance fileInstance) {
        if (!(fileInstance instanceof VlogFileInstance)) {
            return null;
        }
        RfNamedElement semanticScope = ((VlogFileInstance)fileInstance).getSemanticScope();
        return semanticScope instanceof RfLibrary ? null : semanticScope;
    }
}

