/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.pathmanager;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManagerUtils;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.reflection.RfCheckerDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfPrimitiveDef;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class VlogDesignPathProviderCommon
implements IDesignPathProvider {
    public boolean validDesignScope(Object element) {
        return element instanceof RfModuleDef || element instanceof RfGenerateBlockDef || element instanceof RfPrimitiveDef || element instanceof RfProgramDef || element instanceof RfInterfaceDef || element instanceof RfCheckerDef;
    }

    public boolean interestingDesignElement(Object element) {
        return element instanceof RfInstanceDef || element instanceof RfPortDef || this.isNet(element);
    }

    private boolean isNet(Object element) {
        if (!(element instanceof RfFieldDef)) {
            return false;
        }
        RfNamedElement namedElement = ((RfFieldDef)element).getNamedElement();
        if (!(namedElement instanceof RfField)) {
            return false;
        }
        return ((RfField)namedElement).isNet();
    }

    public Set<IRfNamedElement> getNamedElementsSet(IRfDefElement defElement) {
        if (!(defElement instanceof RfDefElement)) {
            return Collections.emptySet();
        }
        return new HashSet<IRfNamedElement>(((RfDefElement)defElement).getNamedElements());
    }

    public boolean isInstanceDef(IRfDefElement defElem) {
        return defElem instanceof RfInstanceDef;
    }

    public boolean isPort(IRfFieldElement field) {
        return !field.isParameter() && !field.isTypeParameter() && field instanceof RfField;
    }

    public IRfNamedElement computeHyperlinkNamedElement(IRfNamedElement hyperlinkNamedElement, IRfDesignElement leafDesign, boolean inhibited) {
        List ports;
        if (inhibited) {
            return hyperlinkNamedElement;
        }
        if (this.useCurrentPath(hyperlinkNamedElement)) {
            return null;
        }
        if (hyperlinkNamedElement instanceof RfPort && (ports = leafDesign.getPortsWithPrefix("", 2)) != null && ports.contains(hyperlinkNamedElement)) {
            return null;
        }
        if (hyperlinkNamedElement instanceof RfField && ((RfField)hyperlinkNamedElement).isParameter()) {
            if (!(leafDesign instanceof RfNamedElement)) {
                return null;
            }
            List<RfField> parametersWithPrefix = ((RfNamedElement)leafDesign).getParametersWithPrefix("", 128, 2, 1);
            if (parametersWithPrefix != null && parametersWithPrefix.contains(hyperlinkNamedElement)) {
                return null;
            }
        }
        return hyperlinkNamedElement;
    }

    private boolean useCurrentPath(IRfNamedElement hyperlinkNamedElement) {
        if (hyperlinkNamedElement instanceof IRfDesignElement) {
            return false;
        }
        if (hyperlinkNamedElement instanceof RfPort) {
            return false;
        }
        return !(hyperlinkNamedElement instanceof RfField) || !((RfField)hyperlinkNamedElement).isParameter();
    }

    public void setSessionProperty(IProject project, DVTEditor editor, IDVTFileInstance instance, String path) {
        try {
            if (!(instance instanceof VlogFileInstance)) {
                return;
            }
            RfNamedElement semanticScope = ((VlogFileInstance)instance).getSemanticScope();
            if (semanticScope == null) {
                return;
            }
            IFile destinationFile = VlogFileUtils.getInstance().getProjectFile(project, path);
            if (destinationFile == null) {
                return;
            }
            ElementPath elementPath = DesignPathManager.getInstance().getPathFor(editor, (IRfNamedElement)semanticScope, false);
            destinationFile.setSessionProperty(IDVTConstants.PATH_FROM_INCLUDE_SCOPE_QN, (Object)elementPath);
            destinationFile.setSessionProperty(IDVTConstants.FILE_INSTANCE_QN, (Object)instance);
            destinationFile.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, new Object());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void checkPathFromInclude(IProject project, ElementPath elementPath, String path) {
        try {
            IFile destinationFile = VlogFileUtils.getInstance().getProjectFile(project, path);
            if (destinationFile == null) {
                return;
            }
            if (destinationFile.getSessionProperty(IDVTConstants.PATH_FROM_INCLUDE_SCOPE_QN) != null) {
                return;
            }
            destinationFile.setSessionProperty(IDVTConstants.PATH_FROM_INCLUDE_SCOPE_QN, (Object)elementPath);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public Map<IRfNamedElement, ElementPath> getAllPathsWithPrefix(Set<IRfNamedElement> bindings, ElementPath prefix, IProject project) {
        return DesignPathManagerUtils.getAllPathsWithPrefix(bindings, (ElementPath)prefix, (IProject)project);
    }
}

