/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtilsBase;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogAbstractQuickAssistProcessor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.CollectOperatorHidsInSelection;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;

public abstract class AbstractQuickAssistExtractProcessorCommon
extends VlogAbstractQuickAssistProcessor {
    protected RfDefElement fStartScope;
    protected RfDefElement fEndScope;
    protected RfDefElement fClosestContainer;
    protected String fSelectedText;
    protected int fStartOffset;
    protected int fEndOffset;

    protected AbstractQuickAssistExtractProcessorCommon(ITextViewer viewer) {
        super(viewer);
    }

    protected boolean init() {
        if (!super.init()) {
            return false;
        }
        ISelection selection = this.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        this.fSelectedText = textSelection.getText();
        this.fStartOffset = textSelection.getOffset();
        this.fEndOffset = textSelection.getOffset() + textSelection.getLength();
        this.fStartScope = (RfDefElement)RfUtilsBase.getRfScope((ITextEditor)this.fEditor, this.fDocument, this.fStartOffset);
        this.fEndScope = (RfDefElement)RfUtilsBase.getRfScope((ITextEditor)this.fEditor, this.fDocument, this.fEndOffset);
        if (!this.isSameScope()) {
            return false;
        }
        this.fClosestContainer = this.internalComputeClosestContainer();
        if (this.fClosestContainer == null) {
            return false;
        }
        return !this.fClosestContainer.hasVirtualOffsets();
    }

    private boolean checkOperator(RfHidOperator operator) {
        if (operator.getOpenBoundary() >= this.fStartOffset && operator.getCloseBoundary() <= this.fEndOffset) {
            return true;
        }
        if (operator.getCloseBoundary() > this.fEndOffset) {
            return false;
        }
        IHidObject rhValue = operator.getFirstRHValue();
        if (rhValue instanceof RfHidOperator && ((RfHidOperator)rhValue).getOpenBoundary() == operator.getOpenBoundary()) {
            return true;
        }
        return this.checkOperatorLeftSide(operator);
    }

    private boolean checkOperatorLeftSide(RfHidOperator operator) {
        if (operator.getOpenBoundary() >= this.fStartOffset) {
            return false;
        }
        int operatorPrecedence = VlogQuickAssistUtil.OperatorPrecedence.getOperatorPrecedence(operator);
        IHidObject lhValue = operator.getLHValue();
        while (lhValue instanceof RfHidOperator) {
            if (VlogQuickAssistUtil.OperatorPrecedence.getOperatorPrecedence((RfHidOperator)lhValue) > operatorPrecedence) {
                return false;
            }
            IHidObject rhValueOfLeftOperator = ((RfHidOperator)lhValue).getFirstRHValue();
            if (rhValueOfLeftOperator instanceof RfHidOperator && ((RfHidOperator)rhValueOfLeftOperator).getOpenBoundary() < this.fStartOffset) {
                return false;
            }
            HidOperatorOccurrence lhOperatorOccurrence = ((RfHidOperator)lhValue).getOccurrence();
            if (lhOperatorOccurrence == null) {
                return false;
            }
            if (lhOperatorOccurrence.getOffset() < this.fStartOffset && ((RfHidOperator)lhValue).getCloseBoundary() >= this.fStartOffset) {
                return true;
            }
            lhValue = ((RfHidOperator)lhValue).getLHValue();
        }
        return false;
    }

    private boolean checkCompleteOperators(RfDefElement scope) {
        CollectOperatorHidsInSelection operatorsInSelectionCollector = new CollectOperatorHidsInSelection(this.fEditor.getParserPath(), this.fStartOffset, this.fEndOffset);
        scope.getNamedElement().visitHidObject(null, operatorsInSelectionCollector);
        if (operatorsInSelectionCollector.getOperatorsInSelection().isEmpty()) {
            return true;
        }
        Set<RfHidOperator> operatorsToCheck = this.computeOperatorsToCheck(operatorsInSelectionCollector);
        this.setCompoundOperators(operatorsToCheck);
        if (operatorsToCheck == null || operatorsToCheck.isEmpty()) {
            return true;
        }
        for (RfHidOperator operator : operatorsToCheck) {
            if (this.checkOperator(operator)) continue;
            return false;
        }
        return true;
    }

    private Set<RfHidOperator> computeOperatorsToCheck(CollectOperatorHidsInSelection operatorsInSelectionCollector) {
        Iterator<RfHidOperator> iterator = operatorsInSelectionCollector.getOperatorsInSelection().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        RfHidOperator compoundOperator = iterator.next();
        LinkedHashSet<RfHidOperator> operatorsToCheck = new LinkedHashSet<RfHidOperator>();
        while (iterator.hasNext()) {
            RfHidOperator crtOperator = iterator.next();
            if (this.crtOperatorIsInsideCompound(compoundOperator, crtOperator)) continue;
            if (this.crtOperatorExtendsCompound(compoundOperator, crtOperator)) {
                compoundOperator = crtOperator;
                continue;
            }
            if (!operatorsToCheck.contains(compoundOperator)) {
                operatorsToCheck.add(compoundOperator);
            }
            compoundOperator = crtOperator;
        }
        if (!operatorsToCheck.contains(compoundOperator)) {
            operatorsToCheck.add(compoundOperator);
        }
        return operatorsToCheck;
    }

    private boolean crtOperatorExtendsCompound(RfHidOperator compoundOperator, RfHidOperator crtOperator) {
        return compoundOperator.getOpenBoundary() >= crtOperator.getOpenBoundary() && compoundOperator.getCloseBoundary() <= crtOperator.getCloseBoundary();
    }

    private boolean crtOperatorIsInsideCompound(RfHidOperator compoundOperator, RfHidOperator crtOperator) {
        return crtOperator.getOpenBoundary() >= compoundOperator.getOpenBoundary() && crtOperator.getCloseBoundary() <= compoundOperator.getCloseBoundary();
    }

    private boolean isForLoopStepOrInitOperator(RfHidOperator hidOperator) {
        if (!hidOperator.isForInit() && !hidOperator.isForStep()) {
            return false;
        }
        int offsetWithoutWS = this.fEndOffset;
        int i = this.fSelectedText.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(this.fSelectedText.charAt(i))) break;
            --offsetWithoutWS;
            --i;
        }
        if (hidOperator.getOpenBoundary() > this.fStartOffset || hidOperator.getCloseBoundary() < offsetWithoutWS) {
            return false;
        }
        IHidObject assignOperator = hidOperator.getLHValue();
        int assignOperatorOffset = ((RfHidOperator)assignOperator).getOffset();
        return this.fStartOffset >= hidOperator.getOpenBoundary() && this.fStartOffset < assignOperatorOffset;
    }

    private boolean selectedForLoopStepOrInitOperators() {
        final AtomicBoolean found = new AtomicBoolean(false);
        if (!(this.fStartScope instanceof RfActionBlockDef)) {
            return false;
        }
        List<RfNamedElement> namedElements = ((RfActionBlockDef)this.fStartScope).getNamedElements();
        if (namedElements == null) {
            return false;
        }
        for (RfNamedElement element : namedElements) {
            element.visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

                public boolean visit(HidOperator operator) {
                    if (found.get()) {
                        return false;
                    }
                    if (AbstractQuickAssistExtractProcessorCommon.this.fEndOffset < operator.getOpenBoundary()) {
                        return false;
                    }
                    if (AbstractQuickAssistExtractProcessorCommon.this.isForLoopStepOrInitOperator((RfHidOperator)operator)) {
                        found.set(true);
                        return false;
                    }
                    return true;
                }
            });
        }
        return found.get();
    }

    public boolean validate() {
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            String endOffsetContentType;
                            block14: {
                                block13: {
                                    block12: {
                                        block11: {
                                            try {
                                                if (!PrecompiledDBUtils.isManualPrecompiledFile((IProject)this.fRfProject.getProject(), (ParserPath)this.fEditor.getParserPath())) break block11;
                                                return false;
                                            }
                                            catch (Exception e) {
                                                DVTLogger.INSTANCE.logError((Throwable)e);
                                                return false;
                                            }
                                        }
                                        if (this.fStartOffset <= 0 || !Character.isJavaIdentifierPart(this.fDocument.get(this.fStartOffset - 1, 1).charAt(0))) break block12;
                                        return false;
                                    }
                                    if (this.fEndOffset >= this.fDocument.getLength() - 1 || !Character.isJavaIdentifierPart(this.fDocument.get(this.fEndOffset, 1).charAt(0))) break block13;
                                    return false;
                                }
                                String startOffsetContentType = ((IDocumentExtension3)this.fDocument).getContentType("__vlog_partitioning", this.fStartOffset, false);
                                endOffsetContentType = ((IDocumentExtension3)this.fDocument).getContentType("__vlog_partitioning", this.fEndOffset, false);
                                if (startOffsetContentType.equals("__dftl_partition_content_type") || this.fStartOffset <= 0 || ((IDocumentExtension3)this.fDocument).getContentType("__vlog_partitioning", this.fStartOffset - 1, false).equals("__dftl_partition_content_type")) break block14;
                                return false;
                            }
                            if (endOffsetContentType.equals("__dftl_partition_content_type") || this.fEndOffset >= this.fDocument.getLength() - 1 || ((IDocumentExtension3)this.fDocument).getContentType("__vlog_partitioning", this.fEndOffset - 1, false).equals("__dftl_partition_content_type") || ((IDocumentExtension3)this.fDocument).getContentType("__vlog_partitioning", this.fEndOffset + 1, false).equals("__dftl_partition_content_type")) break block15;
                            return false;
                        }
                        if (DVTDocumentUtils.hasNestedParentheses((IDocument)this.fDocument, (int)this.fStartOffset, (int)this.fEndOffset, (String)"__vlog_partitioning")) break block16;
                        return false;
                    }
                    if (!DVTQuickAssistUtil.selectionContainsOnlyLastPartOfHid((IRfDefElement)this.fClosestContainer, (int)this.fStartOffset, (int)this.fEndOffset)) break block17;
                    return false;
                }
                if (this.checkCompleteOperators(this.fClosestContainer)) break block18;
                return false;
            }
            if (!this.selectedForLoopStepOrInitOperators()) break block19;
            return false;
        }
        return !this.fSelectedText.trim().isEmpty();
    }

    protected abstract boolean isSameScope();

    protected abstract RfDefElement internalComputeClosestContainer();

    protected abstract void setCompoundOperators(Set<RfHidOperator> var1);

    protected abstract ISelection getSelection();
}

