/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

public class MethodObjectVisitor
implements IHidVisitor<IHidObject> {
    private int documentOffset;
    private RfHidAccessArgs found;

    public MethodObjectVisitor(int documentOffset) {
        this.documentOffset = documentOffset;
    }

    public boolean visit(IHidObject obj) {
        if (obj instanceof RfHid) {
            RfHidAccessArgs access = this.testHid((RfHid)obj);
            if (access != null) {
                this.found = access;
            }
            return this.found == null;
        }
        if (obj instanceof RfHidOperator) {
            final ArrayList collected = new ArrayList(4);
            Predicate<IHidObject> cons = new Predicate<IHidObject>(){

                @Override
                public boolean test(IHidObject element) {
                    if (element instanceof RfHidAccessArgs && ((RfHidAccessArgs)element).isMethodCall(false)) {
                        collected.add(((RfHidAccessArgs)element).getParentHid());
                    } else if (element instanceof RfHid && ((RfHid)element).isMethodCall(false)) {
                        collected.add((RfHid)element);
                    }
                    return true;
                }
            };
            HidUtils.flattenToObjects((Predicate)cons, (IHidObject)obj, (Set)HidFlatteningOption.NONE_EXCLUDED);
            if (collected.isEmpty()) {
                return true;
            }
            for (Hid coll : collected) {
                RfHidAccessArgs methodObj = this.testHid(coll);
                if (methodObj == null) continue;
                this.found = methodObj;
                return false;
            }
        }
        return true;
    }

    private RfHidAccessArgs testHid(Hid obj) {
        if (!obj.isMethodCall(false)) {
            return null;
        }
        if (!obj.hasAccesses()) {
            return null;
        }
        ListContainer accesses = obj.getAccesses();
        String name = obj.getName();
        if (name != null) {
            name.length();
        }
        for (HidAccess currAccess : accesses) {
            int closedBoundary;
            Region region;
            boolean inRegion;
            if (!(currAccess instanceof RfHidAccessArgs) || !((RfHidAccessArgs)currAccess).isMethodCall(false)) continue;
            HidOccurrence occurrence = ((RfHidAccessArgs)currAccess).getOccurrence();
            int offset = occurrence.getOffset();
            List<? extends IHidObject> argumentValues = ((RfHidAccessArgs)currAccess).getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty() || !(inRegion = DVTDocumentUtils.regionContains((IRegion)(region = new Region(offset, (closedBoundary = MethodCallUtils.getClosedBoundary((IHidObject)argumentValues.get(argumentValues.size() - 1))) - offset)), (int)this.documentOffset))) continue;
            return (RfHidAccessArgs)currAccess;
        }
        return null;
    }

    public IHidObject getFound() {
        return this.found;
    }

    public void setFound(RfHidAccessArgs methodObj) {
        this.found = methodObj;
    }

    public Class<IHidObject> getType() {
        return IHidObject.class;
    }

    public IRfNamedElement getMethodNamedElement() {
        return this.found != null && this.found.getParentHid() != null ? this.found.getParentHid().getElement() : null;
    }

    public List<? extends IHidObject> getArgumentValues() {
        return this.found != null ? this.found.getArgumentValues() : null;
    }

    public int getMethodStartOffset() {
        if (this.found == null) {
            return -1;
        }
        HidOccurrence occurrence = this.found.getOccurrence();
        if (occurrence == null) {
            return -1;
        }
        return occurrence.getOffset();
    }

    public int getMethodEndOffset() {
        if (this.found == null) {
            return -1;
        }
        Hid parentHid = this.found.getParentHid();
        if (parentHid == null) {
            return this.getMethodStartOffset();
        }
        String parentName = parentHid.getName();
        int parentNameLength = parentName != null ? parentName.length() : 1;
        List<? extends IHidObject> argumentValues = this.getArgumentValues();
        if (argumentValues == null || argumentValues == Collections.emptyList()) {
            return this.getMethodStartOffset();
        }
        int start = this.getMethodStartOffset();
        return argumentValues.isEmpty() ? start + parentNameLength + 2 : MethodCallUtils.getClosedBoundary((IHidObject)argumentValues.get(argumentValues.size() - 1));
    }
}

