/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistConnectInstancePortsProposal;

public class QuickAssistConnectInstancePortsByPositionProposal
extends QuickAssistConnectInstancePortsProposal {
    public QuickAssistConnectInstancePortsByPositionProposal(IFile file, DVTEditor editor, IDocument document, IRfInstanceElement instance, List<IHidOperator> instancePCs, IRfDesignElement designElement, List<? extends IRfPortElement> designPorts) {
        super(file, editor, document, instance, instancePCs, designElement, designPorts);
        this.displayString = "Connect instance '" + instance.getName() + "' ports by position";
        this.isNamed = true;
    }

    @Override
    protected CreateChangeStatus createChanges(Map<String, QuickAssistConnectInstancePortsProposal.PortConnectionInfo> portInfos) throws Exception {
        for (QuickAssistConnectInstancePortsProposal.PortConnectionInfo portInfo : portInfos.values()) {
            int portStartOffset = portInfo.getPortStartOffset();
            int portEndOffset = portInfo.getPortEndOffset();
            int dotOffset = DVTDocumentUtils.getCharOffset((char)'.', (int)portStartOffset, (boolean)false, (int)100, (IDocument)this.document, (String)"__vlog_partitioning") - 1;
            if (dotOffset < 0) {
                this.textFileChange = null;
                return CreateChangeStatus.ERROR;
            }
            DeleteEdit deleteEdit = new DeleteEdit(dotOffset, portEndOffset - dotOffset);
            this.textFileChange.addEdit((TextEdit)deleteEdit);
        }
        int i = 0;
        while (i < this.designPorts.size()) {
            IRfPortElement designPort = (IRfPortElement)this.designPorts.get(i);
            String portName = designPort.getName();
            if (portName == null || !portInfos.containsKey(portName)) {
                this.textFileChange = null;
                return CreateChangeStatus.ERROR;
            }
            int openBoundary = PortConnectionUtils.getOpenBoundary((IHidOperator)((IHidOperator)this.instancePC.get(i)));
            int insertOffset = DVTDocumentUtils.getCharOffset((char)'.', (int)openBoundary, (boolean)false, (int)100, (IDocument)this.document, (String)"__vlog_partitioning") - 1;
            if (insertOffset < 0) {
                this.textFileChange = null;
                return CreateChangeStatus.ERROR;
            }
            QuickAssistConnectInstancePortsProposal.PortConnectionInfo portInfo = portInfos.get(portName);
            String signalExp = portInfo.getSignalExp();
            InsertEdit insertEdit = new InsertEdit(insertOffset, signalExp);
            this.textFileChange.addEdit((TextEdit)insertEdit);
            ++i;
        }
        return CreateChangeStatus.OK;
    }

    protected String getProposalName() {
        return "Connect instance ports by position";
    }
}

