/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class QuickAssistConnectInstancePortsProposal
extends DVTAbstractQuickAssistProposal {
    protected IRfInstanceElement instance;
    protected List<IHidOperator> instancePC;
    protected IRfDesignElement designElement;
    protected String displayString;
    protected List<? extends IRfPortElement> designPorts;
    protected boolean isNamed;
    private Map<String, PortConnectionInfo> portInfos;

    protected QuickAssistConnectInstancePortsProposal(IFile file, DVTEditor editor, IDocument document, IRfInstanceElement instance, List<IHidOperator> instancePCs, IRfDesignElement designElement, List<? extends IRfPortElement> designPorts) {
        this.file = file;
        this.editor = editor;
        this.document = document;
        this.instance = instance;
        this.instancePC = instancePCs;
        this.designElement = designElement;
        this.designPorts = designPorts;
        this.textFileChange = new VlogTextFileChange(file.getProjectRelativePath().toOSString(), file);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
    }

    protected void preApplyQuickAssist(IDocument document) throws Exception {
        this.portInfos = this.getInfosByPortConnections();
        if (this.portInfos.isEmpty() || this.portInfos.keySet().size() != this.designPorts.size()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public void applyQuickAssist(IDocument document) {
        this.performChanges();
    }

    protected void performChanges() {
        try {
            DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.editor, this.document, this.getDisplayString(), (Change)this.textFileChange);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected Map<String, PortConnectionInfo> getInfosByPortConnections() throws Exception {
        HashMap<String, PortConnectionInfo> portValuesByPortName = new HashMap<String, PortConnectionInfo>();
        int i = 0;
        while (i < this.instancePC.size()) {
            IRfPortElement portElem = this.designPorts.get(i);
            IHidOperator port = this.instancePC.get(i);
            if (portElem == null || port == null) {
                return Collections.emptyMap();
            }
            String portName = this.isNamed ? PortConnectionUtils.getPortName((IHidOperator)port) : portElem.getName();
            int portStartOffset = PortConnectionUtils.getOpenBoundary((IHidOperator)port);
            int portEndOffset = PortConnectionUtils.getClosedBoundary((IHidOperator)port);
            if (portStartOffset < 0 || portEndOffset < 0) {
                return Collections.emptyMap();
            }
            int signalExpStartOffset = -1;
            int signalExpEndOffset = -1;
            if (this.isNamed) {
                int openBracketOffset = DVTDocumentUtils.getCharOffset((char)'(', (int)portStartOffset, (boolean)true, (int)100, (IDocument)this.document, (String)"__vlog_partitioning");
                if (openBracketOffset < 0) {
                    return Collections.emptyMap();
                }
                int closedBracketOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)openBracketOffset, (DVTEditor)this.editor, (IDocument)this.document);
                if (closedBracketOffset < 0) {
                    return Collections.emptyMap();
                }
                signalExpStartOffset = openBracketOffset + 1;
                signalExpEndOffset = closedBracketOffset - 1;
            } else if (this.emptyPortConnection(portStartOffset, portEndOffset)) {
                signalExpStartOffset = signalExpEndOffset = (portStartOffset = (portEndOffset = portStartOffset + 1));
            } else {
                signalExpStartOffset = portStartOffset;
                signalExpEndOffset = portEndOffset;
            }
            if (signalExpStartOffset < 0 || signalExpEndOffset < 0) {
                return Collections.emptyMap();
            }
            String signalExp = this.document.get(signalExpStartOffset, signalExpEndOffset - signalExpStartOffset);
            if (signalExp == null) {
                return Collections.emptyMap();
            }
            portValuesByPortName.put(portName, new PortConnectionInfo(portStartOffset, portEndOffset, signalExp));
            ++i;
        }
        return portValuesByPortName;
    }

    protected boolean emptyPortConnection(int argumentStart, int argumentEnd) throws BadLocationException {
        return argumentEnd - argumentStart == 1 && (this.document.get(argumentStart, 1).equals("(") || this.document.get(argumentStart, 1).equals(","));
    }

    public String getDisplayStringInternal() {
        return this.displayString;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE_INSTANCE);
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.textFileChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        return this.createChanges(this.portInfos);
    }

    protected abstract CreateChangeStatus createChanges(Map<String, PortConnectionInfo> var1) throws Exception;

    static class PortConnectionInfo {
        private int portStartOffset;
        private int portEndOffset;
        private String signalExp;

        public PortConnectionInfo(int portStartOffset, int portEndOffset, String signalExp) {
            this.portStartOffset = portStartOffset;
            this.portEndOffset = portEndOffset;
            this.signalExp = signalExp;
        }

        public int getPortStartOffset() {
            return this.portStartOffset;
        }

        public int getPortEndOffset() {
            return this.portEndOffset;
        }

        public String getSignalExp() {
            return this.signalExp;
        }
    }
}

