/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.PortConnectionUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtilCommon;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtilCommon;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;

public abstract class QuickAssistExpandDotStarProposalCommon
extends DVTAbstractQuickAssistProposal {
    private static final String EXPAND_DOT_STAR_NOTATION_CATEGORY = "EXPAND_DOT_STAR_NOTATION";
    private static final int DOT_STAR_TEXT_LENGTH = 2;
    private Collection<? extends IRfPortElement> designPorts;
    private int offset;
    private RfNamedElement elementAtCursor;
    private LinkedModeModel linkedProposalModel;
    private String displayString;
    private DVTLinkedPositionProvider linkedPositionProvider;
    private IRfDesignElement designElement;
    private IRfScope rfScope;
    private IPreferenceStore store;

    protected QuickAssistExpandDotStarProposalCommon(IFile file, DVTEditor editor, IDocument document, int offset, RfNamedElement elementAtCursor, Collection<? extends IRfPortElement> designPorts, IRfDesignElement designElement, IRfScope rfScope) {
        this.file = file;
        this.editor = editor;
        this.document = document;
        this.offset = offset;
        this.elementAtCursor = elementAtCursor;
        this.linkedProposalModel = new LinkedModeModel();
        this.displayString = "Expand .* port connections";
        this.designPorts = designPorts;
        this.designElement = designElement;
        this.rfScope = rfScope;
        this.store = VlogPlugin.getDefault().getPreferenceStore();
    }

    public CreateChangeStatus createQuickAssistChanges() throws Exception {
        if (this.designPorts.isEmpty()) {
            return CreateChangeStatus.ERROR;
        }
        int insertOffset = this.computeInsertOffset();
        if (insertOffset < 0) {
            return CreateChangeStatus.ERROR;
        }
        String replacementString = this.computeReplacementString(insertOffset);
        LinkedHashMap<String, List<IRegion>> trackedRegionsByCategory = new LinkedHashMap<String, List<IRegion>>();
        trackedRegionsByCategory.put(EXPAND_DOT_STAR_NOTATION_CATEGORY, this.computeTrackedRegions(this.designPorts, replacementString));
        this.textFileChange = new VlogTextFileChange(this.file.getProjectRelativePath().toOSString(), this.file);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        DeleteEdit deleteEdit = new DeleteEdit(insertOffset, 2);
        this.textFileChange.addEdit((TextEdit)deleteEdit);
        InsertEdit insertEdit = new InsertEdit(insertOffset, replacementString);
        this.textFileChange.addEdit((TextEdit)insertEdit, trackedRegionsByCategory);
        return CreateChangeStatus.OK;
    }

    public int computeInsertOffset() {
        HashSet<Class<RfModule>> classes = new HashSet<Class<RfModule>>();
        classes.add(RfModule.class);
        RfDefElement closestContainer = VlogQuickFixUtilCommon.getClosestContainerDef(this.elementAtCursor, this.offset, classes);
        if (closestContainer == null) {
            return -1;
        }
        int instanceStartOffset = ((RfInstance)this.elementAtCursor).getStartOffset();
        int instanceEndOffset = ((RfInstance)this.elementAtCursor).getEndOffset();
        int rightBracketOffset = instanceEndOffset;
        if (rightBracketOffset <= instanceStartOffset) {
            return -1;
        }
        int leftBracketOffset = DVTDocumentUtils.getMatchingLeftBracketOffset((int)rightBracketOffset, (DVTEditor)this.editor, (IDocument)this.document);
        if (leftBracketOffset < 0) {
            return -1;
        }
        int insertOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(this.document, ".*", leftBracketOffset, rightBracketOffset, false) - 2;
        if (insertOffset >= rightBracketOffset) {
            return -1;
        }
        return insertOffset;
    }

    protected String computeReplacementString(int insertOffset) throws BadLocationException, TemplateException {
        List<IHidOperator> instancePortOperators = ((RfInstance)this.elementAtCursor).getHidOperators(ELConstants.PORT_AND_GENERIC_VALUES_QUALIFIERS_ARRAY, true);
        ArrayList<IRfPortElement> instancePorts = new ArrayList<IRfPortElement>();
        if (instancePortOperators != null) {
            for (IHidOperator instancePC : instancePortOperators) {
                IHid instancePortHid = PortConnectionUtils.getPortHid((IHidOperator)instancePC);
                IRfNamedElement instancePort = instancePortHid.getElement();
                if (!(instancePort instanceof IRfPortElement)) continue;
                instancePorts.add((IRfPortElement)instancePort);
            }
        }
        if (!instancePorts.isEmpty()) {
            this.designPorts.removeAll(instancePorts);
        }
        boolean preserveComments = PrefConst.isPreserveComments(this.store);
        boolean groupByDirection = PrefConst.isGroupPortsByDirection(this.store);
        boolean sortAlphabetically = PrefConst.isSortPortAlphabetically(this.store);
        String instanceAlignment = DVTDocumentUtils.getIndent((int)insertOffset, (IDocument)this.document);
        String portAlignment = String.valueOf(instanceAlignment) + DVTDocumentUtils.getTabOrSpace((DVTEditor)this.editor, (IPreferenceStore)this.store);
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.editor);
        StringBuilder replacementStringBuilder = new StringBuilder();
        if (groupByDirection) {
            String portsGroupedByDirection = VlogContentAssistUtilCommon.getPortsGroupedByDirection(this.designPorts, instanceAlignment, portAlignment, false, sortAlphabetically, false, preserveComments, lineDelimiter, this.designElement, this.rfScope, new StringBuilder(), true);
            replacementStringBuilder.append(portsGroupedByDirection);
        } else {
            replacementStringBuilder.append(VlogContentAssistUtilCommon.addPorts(!(this.designElement instanceof RfPrimitive), this.designPorts, true, null, portAlignment, false, lineDelimiter, sortAlphabetically, preserveComments));
            replacementStringBuilder.append(lineDelimiter).append(instanceAlignment);
        }
        Region region = new Region(insertOffset, replacementStringBuilder.length());
        TemplateContext context = VlogContentAssistUtilCommon.createDummyContext(this.document, (IRegion)region);
        Template template = new Template("", this.displayString, "ro.amiq.vlogdt.templates.contextType.unknown", replacementStringBuilder.toString(), true);
        TemplateBuffer templateBuffer = context.evaluate(template);
        replacementStringBuilder = new StringBuilder(templateBuffer.getString());
        boolean insertLineDelimiterAtBegining = !DVTDocumentUtils.isEmptyLineBefore((int)insertOffset, (IDocument)this.document, (String)"__vlog_partitioning");
        boolean insertLineDelimiterAtEnd = DVTDocumentUtils.isOnTheSameLine((IDocument)this.document, (int)((RfInstance)this.elementAtCursor).getEndOffset(), (int)insertOffset);
        replacementStringBuilder.insert(0, insertLineDelimiterAtBegining ? String.valueOf(lineDelimiter) + instanceAlignment : "");
        replacementStringBuilder.insert(replacementStringBuilder.length(), insertLineDelimiterAtEnd ? String.valueOf(lineDelimiter) + instanceAlignment : "");
        return replacementStringBuilder.toString();
    }

    protected List<IRegion> computeTrackedRegions(Collection<? extends IRfPortElement> ports, String replacementString) {
        if (ports == null) {
            return Collections.emptyList();
        }
        LinkedList<IRegion> trackedRegions = new LinkedList<IRegion>();
        for (IRfPortElement iRfPortElement : ports) {
            trackedRegions.addAll(VlogQuickFixUtil.getInstance().getLinkedRegionsForSignalName(replacementString, iRfPortElement.getName()));
        }
        return trackedRegions;
    }

    protected void addLinkedPositions() throws Exception {
        this.linkedPositionProvider = new DVTLinkedPositionProvider(this.editor, this.linkedProposalModel, this.getCategory(), true, this.textFileChange);
        Collection portNameRegions = this.textFileChange.getAbsoluteRegionsByCategory(EXPAND_DOT_STAR_NOTATION_CATEGORY);
        if (portNameRegions == null || portNameRegions.isEmpty()) {
            return;
        }
        for (IRegion region : portNameRegions) {
            this.linkedPositionProvider.addSingleLinkedPosition(region.getOffset(), region.getLength(), this.document);
        }
        this.linkedPositionProvider.enterLinkedMode(this.document, null);
    }

    public IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.textFileChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public String getDisplayStringInternal() {
        return this.displayString;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.SHOW_HIDE_PORTS);
    }

    protected String getCategory() {
        return "QuickAssistProposalCategory_" + ((Object)((Object)this)).toString();
    }

    protected String getProposalName() {
        return "Expand .* port connections";
    }
}

