/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.vlogdt.model.reflection.DataExpressionType;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.ui.editor.quickassist.util.CollectHidsFromSelectionVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.CollectOperatorHidsInSelection;
import ro.amiq.vlogdt.ui.editor.quickassist.util.QuickAssistInputOutputHidsVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.CollectMethodCallsInRegionVisitor;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateConfig;
import ro.amiq.vlogdt.ui.views.templates.VlogMethodTemplateInserter;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class QuickAssistExtractMethodProposalCommon
extends DVTAbstractQuickAssistProposal {
    private static final String SEMI_COLON = ";";
    private static final String NEWLINE = System.lineSeparator();
    private static final String FUNCTION_NAME = "extracted";
    private static final String VOID = "void";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String INOUT = "inout";
    private static final String REF = "ref";
    private String displayString;
    private DVTEditor triggerEditor;
    protected DVTEditor targetEditor;
    protected LinkedModeModel linkedProposalModel;
    protected VlogTextFileChange triggerChange;
    protected VlogTextFileChange targetChange;
    protected DVTLinkedPositionProvider linkedPositionMaker;
    private int startOffset;
    private int endOffset;
    private String selectedText;
    private RfDefElement triggerEnclContainerDefElement;
    private IFile triggerFile;
    protected boolean isTask;
    protected IDocument targetDoc;
    protected IDocument triggerDoc;
    protected boolean isExtern;
    private IFile targetIFile;
    protected boolean shouldDisconnectTarget;
    protected ITextFileBufferManager targetBufferManager;
    private Set<RfHidOperator> compoundOperators;
    private String selectedTextWithoutBoundaryParentheses;
    protected String specifiedFunctionName = "";
    protected boolean isSelectionContainsTimeConsumingAction;
    private boolean hasComputedTimeConsumingAction;
    protected IPath path;
    protected LocationKind locationKind;

    protected QuickAssistExtractMethodProposalCommon(String displayString, int startOffset, int endOffset, String selectedText, RfDefElement selectionEnclosingContainer, IFile file, boolean isTask, Set<RfHidOperator> compoundOperators) {
        this.displayString = displayString;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.selectedText = selectedText;
        this.triggerEnclContainerDefElement = selectionEnclosingContainer;
        this.triggerFile = file;
        this.isTask = isTask;
        this.linkedProposalModel = new LinkedModeModel();
        this.specifiedFunctionName = FUNCTION_NAME;
        this.compoundOperators = compoundOperators;
    }

    protected void preApplyQuickAssist(IDocument document) {
        this.targetDoc = this.document = document;
        this.targetEditor = this.triggerEditor = (DVTEditor)DVTUiUtils.getEditor((IDocument)document);
        if (this.triggerEditor == null) {
            DVTQuickAssistUtil.popSomethingWentWrong((String)this.displayString);
            return;
        }
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        CreateChangeStatus status = this.createChanges();
        if (status != CreateChangeStatus.OK) {
            return status;
        }
        this.compositeChange = this.createCompositeChange();
        if (this.compositeChange == null) {
            return CreateChangeStatus.ERROR;
        }
        return CreateChangeStatus.OK;
    }

    private CompositeChange createCompositeChange() {
        CompositeChange compositeChange = new CompositeChange("Quick fix extract method");
        if (this.targetChange != null && !this.targetDoc.equals(this.triggerDoc)) {
            VlogQuickFixUtil.getInstance().addChangesInOrderToComposite(compositeChange, this.triggerChange, this.targetChange);
        } else {
            compositeChange.add((Change)this.triggerChange);
        }
        return compositeChange;
    }

    protected void addLinkedPositions(IDocument documentWithLinkedPosition, VlogTextFileChange changeWithLinkedPosition, VlogTextFileChange secondaryChange, IDocument secondaryDocument) throws Exception {
        ArrayList allRegions = new ArrayList();
        Collection linkedPositionRegions = changeWithLinkedPosition.getAbsoluteRegions();
        allRegions.addAll(linkedPositionRegions);
        if (secondaryChange != null) {
            Collection secondaryRegions = secondaryChange.getAbsoluteRegions();
            if (documentWithLinkedPosition.equals(secondaryDocument)) {
                allRegions.addAll(secondaryRegions);
            }
        }
        this.linkedPositionMaker.addMultipleLinkedPosition(allRegions, documentWithLinkedPosition, -1);
        this.linkedPositionMaker.enterLinkedMode(documentWithLinkedPosition, null);
    }

    public final CreateChangeStatus createChanges() throws Exception {
        IRegion endLineInfo;
        RfNamedElement triggerEnclContainerNamedElement = this.triggerEnclContainerDefElement.getNamedElement();
        this.triggerDoc = this.document;
        this.triggerChange = new VlogTextFileChange(this.triggerFile.getProjectRelativePath().toOSString(), this.triggerFile);
        boolean bl = this.isExtern = triggerEnclContainerNamedElement instanceof RfFunction && triggerEnclContainerNamedElement.isExtern();
        if (this.isExtern) {
            RfDefElement targetFunction = VlogQuickFixUtil.getInstance().getFunctionDeclaration(triggerEnclContainerNamedElement);
            triggerEnclContainerNamedElement = targetFunction.getNamedElement();
            if (triggerEnclContainerNamedElement == null) {
                return CreateChangeStatus.ERROR;
            }
            RfNamedElement triggerContainerScopeElement = triggerEnclContainerNamedElement.getEnclosingScope();
            if (triggerContainerScopeElement == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            RfDefElement triggerContainerScopeDef = triggerContainerScopeElement.getDeclaration();
            if (!this.initFileChangeForExternFunction(triggerContainerScopeDef)) {
                return CreateChangeStatus.ERROR;
            }
            endLineInfo = this.targetDoc.getLineInformationOfOffset(targetFunction.getEndOffset());
        } else {
            endLineInfo = this.document.getLineInformationOfOffset(this.triggerEnclContainerDefElement.getEndOffset());
        }
        int insertOffset = endLineInfo.getOffset() + endLineInfo.getLength();
        if (triggerEnclContainerNamedElement == null) {
            return CreateChangeStatus.ERROR;
        }
        QuickAssistInputOutputHidsVisitor inputOutputInoutHidsVisitor = this.collectHids(triggerEnclContainerNamedElement);
        if (inputOutputInoutHidsVisitor == null) {
            return CreateChangeStatus.ERROR;
        }
        if (!this.hasComputedTimeConsumingAction) {
            this.computeSelectionContainsTimeConsumingAction();
        }
        if (this.isSelectionContainsTimeConsumingAction && this.popUpTimeConsumingMethod() == CreateChangeStatus.CANCEL) {
            return CreateChangeStatus.CANCEL;
        }
        this.computeEdits(inputOutputInoutHidsVisitor, this.isExtern, triggerEnclContainerNamedElement, insertOffset);
        return CreateChangeStatus.OK;
    }

    protected void computeSelectionContainsTimeConsumingAction() {
        RfNamedElement triggerEnclContainerNamedElement = this.triggerEnclContainerDefElement.getNamedElement();
        QuickAssistInputOutputHidsVisitor inputOutputInoutHidsVisitor = this.collectHids(triggerEnclContainerNamedElement);
        this.isSelectionContainsTimeConsumingAction = this.selectionContainsTimeConsumingAction(inputOutputInoutHidsVisitor, triggerEnclContainerNamedElement);
        this.hasComputedTimeConsumingAction = true;
    }

    protected boolean selectionContainsTimeConsumingAction(QuickAssistInputOutputHidsVisitor inputOutputInoutHidsVisitor, RfNamedElement triggerContainerNamedElement) {
        if (triggerContainerNamedElement == null) {
            return false;
        }
        Collection<IHid> allOutputHids = inputOutputInoutHidsVisitor.getOutputHids();
        allOutputHids.addAll(inputOutputInoutHidsVisitor.getRefHids());
        if (allOutputHids.isEmpty()) {
            return false;
        }
        Iterator<IHid> outputsIterator = allOutputHids.iterator();
        CollectOperatorHidsInSelection operatorsInSelection = new CollectOperatorHidsInSelection(this.triggerEnclContainerDefElement.getParserPath(), this.startOffset, this.endOffset);
        while (outputsIterator.hasNext()) {
            IHid currentHid = outputsIterator.next();
            int currentHidOffset = VlogQuickFixUtil.getInstance().getHidOffsetInRegion(currentHid, (IRegion)new Region(this.startOffset, this.endOffset - this.startOffset));
            if (currentHidOffset < 0) continue;
            operatorsInSelection.setStartOffset(currentHidOffset);
            triggerContainerNamedElement.visitHidObject(null, operatorsInSelection);
            if (!operatorsInSelection.containsTimeComsumingOperators()) continue;
            return true;
        }
        return false;
    }

    private boolean initFileChangeForExternFunction(RfDefElement triggerElementScope) throws CoreException {
        RfFileDef targetFile = triggerElementScope.getDefFile();
        IResource targetFileAdapter = targetFile.getFileAdapter();
        if (!(targetFileAdapter instanceof IFile)) {
            return false;
        }
        this.targetIFile = (IFile)targetFileAdapter;
        this.targetBufferManager = FileBuffers.getTextFileBufferManager();
        TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(this.targetIFile);
        this.path = textFileBufferInfo.getPath();
        this.locationKind = textFileBufferInfo.getLocationKind();
        ITextFileBuffer textFileBuffer = this.targetBufferManager.getTextFileBuffer(this.path, this.locationKind);
        this.shouldDisconnectTarget = false;
        if (textFileBuffer == null) {
            this.shouldDisconnectTarget = true;
            this.targetBufferManager.connect(this.path, this.locationKind, null);
            textFileBuffer = this.targetBufferManager.getTextFileBuffer(this.path, this.locationKind);
        }
        IDocument targetDoc = null;
        if (textFileBuffer != null) {
            targetDoc = textFileBuffer.getDocument();
        }
        if (targetDoc == null) {
            return false;
        }
        this.targetDoc = targetDoc;
        this.targetChange = new VlogTextFileChange(targetFileAdapter.getProjectRelativePath().toOSString(), (IFile)targetFileAdapter);
        return true;
    }

    private QuickAssistInputOutputHidsVisitor collectHids(RfNamedElement selectionEnclosingContainer) {
        QuickAssistInputOutputHidsVisitor inputOutputHidsVisitor = new QuickAssistInputOutputHidsVisitor(this.startOffset, this.endOffset);
        selectionEnclosingContainer.visitHidObject(null, inputOutputHidsVisitor);
        CollectMethodCallsInRegionVisitor hidsInSelectionVisitor = new CollectMethodCallsInRegionVisitor((IRegion)new Region(this.startOffset, this.endOffset - this.startOffset));
        selectionEnclosingContainer.visitHidObject(null, hidsInSelectionVisitor);
        List<IHidAccessArgs> argumentsHid = hidsInSelectionVisitor.getArgsInRegion();
        inputOutputHidsVisitor.processHidsFromMethodCall(argumentsHid);
        inputOutputHidsVisitor.computeOutInRefsAndInouts();
        CollectHidsFromSelectionVisitor hidsInSelectionOperators = new CollectHidsFromSelectionVisitor(this.startOffset, this.endOffset);
        selectionEnclosingContainer.visitHidObject(null, hidsInSelectionOperators);
        inputOutputHidsVisitor.addExtraInputs(hidsInSelectionOperators.getHidsInSelection());
        return inputOutputHidsVisitor;
    }

    private void computeEdits(QuickAssistInputOutputHidsVisitor inputOutputHidsVisitor, boolean isExtern, RfNamedElement selectionEnclosingContainer, int insertOffset) throws Exception {
        RfNamedElement enclosingContainerScope = selectionEnclosingContainer.getEnclosingScope();
        String returnTypeName = this.computeReturnType(selectionEnclosingContainer);
        String argsName = this.computeFunctionArgs(inputOutputHidsVisitor, false, false, false, false);
        boolean isInsideOperator = this.checkIfInsideOperator(selectionEnclosingContainer);
        boolean nextCodeCharIsSemicolon = this.nextCodeCharIsSemicolon();
        String replaceFunction = this.computeReplaceFunction(argsName, isInsideOperator, nextCodeCharIsSemicolon);
        int functionUsageChangeRelativeOffset = replaceFunction.indexOf(this.specifiedFunctionName);
        ReplaceEdit replaceEdit = new ReplaceEdit(this.startOffset, this.selectedText.length(), replaceFunction);
        String functionArguments = this.computeFunctionArgs(inputOutputHidsVisitor, true, true, true, true);
        if (isExtern && this.targetDoc.equals(this.triggerDoc) || !isExtern) {
            this.triggerChange.setEdit((TextEdit)new MultiTextEdit());
            this.triggerChange.addEdit((TextEdit)replaceEdit, (IRegion)new Region(functionUsageChangeRelativeOffset, this.specifiedFunctionName.length()));
            this.addInsertEdit(this.triggerChange, enclosingContainerScope, functionArguments, argsName, insertOffset, returnTypeName, nextCodeCharIsSemicolon);
        } else {
            this.triggerChange.setEdit((TextEdit)new MultiTextEdit());
            this.triggerChange.addEdit((TextEdit)replaceEdit, (IRegion)new Region(functionUsageChangeRelativeOffset, this.specifiedFunctionName.length()));
            this.targetChange.setEdit((TextEdit)new MultiTextEdit());
            this.targetEditor = (DVTEditor)DVTUiUtils.getEditor((IDocument)this.document);
            this.addInsertEdit(this.targetChange, enclosingContainerScope, functionArguments, argsName, insertOffset, returnTypeName, nextCodeCharIsSemicolon);
        }
    }

    private String computeReplaceFunction(String argsName, boolean isInsideOperator, boolean nextCodeCharIsSemicolon) throws BadLocationException {
        String replaceFunction = String.valueOf(this.specifiedFunctionName) + "(" + argsName + ")";
        if (!isInsideOperator && !nextCodeCharIsSemicolon || isInsideOperator && this.selectedText.endsWith(SEMI_COLON)) {
            replaceFunction = String.valueOf(replaceFunction) + SEMI_COLON;
        }
        boolean selectionAtEndOfLine = true;
        char endChar = this.document.getChar(this.endOffset);
        int padding = 0;
        while (!NEWLINE.equals(String.valueOf(endChar))) {
            if (!Character.isWhitespace(endChar)) {
                selectionAtEndOfLine = false;
                break;
            }
            endChar = this.document.getChar(this.endOffset + ++padding);
        }
        return selectionAtEndOfLine ? String.valueOf(replaceFunction) + NEWLINE : replaceFunction;
    }

    private boolean checkIfInsideOperator(RfNamedElement selectionEnclosingContainer) {
        final AtomicBoolean context = new AtomicBoolean(false);
        final int nofLeadingWhitespaces = DVTStringUtil.countLeadingWhitespaces((String)this.selectedText);
        final int nofEndingWhitespaces = DVTStringUtil.countEndingWhitespaces((String)this.selectedText);
        selectionEnclosingContainer.getNamedElement().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (hidOperator.getOpenBoundary() <= QuickAssistExtractMethodProposalCommon.this.startOffset + nofLeadingWhitespaces && hidOperator.getCloseBoundary() >= QuickAssistExtractMethodProposalCommon.this.endOffset - nofEndingWhitespaces) {
                    IHidObject firstRHValue = hidOperator.getFirstRHValue();
                    if (firstRHValue != null && firstRHValue instanceof IHid && ((IHid)firstRHValue).getReparseInfo() != null) {
                        return false;
                    }
                    context.set(true);
                    return false;
                }
                return true;
            }
        });
        return context.get();
    }

    private boolean nextCodeCharIsSemicolon() throws BadLocationException {
        int nextCodeCharOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)this.document, (int)this.endOffset, (boolean)true, (String)"__vlog_partitioning", (boolean)false, (boolean)false) - 1;
        return this.document.getChar(nextCodeCharOffset) == ';';
    }

    private String computeReturnType(RfNamedElement selectionEnclosingContainer) {
        int adjustEndOfStatement = this.selectedText.trim().endsWith(SEMI_COLON) ? -1 : 0;
        String selectedTextWithoutSemicolon = this.selectedText.substring(0, this.selectedText.length() + adjustEndOfStatement);
        this.selectedTextWithoutBoundaryParentheses = VlogQuickAssistUtil.computeSelectedTextWithoutOptionalBoundaries(selectedTextWithoutSemicolon);
        TypeName type = VlogQuickAssistUtil.computeReturnTypeName(this.triggerEnclContainerDefElement.getRfProject(), this.document, this.triggerEnclContainerDefElement.getParserPath(), null, this.startOffset, this.endOffset + adjustEndOfStatement, selectedTextWithoutSemicolon, selectionEnclosingContainer.getNamedElement(), this.triggerEnclContainerDefElement, this.compoundOperators, false);
        if (type == null) {
            return null;
        }
        return type.getTypeName();
    }

    private void addInsertEdit(VlogTextFileChange fileChange, RfNamedElement enclosingContainerScope, String functionArguments, String argsName, int insertOffset, String returnType, boolean nextCodeCharIsSemicolon) {
        String methodBody = this.computeMethodBody(returnType, nextCodeCharIsSemicolon);
        VlogMethodTemplateConfig config = (VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)((VlogMethodTemplateConfig)new VlogMethodTemplateConfig().setTemplate("method_implementation")).setEditor((IEditorPart)this.targetEditor)).setDocument(this.targetDoc)).setDocumentOffset(insertOffset)).setCursorScope(enclosingContainerScope).setKind(this.isTask ? "task" : "function").setReturnType(this.isTask ? "" : (returnType != null ? returnType : VOID)).setIdentifier(this.specifiedFunctionName).setUnqualifiedIdentifier(this.specifiedFunctionName).setArguments(functionArguments).setArgumentNames(argsName).setBodyRelativeIndent(DVTDocumentUtils.getIndent((int)this.startOffset, (IDocument)this.triggerDoc)).setBody(methodBody, true, true).setEndKeyword(this.isTask ? "endtask" : "endfunction").setLeadingNewlines(2)).setIndentFirstLine(false)).setIndentNewlines(false)).setIndentStepOnFirstLine(true);
        String functionSignature = new VlogMethodTemplateInserter(config).parse();
        int functionNameFirstRelativeOffset = functionSignature.indexOf(this.specifiedFunctionName);
        int functionNameLastRelativeOffset = functionSignature.lastIndexOf(this.specifiedFunctionName);
        Map<String, List<IRegion>> functionNameTrack = Collections.singletonMap(this.specifiedFunctionName, Arrays.asList(new Region(functionNameFirstRelativeOffset, this.specifiedFunctionName.length()), new Region(functionNameLastRelativeOffset, this.specifiedFunctionName.length())));
        InsertEdit insertEdit = new InsertEdit(insertOffset, functionSignature);
        fileChange.addEdit((TextEdit)insertEdit, functionNameTrack);
    }

    private String computeMethodBody(String returnType, boolean nextCodeCharIsSemicolon) {
        String methodBody = returnType != null ? "return " + this.selectedTextWithoutBoundaryParentheses + SEMI_COLON : (nextCodeCharIsSemicolon ? String.valueOf(this.selectedText) + SEMI_COLON : this.selectedText);
        return this.escapeDollars(methodBody);
    }

    private String computeFunctionArgs(QuickAssistInputOutputHidsVisitor inputOutputHidsVisitor, boolean includeDirection, boolean includeType, boolean includePackedDim, boolean includeUnpackedDim) {
        Collection<IHid> refHids;
        Collection<IHid> inoutHids;
        Collection<IHid> outputHids;
        StringBuilder allArgs = new StringBuilder();
        Collection<IHid> inputHids = inputOutputHidsVisitor.getInputHids();
        if (inputHids != null && !inputHids.isEmpty()) {
            allArgs.append(this.getArgsFromHids(inputHids, INPUT, false, includeType, includePackedDim, includeUnpackedDim));
        }
        if ((outputHids = inputOutputHidsVisitor.getOutputHids()) != null && !outputHids.isEmpty()) {
            String argsFromHids = this.getArgsFromHids(outputHids, OUTPUT, includeDirection, includeType, includePackedDim, includeUnpackedDim);
            if (!allArgs.toString().isEmpty() && !argsFromHids.isEmpty()) {
                allArgs.append(", ");
            }
            allArgs.append(argsFromHids);
        }
        if ((inoutHids = inputOutputHidsVisitor.getInoutHids()) != null && !inoutHids.isEmpty()) {
            String argsFromHids = this.getArgsFromHids(inoutHids, INOUT, includeDirection, includeType, includePackedDim, includeUnpackedDim);
            if (!allArgs.toString().isEmpty() && !argsFromHids.isEmpty()) {
                allArgs.append(", ");
            }
            allArgs.append(argsFromHids);
        }
        if ((refHids = inputOutputHidsVisitor.getRefHids()) != null && !refHids.isEmpty()) {
            String argsFromHids = this.getArgsFromHids(refHids, REF, includeDirection, includeType, includePackedDim, includeUnpackedDim);
            if (!allArgs.toString().isEmpty() && !argsFromHids.isEmpty()) {
                allArgs.append(", ");
            }
            allArgs.append(argsFromHids);
        }
        return allArgs.toString();
    }

    private String getArgsFromHids(Collection<IHid> hids, String direction, boolean includeDirection, boolean includeType, boolean includePackedDim, boolean includeUnpackedDim) {
        ArrayList<String> functionArgsList = new ArrayList<String>();
        for (IHid hid : hids) {
            String fieldUnpackedDim;
            int fieldOffset;
            RfField field;
            RfDefElement fieldDeclaration;
            IRfNamedElement hidElement;
            StringBuilder argument = new StringBuilder();
            if (includeDirection) {
                argument.append(direction).append(" ");
            }
            if ((hidElement = hid.getElement()) == null || !(hidElement instanceof RfField) || (fieldDeclaration = (field = (RfField)hidElement).getDeclaration()) == null) continue;
            RfDefElement fieldEnclosingScope = null;
            HashSet<Class> classes = new HashSet<Class>();
            classes.add(RfFunction.class);
            classes.add(RfActionBlock.class);
            fieldEnclosingScope = VlogQuickFixUtil.getInstance().getEnclosingDefScope(fieldDeclaration, classes);
            if (fieldEnclosingScope == null) continue;
            List<RfField> selectionFunctionArguments = this.triggerEnclContainerDefElement.getArgumentsWithPrefix("", 2);
            if (!fieldEnclosingScope.equals(this.triggerEnclContainerDefElement) && selectionFunctionArguments != null && !selectionFunctionArguments.contains(field) || (fieldOffset = fieldDeclaration.getStartOffset()) >= this.startOffset && fieldOffset <= this.endOffset) continue;
            if (includeType) {
                DataType fieldDataType = field.getDataType();
                String typeName = "integer";
                if (fieldDataType instanceof DataExpressionType) {
                    typeName = field.getAssociatedTypeName();
                } else if (fieldDataType != null) {
                    typeName = fieldDataType.getTypeNameWithParamAssignments(this.triggerEnclContainerDefElement.getParserPath(), true, false);
                }
                argument.append(typeName).append(" ");
            }
            String fieldName = field.getName();
            argument.append(fieldName);
            if (includeUnpackedDim && !(fieldUnpackedDim = field.getUnpackedDimensionWithMacros()).isEmpty()) {
                argument.append(" ").append(fieldUnpackedDim);
            }
            functionArgsList.add(argument.toString());
        }
        return functionArgsList.size() == 1 ? (String)functionArgsList.get(0) : DVTStringUtil.join((Object[])functionArgsList.toArray(), (String)", ");
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.compositeChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    public String getDisplayStringInternal() {
        return this.displayString;
    }

    public Image getImage() {
        return this.isTask ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_TASK) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
    }

    protected String getCategory() {
        return "QuickAssistProposalCategory_" + ((Object)((Object)this)).toString();
    }

    protected String getProposalName() {
        return "Extract to " + (this.isTask ? "task" : "function");
    }

    public DVTFileUtils getFileUtils() {
        return VlogFileUtils.getInstance();
    }

    protected void addLinkedPositions() throws Exception {
        if (this.isExtern && !this.targetDoc.equals(this.triggerDoc)) {
            this.addLinkedPositions(this.targetDoc, this.targetChange, this.triggerChange, this.triggerDoc);
        } else {
            this.addLinkedPositions(this.triggerDoc, this.triggerChange, this.targetChange, this.targetDoc);
        }
        if (this.shouldDisconnectTarget) {
            this.targetBufferManager.disconnect(this.path, this.locationKind, null);
        }
    }

    protected abstract CreateChangeStatus popUpTimeConsumingMethod();

    protected abstract String escapeDollars(String var1);
}

