/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.ui.editor.quickassist.AbstractQuickAssistExtractProcessor;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistExtractToModuleProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.util.CollectOperatorHidsInRanges;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class QuickAssistExtractToModuleProcessor
extends AbstractQuickAssistExtractProcessor {
    private static final String ENDCELLDEFINE = "endcelldefine";
    private static final String CELLDEFINE = "celldefine";
    private static final String ENDPROTECTED = "endprotected";
    private static final String PROTECTED = "protected";
    private static final String ENDPROTECT = "endprotect";
    private static final String PROTECT = "protect";
    private static final String END_KEYWORDS = "end_keywords";
    private static final String BEGIN_KEYWORDS = "begin_keywords";
    private static final String ELSE = "else";
    private static final String ELSIF = "elsif";
    private static final String ENDIF = "endif";
    private static final String IFNDEF = "ifndef";
    private static final String IFDEF = "ifdef";

    public QuickAssistExtractToModuleProcessor(ITextViewer viewer) {
        super(viewer);
    }

    @Override
    protected boolean isSameScope() {
        return this.fStartScope == this.fEndScope || this.fStartOffset == this.fStartScope.getStartOffset() || this.fEndOffset == this.fEndScope.getEndOffset();
    }

    public List<DVTAbstractQuickAssistProposal> makeProposals() {
        ArrayList<DVTAbstractQuickAssistProposal> result = new ArrayList<DVTAbstractQuickAssistProposal>();
        result.add(new QuickAssistExtractToModuleProposal("Extract to module", this.fStartOffset, this.fEndOffset, this.fSelectedText, this.fClosestContainer, this.fFile));
        return result;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (!(this.fStartScope.getNamedElement() instanceof IRfDesignElement)) {
            return false;
        }
        if (!this.checkPreprocessingDirectives()) {
            return false;
        }
        RfDefElement scope = this.internalComputeClosestContainer();
        List<RfDefElement> allChildren = this.getAllChildrenInSelection(scope);
        LinkedList<Position> parametersRangesToBeChecked = new LinkedList<Position>();
        parametersRangesToBeChecked.add((Position)new DVTPosition(this.fStartOffset, this.fEndOffset - this.fStartOffset));
        ArrayList<Position> positions = new ArrayList<Position>();
        for (RfDefElement child : allChildren) {
            if (!(child instanceof RfInstanceDef) && !(child instanceof RfActionBlockDef)) {
                return false;
            }
            if (parametersRangesToBeChecked.isEmpty()) break;
            Position range = (Position)parametersRangesToBeChecked.poll();
            while (!parametersRangesToBeChecked.isEmpty() && range.getOffset() + range.getLength() < child.getStartOffset()) {
                positions.add(range);
                range = (Position)parametersRangesToBeChecked.poll();
            }
            if (child instanceof RfInstanceDef) {
                if (child.getStartOffset() < range.getOffset() || range.getOffset() + range.getLength() < child.getEndOffset()) {
                    return false;
                }
                this.splitCurrentRangeByElementOffsets(range, child.getStartOffset(), child.getEndOffset(), parametersRangesToBeChecked);
                continue;
            }
            if (child instanceof RfActionBlockDef) {
                List<RfNamedElement> namedElements = ((RfActionBlockDef)child).getNamedElements();
                if (namedElements == null) continue;
                for (RfNamedElement element : namedElements) {
                    if (!(element instanceof RfActionBlock) || !((RfActionBlock)element).isAlways()) continue;
                    int startOffset = ((RfActionBlock)element).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value()) ? VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, "always_comb", scope.getStartOffset(), child.getStartOffset(), false) : (((RfActionBlock)element).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value()) ? VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, "always_ff", scope.getStartOffset(), child.getStartOffset(), false) : (((RfActionBlock)element).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value()) ? VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, "always_latch", scope.getStartOffset(), child.getStartOffset(), false) : VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, "always", scope.getStartOffset(), child.getStartOffset(), false)));
                    int endOffset = child.getEndOffset();
                    if (startOffset < range.getOffset() || range.getOffset() + range.getLength() < endOffset) {
                        return false;
                    }
                    this.splitCurrentRangeByElementOffsets(range, startOffset, endOffset, parametersRangesToBeChecked);
                }
                continue;
            }
            parametersRangesToBeChecked.add(range);
        }
        while (!parametersRangesToBeChecked.isEmpty()) {
            positions.add((Position)parametersRangesToBeChecked.poll());
        }
        return this.checkAllOperatorsInAssign(scope, positions);
    }

    private List<RfDefElement> getAllChildrenInSelection(RfDefElement scope) {
        Collection<RfDefElement> children = scope.getChildren();
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<RfDefElement> result = new ArrayList<RfDefElement>();
        for (RfDefElement child : children) {
            RfField fieldElement;
            if (child.getEndOffset() < this.fStartOffset) continue;
            if (child.getStartOffset() > this.fEndOffset) break;
            if (child instanceof RfFieldDef && ((RfFieldDef)child).getNamedElement() instanceof RfField && (fieldElement = (RfField)((RfFieldDef)child).getNamedElement()).isImplicitSignal()) continue;
            if (!(child instanceof RfGenerateBlockDef)) {
                result.add(child);
                continue;
            }
            if (this.fStartOffset < child.getStartOffset() || this.fEndOffset > child.getEndOffset()) continue;
            result.addAll(this.getAllChildrenInSelection(child));
        }
        return result;
    }

    private boolean checkAllOperatorsInAssign(RfDefElement scope, List<Position> positions) {
        CollectOperatorHidsInRanges operatorsInSelection = new CollectOperatorHidsInRanges(this.fStartOffset, this.fEndOffset, scope.getParserPath());
        operatorsInSelection.setRanges(positions);
        scope.getNamedElement().visitHidObject(null, operatorsInSelection);
        return operatorsInSelection.hasAllOperatorsInAssignsArea();
    }

    private void splitCurrentRangeByElementOffsets(Position range, int startOffset, int endOffset, Queue<Position> parametersRangesToBeChecked) {
        DVTPosition leftRange = new DVTPosition(range.getOffset(), startOffset - range.getOffset());
        DVTPosition rightRange = new DVTPosition(endOffset + 1, range.getOffset() + range.getLength() - endOffset);
        if (leftRange.length > 0) {
            parametersRangesToBeChecked.add((Position)leftRange);
        }
        if (rightRange.length > 0) {
            parametersRangesToBeChecked.add((Position)rightRange);
        }
    }

    private boolean checkPreprocessingDirectives() {
        int nofEndif;
        Map preprocessingDirectivesWithOffsets = DVTDocumentUtils.getAllBackwardListOfOffsetsForWords((IDocument)this.fDocument, VlogQuickAssistUtil.PREPROCESSOR_DIRECTIVES, (int)(this.fStartOffset == 0 ? this.fStartOffset : this.fStartOffset - 1), (int)this.fEndOffset, (boolean)true, (boolean)false);
        int nofIfdef = preprocessingDirectivesWithOffsets.get(IFDEF) == null ? 0 : ((List)preprocessingDirectivesWithOffsets.get(IFDEF)).size();
        int nofIfndef = preprocessingDirectivesWithOffsets.get(IFNDEF) == null ? 0 : ((List)preprocessingDirectivesWithOffsets.get(IFNDEF)).size();
        int n = nofEndif = preprocessingDirectivesWithOffsets.get(ENDIF) == null ? 0 : ((List)preprocessingDirectivesWithOffsets.get(ENDIF)).size();
        if (nofIfndef + nofIfdef != nofEndif) {
            return false;
        }
        List endifs = (List)preprocessingDirectivesWithOffsets.get(ENDIF);
        if (endifs != null) {
            for (Integer endifOffset : endifs) {
                VlogQuickFixUtil quickFixUtilsInstance = VlogQuickFixUtil.getInstance();
                int prevIfdefOffset = quickFixUtilsInstance.getBackwardOffsetFor(this.fDocument, IFDEF, this.fStartOffset - 1, endifOffset, false);
                int prevIfndefOffset = quickFixUtilsInstance.getBackwardOffsetFor(this.fDocument, IFNDEF, this.fStartOffset - 1, endifOffset, false);
                if (prevIfdefOffset != this.fStartOffset - 1 || prevIfndefOffset != this.fStartOffset - 1) continue;
                return false;
            }
        }
        if (!this.checkIntermediateDirectiveInIfArea((List)preprocessingDirectivesWithOffsets.get(ELSIF))) {
            return false;
        }
        if (!this.checkIntermediateDirectiveInIfArea((List)preprocessingDirectivesWithOffsets.get(ELSE))) {
            return false;
        }
        if (!this.checkMatchingBeginEndDirectives(preprocessingDirectivesWithOffsets, BEGIN_KEYWORDS, END_KEYWORDS)) {
            return false;
        }
        if (!this.checkMatchingBeginEndDirectives(preprocessingDirectivesWithOffsets, PROTECT, ENDPROTECT)) {
            return false;
        }
        if (!this.checkMatchingBeginEndDirectives(preprocessingDirectivesWithOffsets, PROTECTED, ENDPROTECTED)) {
            return false;
        }
        return this.checkMatchingBeginEndDirectives(preprocessingDirectivesWithOffsets, CELLDEFINE, ENDCELLDEFINE);
    }

    private boolean checkMatchingBeginEndDirectives(Map<String, List<Integer>> preprocessingDirectivesWithOffsets, String startDirective, String endDirective) {
        int nofEndDirectives;
        List<Integer> beginDirectives = preprocessingDirectivesWithOffsets.get(startDirective);
        List<Integer> endDirectives = preprocessingDirectivesWithOffsets.get(endDirective);
        int nofBeginDirectives = beginDirectives == null ? 0 : beginDirectives.size();
        int n = nofEndDirectives = endDirectives == null ? 0 : endDirectives.size();
        if (nofEndDirectives != nofBeginDirectives) {
            return false;
        }
        if (endDirectives != null) {
            for (Integer endKeywordOffset : endDirectives) {
                int prevStartKeywordsOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, startDirective, this.fStartOffset - 1, endKeywordOffset, false);
                if (prevStartKeywordsOffset != this.fStartOffset - 1) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkIntermediateDirectiveInIfArea(List<Integer> elseOffsets) {
        if (elseOffsets == null) {
            return true;
        }
        VlogQuickFixUtil quickFixUtilsInstance = VlogQuickFixUtil.getInstance();
        for (Integer elseOffset : elseOffsets) {
            int prevIfdefOffset = quickFixUtilsInstance.getBackwardOffsetFor(this.fDocument, IFDEF, this.fStartOffset - 1, elseOffset, false);
            int prevIfndefOffset = quickFixUtilsInstance.getBackwardOffsetFor(this.fDocument, IFNDEF, this.fStartOffset - 1, elseOffset, false);
            if (prevIfdefOffset == this.fStartOffset - 1 && prevIfndefOffset == this.fStartOffset - 1) {
                return false;
            }
            int nextEndifOffset = quickFixUtilsInstance.getBackwardOffsetFor(this.fDocument, ENDIF, elseOffset, this.fEndOffset, false);
            if (nextEndifOffset != elseOffset) continue;
            return false;
        }
        return true;
    }

    @Override
    protected RfDefElement internalComputeClosestContainer() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(RfModule.class);
        classes.add(RfInterface.class);
        classes.add(RfProgram.class);
        classes.add(RfChecker.class);
        RfDefElement defScopeAtOffset = (RfDefElement)RfUtils.getRfScope((ITextEditor)this.fEditor, this.fEditor.getDocument(), this.fStartOffset);
        if (defScopeAtOffset instanceof RfFileDef) {
            return defScopeAtOffset;
        }
        return VlogQuickFixUtil.getInstance().getEnclosingDefAtOffset(this.fStartOffset, this.fEditor, classes);
    }

    @Override
    protected void setCompoundOperators(Set<RfHidOperator> operatorsToCheck) {
    }
}

