/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.DVTDummyCreateFileChange;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.ui.search.HidMatch;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.wizards.newfile.FormatNewFileContentPatternType;
import ro.amiq.dvt.wizards.newfile.QuickFixOrAssistType;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.parser.VlogMacroZone;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistModuleAssignVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistModulePortConnectionVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.QuickAssistMoveSelectionToNewFileProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.util.QuickAssistModuleHidsVisitor;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.ui.search.new_engine.SignalReadWriteVisitor;
import ro.amiq.vlogdt.ui.search.new_engine.VlogHidMatch;

public abstract class QuickAssistExtractToModuleProposalCommon
extends DVTAbstractQuickAssistProposal {
    private static final int MAX_BLOCKS_IN_WARNING = 10;
    private static final String FIXME_PREFIX = "// FIXME (extract to module):";
    private static final String FIXME_REMOVE_DANGLING_SIGNAL = "// FIXME (extract to module): Remove dangling signal";
    private static final String FIXME_SIGNAL_HAS_MULTIPLE_DRIVERS = "// FIXME (extract to module): Unable to reliably determine port direction (extracted signal had multiple drivers)";
    private static final String FIXME_SELECT = "// FIXME (extract to module): You should consider propagating only the required bit slices of this bus";
    private static final String MODULE_NAME = String.valueOf(DVTQuickAssistUtil.STR_SUBSTITUTOR_PREFIX) + FormatNewFileContentPatternType.FILE_NAME.getPattern() + DVTQuickAssistUtil.STR_SUBSTITUTOR_SUFFIX;
    private static final String INSTANCE_NAME = "u_" + MODULE_NAME;
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String WARNING = "WARNING";
    private String displayString;
    private int selectionStartOffset;
    private int selectionEndOffset;
    private String selectedText;
    private RfDefElement triggerEnclContainerDefElement;
    private DVTEditor triggerEditor;
    protected IFile triggerFile;
    private IDocument triggerDoc;
    private QuickAssistMoveSelectionToNewFileProposal moveQuickAssistProposal;
    protected String targetFilePath;
    protected String fileNameWithoutExtension;

    protected QuickAssistExtractToModuleProposalCommon(String displayString, int startOffset, int endOffset, String selectedText, RfDefElement closestContainer, IFile file) {
        this.displayString = displayString;
        this.selectionStartOffset = startOffset;
        this.selectionEndOffset = endOffset;
        this.selectedText = selectedText;
        this.triggerEnclContainerDefElement = closestContainer;
        this.triggerFile = file;
    }

    protected void preApplyQuickAssist(IDocument document) throws Exception {
        this.triggerDoc = this.document = document;
        this.triggerEditor = (DVTEditor)DVTUiUtils.getEditor((IDocument)document);
        if (this.triggerEditor == null) {
            DVTQuickAssistUtil.popSomethingWentWrong((String)this.displayString);
            return;
        }
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        CreateChangeStatus status = this.createChanges();
        if (status != CreateChangeStatus.OK) {
            return status;
        }
        CompositeChange moveChange = this.moveQuickAssistProposal.getChanges();
        this.compositeChange = this.createCompositeChange((VlogTextFileChange)this.textFileChange, moveChange);
        this.textFileChange = null;
        return status;
    }

    private CompositeChange createCompositeChange(VlogTextFileChange firstChange, CompositeChange secondChange) {
        Change change;
        CompositeChange compositeChange = new CompositeChange("Quick fix extract module");
        compositeChange.add((Change)firstChange);
        Change[] changeArray = secondChange.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            change = changeArray[n2];
            IFile file = ((DVTTextFileChange)change).getFile();
            if (file.getLocation().toOSString().equals(firstChange.getFile().getLocation().toOSString())) {
                VlogTextFileChange dvtChange = new VlogTextFileChange(file.getLocation().toOSString(), file);
                dvtChange.setEdit(((VlogTextFileChange)change).getEdit());
                compositeChange.add((Change)dvtChange);
            }
            ++n2;
        }
        changeArray = secondChange.getChildren();
        n = changeArray.length;
        n2 = 0;
        while (n2 < n) {
            change = changeArray[n2];
            VlogTextFileChange dvtChange = null;
            IFile file = ((DVTTextFileChange)change).getFile();
            if (!file.getLocation().toOSString().equals(firstChange.getFile().getLocation().toOSString())) {
                if (change instanceof VlogTextFileChange) {
                    dvtChange = new VlogTextFileChange(file.getLocation().toOSString(), file);
                    dvtChange.setEdit(((VlogTextFileChange)change).getEdit());
                } else if (change instanceof DVTDummyCreateFileChange) {
                    dvtChange = new DVTDummyCreateFileChange(file.getLocation().toOSString(), file, new Path(this.targetFilePath));
                }
                compositeChange.add(dvtChange);
            }
            ++n2;
        }
        return compositeChange;
    }

    public final CreateChangeStatus createChanges() throws Exception {
        RfNamedElement triggerEnclContainerNamedElement = this.triggerEnclContainerDefElement.getNamedElement();
        this.triggerDoc = this.document;
        this.textFileChange = new VlogTextFileChange(this.triggerFile.getProjectRelativePath().toOSString(), this.triggerFile);
        if (triggerEnclContainerNamedElement == null) {
            return CreateChangeStatus.ERROR;
        }
        HashMap<RfNamedElement, ModuleFieldInfo> moduleFieldsInfoMap = new HashMap<RfNamedElement, ModuleFieldInfo>();
        HashMap<RfNamedElement, ModuleFieldInfo> selectsInfoMap = new HashMap<RfNamedElement, ModuleFieldInfo>();
        HashMap<RfNamedElement, String> fieldsToBeMovedInNewModuleMap = new HashMap<RfNamedElement, String>();
        HashMap<RfNamedElement, String> inputPorts = new HashMap<RfNamedElement, String>();
        HashMap<RfNamedElement, String> outputPorts = new HashMap<RfNamedElement, String>();
        HashMap<RfNamedElement, String> undefinedPorts = new HashMap<RfNamedElement, String>();
        CreateChangeStatus collectHidsResult = this.collectHids(triggerEnclContainerNamedElement, moduleFieldsInfoMap, selectsInfoMap);
        if (collectHidsResult != CreateChangeStatus.OK) {
            return collectHidsResult;
        }
        this.computeDirectionForColectedElements(moduleFieldsInfoMap, selectsInfoMap, fieldsToBeMovedInNewModuleMap, inputPorts, outputPorts, undefinedPorts);
        return this.computeEdits(fieldsToBeMovedInNewModuleMap, inputPorts, outputPorts, undefinedPorts);
    }

    private CreateChangeStatus computeEdits(Map<RfNamedElement, String> fieldsToBeMovedInNewModule, Map<RfNamedElement, String> inputPorts, Map<RfNamedElement, String> outputPorts, Map<RfNamedElement, String> undefinedPorts) throws Exception {
        int moduleDeclStartOffset;
        IFile includingFile;
        String indent = DVTDocumentUtils.getIndent((int)this.selectionStartOffset, (IDocument)this.document);
        String moduleParameters = this.computeParameters(false);
        String modulePorts = this.computePorts(false, inputPorts, outputPorts, undefinedPorts);
        String fieldsToBeMoved = fieldsToBeMovedInNewModule != null && !fieldsToBeMovedInNewModule.isEmpty() ? this.getPortDeclStringForDirection(fieldsToBeMovedInNewModule, "", false, false) : "";
        String moduleSignature = this.getModuleDefinitionSignatureAndBody(modulePorts, moduleParameters, fieldsToBeMoved, indent);
        String moduleSignatureFormatted = Utils.formatString(() -> new VlogSourceViewerConfiguration((VlogEditor)this.triggerEditor, false), (String)moduleSignature, null, (String)"", (boolean)false);
        if (this.triggerEnclContainerDefElement instanceof RfFileDef) {
            VlogMacroZone macrozone = ((RfFileDef)this.triggerEnclContainerDefElement).getNamedElement().getMacroZone();
            if (macrozone == null) {
                return CreateChangeStatus.CANCEL;
            }
            VlogFileInstance fileInstance = macrozone.getIncludedFile();
            if (fileInstance == null) {
                return CreateChangeStatus.CANCEL;
            }
            VlogIncludingScope includingScope = fileInstance.getIncludingScope();
            if (includingScope == null) {
                return CreateChangeStatus.CANCEL;
            }
            VlogFileInstance includingInstance = includingScope.getIncludingInstance();
            if (includingInstance == null) {
                return CreateChangeStatus.CANCEL;
            }
            includingFile = RfUtils.getFile(includingInstance, this.triggerFile.getProject());
            int includingLine = includingScope.getIncludingLine() - 1;
            moduleDeclStartOffset = DVTFileUtils.getInstance().getLineOffset(includingFile, includingLine);
        } else {
            IRegion startLineInfo = this.document.getLineInformationOfOffset(this.triggerEnclContainerDefElement.getStartOffset());
            moduleDeclStartOffset = startLineInfo.getOffset();
            includingFile = null;
        }
        QuickFixOrAssistType fixOrAssistType = QuickFixOrAssistType.EXTRACT_TO_MODULE_TYPE;
        this.moveQuickAssistProposal = new QuickAssistMoveSelectionToNewFileProposal(moduleDeclStartOffset, "", moduleSignatureFormatted, this.triggerFile, includingFile, FormatNewFileContentPatternType.FILE_NAME, fixOrAssistType, fixOrAssistType.getPattern(), this.targetFilePath, this.fileNameWithoutExtension);
        this.moveQuickAssistProposal.preApplyQuickAssist(this.triggerDoc);
        CreateChangeStatus moveQuickAssistChangeStatus = this.moveQuickAssistProposal.createQuickAssistChanges();
        if (CreateChangeStatus.OK != moveQuickAssistChangeStatus) {
            return moveQuickAssistChangeStatus;
        }
        String instancePortConnections = this.computePorts(true, inputPorts, outputPorts, undefinedPorts);
        String instanceParameterConnections = this.computeParameters(true);
        StringBuilder instancePattern = this.generateModulePattern(instancePortConnections, instanceParameterConnections, true);
        Map substMap = DVTQuickAssistUtil.makeCommentSubstMap(Arrays.asList(FormatNewFileContentPatternType.FILE_NAME.getPattern()), Arrays.asList(this.moveQuickAssistProposal.getTargetFileNameWithoutExtension()));
        String instance = StrSubstitutor.replace((Object)instancePattern, (Map)substMap, (String)DVTQuickAssistUtil.STR_SUBSTITUTOR_PREFIX, (String)DVTQuickAssistUtil.STR_SUBSTITUTOR_SUFFIX);
        int moduleInstanceChangeRelativeOffset = instance.indexOf(MODULE_NAME);
        String instancePatternFormated = Utils.formatString(() -> new VlogSourceViewerConfiguration((VlogEditor)this.triggerEditor, false), (String)instance, null, (String)indent, (boolean)false);
        ReplaceEdit replaceEdit = new ReplaceEdit(this.selectionStartOffset, this.selectedText.length(), instancePatternFormated);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        this.textFileChange.addEdit((TextEdit)replaceEdit, (IRegion)new Region(moduleInstanceChangeRelativeOffset, MODULE_NAME.length()));
        if (fieldsToBeMovedInNewModule == null) {
            return CreateChangeStatus.OK;
        }
        LinkedHashSet fieldsToBeMovedInNewModuleSet = new LinkedHashSet();
        fieldsToBeMovedInNewModule.keySet().stream().sorted((h1, h2) -> h1.getName().compareTo(h2.getName())).forEach(y -> {
            boolean bl = fieldsToBeMovedInNewModuleSet.add(y);
        });
        for (RfNamedElement element : fieldsToBeMovedInNewModuleSet) {
            if (!(element instanceof RfField)) continue;
            RfField field = (RfField)element;
            RfDefElement fieldDeclaration = field.getDeclaration();
            if (!this.triggerEnclContainerDefElement.getParserPath().equals((Object)fieldDeclaration.getParserPath())) continue;
            String fieldIndent = DVTDocumentUtils.getIndent((int)fieldDeclaration.getStartOffset(), (IDocument)this.document);
            int declarationStartLine = fieldDeclaration.getStartLine() - 1;
            String fixMeWarning = String.valueOf(fieldIndent) + FIXME_REMOVE_DANGLING_SIGNAL + " '" + field.getName() + "'" + this.triggerEditor.getNewLineDelimiter();
            InsertEdit insertEdit = new InsertEdit(this.document.getLineOffset(declarationStartLine), fixMeWarning);
            this.textFileChange.addEdit((TextEdit)insertEdit);
        }
        return CreateChangeStatus.OK;
    }

    private StringBuilder generateModulePattern(String portConnections, String parameterConnections, boolean isInstance) {
        StringBuilder pattern = new StringBuilder();
        String newLineDelimiter = this.triggerEditor.getNewLineDelimiter();
        pattern.append(newLineDelimiter).append(isInstance ? "" : "module ").append(MODULE_NAME).append(" ");
        if (!parameterConnections.isEmpty()) {
            pattern.append("#(").append(newLineDelimiter).append(parameterConnections).append(newLineDelimiter).append(") ");
        }
        pattern.append(isInstance ? String.valueOf(INSTANCE_NAME) + " " : "").append("(");
        if (!portConnections.isEmpty()) {
            pattern.append(newLineDelimiter).append(portConnections).append(newLineDelimiter);
        }
        pattern.append(");").append(newLineDelimiter);
        return pattern;
    }

    private String getModuleDefinitionSignatureAndBody(String ports, String parameters, String fieldsToBeMoved, String indent) {
        String newline = this.triggerEditor.getNewLineDelimiter();
        int tabWidth = this.triggerEditor.getTabWidth();
        String indentAtOffset = TextUtils.replaceTabsWithSpacesVisual((String)indent, (int)tabWidth);
        boolean useSpacesNotTabs = this.triggerEditor.isInsertSpaces(VlogPlugin.getDefault().getCombinedPreferenceStore());
        String tabOrSpace = TextUtils.getIndentTab((boolean)useSpacesNotTabs, (int)tabWidth);
        if (tabOrSpace == null) {
            tabOrSpace = "    ";
        }
        StringBuilder moduleDefinition = this.generateModulePattern(ports, parameters, false);
        StringBuilder signalDeclaration = new StringBuilder();
        signalDeclaration.append(fieldsToBeMoved);
        String moduleBodyText = String.valueOf(newline) + signalDeclaration.toString() + newline + this.selectedText;
        String[] extractedTextLines = moduleBodyText.split(newline);
        int i = 0;
        while (i < extractedTextLines.length) {
            String moduleLine = TextUtils.replaceTabsWithSpacesVisual((String)extractedTextLines[i], (int)tabWidth);
            moduleLine = TextUtils.trimNumberOfWhitespacesFromBeginningOfString((String)moduleLine, (int)indentAtOffset.length());
            moduleDefinition.append(tabOrSpace);
            moduleDefinition.append(moduleLine).append(newline);
            ++i;
        }
        moduleDefinition.append("endmodule : " + MODULE_NAME + newline);
        return moduleDefinition.toString();
    }

    private String computeParameters(boolean isParameterConnection) {
        StringBuilder portsString = new StringBuilder();
        ArrayList<String> parameters = new ArrayList<String>();
        String newLineDelimiter = this.triggerEditor.getNewLineDelimiter();
        if (this.triggerEnclContainerDefElement == null || this.triggerEnclContainerDefElement.getNamedElement() == null) {
            return portsString.toString();
        }
        List<RfField> parametersInEnclContainer = this.triggerEnclContainerDefElement.getNamedElement().getParametersWithPrefix("", 128, 2, 1);
        if (parametersInEnclContainer == null || parametersInEnclContainer.isEmpty()) {
            return portsString.toString();
        }
        for (RfField field : parametersInEnclContainer) {
            String initialValue;
            String fieldUnpackedDim;
            int fieldOffset;
            if (field.getDeclaration() == null || field.getDeclaration().getStartOffset() > this.selectionEndOffset) continue;
            StringBuilder argument = new StringBuilder();
            RfDefElement fieldDeclaration = field.getDeclaration();
            if (fieldDeclaration == null || (fieldOffset = fieldDeclaration.getStartOffset()) >= this.selectionStartOffset && fieldOffset <= this.selectionEndOffset) continue;
            if (!isParameterConnection) {
                argument.append("parameter").append(" ");
            }
            String fieldName = field.getName();
            argument.append(fieldName);
            if (!isParameterConnection && !(fieldUnpackedDim = field.getUnpackedDimensionWithMacros()).isEmpty()) {
                argument.append(fieldUnpackedDim);
            }
            if ((initialValue = field.getInitialValue(false)) == null || initialValue.isEmpty()) {
                initialValue = "0";
            }
            if (!isParameterConnection) {
                argument.append(" = " + initialValue);
            }
            parameters.add(argument.toString());
        }
        String paramString = parameters.size() == 1 ? (String)parameters.get(0) : DVTStringUtil.join((Object[])parameters.toArray(), (String)(", " + newLineDelimiter));
        return paramString.isEmpty() ? "" : paramString;
    }

    private String computePorts(boolean isPortConnection, Map<RfNamedElement, String> inputPorts, Map<RfNamedElement, String> outputPorts, Map<RfNamedElement, String> undefinedPorts) {
        String argsFromHids;
        StringBuilder portsString = new StringBuilder();
        String newLineDelimiter = this.triggerEditor.getNewLineDelimiter();
        String indent = DVTDocumentUtils.getIndent((int)this.selectionStartOffset, (IDocument)this.document);
        String portDeclStringForInput = this.getPortDeclStringForDirection(inputPorts, INPUT, isPortConnection, true);
        if (inputPorts != null && !inputPorts.isEmpty() && !portDeclStringForInput.isEmpty()) {
            portsString.append(String.valueOf(indent) + "// Inputs" + newLineDelimiter);
            portsString.append(portDeclStringForInput);
        }
        if (outputPorts != null && !outputPorts.isEmpty()) {
            argsFromHids = this.getPortDeclStringForDirection(outputPorts, OUTPUT, isPortConnection, true);
            if (!portsString.toString().isEmpty() && !argsFromHids.isEmpty()) {
                portsString.append(", " + newLineDelimiter);
            }
            if (!argsFromHids.isEmpty()) {
                portsString.append(String.valueOf(indent) + "// Outputs" + newLineDelimiter);
            }
            portsString.append(argsFromHids);
        }
        if (undefinedPorts != null && !undefinedPorts.isEmpty()) {
            argsFromHids = this.getPortDeclStringForDirection(undefinedPorts, WARNING, isPortConnection, true);
            if (!portsString.toString().isEmpty() && !argsFromHids.isEmpty()) {
                portsString.append(", " + newLineDelimiter);
            }
            if ((outputPorts == null || outputPorts.isEmpty()) && !argsFromHids.isEmpty()) {
                portsString.append(String.valueOf(indent) + "// Outputs" + newLineDelimiter);
            }
            portsString.append(argsFromHids);
        }
        return portsString.toString();
    }

    private String getPortDeclStringForDirection(Map<RfNamedElement, String> portsList, String direction, boolean isPortConnection, boolean isInPortList) {
        ArrayList<String> ports = new ArrayList<String>();
        String newLineDelimiter = this.triggerEditor.getNewLineDelimiter();
        if (portsList == null) {
            return "";
        }
        LinkedHashSet sortedPortsSet = new LinkedHashSet();
        portsList.keySet().stream().sorted((h1, h2) -> h1.getName().compareTo(h2.getName())).forEach(y -> {
            boolean bl = sortedPortsSet.add(y);
        });
        for (RfNamedElement hidElement : sortedPortsSet) {
            RfField field;
            RfDefElement fieldDeclaration;
            StringBuilder argument = new StringBuilder();
            if (!(hidElement instanceof RfField) || (fieldDeclaration = (field = (RfField)hidElement).getDeclaration()) == null) continue;
            if (!portsList.get(hidElement).isEmpty()) {
                argument.append(portsList.get(hidElement)).append(newLineDelimiter);
            }
            if (!isPortConnection) {
                if (direction.equals(WARNING)) {
                    argument.append(OUTPUT).append(" ");
                } else {
                    argument.append(direction).append(" ");
                }
            }
            RfDefElement fieldEnclosingScope = null;
            HashSet<Class<RfGenerateBlock>> classes = new HashSet<Class<RfGenerateBlock>>();
            classes.add(RfModule.class);
            classes.add(RfInterface.class);
            classes.add(RfProgram.class);
            classes.add(RfProgram.class);
            classes.add(RfChecker.class);
            classes.add(RfGenerateBlock.class);
            fieldEnclosingScope = VlogQuickFixUtil.getInstance().getEnclosingDefScope(fieldDeclaration, classes);
            if (fieldEnclosingScope == null) continue;
            List<RfField> selectionModulePorts = this.triggerEnclContainerDefElement.getArgumentsWithPrefix("", 2);
            if (!fieldEnclosingScope.equals(this.triggerEnclContainerDefElement) && selectionModulePorts != null && !selectionModulePorts.contains(field)) continue;
            if (!isPortConnection) {
                if (isInPortList) {
                    String typeName = this.computeTypeName(field, direction);
                    argument.append(StringUtils.normalizeSpace((String)typeName).replace("[ ", "[").replace(": ", ":").replace(" :", ":").replace(" ]", "]")).append(" ");
                } else {
                    String implicitTypeName;
                    DataType fieldDataType = field.getDataType();
                    String typeName = "logic";
                    String string = implicitTypeName = VlogQuickFixUtil.getInstance().isVerilogSyntax(this.getLanguageSyntax()) ? null : "logic";
                    if (fieldDataType != null) {
                        typeName = fieldDataType.getTypeNameWithParamAssignments(implicitTypeName, field.getDeclaration().getParserPath(), true, false);
                    }
                    argument.append(StringUtils.normalizeSpace((String)typeName).replace("[ ", "[").replace(": ", ":").replace(" :", ":").replace(" ]", "]")).append(" ");
                }
            }
            String fieldName = field.getName();
            if (isPortConnection) {
                argument.append("." + fieldName).append("(").append(fieldName).append(")");
            } else {
                argument.append(fieldName);
            }
            if (!isPortConnection) {
                String fieldUnpackedDim = field.getUnpackedDimensionWithMacros();
                String trimmedUnpackedDim = StringUtils.normalizeSpace((String)fieldUnpackedDim).replace("[ ", "[").replace(": ", ":").replace(" :", ":").replace(" ]", "]");
                if (!fieldUnpackedDim.isEmpty()) {
                    argument.append(" ").append(trimmedUnpackedDim);
                }
            }
            if (direction.isEmpty()) {
                argument.append(";" + newLineDelimiter);
            }
            ports.add(argument.toString());
        }
        return ports.size() == 1 ? (String)ports.get(0) : (direction.isEmpty() ? DVTStringUtil.join((Object[])ports.toArray(), (String)"") : DVTStringUtil.join((Object[])ports.toArray(), (String)(", " + newLineDelimiter)));
    }

    private String computeTypeName(RfField field, String direction) {
        IRfNamedElement assocType = field.getAssociatedType();
        String packedDimensionString = "";
        if (assocType instanceof RfListType) {
            packedDimensionString = ((RfListType)assocType).getPackedDimensionWithMacros();
            assocType = ((RfListType)assocType).getAssociatedType();
        }
        if (assocType != null && assocType.isPredefined()) {
            return String.valueOf(INPUT.equals(direction) ? "wire" : (WARNING.equals(direction) || OUTPUT.equals(direction) ? "reg" : "logic")) + " " + packedDimensionString;
        }
        DataType fieldDataType = field.getDataType();
        if (fieldDataType != null) {
            return fieldDataType.getTypeNameWithParamAssignments(field.getDeclaration().getParserPath(), true, false);
        }
        return "logic";
    }

    private CreateChangeStatus collectHids(RfNamedElement selectionEnclosingContainer, Map<RfNamedElement, ModuleFieldInfo> moduleFieldsInfoMap, Map<RfNamedElement, ModuleFieldInfo> selectsInfoMap) {
        QuickAssistModuleHidsVisitor hidVisitor = new QuickAssistModuleHidsVisitor(this.selectionStartOffset, this.selectionEndOffset, this.triggerEnclContainerDefElement.getParserPath());
        selectionEnclosingContainer.visitHidObject(null, hidVisitor);
        Set<RfNamedElement> instancesAndBlocksReferencedOutsideSelection = hidVisitor.getInstancesAndBlocksReferencedOutsideSelection();
        for (RfNamedElement instanceOrBlockReferencedOutsideSelection : instancesAndBlocksReferencedOutsideSelection) {
            if (!this.isElementInsideSelection(instanceOrBlockReferencedOutsideSelection)) continue;
            if (TestHelper.isTestMode()) {
                return CreateChangeStatus.CANCEL;
            }
            String elementKind = RfKind.of(instanceOrBlockReferencedOutsideSelection).getName();
            if (elementKind == null || elementKind.isEmpty()) {
                elementKind = "Element";
            }
            elementKind = DVTStringUtil.capitalizeFirstLetter((String)elementKind);
            String errorMessage = String.valueOf(elementKind) + " '" + instanceOrBlockReferencedOutsideSelection.getFullNameLabel() + "' is defined inside the selected region and referenced elsewhere in the module.";
            this.popUpUnableToExtractError("Unable to extract selection", errorMessage);
            return CreateChangeStatus.CANCEL;
        }
        Set<RfNamedElement> elementsReferencedInSelection = hidVisitor.getElementsReferencedInSelection();
        Set<VlogHidMatch> referencesOfElementsInScope = hidVisitor.getReferencesOfElementsInModule();
        IdentityHashMap<Hid, HidMatch> rwMap = new IdentityHashMap<Hid, HidMatch>();
        referencesOfElementsInScope.stream().filter(hm -> elementsReferencedInSelection.contains(hm.getHid().getElement())).forEach(y -> {
            VlogHidMatch vlogHidMatch = rwMap.put(y.getHid(), (HidMatch)y);
        });
        SignalReadWriteVisitor signalReadWriteVisitor = new SignalReadWriteVisitor(rwMap);
        selectionEnclosingContainer.visitHidObject(null, signalReadWriteVisitor);
        for (HidMatch hidMatch : rwMap.values()) {
            boolean markAsRead;
            if (!RfReferencesUtils.canBeReadOrWritten((IRfNamedElement)hidMatch.getHid().getElement()) || hidMatch.getAccess() != RWKind.NONE || !(markAsRead = this.shoudlMarkAsRead(hidMatch))) continue;
            hidMatch.addReadOccurence(hidMatch.getHid().getOccurrence());
        }
        QuickAssistModuleAssignVisitor moduleAssignVisitor = new QuickAssistModuleAssignVisitor(this.selectionStartOffset, this.selectionEndOffset, this.triggerEnclContainerDefElement.getParserPath());
        selectionEnclosingContainer.visitHidObject(null, moduleAssignVisitor);
        List<IHid> fieldsInstantiatedAtDeclaration = moduleAssignVisitor.getFieldsAssignedAtDeclaration();
        LinkedHashSet<RfNamedElement> writtenFieldsAtDeclaration = new LinkedHashSet<RfNamedElement>();
        for (IHid fieldInstantiatedAtDeclaration : fieldsInstantiatedAtDeclaration) {
            List<RfField> parametersInEnclContainer = this.triggerEnclContainerDefElement.getNamedElement().getFieldsWithPrefix(fieldInstantiatedAtDeclaration.getName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PROTECTED);
            if (parametersInEnclContainer == null || parametersInEnclContainer.isEmpty()) continue;
            for (RfField field : parametersInEnclContainer) {
                writtenFieldsAtDeclaration.add(field);
            }
        }
        QuickAssistModulePortConnectionVisitor portReadWriteVisitor = new QuickAssistModulePortConnectionVisitor(rwMap);
        selectionEnclosingContainer.visitHidObject(null, portReadWriteVisitor);
        Map<RfHidOperator, Set<IRfNamedElement>> elementsReferencedOutsideSelectionByAssign = moduleAssignVisitor.getElementsReferencedOutsideSelectionByAssign();
        Map<RfActionBlock, Set<RfNamedElement>> elementsReferencedOutsideSelectionByBlock = hidVisitor.getElementsReferencedOutsideSelectionByBlock();
        Map<Integer, String> blocksAndAssignsWithProblemsAtLines = this.computeLinesForBlocksAndAssignsWithProblems(elementsReferencedInSelection, elementsReferencedOutsideSelectionByAssign, elementsReferencedOutsideSelectionByBlock);
        if (!blocksAndAssignsWithProblemsAtLines.isEmpty()) {
            if (TestHelper.isTestMode()) {
                return CreateChangeStatus.CANCEL;
            }
            String andPossiblyMore = blocksAndAssignsWithProblemsAtLines.size() > 10 ? "\n\t(... and " + (blocksAndAssignsWithProblemsAtLines.size() - 10) + " others)" : "";
            String dialogMessage = "The following blocks involve only signals directly connected to the newly extracted module:\n\n\t" + blocksAndAssignsWithProblemsAtLines.entrySet().stream().limit(5L).sorted((o1, o2) -> ((Integer)o1.getKey()).compareTo((Integer)o2.getKey())).map(e -> String.valueOf((String)e.getValue()) + " @ line " + e.getKey()).collect(Collectors.joining("\n\t")) + andPossiblyMore + "\n\nExtract anyway?";
            CreateChangeStatus status = this.popUpDirectlyConnectedSignals(dialogMessage);
            if (status == CreateChangeStatus.CANCEL) {
                return CreateChangeStatus.CANCEL;
            }
        }
        this.computeModuleFieldsInfo(rwMap, writtenFieldsAtDeclaration, moduleFieldsInfoMap, selectsInfoMap);
        return CreateChangeStatus.OK;
    }

    protected abstract void popUpUnableToExtractError(String var1, String var2);

    protected abstract CreateChangeStatus popUpDirectlyConnectedSignals(String var1);

    private Map<Integer, String> computeLinesForBlocksAndAssignsWithProblems(Set<RfNamedElement> elementsReferencedInSelection, Map<RfHidOperator, Set<IRfNamedElement>> elementsReferencedOutsideSelectionByAssign, Map<RfActionBlock, Set<RfNamedElement>> elementsReferencedOutsideSelectionByBlock) {
        HashMap<Integer, String> blocksAndAssignsWithProblemsAtLines = new HashMap<Integer, String>();
        try {
            LinkedHashSet<RfHidOperator> elementsReferencedOutsideSelectionByAssignSet = new LinkedHashSet<RfHidOperator>(elementsReferencedOutsideSelectionByAssign.keySet());
            for (RfHidOperator elementReferencedOutsideSelectionByAssign : elementsReferencedOutsideSelectionByAssignSet) {
                int startOffset;
                Set<IRfNamedElement> namedElements = elementsReferencedOutsideSelectionByAssign.get(elementReferencedOutsideSelectionByAssign);
                boolean moveToNextLogic = false;
                for (IRfNamedElement namedElement : namedElements) {
                    if (elementsReferencedInSelection.contains(namedElement)) continue;
                    moveToNextLogic = true;
                }
                if (moveToNextLogic || (startOffset = elementReferencedOutsideSelectionByAssign.getOccurrence().getOffset()) >= this.selectionStartOffset && startOffset <= this.selectionEndOffset) continue;
                blocksAndAssignsWithProblemsAtLines.put(this.document.getLineOfOffset(startOffset) + 1, "assign");
            }
            LinkedHashSet<RfActionBlock> elementsReferencedOutsideSelectionByBlockSet = new LinkedHashSet<RfActionBlock>(elementsReferencedOutsideSelectionByBlock.keySet());
            for (RfNamedElement rfNamedElement : elementsReferencedOutsideSelectionByBlockSet) {
                int n;
                Set<RfNamedElement> namedElements = elementsReferencedOutsideSelectionByBlock.get(rfNamedElement);
                boolean moveToNextLogic = false;
                for (IRfNamedElement iRfNamedElement : namedElements) {
                    if (elementsReferencedInSelection.contains(iRfNamedElement)) continue;
                    moveToNextLogic = true;
                }
                if (moveToNextLogic) continue;
                int n2 = rfNamedElement.getOffset();
                if (rfNamedElement instanceof RfActionBlock || ((RfActionBlock)rfNamedElement).isAlways()) {
                    n = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.document, "always", 0, n2, false);
                }
                if (n >= this.selectionStartOffset && n <= this.selectionEndOffset) continue;
                blocksAndAssignsWithProblemsAtLines.put(this.document.getLineOfOffset(n) + 1, "always block");
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return blocksAndAssignsWithProblemsAtLines;
    }

    public void computeModuleFieldsInfo(IdentityHashMap<Hid, HidMatch> rwMap, Set<RfNamedElement> writtenFieldsAtDeclaration, Map<RfNamedElement, ModuleFieldInfo> moduleFieldsInfoMap, Map<RfNamedElement, ModuleFieldInfo> selectsInfoMap) {
        for (RfNamedElement field : writtenFieldsAtDeclaration) {
            ModuleFieldInfo fieldInfo = moduleFieldsInfoMap.get(field);
            if (fieldInfo == null) continue;
            fieldInfo.addLocationAccess(Location.OUT, Access.W);
            moduleFieldsInfoMap.put(field, fieldInfo);
        }
        for (Hid hid : rwMap.keySet()) {
            Map<Location, Access> locationAccessMap;
            IRfNamedElement element = hid.getElement();
            if (element == null) continue;
            Access accesType = Access.NONE;
            Location location = this.computeLocation(hid.getOccurrence().getOffset());
            HidAccess access = hid.getFirstAccess();
            if (access != null) {
                List selects;
                ModuleFieldInfo selectInformation = selectsInfoMap.get(element);
                if (selectInformation == null) {
                    selectInformation = new ModuleFieldInfo();
                }
                if ((selects = access.getSelects()) == null) continue;
                StringJoiner sj = new StringJoiner("");
                for (IHidObject select : selects) {
                    String selectText = select.toString();
                    if (selectText.length() > 0 && selectText.charAt(0) != '[') {
                        selectText = "[" + selectText + "]";
                    }
                    sj.add(selectText);
                }
                selectInformation.addSelectRanges(location, sj.toString());
                selectsInfoMap.put((RfNamedElement)element, selectInformation);
                Map<Location, Access> locationAccessMap2 = selectInformation.getLocationAccessMap();
                accesType = this.computeAccessTypeForLocation(location, accesType, locationAccessMap2, hid, rwMap);
                selectInformation.addLocationAccess(location, accesType);
                continue;
            }
            ModuleFieldInfo hidElementInfo = moduleFieldsInfoMap.get(element);
            if (hidElementInfo == null) {
                hidElementInfo = new ModuleFieldInfo();
            }
            if ((locationAccessMap = hidElementInfo.getLocationAccessMap()) == null) {
                locationAccessMap = new EnumMap<Location, Access>(Location.class);
            }
            accesType = this.computeAccessTypeForLocation(location, accesType, locationAccessMap, hid, rwMap);
            locationAccessMap.put(location, accesType);
            moduleFieldsInfoMap.put((RfNamedElement)element, hidElementInfo);
        }
    }

    private Location computeLocation(int offset) {
        Location location = offset < this.selectionStartOffset || offset > this.selectionEndOffset ? Location.OUT : Location.IN;
        return location;
    }

    private Access computeAccessTypeForLocation(Location location, Access accessType, Map<Location, Access> locationAccessMap, Hid hid, IdentityHashMap<Hid, HidMatch> rwMap) {
        HidMatch hidMatch = rwMap.get(hid);
        if (hidMatch.getAccess().equals((Object)RWKind.READ)) {
            accessType = Access.R;
        } else if (hidMatch.getAccess().equals((Object)RWKind.WRITE)) {
            accessType = Access.W;
        } else if (hidMatch.getAccess().equals((Object)RWKind.READ_WRITE)) {
            accessType = Access.RW;
        }
        Access hidAccessType = locationAccessMap.get((Object)location);
        if (hidAccessType == null) {
            return accessType;
        }
        if (hidAccessType.equals((Object)Access.RW)) {
            return hidAccessType;
        }
        if (hidAccessType.equals((Object)accessType)) {
            return accessType;
        }
        if (hidAccessType.equals((Object)Access.R) && accessType.equals((Object)Access.W) || hidAccessType.equals((Object)Access.W) && accessType.equals((Object)Access.R)) {
            accessType = Access.RW;
        }
        return accessType;
    }

    public void computeDirectionForColectedElements(Map<RfNamedElement, ModuleFieldInfo> moduleFieldsInfoMap, Map<RfNamedElement, ModuleFieldInfo> selectsInfoMap, Map<RfNamedElement, String> fieldsToBeMovedInNewModule, Map<RfNamedElement, String> inputPorts, Map<RfNamedElement, String> outputPorts, Map<RfNamedElement, String> undefinedPorts) {
        this.computeDirectionForSelects(moduleFieldsInfoMap, selectsInfoMap, fieldsToBeMovedInNewModule, inputPorts, outputPorts, undefinedPorts);
        LinkedHashSet<RfNamedElement> moduleFieldsInfoKeySet = new LinkedHashSet<RfNamedElement>(moduleFieldsInfoMap.keySet());
        for (RfNamedElement hidElement : moduleFieldsInfoKeySet) {
            ModuleFieldInfo elementInfo;
            RfDefElement declaration;
            if (hidElement instanceof IRfInstanceElement || hidElement instanceof IRfDesignElement || hidElement.getEnclosingScope() instanceof RfFunction && (declaration = ((RfFunction)hidElement.getEnclosingScope()).getDeclaration()) instanceof RfFunctionDef && ((RfFunctionDef)declaration).getStartOffset() < this.selectionStartOffset || hidElement instanceof IRfFieldElement && ((IRfFieldElement)hidElement).isParameter() || (elementInfo = moduleFieldsInfoMap.get(hidElement)) == null) continue;
            Map<Location, Access> locationAccessMapForField = elementInfo.getLocationAccessMap();
            RfDefElement elementDeclaration = hidElement.getDeclaration();
            if (elementDeclaration == null) continue;
            if (elementDeclaration instanceof RfPortDef && locationAccessMapForField.containsKey((Object)Location.IN) && ((RfPort)hidElement).getDirectionString().equals(INPUT)) {
                inputPorts.put(hidElement, "");
                continue;
            }
            if (!locationAccessMapForField.containsKey((Object)Location.OUT) && elementDeclaration.getStartInfo().getOffset() < this.selectionStartOffset && !(elementDeclaration instanceof RfPortDef)) {
                fieldsToBeMovedInNewModule.put(hidElement, "");
                continue;
            }
            if (!locationAccessMapForField.containsKey((Object)Location.OUT) && !(elementDeclaration instanceof RfPortDef) || !(hidElement instanceof RfField)) continue;
            RfField field = (RfField)hidElement;
            String message = this.computeFixMeMessage(field, elementInfo);
            Access innerAccessType = locationAccessMapForField.get((Object)Location.IN);
            if (innerAccessType == null) continue;
            if (innerAccessType.equals((Object)Access.R)) {
                inputPorts.put(field, "");
                continue;
            }
            if (!innerAccessType.equals((Object)Access.W) && !innerAccessType.equals((Object)Access.RW)) continue;
            Access outerAccessType = locationAccessMapForField.get((Object)Location.OUT);
            if (Access.R.equals((Object)outerAccessType)) {
                outputPorts.put(field, message);
                continue;
            }
            if (Access.W.equals((Object)outerAccessType) || Access.RW.equals((Object)outerAccessType)) {
                String msg = "";
                msg = elementInfo.getSelectRanges() != null && !elementInfo.getSelectRanges().isEmpty() ? this.computeFixMeMessage(field, elementInfo) : String.valueOf(DVTDocumentUtils.getIndent((int)this.selectionStartOffset, (IDocument)this.document)) + FIXME_SIGNAL_HAS_MULTIPLE_DRIVERS;
                undefinedPorts.put(field, msg);
                continue;
            }
            if (!(elementDeclaration instanceof RfPortDef) || outerAccessType != null && !Access.NONE.equals((Object)outerAccessType)) continue;
            outputPorts.put(field, message);
        }
    }

    private void computeDirectionForSelects(Map<RfNamedElement, ModuleFieldInfo> moduleFieldsInfoMap, Map<RfNamedElement, ModuleFieldInfo> selectsInfoMap, Map<RfNamedElement, String> fieldsToBeMovedInNewModule, Map<RfNamedElement, String> inputPorts, Map<RfNamedElement, String> outputPorts, Map<RfNamedElement, String> undefinedPorts) {
        LinkedHashSet<RfNamedElement> selectMapKeySet = new LinkedHashSet<RfNamedElement>(selectsInfoMap.keySet());
        for (RfNamedElement select : selectMapKeySet) {
            if (moduleFieldsInfoMap.containsKey(select)) {
                ModuleFieldInfo fieldInfoInModule;
                ModuleFieldInfo selectFieldInfo = selectsInfoMap.get(select);
                if (selectFieldInfo == null || (fieldInfoInModule = moduleFieldsInfoMap.get(select)) == null) continue;
                Map<Location, Access> moduleLocationAccessMap = fieldInfoInModule.getLocationAccessMap();
                Map<Location, Access> selectLocationAccessMap = selectFieldInfo.getLocationAccessMap();
                for (Map.Entry<Location, Access> entry : selectLocationAccessMap.entrySet()) {
                    Location selectLocation = entry.getKey();
                    Access accessTypeForCompleteField = moduleLocationAccessMap.get((Object)selectLocation);
                    fieldInfoInModule.setSelectRanges(selectFieldInfo.getSelectRanges());
                    if (accessTypeForCompleteField == null) {
                        moduleLocationAccessMap.put(selectLocation, entry.getValue());
                        fieldInfoInModule.setSelectRanges(selectFieldInfo.getSelectRanges());
                        continue;
                    }
                    Access selectAccessType = entry.getValue();
                    if (selectAccessType.equals((Object)Access.RW) || accessTypeForCompleteField.equals((Object)Access.RW)) {
                        moduleLocationAccessMap.put(selectLocation, Access.RW);
                        fieldInfoInModule.setSelectRanges(selectFieldInfo.getSelectRanges());
                    }
                    if (selectAccessType.equals((Object)accessTypeForCompleteField) || (!selectAccessType.equals((Object)Access.R) || !accessTypeForCompleteField.equals((Object)Access.W)) && (!selectAccessType.equals((Object)Access.W) || !accessTypeForCompleteField.equals((Object)Access.R))) continue;
                    moduleLocationAccessMap.put(selectLocation, Access.RW);
                    fieldInfoInModule.setSelectRanges(selectFieldInfo.getSelectRanges());
                }
                continue;
            }
            ModuleFieldInfo selectInfo = selectsInfoMap.get(select);
            Map<Location, Access> locationAccessMapForSelect = selectInfo.getLocationAccessMap();
            Access innerAccessType = locationAccessMapForSelect.get((Object)Location.IN);
            if (innerAccessType == null) continue;
            RfDefElement elementDeclaration = select.getDeclaration();
            if (elementDeclaration instanceof RfPortDef && ((RfPort)select).getDirectionString().equals(INPUT)) {
                inputPorts.put(select, "");
                continue;
            }
            Access outerAccessType = locationAccessMapForSelect.get((Object)Location.OUT);
            if ((outerAccessType == null || outerAccessType.equals((Object)Access.NONE)) && !(elementDeclaration instanceof RfPortDef)) {
                ModuleFieldInfo moduleFieldInfo = moduleFieldsInfoMap.get(select);
                if (moduleFieldInfo == null) {
                    moduleFieldInfo = new ModuleFieldInfo();
                }
                moduleFieldInfo.setLocationAccessMap(locationAccessMapForSelect);
                fieldsToBeMovedInNewModule.put(select, "");
                continue;
            }
            if (!(select instanceof RfField)) continue;
            RfField field = (RfField)select;
            String message = this.computeFixMeMessage(field, selectInfo);
            if (Access.R.equals((Object)innerAccessType)) {
                inputPorts.put(field, "");
                continue;
            }
            if (!Access.W.equals((Object)innerAccessType) && !Access.RW.equals((Object)innerAccessType)) continue;
            if (Access.R.equals((Object)outerAccessType)) {
                outputPorts.put(field, message);
                continue;
            }
            if (Access.W.equals((Object)outerAccessType) || Access.RW.equals((Object)outerAccessType)) {
                undefinedPorts.put(field, message);
                continue;
            }
            if (!(elementDeclaration instanceof RfPortDef) || outerAccessType != null && !Access.NONE.equals((Object)outerAccessType)) continue;
            outputPorts.put(field, message);
        }
    }

    private String computeFixMeMessage(RfField field, ModuleFieldInfo selectInfo) {
        Map<Location, Set<String>> selectRanges = selectInfo.getSelectRanges();
        if (selectRanges == null) {
            return "";
        }
        Set<String> infos = selectRanges.get((Object)Location.IN);
        if (infos == null) {
            return "";
        }
        String indent = DVTDocumentUtils.getIndent((int)this.selectionStartOffset, (IDocument)this.document);
        String msg = infos.stream().sorted().map(s -> String.valueOf(indent) + "//   " + field.getName() + s).collect(Collectors.joining(this.triggerEditor.getNewLineDelimiter()));
        return String.valueOf(indent) + FIXME_SELECT + this.triggerEditor.getNewLineDelimiter() + indent + "// Referenced in the extracted selection are:\n" + msg;
    }

    private boolean shoudlMarkAsRead(HidMatch hidMatch) {
        boolean markAsRead = true;
        Collection declarations = hidMatch.getHid().getElement().getDeclarations();
        if (declarations != null) {
            for (IRfDefElement declaration : declarations) {
                if (hidMatch.getHid().getOccurrence().getLine() != declaration.getStartLine()) continue;
                markAsRead = false;
                break;
            }
        }
        return markAsRead;
    }

    private boolean isElementInsideSelection(RfNamedElement e) {
        RfDefElement declaration = e.getDeclaration();
        if (declaration == null) {
            return false;
        }
        ParserPath parserPath = declaration.getParserPath();
        if (parserPath == null) {
            return false;
        }
        if (!parserPath.equals((Object)this.triggerEnclContainerDefElement.getParserPath())) {
            return false;
        }
        return new DVTFoldingPosition(declaration.getStartOffset(), declaration.getEndOffset() - declaration.getStartOffset(), ' ').isIncludedBy(this.selectionStartOffset, this.selectionEndOffset - this.selectionStartOffset);
    }

    public void applyQuickAssist(IDocument document) throws Exception {
        DVTTextChangePerformer.getInstance().performTextChange((IEditorPart)this.triggerEditor, this.triggerDoc, this.getDisplayString(), (Change)this.compositeChange);
    }

    protected IFile[] getAffectedFiles() throws Exception {
        Object[] affectedObjects = this.compositeChange.getAffectedObjects();
        IFile[] affectedFiles = new IFile[affectedObjects.length];
        int i = 0;
        while (i < affectedObjects.length) {
            Object affectedObject = affectedObjects[i];
            if (affectedObject instanceof IFile) {
                affectedFiles[i] = (IFile)affectedObject;
            }
            ++i;
        }
        return affectedFiles;
    }

    protected String getDisplayStringInternal() throws Exception {
        return this.displayString;
    }

    protected String getProposalName() {
        return this.displayString;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE);
    }

    private IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        if (this.triggerEditor == null || this.triggerEnclContainerDefElement == null) {
            return null;
        }
        RfProject rfProject = this.triggerEnclContainerDefElement.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = this.triggerEditor.getParserPath();
        if (parserPath == null) {
            return null;
        }
        return VlogQuickFixUtil.getInstance().getLanguageSyntaxForParserPath(rfProject, parserPath);
    }

    public QuickAssistMoveSelectionToNewFileProposal getMoveQuickAssistProposal() {
        return this.moveQuickAssistProposal;
    }

    protected void computeDirectlyConectedSignals() {
        RfNamedElement triggerEnclContainerNamedElement = this.triggerEnclContainerDefElement.getNamedElement();
        if (triggerEnclContainerNamedElement == null) {
            return;
        }
        this.collectHids(triggerEnclContainerNamedElement, new HashMap<RfNamedElement, ModuleFieldInfo>(), new HashMap<RfNamedElement, ModuleFieldInfo>());
    }

    private static enum Access {
        R,
        RW,
        W,
        NONE;

    }

    private static enum Location {
        IN,
        OUT;

    }

    private static class ModuleFieldInfo {
        private Map<Location, Access> locationAccessMap = new EnumMap<Location, Access>(Location.class);
        private Map<Location, Set<String>> selectRanges = new EnumMap<Location, Set<String>>(Location.class);

        public void setSelectRanges(Map<Location, Set<String>> selectRanges) {
            this.selectRanges = selectRanges;
        }

        public Map<Location, Access> getLocationAccessMap() {
            return this.locationAccessMap;
        }

        public void setLocationAccessMap(Map<Location, Access> locationAccessMap) {
            this.locationAccessMap = locationAccessMap;
        }

        public void addLocationAccess(Location location, Access access) {
            this.locationAccessMap.put(location, access);
        }

        public Map<Location, Set<String>> getSelectRanges() {
            return this.selectRanges;
        }

        public void addSelectRanges(Location location, String range) {
            Set<String> ranges = this.selectRanges.get((Object)location);
            if (ranges == null) {
                ranges = new LinkedHashSet<String>();
            }
            ranges.add(range);
            this.selectRanges.put(location, ranges);
        }
    }
}

