/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.quickassist;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistExtractVariableProposal;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssertExpectDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtilsBase;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.quickassist.util.QuickAssistIfLoopCaseHidVisitor;
import ro.amiq.vlogdt.ui.editor.quickassist.util.VlogQuickAssistUtil;
import ro.amiq.vlogdt.ui.editor.quickfix.quickfixes.TypeName;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.refactor.VlogTextFileChange;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public abstract class QuickAssistExtractVariableProposalCommon
extends DVTAbstractQuickAssistExtractVariableProposal {
    public static final HidOperatorQualifier[] EVENT_CONTROL_QUALIFIERS = new HidOperatorQualifier[]{HidOperatorQualifier.IS_EVENT_CONTROL};
    private RfDefElement startScope;
    private RfDefElement declarationEnclosingScope;
    private RfDefElement enclosingContainerDef;
    private TypeName variableTypeName;
    protected int initializationOffset;

    protected QuickAssistExtractVariableProposalCommon(TypeName typeName, RfDefElement enclosingContainerDef, int startOffset, int endOffset, RfDefElement startScope, List<IRegion> multipleOccurrences, String displayString, boolean multiple, IFile file) {
        this.displayString = String.valueOf(displayString) + (multiple ? " (replace all occurrences)" : "");
        this.multiple = multiple;
        this.file = file;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.startScope = startScope;
        this.multipleOccurrences = multipleOccurrences;
        this.variableTypeName = typeName;
        this.enclosingContainerDef = enclosingContainerDef;
        this.initializationOffset = Integer.MAX_VALUE;
        this.linkedProposalModel = new LinkedModeModel();
    }

    protected CreateChangeStatus createQuickAssistChanges() throws Exception {
        boolean isDeclAnchorActionBlock;
        this.textFileChange = new VlogTextFileChange(this.file.getProjectRelativePath().toOSString(), this.file);
        this.textFileChange.setEdit((TextEdit)new MultiTextEdit());
        IRfDefElement declarationAnchor = this.computeExtendedEncompassingActionBlockDef();
        if (declarationAnchor == null) {
            return CreateChangeStatus.ERROR;
        }
        int declarationOffset = declarationAnchor.getStartOffset();
        declarationOffset = this.computeOffsetForDeclarationAssign(declarationAnchor, declarationOffset);
        declarationOffset = this.computeDeclarationOffsetForSelectionInsideAlwaysBlocks(declarationAnchor, declarationOffset);
        declarationOffset = this.computeDeclarationOffset(declarationOffset);
        String extracted = this.document.get(this.startOffset, this.endOffset - this.startOffset);
        extracted = VlogQuickAssistUtil.computeSelectedTextWithoutOptionalBoundaries(extracted);
        String typeName = this.variableTypeName.getTypeName();
        String unpackedDimension = this.variableTypeName.getUnpackedDim();
        String packedDimension = this.variableTypeName.getPackedDim();
        String indent = DVTDocumentUtils.getIndent((int)declarationAnchor.getStartOffset(), (IDocument)this.document);
        StringBuilder sbDeclaration = new StringBuilder();
        String tabOrSpace = DVTDocumentUtils.getTabOrSpace((DVTEditor)this.editor, (IPreferenceStore)VlogPlugin.getDefault().getCombinedPreferenceStore());
        boolean isSingleLineBlock = this.isSingleLineActionBlock(this.declarationEnclosingScope);
        if (isSingleLineBlock) {
            declarationOffset = this.computeBeginDeclarationOffset();
            indent = String.valueOf(indent) + tabOrSpace;
            sbDeclaration.append(" begin" + NEWLINE + indent);
        }
        boolean bl = isDeclAnchorActionBlock = !(declarationAnchor instanceof RfField) && !(declarationAnchor instanceof RfFieldDef) && !isSingleLineBlock;
        if (isDeclAnchorActionBlock) {
            indent = String.valueOf(indent) + tabOrSpace;
        }
        if (!isSingleLineBlock) {
            this.addPrefix(sbDeclaration, indent);
        }
        sbDeclaration.append(typeName).append(" ");
        if (!packedDimension.isEmpty()) {
            sbDeclaration.append(packedDimension).append(" ");
        }
        String variableName = "var_name";
        if (this.isSpecifiedVarName) {
            variableName = this.specifiedVarName;
        }
        sbDeclaration.append(variableName).append(unpackedDimension).append(";");
        if (!isSingleLineBlock) {
            this.addSuffix(sbDeclaration);
        }
        this.varTypeOffset = declarationOffset + sbDeclaration.toString().indexOf(typeName);
        this.varTypeLength = typeName.length();
        int declarationChangeRelativeOffset = sbDeclaration.toString().indexOf(variableName);
        DVTQuickAssistUtil.addFileEdit((DVTTextFileChange)this.textFileChange, (int)declarationOffset, (int)sbDeclaration.length(), (String)sbDeclaration.toString(), (int)declarationChangeRelativeOffset, (DVTQuickAssistUtil.FileEditType)DVTQuickAssistUtil.FileEditType.INSERT, (String)variableName);
        StringBuilder sbInitialization = new StringBuilder();
        sbInitialization.append(NEWLINE).append(indent).append(variableName).append(" = ").append(extracted).append(";").append(NEWLINE);
        int initStartOffsetPivot = this.startOffset;
        int initEndOffsetPivot = this.endOffset;
        if (this.multiple) {
            for (IRegion region : this.multipleOccurrences) {
                if (region.getOffset() >= initStartOffsetPivot) continue;
                initStartOffsetPivot = region.getOffset();
                initEndOffsetPivot = region.getOffset() + region.getLength();
            }
        }
        this.declarationEnclosingScope.getNamedElement().visitHidObject(this.declarationEnclosingScope.getRfProject(), new LocalHidVisitor(initStartOffsetPivot, initEndOffsetPivot, declarationOffset));
        if (this.initializationOffset == -1 || this.initializationOffset == Integer.MAX_VALUE) {
            this.initializationOffset = declarationOffset;
            if (this.isConstructor()) {
                this.initializationOffset = this.computeInitializationOffset();
                if (this.initializationOffset == -1) {
                    this.initializationOffset = declarationOffset;
                }
            }
        }
        this.computeInitializationOffsetForSelectionInsideActionBlocksAndAsserts();
        String initializationIndent = DVTDocumentUtils.getIndent((int)this.initializationOffset, (IDocument)this.document);
        sbInitialization.append(initializationIndent);
        int initializationChangeRelativeOffset = sbInitialization.toString().indexOf(variableName);
        DVTQuickAssistUtil.addFileEdit((DVTTextFileChange)this.textFileChange, (int)this.initializationOffset, (int)sbInitialization.length(), (String)sbInitialization.toString(), (int)initializationChangeRelativeOffset, (DVTQuickAssistUtil.FileEditType)DVTQuickAssistUtil.FileEditType.INSERT, (String)variableName);
        if (!this.multiple) {
            int startOffset = this.startOffset;
            int length = this.endOffset - this.startOffset;
            DVTQuickAssistUtil.addFileEdit((DVTTextFileChange)this.textFileChange, (int)startOffset, (int)length, (String)variableName, (int)0, (DVTQuickAssistUtil.FileEditType)DVTQuickAssistUtil.FileEditType.REPLACE, (String)variableName);
        } else {
            for (IRegion region : this.multipleOccurrences) {
                DVTQuickAssistUtil.addFileEdit((DVTTextFileChange)this.textFileChange, (int)region.getOffset(), (int)region.getLength(), (String)variableName, (int)0, (DVTQuickAssistUtil.FileEditType)DVTQuickAssistUtil.FileEditType.REPLACE, (String)variableName);
            }
        }
        if (isSingleLineBlock) {
            String endStatement = String.valueOf(NEWLINE) + indent.substring(0, indent.length() - tabOrSpace.length()) + "end" + NEWLINE;
            InsertEdit endStatementEdit = new InsertEdit(this.declarationEnclosingScope.getEndOffset(), endStatement);
            this.textFileChange.addEdit((TextEdit)endStatementEdit);
        }
        this.hasPositions = true;
        return CreateChangeStatus.OK;
    }

    private int computeOffsetForDeclarationAssign(IRfDefElement declarationAnchor, int declarationOffset) {
        boolean selectionInsideDeclarationAssign;
        if (!(declarationAnchor instanceof RfFieldDef)) {
            return declarationOffset;
        }
        declarationOffset = declarationAnchor.getEndOffset();
        boolean bl = selectionInsideDeclarationAssign = this.startOffset >= declarationAnchor.getStartOffset() && this.startOffset <= declarationAnchor.getEndOffset();
        if (!selectionInsideDeclarationAssign) {
            return declarationOffset;
        }
        DataType datatype = ((RfFieldDef)declarationAnchor).getDataType(declarationAnchor.getNamedElement());
        if (datatype == null) {
            return declarationOffset;
        }
        declarationOffset = datatype.getPackageScope() != null ? datatype.getPackageScope().getOffset() : datatype.getOffset();
        return VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.document, NEWLINE, this.declarationEnclosingScope.getStartOffset(), declarationOffset, true);
    }

    private int computeDeclarationOffsetForSelectionInsideAlwaysBlocks(IRfDefElement declarationAnchor, int declarationOffset) {
        if (!(declarationAnchor instanceof RfActionBlockDef)) {
            return declarationOffset;
        }
        RfNamedElement encompassingElement = (RfNamedElement)declarationAnchor.getNamedElement();
        if (!(encompassingElement instanceof RfActionBlock) || !((RfActionBlock)encompassingElement).isAlways()) {
            return declarationOffset;
        }
        List<IHidOperator> sensitivityLists = encompassingElement.getHidOperators(EVENT_CONTROL_QUALIFIERS, false);
        if (sensitivityLists == null || sensitivityLists.isEmpty()) {
            return declarationOffset;
        }
        IHidOperator lastSensitivity = sensitivityLists.get(sensitivityLists.size() - 1);
        int conditionCloseBoundary = lastSensitivity.getOccurrence().getCloseBoundary();
        if (conditionCloseBoundary >= this.startOffset) {
            return declarationOffset;
        }
        int beginOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(this.document, "begin", conditionCloseBoundary, this.startOffset, false);
        declarationOffset = beginOffset == this.startOffset ? conditionCloseBoundary : beginOffset;
        return declarationOffset;
    }

    private void computeInitializationOffsetForSelectionInsideActionBlocksAndAsserts() {
        RfWNamedElementAndScope namedElement = RfUtils.getRfElement(this.declarationEnclosingScope.getRfProject(), this.file, this.document, this.initializationOffset, this.editor);
        if (namedElement == null) {
            return;
        }
        IRfScopeElement initScope = namedElement.getScope();
        while (initScope != null && !initScope.equals(this.declarationEnclosingScope)) {
            if (!(initScope instanceof RfAssertExpectDef || initScope instanceof RfActionBlockDef && ((RfActionBlockDef)initScope).getNamedElement() instanceof RfActionBlock)) {
                return;
            }
            RfNamedElement actionBlock = ((RfDefElement)initScope).getNamedElement();
            if (actionBlock == null) {
                return;
            }
            this.initializationOffset = initScope instanceof RfActionBlockDef && ((RfActionBlockDef)initScope).getReparseInfo() != null ? ((RfActionBlockDef)initScope).getStartOffset() : (actionBlock instanceof RfActionBlock ? VlogQuickFixUtil.getInstance().getActionBlockLabelStartOffset((RfActionBlock)actionBlock, this.document) : ((IRfDefElement)initScope).getStartOffset());
            IRfScope enclosingScope = actionBlock.getEnclosingScope();
            if (enclosingScope instanceof RfNamedElement) {
                enclosingScope = enclosingScope.getDeclaration();
            }
            initScope = enclosingScope;
        }
    }

    private int computeInitializationOffset() throws BadLocationException, BadPartitioningException {
        final AtomicInteger superOffset = new AtomicInteger(-1);
        RfHidHolder hidHolder = this.enclosingContainerDef.getNamedElement().getHidHolder();
        if (hidHolder == null) {
            return -1;
        }
        hidHolder.visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if ("super".equals(hidObject.getName())) {
                    HidOccurrence hidOccurrence = hidObject.getOccurrence();
                    if (hidOccurrence != null) {
                        int hidOccurrenceOffset = hidOccurrence.getOffset();
                        if (QuickAssistExtractVariableProposalCommon.this.enclosingContainerDef.getStartOffset() < hidOccurrenceOffset && hidOccurrenceOffset < QuickAssistExtractVariableProposalCommon.this.enclosingContainerDef.getEndOffset()) {
                            superOffset.set(hidOccurrenceOffset);
                            return false;
                        }
                    }
                    return false;
                }
                return true;
            }
        });
        if (superOffset.get() == -1) {
            return -1;
        }
        DVTCharacterScanner cs = new DVTCharacterScanner(100, this.document, superOffset.get(), true);
        int nextChar = -1;
        while ((nextChar = cs.read()) != -1) {
            if ("__dftl_partition_content_type".equals(((IDocumentExtension3)this.document).getContentType("__vlog_partitioning", cs.getOffset() - 1, false)) && (char)nextChar == ';') break;
        }
        return cs.getOffset() + 1;
    }

    private int computeBeginDeclarationOffset() throws BadLocationException, BadPartitioningException {
        List<IHidOperator> sensitivityLists;
        int declarationOffset = ((RfActionBlockDef)this.declarationEnclosingScope).getStartOffset();
        if (!(this.declarationEnclosingScope instanceof RfActionBlockDef)) {
            return declarationOffset;
        }
        int bracketToMatch = 65535;
        if (((RfActionBlock)this.declarationEnclosingScope.getNamedElement()).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FOR)) {
            bracketToMatch = 40;
        } else if (((RfActionBlock)this.declarationEnclosingScope.getNamedElement()).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FOREACH)) {
            bracketToMatch = 91;
        } else if (((RfActionBlock)this.declarationEnclosingScope.getNamedElement()).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS) && (sensitivityLists = ((RfActionBlock)this.declarationEnclosingScope.getNamedElement()).getHidOperators(EVENT_CONTROL_QUALIFIERS, false)) != null && !sensitivityLists.isEmpty()) {
            bracketToMatch = 40;
        }
        if (bracketToMatch == 65535) {
            return declarationOffset;
        }
        declarationOffset = DVTDocumentUtils.getCharOffset((char)bracketToMatch, (int)declarationOffset, (boolean)true, (int)100, (IDocument)this.document, (String)"__vlog_partitioning");
        ICharacterPairMatcher bracketMatcher = this.editor.getBracketMatcher();
        IRegion region = bracketMatcher.match(this.document, declarationOffset);
        if (region != null) {
            declarationOffset += region.getLength();
        }
        return declarationOffset;
    }

    private IRfDefElement computeExtendedEncompassingActionBlockDef() {
        List<RfActionBlock> actionBlocks;
        IRfDefElement encompassingDef = this.computeEncompassingActionBlockDef();
        if (encompassingDef == null) {
            return null;
        }
        RfNamedElement encompassingElement = (RfNamedElement)encompassingDef.getNamedElement();
        if (encompassingElement == null) {
            return null;
        }
        boolean getEnclosingDef = false;
        if (!getEnclosingDef && encompassingElement instanceof RfActionBlock && ((RfActionBlock)encompassingElement).isCase()) {
            getEnclosingDef = true;
        }
        if (!getEnclosingDef && encompassingElement instanceof RfActionBlock && ((RfActionBlock)encompassingElement).isAlways()) {
            actionBlocks = encompassingElement.getLocalMembers(RfActionBlock.class);
            getEnclosingDef = actionBlocks != null && !actionBlocks.isEmpty();
            List<IHidOperator> sensitivityLists = encompassingElement.getHidOperators(EVENT_CONTROL_QUALIFIERS, false);
            if (sensitivityLists != null && !sensitivityLists.isEmpty()) {
                IHidOperator firstSensitivity = sensitivityLists.get(0);
                IHidOperator lastSensitivity = sensitivityLists.get(sensitivityLists.size() - 1);
                int conditionOpenBoundary = firstSensitivity.getOccurrence().getOpenBoundary();
                int conditionCloseBoundary = lastSensitivity.getOccurrence().getCloseBoundary();
                if (conditionOpenBoundary <= this.startOffset && conditionCloseBoundary >= this.endOffset) {
                    getEnclosingDef = true;
                }
            }
        }
        if (!getEnclosingDef && encompassingElement instanceof RfActionBlock && (((RfActionBlock)encompassingElement).isForOrForeach() || ((RfActionBlock)encompassingElement).isCase())) {
            actionBlocks = encompassingElement.getLocalMembers(RfActionBlock.class);
            getEnclosingDef = actionBlocks != null && !actionBlocks.isEmpty();
            QuickAssistIfLoopCaseHidVisitor qaIfLoopCaseVisitor = new QuickAssistIfLoopCaseHidVisitor(this.startOffset, this.endOffset);
            this.declarationEnclosingScope.getNamedElement().visitHidObject(null, qaIfLoopCaseVisitor);
            if (qaIfLoopCaseVisitor.isInIfCaseLoop()) {
                getEnclosingDef = true;
            }
        }
        if (!getEnclosingDef && encompassingElement instanceof RfActionBlock && ((RfActionBlock)encompassingElement).isStatementLabel()) {
            getEnclosingDef = true;
        }
        if (!getEnclosingDef && encompassingElement instanceof RfAssertExpect) {
            getEnclosingDef = true;
        }
        if (getEnclosingDef) {
            if (!(this.declarationEnclosingScope.getNamedElement() instanceof RfFunction)) {
                this.declarationEnclosingScope = this.declarationEnclosingScope.getNamedElement().getEnclosingScope().getDeclaration();
            }
            encompassingDef = VlogQuickFixUtil.getInstance().computeDeclarationAnchorForQuickAssist(this.declarationEnclosingScope, (IResource)this.file, this.startOffset);
        }
        return encompassingDef;
    }

    private boolean isSingleLineActionBlock(RfDefElement def) {
        RfNamedElement elem = def.getNamedElement();
        if (!(elem instanceof RfActionBlock)) {
            return false;
        }
        RfActionBlock actionBlock = (RfActionBlock)elem;
        if (actionBlock.hasBeginOrFork()) {
            return false;
        }
        return actionBlock.isConditional() || actionBlock.isLoop() || actionBlock.isCaseItem() || actionBlock.isProceduralBlock();
    }

    private RfDefElement computeEncompassingMOScope() {
        return (RfDefElement)RfUtilsBase.getActionsCommonRfScope((ITextEditor)this.editor, this.document, this.multipleOccurrences);
    }

    private IRfDefElement computeEncompassingActionBlockDef() {
        this.declarationEnclosingScope = this.multiple ? this.computeEncompassingMOScope() : this.startScope;
        if (this.declarationEnclosingScope == null) {
            return null;
        }
        return VlogQuickFixUtil.getInstance().computeDeclarationAnchorForQuickAssist(this.declarationEnclosingScope, (IResource)this.file, this.startOffset);
    }

    private boolean isConstructor() {
        RfNamedElement containerNamed = this.enclosingContainerDef.getNamedElement();
        return containerNamed instanceof RfFunction && ((RfFunction)containerNamed).isConstructor();
    }

    public DVTFileUtils getFileUtils() {
        return VlogFileUtils.getInstance();
    }

    protected void addLinkedPositions() throws Exception {
        this.linkedPositionMaker = new DVTLinkedPositionProvider(this.editor, this.linkedProposalModel, this.getCategory(), this.hasPositions, this.textFileChange);
        this.linkedPositionMaker.addSingleLinkedPosition(this.varTypeOffset, this.varTypeLength, this.document);
        if (!this.isSpecifiedVarName()) {
            Collection absoluteRegions = this.textFileChange.getAbsoluteRegions();
            this.linkedPositionMaker.addMultipleLinkedPosition(absoluteRegions, this.document, -1);
        }
        this.linkedPositionMaker.enterLinkedMode(this.document, null);
    }

    protected abstract int computeDeclarationOffset(int var1) throws Exception;

    protected abstract void addPrefix(StringBuilder var1, String var2);

    protected abstract void addSuffix(StringBuilder var1);

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        int initStartOffsetPivot;
        int endOffset;
        private int declarationOffset;

        public LocalHidVisitor(int initStartOffsetPivot, int endOffset, int declarationOffset) {
            this.initStartOffsetPivot = initStartOffsetPivot;
            this.endOffset = endOffset;
            this.declarationOffset = declarationOffset;
        }

        public boolean visit(IHidObject hidObject) {
            boolean isSelectionInsideHid;
            IHid parentHid = this.computeParentHid(hidObject);
            HidOccurrence hidOccurence = HidUtils.getOccurrence((IHidObject)hidObject);
            HidOccurrence parentOccurence = parentHid != null ? HidUtils.getOccurrence((IHidObject)parentHid) : hidOccurence;
            int hidStartOffset = HidUtils.getStartOffset((HidOccurrence)parentOccurence);
            int hidEndOffset = HidUtils.getEndOffset((IHidObject)hidObject, (int)HidUtils.getStartOffset((HidOccurrence)hidOccurence), (HidOccurrence)hidOccurence);
            boolean bl = isSelectionInsideHid = hidStartOffset <= this.initStartOffsetPivot && hidEndOffset >= this.endOffset;
            if (hidObject instanceof RfHidAccessArgs) {
                boolean isSelectionInsideArguments;
                List<? extends IHidObject> arguments = ((RfHidAccessArgs)hidObject).getArgumentValues();
                if (arguments == null || arguments.isEmpty()) {
                    return true;
                }
                IHidObject firstArgument = arguments.get(0);
                HidOccurrence firstArgumentOccurence = HidUtils.getOccurrence((IHidObject)firstArgument);
                int firstArgumentStartOffset = HidUtils.getStartOffset((HidOccurrence)firstArgumentOccurence);
                IHidObject lastArgument = arguments.get(arguments.size() - 1);
                HidOccurrence lastArgumentOccurence = HidUtils.getOccurrence((IHidObject)lastArgument);
                int lastArgumentStartOffset = HidUtils.getStartOffset((HidOccurrence)lastArgumentOccurence);
                int lastArgumentEndOffset = HidUtils.getEndOffset((IHidObject)lastArgument, (int)lastArgumentStartOffset, (HidOccurrence)lastArgumentOccurence);
                boolean bl2 = isSelectionInsideArguments = firstArgumentStartOffset <= this.initStartOffsetPivot && lastArgumentEndOffset >= this.endOffset;
                if (isSelectionInsideArguments && hidStartOffset < QuickAssistExtractVariableProposalCommon.this.initializationOffset) {
                    QuickAssistExtractVariableProposalCommon.this.initializationOffset = hidStartOffset;
                }
                return true;
            }
            if (!isSelectionInsideHid) {
                return true;
            }
            if (hidObject instanceof RfHidOperator) {
                if (((RfHidOperator)hidObject).hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                    hidStartOffset = this.computeInitializationOffsetForDeclarationAssign(hidStartOffset);
                } else if (((RfHidOperator)hidObject).hasOccurrence(HidOperatorQualifier.IS_PROCEDURAL_CONTINUOUS_ASSIGN)) {
                    hidStartOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(QuickAssistExtractVariableProposalCommon.this.document, "assign", this.declarationOffset, hidStartOffset, false);
                } else if (((RfHidOperator)hidObject).isActionBlockCondition()) {
                    hidStartOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(QuickAssistExtractVariableProposalCommon.this.document, ((RfHidOperator)hidObject).getOperatorText(), this.declarationOffset, hidStartOffset, false);
                }
            }
            if (hidStartOffset < QuickAssistExtractVariableProposalCommon.this.initializationOffset) {
                QuickAssistExtractVariableProposalCommon.this.initializationOffset = hidStartOffset;
            }
            return true;
        }

        private int computeInitializationOffsetForDeclarationAssign(int hidStartOffset) {
            RfWNamedElementAndScope namedElement = RfUtils.getRfElement(QuickAssistExtractVariableProposalCommon.this.declarationEnclosingScope.getRfProject(), QuickAssistExtractVariableProposalCommon.this.file, QuickAssistExtractVariableProposalCommon.this.document, hidStartOffset, QuickAssistExtractVariableProposalCommon.this.editor);
            RfNamedElement element = namedElement.getNamedElement();
            if (!(element instanceof RfField)) {
                return hidStartOffset;
            }
            DataType dataType = ((RfField)element).getDataType();
            if (dataType == null) {
                return hidStartOffset;
            }
            if (dataType.getPackageScope() != null) {
                return dataType.getPackageScope().getOffset();
            }
            return dataType.getOffset();
        }

        private IHid computeParentHid(IHidObject hidObject) {
            IHid hid = HidUtils.getHidFrom((IHidObject)hidObject);
            if (hid instanceof Hid) {
                return ((Hid)hid).getAncestorHid();
            }
            IHid parentHid = hid != null && hid.getParentHid() != null ? hid.getParentHid() : null;
            while (parentHid != null && parentHid.getParentHid() != null) {
                parentHid = parentHid.getParentHid();
            }
            return parentHid;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

